package org.openqa.selenium.devtools.v132.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Detailed information about exception (or error) that was thrown during script compilation or
 * execution.
 */
public class ExceptionDetails {

    private final java.lang.Integer exceptionId;

    private final java.lang.String text;

    private final java.lang.Integer lineNumber;

    private final java.lang.Integer columnNumber;

    private final java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.ScriptId> scriptId;

    private final java.util.Optional<java.lang.String> url;

    private final java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.StackTrace> stackTrace;

    private final java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.RemoteObject> exception;

    private final java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.ExecutionContextId> executionContextId;

    private final java.util.Optional<java.util.Map<String, Object>> exceptionMetaData;

    public ExceptionDetails(java.lang.Integer exceptionId, java.lang.String text, java.lang.Integer lineNumber, java.lang.Integer columnNumber, java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.ScriptId> scriptId, java.util.Optional<java.lang.String> url, java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.StackTrace> stackTrace, java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.RemoteObject> exception, java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.ExecutionContextId> executionContextId, java.util.Optional<java.util.Map<String, Object>> exceptionMetaData) {
        this.exceptionId = java.util.Objects.requireNonNull(exceptionId, "exceptionId is required");
        this.text = java.util.Objects.requireNonNull(text, "text is required");
        this.lineNumber = java.util.Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = java.util.Objects.requireNonNull(columnNumber, "columnNumber is required");
        this.scriptId = scriptId;
        this.url = url;
        this.stackTrace = stackTrace;
        this.exception = exception;
        this.executionContextId = executionContextId;
        this.exceptionMetaData = exceptionMetaData;
    }

    /**
     * Exception id.
     */
    public java.lang.Integer getExceptionId() {
        return exceptionId;
    }

    /**
     * Exception text, which should be used together with exception object when available.
     */
    public java.lang.String getText() {
        return text;
    }

    /**
     * Line number of the exception location (0-based).
     */
    public java.lang.Integer getLineNumber() {
        return lineNumber;
    }

    /**
     * Column number of the exception location (0-based).
     */
    public java.lang.Integer getColumnNumber() {
        return columnNumber;
    }

    /**
     * Script ID of the exception location.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.ScriptId> getScriptId() {
        return scriptId;
    }

    /**
     * URL of the exception location, to be used when the script was not reported.
     */
    public java.util.Optional<java.lang.String> getUrl() {
        return url;
    }

    /**
     * JavaScript stack trace if available.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.StackTrace> getStackTrace() {
        return stackTrace;
    }

    /**
     * Exception object if available.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.RemoteObject> getException() {
        return exception;
    }

    /**
     * Identifier of the context where exception happened.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.ExecutionContextId> getExecutionContextId() {
        return executionContextId;
    }

    /**
     * Dictionary with entries of meta data that the client associated
     * with this exception, such as information about associated network
     * requests, etc.
     */
    @Beta()
    public java.util.Optional<java.util.Map<String, Object>> getExceptionMetaData() {
        return exceptionMetaData;
    }

    private static ExceptionDetails fromJson(JsonInput input) {
        java.lang.Integer exceptionId = 0;
        java.lang.String text = null;
        java.lang.Integer lineNumber = 0;
        java.lang.Integer columnNumber = 0;
        java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.ScriptId> scriptId = java.util.Optional.empty();
        java.util.Optional<java.lang.String> url = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.StackTrace> stackTrace = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.RemoteObject> exception = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v132.runtime.model.ExecutionContextId> executionContextId = java.util.Optional.empty();
        java.util.Optional<java.util.Map<String, Object>> exceptionMetaData = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "exceptionId":
                    exceptionId = input.nextNumber().intValue();
                    break;
                case "text":
                    text = input.nextString();
                    break;
                case "lineNumber":
                    lineNumber = input.nextNumber().intValue();
                    break;
                case "columnNumber":
                    columnNumber = input.nextNumber().intValue();
                    break;
                case "scriptId":
                    scriptId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.runtime.model.ScriptId.class));
                    break;
                case "url":
                    url = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "stackTrace":
                    stackTrace = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.runtime.model.StackTrace.class));
                    break;
                case "exception":
                    exception = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.runtime.model.RemoteObject.class));
                    break;
                case "executionContextId":
                    executionContextId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.runtime.model.ExecutionContextId.class));
                    break;
                case "exceptionMetaData":
                    exceptionMetaData = java.util.Optional.ofNullable((java.util.Map<String, Object>) input.read(java.util.Map.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ExceptionDetails(exceptionId, text, lineNumber, columnNumber, scriptId, url, stackTrace, exception, executionContextId, exceptionMetaData);
    }
}
