package org.openqa.selenium.devtools.v130.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Enum of possible auto-response for permission / prompt dialogs.
 */
@org.openqa.selenium.Beta()
public enum AutoResponseMode {

    NONE("none"), AUTOACCEPT("autoAccept"), AUTOREJECT("autoReject"), AUTOOPTOUT("autoOptOut");

    private String value;

    AutoResponseMode(String value) {
        this.value = value;
    }

    public static AutoResponseMode fromString(String s) {
        return java.util.Arrays.stream(AutoResponseMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AutoResponseMode "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AutoResponseMode fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
