package org.openqa.selenium.devtools.v130.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS try rule representation.
 */
public class CSSTryRule {

    private final java.util.Optional<org.openqa.selenium.devtools.v130.css.model.StyleSheetId> styleSheetId;

    private final org.openqa.selenium.devtools.v130.css.model.StyleSheetOrigin origin;

    private final org.openqa.selenium.devtools.v130.css.model.CSSStyle style;

    public CSSTryRule(java.util.Optional<org.openqa.selenium.devtools.v130.css.model.StyleSheetId> styleSheetId, org.openqa.selenium.devtools.v130.css.model.StyleSheetOrigin origin, org.openqa.selenium.devtools.v130.css.model.CSSStyle style) {
        this.styleSheetId = styleSheetId;
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.style = java.util.Objects.requireNonNull(style, "style is required");
    }

    /**
     * The css style sheet identifier (absent for user agent stylesheet and user-specified
     * stylesheet rules) this rule came from.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v130.css.model.StyleSheetId> getStyleSheetId() {
        return styleSheetId;
    }

    /**
     * Parent stylesheet's origin.
     */
    public org.openqa.selenium.devtools.v130.css.model.StyleSheetOrigin getOrigin() {
        return origin;
    }

    /**
     * Associated style declaration.
     */
    public org.openqa.selenium.devtools.v130.css.model.CSSStyle getStyle() {
        return style;
    }

    private static CSSTryRule fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v130.css.model.StyleSheetId> styleSheetId = java.util.Optional.empty();
        org.openqa.selenium.devtools.v130.css.model.StyleSheetOrigin origin = null;
        org.openqa.selenium.devtools.v130.css.model.CSSStyle style = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "styleSheetId":
                    styleSheetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v130.css.model.StyleSheetId.class));
                    break;
                case "origin":
                    origin = input.read(org.openqa.selenium.devtools.v130.css.model.StyleSheetOrigin.class);
                    break;
                case "style":
                    style = input.read(org.openqa.selenium.devtools.v130.css.model.CSSStyle.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSTryRule(styleSheetId, origin, style);
    }
}
