/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class ChromiumDevToolsLocator {
    private static final Json JSON = new Json();

    ChromiumDevToolsLocator() {
    }

    public static Optional<Connection> getChromeConnector(HttpClient.Factory clientFactory, Capabilities caps, String capabilityKey) {
        Object raw = caps.getCapability(capabilityKey);
        if (!(raw instanceof Map)) {
            return Optional.empty();
        }
        if (!((raw = ((Map)raw).get("debuggerAddress")) instanceof String)) {
            return Optional.empty();
        }
        int index = ((String)raw).lastIndexOf(":");
        if (index == -1 || index == ((String)raw).length() - 1) {
            return Optional.empty();
        }
        try {
            URL url = new URL(String.format("http://%s", raw));
            HttpClient client = clientFactory.createClient(url);
            HttpResponse res = client.execute(new HttpRequest(HttpMethod.GET, "/json/version"));
            if (res.getStatus() != 200) {
                return Optional.empty();
            }
            Map versionData = (Map)JSON.toType(Contents.string((HttpMessage)res), Json.MAP_TYPE);
            raw = versionData.get("webSocketDebuggerUrl");
            if (!(raw instanceof String)) {
                return Optional.empty();
            }
            String debuggerUrl = (String)raw;
            return Optional.of(new Connection(client, debuggerUrl));
        }
        catch (IOException | JsonException e) {
            return Optional.empty();
        }
    }
}

