/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit.options;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.htmlunit.BrowserVersion;
import org.htmlunit.ProxyConfig;
import org.openqa.selenium.htmlunit.options.BrowserVersionTrait;
import org.openqa.selenium.htmlunit.options.KeyStoreBean;
import org.openqa.selenium.htmlunit.options.ProxyConfigBean;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.TypeToken;

final class TypeCodec {
    private static final Type MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    private static final Type LIST_TYPE = new TypeToken<List<String>>(){}.getType();

    private TypeCodec() {
        throw new AssertionError((Object)"TypeCodec is a static utility class that cannot be instantiated");
    }

    static boolean decodeBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new IllegalStateException("Specified value must be 'Boolean' or 'String'; was " + TypeCodec.getClassName(value));
    }

    static int decodeInt(Object value) {
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new IllegalStateException("Specified value must be 'Long', 'Integer', or 'String'; was " + TypeCodec.getClassName(value));
    }

    static long decodeLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new IllegalStateException("Specified value must be 'Long' or 'String'; was " + TypeCodec.getClassName(value));
    }

    static String decodeString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalStateException("Specified value must be 'String'; was " + TypeCodec.getClassName(value));
    }

    static char[] decodeCharArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof char[]) {
            return (char[])value;
        }
        if (value instanceof String) {
            return ((String)value).toCharArray();
        }
        throw new IllegalStateException("Specified value must be 'char[]' or 'String'; was " + TypeCodec.getClassName(value));
    }

    static String[] decodeStringArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof String) {
            List listOfStrings = (List)new Json().toType((String)value, LIST_TYPE);
            return listOfStrings.toArray(new String[0]);
        }
        throw new IllegalStateException("Specified value must be 'String[]' or 'String'; was " + TypeCodec.getClassName(value));
    }

    static String encodeFile(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof File) {
            try {
                return ((File)value).getCanonicalPath();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed encoding 'File' to canonical path", e);
            }
        }
        throw new IllegalStateException("Specified value must be 'File' or 'String'; was " + TypeCodec.getClassName(value));
    }

    static File decodeFile(Object value) {
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof String) {
            return new File((String)value);
        }
        throw new IllegalStateException("Specified value must be 'File' or 'String'; was " + TypeCodec.getClassName(value));
    }

    static String encodeInetAddress(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof InetAddress) {
            return ((InetAddress)value).getHostAddress();
        }
        throw new IllegalStateException("Specified value must be 'InetAddress' or 'String'; was " + TypeCodec.getClassName(value));
    }

    static InetAddress decodeInetAddress(Object value) {
        if (value instanceof InetAddress) {
            return (InetAddress)value;
        }
        if (value instanceof String) {
            try {
                return InetAddress.getByName((String)value);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Failed decoding address: " + (String)value, e);
            }
        }
        throw new IllegalStateException("Specified value must be 'InetAddress' or 'String'; was " + TypeCodec.getClassName(value));
    }

    static KeyStoreBean decodeKeyStore(Object value) {
        if (value instanceof String) {
            KeyStoreBean bean = (KeyStoreBean)new Json().toType((String)value, KeyStoreBean.class);
            Objects.requireNonNull(bean.getUrl(), "Client certificate store object omits [url] property");
            Objects.requireNonNull(bean.getType(), "Client certificate store object omits [type] property");
            return bean;
        }
        throw new IllegalStateException("Specified value must be 'String'; was " + TypeCodec.getClassName(value));
    }

    static Map<String, Object> encodeProxyConfig(Object value) {
        if (value instanceof ProxyConfig) {
            return ProxyConfigBean.encodeProxyConfig((ProxyConfig)value);
        }
        throw new IllegalStateException("Specified value must be 'ProxyConfig'; was " + TypeCodec.getClassName(value));
    }

    static ProxyConfig decodeProxyConfig(Object value) {
        String json;
        if (value instanceof ProxyConfig) {
            return (ProxyConfig)value;
        }
        if (value instanceof Map) {
            json = new Json().toJson(value);
        } else if (value instanceof String) {
            json = (String)value;
        } else {
            throw new IllegalStateException("Specified value must be 'ProxyConfig', 'Map', or 'String'; was " + TypeCodec.getClassName(value));
        }
        ProxyConfigBean bean = (ProxyConfigBean)new Json().toType(json, ProxyConfigBean.class);
        return bean.build();
    }

    static Map<String, Object> encodeBrowserVersion(Object value) {
        if (value instanceof BrowserVersion) {
            HashMap<String, Object> optionsMap = new HashMap<String, Object>();
            BrowserVersion browserVersion = (BrowserVersion)value;
            for (BrowserVersionTrait trait : BrowserVersionTrait.values()) {
                Object traitValue = trait.obtain(browserVersion);
                if (trait.isDefaultValue(traitValue)) continue;
                optionsMap.put(trait.getCapabilityKey(), trait.encode(traitValue));
            }
            return optionsMap;
        }
        throw new IllegalStateException("Specified value must be 'BrowserVersion'; was " + TypeCodec.getClassName(value));
    }

    static BrowserVersion decodeBrowserVersion(Object value) {
        BrowserVersion seed;
        int code;
        Map<Object, Object> optionsMap = new HashMap();
        if (value != null) {
            if (value instanceof BrowserVersion) {
                optionsMap = TypeCodec.encodeBrowserVersion(value);
            } else if (value instanceof Map) {
                optionsMap = (Map)value;
            } else if (value instanceof String) {
                optionsMap = (Map)new Json().toType((String)value, MAP_TYPE);
            } else {
                throw new IllegalStateException("Specified value must be 'BrowserVersion', 'Map', or 'String'; was " + TypeCodec.getClassName(value));
            }
        }
        for (BrowserVersionTrait option : BrowserVersionTrait.values()) {
            option.applyPropertyTo(optionsMap);
        }
        Object numericCode = Objects.requireNonNull(optionsMap.get(BrowserVersionTrait.NUMERIC_CODE.getCapabilityKey()), "Required browser version trait [numericCode] is unspecified");
        if (numericCode instanceof Long) {
            code = ((Long)numericCode).intValue();
        } else if (numericCode instanceof Integer) {
            code = (Integer)numericCode;
        } else {
            throw new IllegalStateException("Browser numeric code must be 'Long' or 'Integer'; was " + TypeCodec.getClassName(numericCode));
        }
        Object nickname = Objects.requireNonNull(optionsMap.get(BrowserVersionTrait.NICKNAME.getCapabilityKey()), "Required browser version trait [nickname] is unspecified");
        if (!(nickname instanceof String)) {
            throw new IllegalStateException("Browser nickname must be 'String'; was " + TypeCodec.getClassName(nickname));
        }
        String name = (String)nickname;
        if (name.startsWith("Chrome")) {
            seed = BrowserVersion.CHROME;
        } else if (name.startsWith("Edge")) {
            seed = BrowserVersion.EDGE;
        } else if (name.startsWith("FF")) {
            seed = code == BrowserVersion.FIREFOX_ESR.getBrowserVersionNumeric() ? BrowserVersion.FIREFOX_ESR : BrowserVersion.FIREFOX;
        } else {
            throw new IllegalArgumentException("Browser nickname must start with 'Chrome', 'Edge', or 'FF'; was: " + name);
        }
        if (seed.getBrowserVersionNumeric() != code) {
            try {
                Field browserVersionNumericField = BrowserVersion.class.getField("browserVersionNumeric_");
                browserVersionNumericField.setAccessible(true);
                browserVersionNumericField.set(seed, code);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException browserVersionNumericField) {
                // empty catch block
            }
        }
        BrowserVersion.BrowserVersionBuilder builder = new BrowserVersion.BrowserVersionBuilder(seed);
        block6: for (BrowserVersionTrait trait : BrowserVersionTrait.values()) {
            switch (trait) {
                case NUMERIC_CODE: 
                case NICKNAME: {
                    continue block6;
                }
                default: {
                    if (!optionsMap.containsKey(trait.getCapabilityKey())) continue block6;
                    trait.apply(optionsMap.get(trait.getCapabilityKey()), builder);
                }
            }
        }
        return builder.build();
    }

    static String encodeTimeZone(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof TimeZone) {
            return ((TimeZone)value).getID();
        }
        throw new IllegalStateException("Specified value must be 'TimeZone' or 'String'; was " + TypeCodec.getClassName(value));
    }

    static TimeZone decodeTimeZone(Object value) {
        if (value instanceof TimeZone) {
            return (TimeZone)value;
        }
        if (value instanceof String) {
            return TimeZone.getTimeZone((String)value);
        }
        throw new IllegalStateException("Specified value must be 'TimeZone' or 'String'; was " + TypeCodec.getClassName(value));
    }

    static String getClassName(Object value) {
        return value != null ? value.getClass().getName() : "'null'";
    }
}

