/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLHandshakeException;
import org.htmlunit.BrowserVersion;
import org.htmlunit.ClipboardHandler;
import org.htmlunit.CookieManager;
import org.htmlunit.Page;
import org.htmlunit.ProxyConfig;
import org.htmlunit.RefreshHandler;
import org.htmlunit.ScriptResult;
import org.htmlunit.SgmlPage;
import org.htmlunit.TopLevelWindow;
import org.htmlunit.WaitingRefreshHandler;
import org.htmlunit.WebClient;
import org.htmlunit.WebClientOptions;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.WebWindow;
import org.htmlunit.WebWindowEvent;
import org.htmlunit.WebWindowListener;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.IdScriptableObject;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.Location;
import org.htmlunit.javascript.host.html.DocumentProxy;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.platform.AwtClipboardHandler;
import org.htmlunit.util.UrlUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UnableToSetCookieException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.htmlunit.AsyncScriptExecutor;
import org.openqa.selenium.htmlunit.HtmlUnitAlert;
import org.openqa.selenium.htmlunit.HtmlUnitElementFinder;
import org.openqa.selenium.htmlunit.HtmlUnitInputProcessor;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboard;
import org.openqa.selenium.htmlunit.HtmlUnitMouse;
import org.openqa.selenium.htmlunit.HtmlUnitTargetLocator;
import org.openqa.selenium.htmlunit.HtmlUnitTimeouts;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.htmlunit.HtmlUnitWindow;
import org.openqa.selenium.htmlunit.logging.HtmlUnitLogs;
import org.openqa.selenium.htmlunit.options.HtmlUnitDriverOptions;
import org.openqa.selenium.htmlunit.w3.Action;
import org.openqa.selenium.htmlunit.w3.Algorithms;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.remote.DesiredCapabilities;

public class HtmlUnitDriver
implements WebDriver,
JavascriptExecutor,
HasCapabilities,
Interactive {
    private static final int sleepTime = 200;
    private WebClient webClient_;
    private final HtmlUnitAlert alert_;
    private HtmlUnitWindow currentWindow_;
    private HtmlUnitKeyboard keyboard_;
    private HtmlUnitMouse mouse_;
    private final WebDriver.TargetLocator targetLocator_;
    private AsyncScriptExecutor asyncScriptExecutor_;
    private PageLoadStrategy pageLoadStrategy_ = PageLoadStrategy.NORMAL;
    private final ElementsMap elementsMap_ = new ElementsMap();
    private final WebDriver.Options options_;
    private final HtmlUnitElementFinder elementFinder_;
    private HtmlUnitInputProcessor inputProcessor_ = new HtmlUnitInputProcessor(this);
    public static final String BROWSER_LANGUAGE_CAPABILITY = "browserLanguage";
    public static final String DOWNLOAD_IMAGES_CAPABILITY = "downloadImages";
    public static final String JAVASCRIPT_ENABLED = "javascriptEnabled";
    private final Lock conditionLock_ = new ReentrantLock();
    private final Condition mainCondition_ = this.conditionLock_.newCondition();
    private boolean runAsyncRunning_;
    private RuntimeException exception_;
    private final ExecutorService defaultExecutor_;
    private Executor executor_;

    public HtmlUnitDriver() {
        this(BrowserVersion.getDefault(), false);
    }

    public HtmlUnitDriver(BrowserVersion version) {
        this(version, false);
    }

    public HtmlUnitDriver(boolean enableJavascript) {
        this(BrowserVersion.getDefault(), enableJavascript);
    }

    public HtmlUnitDriver(BrowserVersion version, boolean enableJavascript) {
        this((Capabilities)new HtmlUnitDriverOptions(version, enableJavascript));
    }

    public HtmlUnitDriver(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this((Capabilities)new DesiredCapabilities(new Capabilities[]{desiredCapabilities, requiredCapabilities}));
    }

    public HtmlUnitDriver(Capabilities capabilities) {
        HtmlUnitDriverOptions driverOptions = new HtmlUnitDriverOptions(capabilities);
        this.webClient_ = this.newWebClient(driverOptions.getWebClientVersion());
        this.setAcceptInsecureCerts(Boolean.FALSE != driverOptions.getCapability("acceptInsecureCerts"));
        String pageLoadStrategyString = (String)driverOptions.getCapability("pageLoadStrategy");
        if ("none".equals(pageLoadStrategyString)) {
            this.pageLoadStrategy_ = PageLoadStrategy.NONE;
        } else if ("eager".equals(pageLoadStrategyString)) {
            this.pageLoadStrategy_ = PageLoadStrategy.EAGER;
        }
        WebClientOptions clientOptions = this.webClient_.getOptions();
        driverOptions.applyOptions(clientOptions);
        this.setProxySettings(Proxy.extractFrom((Capabilities)driverOptions));
        this.webClient_.setRefreshHandler((RefreshHandler)new WaitingRefreshHandler());
        this.webClient_.setClipboardHandler((ClipboardHandler)new AwtClipboardHandler());
        this.elementFinder_ = new HtmlUnitElementFinder();
        this.alert_ = new HtmlUnitAlert(this);
        this.alert_.handleBrowserCapabilities((Capabilities)driverOptions);
        this.currentWindow_ = new HtmlUnitWindow(this.webClient_.getCurrentWindow());
        this.defaultExecutor_ = Executors.newCachedThreadPool();
        this.executor_ = this.defaultExecutor_;
        this.get(clientOptions.getHomePage());
        this.options_ = new HtmlUnitWebDriverOptions(this);
        this.targetLocator_ = new HtmlUnitTargetLocator(this);
        this.webClient_.addWebWindowListener(new WebWindowListener(){

            public void webWindowOpened(WebWindowEvent webWindowEvent) {
                if (webWindowEvent.getWebWindow() instanceof TopLevelWindow && HtmlUnitDriver.this.currentWindow_ == null && HtmlUnitDriver.this.webClient_.getTopLevelWindows().size() == 1) {
                    HtmlUnitDriver.this.currentWindow_ = new HtmlUnitWindow((WebWindow)HtmlUnitDriver.this.webClient_.getTopLevelWindows().get(0));
                }
            }

            public void webWindowContentChanged(WebWindowEvent event) {
                HtmlUnitDriver.this.elementsMap_.remove(event.getOldPage());
                if (event.getWebWindow() != HtmlUnitDriver.this.currentWindow_.getWebWindow()) {
                    return;
                }
                HtmlUnitDriver.this.switchToDefaultContentOfWindow(HtmlUnitDriver.this.currentWindow_.getWebWindow());
            }

            public void webWindowClosed(WebWindowEvent event) {
                HtmlUnitDriver.this.elementsMap_.remove(event.getOldPage());
                if (HtmlUnitDriver.this.getWebClient().getTopLevelWindows().size() == 0) {
                    HtmlUnitDriver.this.currentWindow_ = null;
                    return;
                }
                WebWindow ourCurrentWindow = HtmlUnitDriver.this.currentWindow_.getWebWindow();
                WebWindow ourCurrentTopWindow = HtmlUnitDriver.this.currentWindow_.getWebWindow().getTopWindow();
                do {
                    if (ourCurrentWindow != event.getWebWindow()) continue;
                    HtmlUnitDriver.this.setCurrentWindow(ourCurrentTopWindow);
                    return;
                } while ((ourCurrentWindow = ourCurrentWindow.getParentWindow()) != ourCurrentTopWindow);
            }
        });
        this.resetKeyboardAndMouseState();
        this.modifyWebClient(this.webClient_);
    }

    boolean isProcessAlert() {
        if (this.asyncScriptExecutor_ != null) {
            String text = this.alert_.getText();
            this.alert_.dismiss();
            this.asyncScriptExecutor_.alertTriggered(text);
            return false;
        }
        this.conditionLock_.lock();
        try {
            this.mainCondition_.signal();
        }
        finally {
            this.conditionLock_.unlock();
        }
        return true;
    }

    protected void runAsync(Runnable r) {
        boolean loadStrategyWait;
        boolean bl = loadStrategyWait = this.pageLoadStrategy_ != PageLoadStrategy.NONE;
        if (loadStrategyWait) {
            while (this.runAsyncRunning_) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.conditionLock_.lock();
            this.runAsyncRunning_ = true;
        }
        this.exception_ = null;
        Runnable wrapped = () -> {
            try {
                r.run();
            }
            catch (RuntimeException e) {
                this.exception_ = e;
            }
            finally {
                this.conditionLock_.lock();
                try {
                    this.runAsyncRunning_ = false;
                    this.mainCondition_.signal();
                }
                finally {
                    this.conditionLock_.unlock();
                }
            }
        };
        this.executor_.execute(wrapped);
        if (loadStrategyWait && this.runAsyncRunning_) {
            this.mainCondition_.awaitUninterruptibly();
            this.conditionLock_.unlock();
        }
        if (this.exception_ != null) {
            throw this.exception_;
        }
    }

    public void click(DomElement element, boolean directClick) {
        this.runAsync(() -> this.mouse_.click(element, directClick));
    }

    public void doubleClick(DomElement element) {
        this.runAsync(() -> this.mouse_.doubleClick(element));
    }

    public void mouseUp(DomElement element) {
        this.runAsync(() -> this.mouse_.mouseUp(element));
    }

    public void mouseMove(DomElement element) {
        this.runAsync(() -> this.mouse_.mouseMove(element));
    }

    public void mouseDown(DomElement element) {
        this.runAsync(() -> this.mouse_.mouseDown(element));
    }

    public void submit(HtmlUnitWebElement element) {
        this.runAsync(element::submitImpl);
    }

    public void sendKeys(HtmlUnitWebElement element, CharSequence ... value) {
        this.runAsync(() -> this.keyboard_.sendKeys(element, true, value));
    }

    public BrowserVersion getBrowserVersion() {
        return this.webClient_.getBrowserVersion();
    }

    protected WebClient newWebClient(BrowserVersion version) {
        return new WebClient(version);
    }

    protected WebClient modifyWebClient(WebClient client) {
        return client;
    }

    public HtmlUnitAlert getAlert() {
        return this.alert_;
    }

    public ElementsMap getElementsMap() {
        return this.elementsMap_;
    }

    public void setCurrentWindow(WebWindow window) {
        if (this.currentWindow_.getWebWindow() != window) {
            this.currentWindow_ = new HtmlUnitWindow(window);
        }
    }

    public void setProxySettings(Proxy proxy) {
        if (proxy == null || proxy.getProxyType() == Proxy.ProxyType.UNSPECIFIED) {
            return;
        }
        switch (proxy.getProxyType()) {
            case MANUAL: {
                String socksProxy;
                String httpProxy;
                ArrayList<String> noProxyHosts = new ArrayList<String>();
                String noProxy = proxy.getNoProxy();
                if (noProxy != null && !noProxy.isEmpty()) {
                    String[] hosts;
                    for (String host : hosts = noProxy.split(",")) {
                        if (host.trim().length() <= 0) continue;
                        noProxyHosts.add(host.trim());
                    }
                }
                if ((httpProxy = proxy.getHttpProxy()) != null && !httpProxy.isEmpty()) {
                    String host = httpProxy;
                    int port = 0;
                    int index = httpProxy.indexOf(":");
                    if (index != -1) {
                        host = httpProxy.substring(0, index);
                        port = Integer.parseInt(httpProxy.substring(index + 1));
                    }
                    this.setHTTPProxy(host, port, noProxyHosts);
                }
                if ((socksProxy = proxy.getSocksProxy()) == null || socksProxy.isEmpty()) break;
                String host = socksProxy;
                int port = 0;
                int index = socksProxy.indexOf(":");
                if (index != -1) {
                    host = socksProxy.substring(0, index);
                    port = Integer.parseInt(socksProxy.substring(index + 1));
                }
                this.setSocksProxy(host, port, noProxyHosts);
                break;
            }
            case PAC: {
                String pac = proxy.getProxyAutoconfigUrl();
                if (pac == null || pac.isEmpty()) break;
                this.setAutoProxy(pac);
                break;
            }
        }
    }

    public void setProxy(String host, int port) {
        this.setHTTPProxy(host, port, null);
    }

    public void setHTTPProxy(String host, int port, List<String> noProxyHosts) {
        ProxyConfig proxyConfig = new ProxyConfig();
        proxyConfig.setProxyHost(host);
        proxyConfig.setProxyPort(port);
        if (noProxyHosts != null && noProxyHosts.size() > 0) {
            for (String noProxyHost : noProxyHosts) {
                proxyConfig.addHostsToProxyBypass(noProxyHost);
            }
        }
        this.getWebClient().getOptions().setProxyConfig(proxyConfig);
    }

    public void setSocksProxy(String host, int port) {
        this.setSocksProxy(host, port, null);
    }

    public void setSocksProxy(String host, int port, List<String> noProxyHosts) {
        ProxyConfig proxyConfig = new ProxyConfig();
        proxyConfig.setProxyHost(host);
        proxyConfig.setProxyPort(port);
        proxyConfig.setSocksProxy(true);
        if (noProxyHosts != null && noProxyHosts.size() > 0) {
            for (String noProxyHost : noProxyHosts) {
                proxyConfig.addHostsToProxyBypass(noProxyHost);
            }
        }
        this.getWebClient().getOptions().setProxyConfig(proxyConfig);
    }

    public void setExecutor(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        this.executor_ = executor;
    }

    public void setAutoProxy(String autoProxyUrl) {
        ProxyConfig proxyConfig = new ProxyConfig();
        proxyConfig.setProxyAutoConfigUrl(autoProxyUrl);
        this.getWebClient().getOptions().setProxyConfig(proxyConfig);
    }

    public Capabilities getCapabilities() {
        return new HtmlUnitDriverOptions(this.getBrowserVersion()).importOptions(this.webClient_.getOptions());
    }

    public void get(String url) {
        URL fullUrl;
        try {
            fullUrl = UrlUtils.toUrlUnsafe((String)url);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        this.runAsync(() -> this.get(fullUrl));
    }

    protected void get(URL fullUrl) {
        this.getAlert().close();
        this.getAlert().setAutoAccept(false);
        try {
            BrowserVersion browser = this.getBrowserVersion();
            WebRequest request = new WebRequest(fullUrl, browser.getHtmlAcceptHeader(), browser.getAcceptEncodingHeader());
            request.setCharset(StandardCharsets.UTF_8);
            this.getWebClient().getPage(this.getCurrentWindow().getWebWindow().getTopWindow(), request);
            this.setCurrentWindow(this.getCurrentWindow().getWebWindow().getTopWindow());
        }
        catch (UnknownHostException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (ConnectException e) {
        }
        catch (SocketTimeoutException e) {
            throw new TimeoutException((Throwable)e);
        }
        catch (NoSuchSessionException e) {
            throw e;
        }
        catch (NoSuchWindowException e) {
            throw e;
        }
        catch (SSLHandshakeException e) {
            return;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        this.resetKeyboardAndMouseState();
    }

    private void resetKeyboardAndMouseState() {
        this.keyboard_ = new HtmlUnitKeyboard(this);
        this.mouse_ = new HtmlUnitMouse(this, this.keyboard_);
    }

    public String getCurrentUrl() {
        this.getWebClient();
        Page page = this.getCurrentWindow().getWebWindow().getTopWindow().getEnclosedPage();
        if (page == null) {
            return null;
        }
        URL url = page.getUrl();
        if (url == null) {
            return null;
        }
        return url.toString();
    }

    public String getTitle() {
        this.alert_.ensureUnlocked();
        Page page = this.getCurrentWindow().lastPage();
        if (!(page instanceof HtmlPage)) {
            return null;
        }
        if (this.getCurrentWindow().getWebWindow() instanceof FrameWindow) {
            page = this.getCurrentWindow().getWebWindow().getTopWindow().getEnclosedPage();
        }
        return ((HtmlPage)page).getTitleText();
    }

    public WebElement findElement(By by) {
        this.alert_.ensureUnlocked();
        return this.implicitlyWaitFor(() -> this.elementFinder_.findElement(this, by));
    }

    public List<WebElement> findElements(By by) {
        List<WebElement> found;
        long implicitWait = this.options_.timeouts().getImplicitWaitTimeout().toMillis();
        if (implicitWait < 200L) {
            return this.elementFinder_.findElements(this, by);
        }
        long end = System.currentTimeMillis() + implicitWait;
        do {
            if (!(found = this.elementFinder_.findElements(this, by)).isEmpty()) {
                return found;
            }
            HtmlUnitDriver.sleepQuietly(200L);
        } while (System.currentTimeMillis() < end);
        return found;
    }

    public WebElement findElement(HtmlUnitWebElement element, By by) {
        this.alert_.ensureUnlocked();
        return this.implicitlyWaitFor(() -> this.elementFinder_.findElement(element, by));
    }

    public List<WebElement> findElements(HtmlUnitWebElement element, By by) {
        List<WebElement> found;
        long implicitWait = this.options_.timeouts().getImplicitWaitTimeout().toMillis();
        if (implicitWait < 200L) {
            return this.elementFinder_.findElements(element, by);
        }
        long end = System.currentTimeMillis() + implicitWait;
        do {
            if (!(found = this.elementFinder_.findElements(element, by)).isEmpty()) {
                return found;
            }
            HtmlUnitDriver.sleepQuietly(200L);
        } while (System.currentTimeMillis() < end);
        return found;
    }

    public String getPageSource() {
        Page page = this.getCurrentWindow().lastPage();
        if (page == null) {
            return null;
        }
        if (page instanceof SgmlPage) {
            return ((SgmlPage)page).asXml();
        }
        WebResponse response = page.getWebResponse();
        return response.getContentAsString();
    }

    public void close() {
        this.getWebClient();
        if (this.getWebClient().getWebWindows().size() == 1) {
            this.quit();
        } else {
            WebWindow thisWindow = this.getCurrentWindow().getWebWindow();
            if (thisWindow != null) {
                this.alert_.close();
                ((TopLevelWindow)thisWindow.getTopWindow()).close();
            }
            if (this.getWebClient().getWebWindows().size() == 0) {
                this.quit();
            }
        }
    }

    public void quit() {
        while (this.runAsyncRunning_) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.conditionLock_.lock();
        this.runAsyncRunning_ = true;
        try {
            if (this.webClient_ != null) {
                this.alert_.close();
                this.webClient_.close();
                this.webClient_ = null;
            }
            this.defaultExecutor_.shutdown();
        }
        finally {
            this.runAsyncRunning_ = false;
            this.conditionLock_.unlock();
        }
    }

    public Set<String> getWindowHandles() {
        HashSet<String> allHandles = new HashSet<String>();
        for (WebWindow window : this.getWebClient().getTopLevelWindows()) {
            allHandles.add(String.valueOf(System.identityHashCode(window)));
        }
        return allHandles;
    }

    public String getWindowHandle() {
        WebWindow topWindow = this.getCurrentWindow().getWebWindow().getTopWindow();
        if (topWindow.isClosed()) {
            throw new NoSuchWindowException("Window is closed");
        }
        return String.valueOf(System.identityHashCode(topWindow));
    }

    public Object executeScript(String script, Object ... args) {
        HtmlPage page = this.getPageToInjectScriptInto();
        script = "let huDriverFoo = function() {" + (String)script + "\n}; huDriverFoo;";
        ScriptResult result = page.executeJavaScript((String)script);
        Object function = result.getJavaScriptResult();
        Object[] parameters = this.convertScriptArgs(page, args);
        try {
            result = page.executeJavaScriptFunction(function, this.getCurrentWindow().getWebWindow().getScriptableObject(), parameters, (DomNode)page.getDocumentElement());
            return this.parseNativeJavascriptResult(result);
        }
        catch (Throwable ex) {
            throw new WebDriverException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeAsyncScript(String script, Object ... args) {
        HtmlPage page = this.getPageToInjectScriptInto();
        args = this.convertScriptArgs(page, args);
        this.asyncScriptExecutor_ = new AsyncScriptExecutor(page, this.options_.timeouts().getScriptTimeout().toMillis());
        try {
            Object result = this.asyncScriptExecutor_.execute(script, args);
            this.alert_.ensureUnlocked();
            Object object = this.parseNativeJavascriptResult(result);
            return object;
        }
        finally {
            this.asyncScriptExecutor_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] convertScriptArgs(HtmlPage page, Object[] args) {
        HtmlUnitScriptable scope = (HtmlUnitScriptable)page.getEnclosingWindow().getScriptableObject();
        if (scope == null) {
            return args;
        }
        Object[] parameters = new Object[args.length];
        Context.enter();
        try {
            for (int i = 0; i < args.length; ++i) {
                parameters[i] = this.parseArgumentIntoJavascriptParameter((Scriptable)scope, args[i]);
            }
        }
        finally {
            Context.exit();
        }
        return parameters;
    }

    private HtmlPage getPageToInjectScriptInto() {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("Javascript is not enabled for this HtmlUnitDriver instance");
        }
        Page lastPage = this.getCurrentWindow().lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            throw new UnsupportedOperationException("Cannot execute JS against a plain text page");
        }
        return (HtmlPage)lastPage;
    }

    private Object parseArgumentIntoJavascriptParameter(Scriptable scope, Object arg) {
        while (arg instanceof WrapsElement) {
            arg = ((WrapsElement)arg).getWrappedElement();
        }
        if (!(arg instanceof HtmlUnitWebElement || arg instanceof HtmlElement || arg instanceof Number || arg instanceof String || arg instanceof Boolean || arg instanceof Object[] || arg instanceof int[] || arg instanceof long[] || arg instanceof float[] || arg instanceof double[] || arg instanceof boolean[] || arg instanceof Collection || arg instanceof Map)) {
            throw new IllegalArgumentException("Argument must be a string, number, boolean or WebElement: " + String.valueOf(arg) + " (" + String.valueOf(arg.getClass()) + ")");
        }
        if (arg instanceof HtmlUnitWebElement) {
            HtmlUnitWebElement webElement = (HtmlUnitWebElement)arg;
            this.assertElementNotStale(webElement.getElement());
            return webElement.getElement().getScriptableObject();
        }
        if (arg instanceof HtmlElement) {
            HtmlElement element = (HtmlElement)arg;
            this.assertElementNotStale((DomElement)element);
            return element.getScriptableObject();
        }
        if (arg instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Collection)arg) {
                list.add(this.parseArgumentIntoJavascriptParameter(scope, o));
            }
            return Context.getCurrentContext().newArray(scope, list.toArray());
        }
        if (arg instanceof Object[]) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Object[])arg) {
                list.add(this.parseArgumentIntoJavascriptParameter(scope, o));
            }
            return Context.getCurrentContext().newArray(scope, list.toArray());
        }
        if (arg instanceof int[]) {
            ArrayList<Object> list = new ArrayList<Object>();
            int[] nArray = (int[])arg;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer o = nArray[i];
                list.add(this.parseArgumentIntoJavascriptParameter(scope, o));
            }
            return Context.getCurrentContext().newArray(scope, list.toArray());
        }
        if (arg instanceof long[]) {
            ArrayList<Object> list = new ArrayList<Object>();
            long[] lArray = (long[])arg;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long o = lArray[i];
                list.add(this.parseArgumentIntoJavascriptParameter(scope, o));
            }
            return Context.getCurrentContext().newArray(scope, list.toArray());
        }
        if (arg instanceof float[]) {
            ArrayList<Object> list = new ArrayList<Object>();
            float[] fArray = (float[])arg;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float o = Float.valueOf(fArray[i]);
                list.add(this.parseArgumentIntoJavascriptParameter(scope, o));
            }
            return Context.getCurrentContext().newArray(scope, list.toArray());
        }
        if (arg instanceof double[]) {
            ArrayList<Object> list = new ArrayList<Object>();
            double[] dArray = (double[])arg;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double o = dArray[i];
                list.add(this.parseArgumentIntoJavascriptParameter(scope, o));
            }
            return Context.getCurrentContext().newArray(scope, list.toArray());
        }
        if (arg instanceof boolean[]) {
            ArrayList<Object> list = new ArrayList<Object>();
            boolean[] blArray = (boolean[])arg;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                Boolean o = blArray[i];
                list.add(this.parseArgumentIntoJavascriptParameter(scope, o));
            }
            return Context.getCurrentContext().newArray(scope, list.toArray());
        }
        if (arg instanceof Map) {
            Map map = (Map)arg;
            Scriptable obj = Context.getCurrentContext().newObject(scope);
            for (Map.Entry entry : map.entrySet()) {
                obj.put((String)entry.getKey(), obj, this.parseArgumentIntoJavascriptParameter(scope, entry.getValue()));
            }
            return obj;
        }
        return arg;
    }

    protected void assertElementNotStale(DomElement element) {
        DomElement parentElement;
        SgmlPage elementPage = element.getPage();
        Page lastPage = this.getCurrentWindow().lastPage();
        if (!lastPage.equals(elementPage)) {
            throw new StaleElementReferenceException("Element appears to be stale. Did you navigate away from the page that contained it? And is the current window focused the same as the one holding this element?");
        }
        for (parentElement = element; parentElement != null && !(parentElement instanceof SgmlPage); parentElement = parentElement.getParentNode()) {
        }
        if (parentElement == null) {
            throw new StaleElementReferenceException("The element seems to be disconnected from the DOM. This means that a user cannot interact with it.");
        }
    }

    public HtmlUnitKeyboard getKeyboard() {
        return this.keyboard_;
    }

    public HtmlUnitMouse getMouse() {
        return this.mouse_;
    }

    private Object parseNativeJavascriptResult(Object result) {
        Object value = result instanceof ScriptResult ? ((ScriptResult)result).getJavaScriptResult() : result;
        if (value instanceof HTMLElement) {
            return this.toWebElement((DomElement)((HTMLElement)value).getDomNodeOrDie());
        }
        if (value instanceof DocumentProxy) {
            Element element = ((DocumentProxy)value).getDelegee().getDocumentElement();
            if (element instanceof HTMLElement) {
                return this.toWebElement((DomElement)((HTMLElement)element).getDomNodeOrDie());
            }
            throw new WebDriverException("Do not know how to coerce to an HTMLElement: " + String.valueOf(element));
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            String s = n.toString();
            if (!s.contains(".") || s.endsWith(".0")) {
                return n.longValue();
            }
            return n.doubleValue();
        }
        if (value instanceof NativeObject) {
            HashMap map = new HashMap((NativeObject)value);
            for (Map.Entry entry : map.entrySet()) {
                entry.setValue(this.parseNativeJavascriptResult(entry.getValue()));
            }
            return map;
        }
        if (value instanceof Location) {
            return HtmlUnitDriver.convertLocationToMap((Location)value);
        }
        if (value instanceof NativeArray) {
            final NativeArray array = (NativeArray)value;
            JavaScriptResultsCollection collection = new JavaScriptResultsCollection(){

                @Override
                public int getLength() {
                    return (int)array.getLength();
                }

                @Override
                public Object item(int index) {
                    return array.get(index);
                }
            };
            return this.parseJavascriptResultsList(collection);
        }
        if (value instanceof HTMLCollection) {
            final HTMLCollection array = (HTMLCollection)value;
            JavaScriptResultsCollection collection = new JavaScriptResultsCollection(){

                @Override
                public int getLength() {
                    return array.getLength();
                }

                @Override
                public Object item(int index) {
                    return array.get((Object)index);
                }
            };
            return this.parseJavascriptResultsList(collection);
        }
        if (value instanceof IdScriptableObject && value.getClass().getSimpleName().equals("NativeDate")) {
            long l = ((Number)HtmlUnitDriver.getPrivateField(value, "date")).longValue();
            return Instant.ofEpochMilli(l).toString();
        }
        if (Undefined.isUndefined((Object)value)) {
            return null;
        }
        return value;
    }

    private static Object getPrivateField(Object o, String fieldName) {
        try {
            Field field = o.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> convertLocationToMap(Location location) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protocol", location.getProtocol());
        map.put("host", location.getHost());
        map.put("hostname", location.getHostname());
        map.put("port", location.getPort());
        map.put("pathname", location.getPathname());
        map.put("search", location.getSearch());
        map.put("hash", location.getHash());
        map.put("href", location.getHref());
        return map;
    }

    private List<Object> parseJavascriptResultsList(JavaScriptResultsCollection array) {
        ArrayList<Object> list = new ArrayList<Object>(array.getLength());
        for (int i = 0; i < array.getLength(); ++i) {
            list.add(this.parseNativeJavascriptResult(array.item(i)));
        }
        return list;
    }

    public WebDriver.TargetLocator switchTo() {
        return this.targetLocator_;
    }

    public WebDriver.Navigation navigate() {
        return new HtmlUnitNavigation();
    }

    protected HtmlUnitWebElement toWebElement(DomElement element) {
        return this.getElementsMap().addIfAbsent(this, element);
    }

    public HtmlUnitWebElement toWebElement(String elementId) {
        return this.getElementsMap().getWebElement(elementId);
    }

    public boolean isJavascriptEnabled() {
        return this.getWebClient().getOptions().isJavaScriptEnabled();
    }

    public void setJavascriptEnabled(boolean enableJavascript) {
        this.getWebClient().getOptions().setJavaScriptEnabled(enableJavascript);
    }

    public boolean isDownloadImages() {
        return this.getWebClient().getOptions().isDownloadImages();
    }

    public void setDownloadImages(boolean downloadImages) {
        this.getWebClient().getOptions().setDownloadImages(downloadImages);
    }

    public void setAcceptInsecureCerts(boolean accept) {
        this.getWebClient().getOptions().setUseInsecureSSL(accept);
    }

    public boolean isAcceptInsecureCerts() {
        return this.getWebClient().getOptions().isUseInsecureSSL();
    }

    protected <X> X implicitlyWaitFor(Callable<X> condition) {
        long implicitWait = this.options_.timeouts().getImplicitWaitTimeout().toMillis();
        if (implicitWait < 200L) {
            try {
                return condition.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        long end = System.currentTimeMillis() + implicitWait;
        Exception lastException = null;
        do {
            X toReturn = null;
            try {
                toReturn = condition.call();
            }
            catch (Exception e) {
                lastException = e;
            }
            if (toReturn instanceof Boolean && !((Boolean)toReturn).booleanValue()) continue;
            if (toReturn != null) {
                return toReturn;
            }
            HtmlUnitDriver.sleepQuietly(200L);
        } while (System.currentTimeMillis() < end);
        if (lastException != null) {
            if (lastException instanceof RuntimeException) {
                throw (RuntimeException)lastException;
            }
            throw new WebDriverException((Throwable)lastException);
        }
        return null;
    }

    public WebClient getWebClient() {
        if (this.webClient_ == null) {
            throw new NoSuchSessionException("Session is closed");
        }
        return this.webClient_;
    }

    public HtmlUnitWindow getCurrentWindow() {
        if (this.webClient_ == null || this.currentWindow_ == null) {
            throw new NoSuchSessionException("Session is closed");
        }
        if (this.currentWindow_.getWebWindow().isClosed()) {
            throw new NoSuchWindowException("Window is closed");
        }
        return this.currentWindow_;
    }

    public WebDriver.Options manage() {
        return this.options_;
    }

    private static void sleepQuietly(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void perform(Collection<Sequence> sequences) {
        List<List<Action>> actionsByTick = Algorithms.extractActionSequence(sequences);
        Algorithms.dispatchActions(actionsByTick, this.inputProcessor_);
    }

    public void resetInputState() {
        this.inputProcessor_ = new HtmlUnitInputProcessor(this);
    }

    protected void switchToDefaultContentOfWindow(WebWindow window) {
        Page page = window.getEnclosedPage();
        if (page instanceof HtmlPage) {
            this.setCurrentWindow(page.getEnclosingWindow());
        }
    }

    public void openNewWindow() {
        WebWindow newWindow = this.webClient_.openWindow(UrlUtils.URL_ABOUT_BLANK, "");
        this.currentWindow_ = new HtmlUnitWindow(newWindow);
    }

    protected class HtmlUnitWebDriverOptions
    implements WebDriver.Options {
        private final HtmlUnitLogs logs_;
        private final HtmlUnitDriver driver_;
        private final HtmlUnitTimeouts timeouts_;

        protected HtmlUnitWebDriverOptions(HtmlUnitDriver driver) {
            this.driver_ = driver;
            this.logs_ = new HtmlUnitLogs(this.getWebClient());
            this.timeouts_ = new HtmlUnitTimeouts(this.getWebClient());
        }

        public Logs logs() {
            return this.logs_;
        }

        public void addCookie(Cookie cookie) {
            Page page = this.window().lastPage();
            if (!(page instanceof HtmlPage)) {
                throw new UnableToSetCookieException("You may not set cookies on a page that is not HTML");
            }
            String domain = this.getDomainForCookie();
            this.verifyDomain(cookie, domain);
            this.getWebClient().getCookieManager().addCookie(new org.htmlunit.util.Cookie(domain, cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure(), cookie.isHttpOnly(), cookie.getSameSite()));
        }

        private void verifyDomain(Cookie cookie, String expectedDomain) {
            Object domain = cookie.getDomain();
            if (domain == null) {
                return;
            }
            if ("".equals(domain)) {
                throw new InvalidCookieDomainException("Domain must not be an empty string. Consider using null instead");
            }
            if (((String)domain).matches(".*[^:]:\\d+$")) {
                domain = ((String)domain).replaceFirst(":\\d+$", "");
            }
            expectedDomain = ((String)expectedDomain).startsWith(".") ? expectedDomain : "." + (String)expectedDomain;
            Object object = domain = ((String)domain).startsWith(".") ? domain : "." + (String)domain;
            if (!((String)expectedDomain).endsWith((String)domain)) {
                throw new InvalidCookieDomainException(String.format("You may only add cookies that would be visible to the current domain: %s => %s", domain, expectedDomain));
            }
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
            return null;
        }

        public void deleteCookieNamed(String name) {
            CookieManager cookieManager = this.getWebClient().getCookieManager();
            URL url = this.getRawUrl();
            Set rawCookies = this.getWebClient().getCookies(url);
            for (org.htmlunit.util.Cookie cookie : rawCookies) {
                if (!name.equals(cookie.getName())) continue;
                cookieManager.removeCookie(cookie);
            }
        }

        public void deleteCookie(Cookie cookie) {
            this.getWebClient().getCookieManager().removeCookie(this.convertSeleniumCookieToHtmlUnit(cookie));
        }

        public void deleteAllCookies() {
            CookieManager cookieManager = this.getWebClient().getCookieManager();
            URL url = this.getRawUrl();
            Set rawCookies = this.getWebClient().getCookies(url);
            for (org.htmlunit.util.Cookie cookie : rawCookies) {
                cookieManager.removeCookie(cookie);
            }
        }

        public Set<Cookie> getCookies() {
            URL url = this.getRawUrl();
            if (!url.toString().startsWith("http")) {
                return Collections.emptySet();
            }
            HashSet<Cookie> result = new HashSet<Cookie>();
            for (org.htmlunit.util.Cookie c : this.getWebClient().getCookies(url)) {
                result.add(new Cookie.Builder(c.getName(), c.getValue()).domain(c.getDomain()).path(c.getPath()).expiresOn(c.getExpires()).isSecure(c.isSecure()).isHttpOnly(c.isHttpOnly()).sameSite(c.getSameSite()).build());
            }
            return Collections.unmodifiableSet(result);
        }

        private org.htmlunit.util.Cookie convertSeleniumCookieToHtmlUnit(Cookie cookie) {
            return new org.htmlunit.util.Cookie(cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure(), cookie.isHttpOnly(), cookie.getSameSite());
        }

        private String getDomainForCookie() {
            URL current = this.getRawUrl();
            return current.getHost();
        }

        private WebClient getWebClient() {
            return this.driver_.getWebClient();
        }

        public WebDriver.Timeouts timeouts() {
            return this.timeouts_;
        }

        public HtmlUnitWindow window() {
            return this.driver_.getCurrentWindow();
        }

        private URL getRawUrl() {
            return Optional.ofNullable(this.window().lastPage()).map(Page::getUrl).orElse(null);
        }
    }

    protected static class ElementsMap {
        private final Map<SgmlPage, Map<DomElement, HtmlUnitWebElement>> elementsMapByPage_ = new WeakHashMap<SgmlPage, Map<DomElement, HtmlUnitWebElement>>();
        private final Map<String, HtmlUnitWebElement> elementsMapById_ = new HashMap<String, HtmlUnitWebElement>();
        private int idCounter_ = 0;

        public HtmlUnitWebElement addIfAbsent(HtmlUnitDriver driver, DomElement element) {
            Map pageMap = this.elementsMapByPage_.computeIfAbsent(element.getPage(), k -> new HashMap());
            HtmlUnitWebElement e = (HtmlUnitWebElement)pageMap.get(element);
            if (e == null) {
                ++this.idCounter_;
                e = new HtmlUnitWebElement(driver, this.idCounter_, element);
                pageMap.put(element, e);
                this.elementsMapById_.put(Integer.toString(this.idCounter_), e);
            }
            return e;
        }

        public void remove(Page page) {
            Map<DomElement, HtmlUnitWebElement> pageMap = this.elementsMapByPage_.remove(page);
            if (pageMap != null) {
                pageMap.values().forEach(element -> this.elementsMapById_.remove(Integer.toString(element.getId())));
            }
        }

        public HtmlUnitWebElement getWebElement(String elementId) {
            HtmlUnitWebElement webElement = this.elementsMapById_.get(elementId);
            if (webElement == null) {
                throw new StaleElementReferenceException("Failed finding web element associated with identifier: " + elementId);
            }
            return webElement;
        }
    }

    private static enum PageLoadStrategy {
        NORMAL,
        EAGER,
        NONE;

    }

    private final class HtmlUnitNavigation
    implements WebDriver.Navigation {
        private HtmlUnitNavigation() {
        }

        public void back() {
            HtmlUnitDriver.this.runAsync(() -> {
                try {
                    HtmlUnitDriver.this.getCurrentWindow().getWebWindow().getHistory().back();
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            });
        }

        public void forward() {
            HtmlUnitDriver.this.runAsync(() -> {
                try {
                    HtmlUnitDriver.this.getCurrentWindow().getWebWindow().getHistory().forward();
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            });
        }

        public void to(String url) {
            HtmlUnitDriver.this.get(url);
        }

        public void to(URL url) {
            HtmlUnitDriver.this.get(url);
        }

        public void refresh() {
            if (HtmlUnitDriver.this.getCurrentWindow().lastPage() instanceof HtmlPage) {
                HtmlUnitDriver.this.runAsync(() -> {
                    try {
                        ((HtmlPage)HtmlUnitDriver.this.getCurrentWindow().lastPage()).refresh();
                    }
                    catch (SocketTimeoutException e) {
                        throw new TimeoutException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new WebDriverException((Throwable)e);
                    }
                });
            }
        }
    }

    protected static interface JavaScriptResultsCollection {
        public int getLength();

        public Object item(int var1);
    }
}

