/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.Version;
import com.gargoylesoftware.htmlunit.WaitingRefreshHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLHandshakeException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.IdScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UnableToSetCookieException;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.htmlunit.AsyncScriptExecutor;
import org.openqa.selenium.htmlunit.HtmlUnitAlert;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboard;
import org.openqa.selenium.htmlunit.HtmlUnitMouse;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.htmlunit.logging.HtmlUnitLogs;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.w3c.dom.Node;

public class HtmlUnitDriver
implements WebDriver,
JavascriptExecutor,
FindsById,
FindsByLinkText,
FindsByXPath,
FindsByName,
FindsByCssSelector,
FindsByTagName,
FindsByClassName,
HasCapabilities,
HasInputDevices {
    private static final int sleepTime = 200;
    private WebClient webClient;
    private WebWindow currentWindow;
    private HtmlUnitAlert alert;
    private Point windowPosition = new Point(0, 0);
    private Dimension initialWindowDimension;
    private long implicitWait = 0L;
    private long scriptTimeout = 0L;
    private HtmlUnitKeyboard keyboard;
    private HtmlUnitMouse mouse;
    private boolean gotPage;
    private WebDriver.TargetLocator targetLocator = new HtmlUnitTargetLocator();
    private AsyncScriptExecutor asyncScriptExecutor;
    private UnexpectedAlertBehaviour unexpectedAlertBehaviour;
    private PageLoadStrategy pageLoadStrategy = PageLoadStrategy.NORMAL;
    private int elementsCounter;
    private Map<SgmlPage, Map<DomElement, HtmlUnitWebElement>> elementsMap = new WeakHashMap<SgmlPage, Map<DomElement, HtmlUnitWebElement>>();
    private WebDriver.Options options;
    public static final String INVALIDXPATHERROR = "The xpath expression '%s' cannot be evaluated";
    public static final String INVALIDSELECTIONERROR = "The xpath expression '%s' selected an object of type '%s' instead of a WebElement";
    public static final String BROWSER_LANGUAGE_CAPABILITY = "browserLanguage";
    public static final String DOWNLOAD_IMAGES_CAPABILITY = "downloadImages";
    public static final String JAVASCRIPT_ENABLED = "javascriptEnabled";
    private Lock conditionLock = new ReentrantLock();
    private Condition mainCondition = this.conditionLock.newCondition();
    private boolean runAsyncRunning;
    private RuntimeException exception;
    private final ExecutorService defaultExecutor;
    private Executor executor;

    public HtmlUnitDriver() {
        this(BrowserVersion.getDefault(), false);
    }

    public HtmlUnitDriver(BrowserVersion version) {
        this(version, false);
    }

    public HtmlUnitDriver(boolean enableJavascript) {
        this(BrowserVersion.getDefault(), enableJavascript);
    }

    public HtmlUnitDriver(BrowserVersion version, boolean enableJavascript) {
        this(version, enableJavascript, null);
        this.modifyWebClient(this.webClient);
    }

    public HtmlUnitDriver(Capabilities capabilities) {
        this(HtmlUnitDriver.determineBrowserVersion(capabilities), capabilities.getCapability(JAVASCRIPT_ENABLED) == null || capabilities.is(JAVASCRIPT_ENABLED), Proxy.extractFrom((Capabilities)capabilities));
        Boolean acceptSslCerts;
        this.setDownloadImages(capabilities.is(DOWNLOAD_IMAGES_CAPABILITY));
        this.unexpectedAlertBehaviour = (UnexpectedAlertBehaviour)capabilities.getCapability("unexpectedAlertBehaviour");
        if (this.unexpectedAlertBehaviour == null) {
            this.unexpectedAlertBehaviour = UnexpectedAlertBehaviour.DISMISS_AND_NOTIFY;
        }
        if ((acceptSslCerts = (Boolean)capabilities.getCapability("acceptSslCerts")) == null) {
            acceptSslCerts = true;
        }
        this.setAcceptSslCertificates(acceptSslCerts);
        String pageLoadStrategyString = (String)capabilities.getCapability("pageLoadStrategy");
        if ("none".equals(pageLoadStrategyString)) {
            this.pageLoadStrategy = PageLoadStrategy.NONE;
        } else if ("eager".equals(pageLoadStrategyString)) {
            this.pageLoadStrategy = PageLoadStrategy.EAGER;
        }
        this.modifyWebClient(this.webClient);
    }

    public HtmlUnitDriver(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this((Capabilities)new DesiredCapabilities(new Capabilities[]{desiredCapabilities, requiredCapabilities}));
    }

    private HtmlUnitDriver(BrowserVersion version, boolean enableJavascript, Proxy proxy) {
        this.webClient = this.newWebClient(version);
        WebClientOptions clienOptions = this.webClient.getOptions();
        clienOptions.setHomePage(UrlUtils.URL_ABOUT_BLANK.toString());
        clienOptions.setThrowExceptionOnFailingStatusCode(false);
        clienOptions.setPrintContentOnFailingStatusCode(false);
        clienOptions.setRedirectEnabled(true);
        clienOptions.setUseInsecureSSL(true);
        this.setJavascriptEnabled(enableJavascript);
        this.setProxySettings(proxy);
        this.webClient.setRefreshHandler((RefreshHandler)new WaitingRefreshHandler());
        this.alert = new HtmlUnitAlert(this);
        this.currentWindow = this.webClient.getCurrentWindow();
        this.initialWindowDimension = new Dimension(this.currentWindow.getOuterWidth(), this.currentWindow.getOuterHeight());
        this.unexpectedAlertBehaviour = UnexpectedAlertBehaviour.DISMISS_AND_NOTIFY;
        this.defaultExecutor = Executors.newCachedThreadPool();
        this.executor = this.defaultExecutor;
        this.webClient.addWebWindowListener(new WebWindowListener(){

            public void webWindowOpened(WebWindowEvent webWindowEvent) {
            }

            public void webWindowContentChanged(WebWindowEvent event) {
                HtmlUnitDriver.this.elementsMap.remove(event.getOldPage());
                if (event.getWebWindow() != HtmlUnitDriver.this.currentWindow) {
                    return;
                }
                HtmlUnitDriver.this.switchToDefaultContentOfWindow(HtmlUnitDriver.this.currentWindow);
            }

            public void webWindowClosed(WebWindowEvent event) {
                HtmlUnitDriver.this.elementsMap.remove(event.getOldPage());
                WebWindow curr = HtmlUnitDriver.this.currentWindow;
                do {
                    if (curr != event.getWebWindow()) continue;
                    HtmlUnitDriver.this.currentWindow = HtmlUnitDriver.this.currentWindow.getTopWindow();
                    return;
                } while ((curr = curr.getParentWindow()) != HtmlUnitDriver.this.currentWindow.getTopWindow());
            }
        });
        this.get(clienOptions.getHomePage());
        this.gotPage = false;
        this.resetKeyboardAndMouseState();
        this.options = new HtmlUnitOptions();
    }

    static BrowserVersion determineBrowserVersion(Capabilities capabilities) {
        BrowserVersion browserVersionObject;
        String browserVersion;
        String browserName;
        String[] splitVersion;
        String capBrowserName = capabilities.getBrowserName();
        if (!"htmlunit".equals(capBrowserName)) {
            throw new IllegalArgumentException("When building an HtmlUntDriver, the capability browser name must be set to 'htmlunit' but was '" + capBrowserName + "'.");
        }
        String rawVersion = capabilities.getVersion();
        String[] stringArray = splitVersion = rawVersion == null ? new String[]{} : rawVersion.split("-");
        if (splitVersion.length > 1) {
            browserName = splitVersion[0];
            browserVersion = splitVersion[1];
        } else {
            browserName = capabilities.getVersion();
            browserVersion = null;
        }
        switch (browserName) {
            case "chrome": {
                browserVersionObject = BrowserVersion.CHROME;
                break;
            }
            case "MicrosoftEdge": {
                browserVersionObject = BrowserVersion.EDGE;
                break;
            }
            case "internet explorer": {
                browserVersionObject = BrowserVersion.INTERNET_EXPLORER;
                break;
            }
            case "firefox": {
                try {
                    int version = Integer.parseInt(browserVersion);
                    if (version == BrowserVersion.FIREFOX_78.getBrowserVersionNumeric()) {
                        browserVersionObject = BrowserVersion.FIREFOX_78;
                        break;
                    }
                    if (version == BrowserVersion.FIREFOX.getBrowserVersionNumeric()) {
                        browserVersionObject = BrowserVersion.FIREFOX;
                        break;
                    }
                    browserVersionObject = BrowserVersion.FIREFOX;
                }
                catch (NumberFormatException e) {
                    browserVersionObject = BrowserVersion.FIREFOX;
                }
                break;
            }
            default: {
                browserVersionObject = BrowserVersion.getDefault();
            }
        }
        Object rawLanguage = capabilities.getCapability(BROWSER_LANGUAGE_CAPABILITY);
        if (rawLanguage instanceof String) {
            browserVersionObject = new BrowserVersion.BrowserVersionBuilder(browserVersionObject).setBrowserLanguage((String)rawLanguage).build();
        }
        return browserVersionObject;
    }

    boolean isProcessAlert() {
        if (this.asyncScriptExecutor != null) {
            String text = this.alert.getText();
            this.alert.dismiss();
            this.asyncScriptExecutor.alertTriggered(text);
            return false;
        }
        this.conditionLock.lock();
        this.mainCondition.signal();
        this.conditionLock.unlock();
        return true;
    }

    void runAsync(Runnable r) {
        boolean loadStrategyWait;
        boolean bl = loadStrategyWait = this.pageLoadStrategy != PageLoadStrategy.NONE;
        if (loadStrategyWait) {
            while (this.runAsyncRunning) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.conditionLock.lock();
            this.runAsyncRunning = true;
        }
        this.exception = null;
        Runnable wrapped = () -> {
            try {
                r.run();
            }
            catch (RuntimeException e) {
                this.exception = e;
            }
            finally {
                this.conditionLock.lock();
                this.runAsyncRunning = false;
                this.mainCondition.signal();
                this.conditionLock.unlock();
            }
        };
        this.executor.execute(wrapped);
        if (loadStrategyWait && this.runAsyncRunning) {
            this.mainCondition.awaitUninterruptibly();
            this.conditionLock.unlock();
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    void click(DomElement element, boolean directClick) {
        this.runAsync(() -> this.mouse.click(element, directClick));
    }

    void doubleClick(DomElement element) {
        this.runAsync(() -> this.mouse.doubleClick(element));
    }

    void mouseUp(DomElement element) {
        this.runAsync(() -> this.mouse.mouseUp(element));
    }

    void mouseMove(DomElement element) {
        this.runAsync(() -> this.mouse.mouseMove(element));
    }

    void mouseDown(DomElement element) {
        this.runAsync(() -> this.mouse.mouseDown(element));
    }

    void submit(HtmlUnitWebElement element) {
        this.runAsync(() -> element.submitImpl());
    }

    void sendKeys(HtmlUnitWebElement element, CharSequence ... value) {
        this.runAsync(() -> this.keyboard.sendKeys(element, true, value));
    }

    public BrowserVersion getBrowserVersion() {
        return this.webClient.getBrowserVersion();
    }

    protected WebClient newWebClient(BrowserVersion version) {
        return new WebClient(version);
    }

    protected WebClient modifyWebClient(WebClient client) {
        return client;
    }

    public void setProxySettings(Proxy proxy) {
        if (proxy == null || proxy.getProxyType() == Proxy.ProxyType.UNSPECIFIED) {
            return;
        }
        switch (proxy.getProxyType()) {
            case MANUAL: {
                String socksProxy;
                String httpProxy;
                ArrayList<String> noProxyHosts = new ArrayList<String>();
                String noProxy = proxy.getNoProxy();
                if (noProxy != null && !noProxy.isEmpty()) {
                    String[] hosts;
                    for (String host : hosts = noProxy.split(",")) {
                        if (host.trim().length() <= 0) continue;
                        noProxyHosts.add(host.trim());
                    }
                }
                if ((httpProxy = proxy.getHttpProxy()) != null && !httpProxy.isEmpty()) {
                    String host = httpProxy;
                    int port = 0;
                    int index = httpProxy.indexOf(":");
                    if (index != -1) {
                        host = httpProxy.substring(0, index);
                        port = Integer.parseInt(httpProxy.substring(index + 1));
                    }
                    this.setHTTPProxy(host, port, noProxyHosts);
                }
                if ((socksProxy = proxy.getSocksProxy()) == null || socksProxy.isEmpty()) break;
                String host = socksProxy;
                int port = 0;
                int index = socksProxy.indexOf(":");
                if (index != -1) {
                    host = socksProxy.substring(0, index);
                    port = Integer.parseInt(socksProxy.substring(index + 1));
                }
                this.setSocksProxy(host, port, noProxyHosts);
                break;
            }
            case PAC: {
                String pac = proxy.getProxyAutoconfigUrl();
                if (pac == null || pac.isEmpty()) break;
                this.setAutoProxy(pac);
                break;
            }
        }
    }

    public void setProxy(String host, int port) {
        this.setHTTPProxy(host, port, null);
    }

    public void setHTTPProxy(String host, int port, List<String> noProxyHosts) {
        ProxyConfig proxyConfig = new ProxyConfig();
        proxyConfig.setProxyHost(host);
        proxyConfig.setProxyPort(port);
        if (noProxyHosts != null && noProxyHosts.size() > 0) {
            for (String noProxyHost : noProxyHosts) {
                proxyConfig.addHostsToProxyBypass(noProxyHost);
            }
        }
        this.getWebClient().getOptions().setProxyConfig(proxyConfig);
    }

    public void setSocksProxy(String host, int port) {
        this.setSocksProxy(host, port, null);
    }

    public void setSocksProxy(String host, int port, List<String> noProxyHosts) {
        ProxyConfig proxyConfig = new ProxyConfig();
        proxyConfig.setProxyHost(host);
        proxyConfig.setProxyPort(port);
        proxyConfig.setSocksProxy(true);
        if (noProxyHosts != null && noProxyHosts.size() > 0) {
            for (String noProxyHost : noProxyHosts) {
                proxyConfig.addHostsToProxyBypass(noProxyHost);
            }
        }
        this.getWebClient().getOptions().setProxyConfig(proxyConfig);
    }

    public void setExecutor(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        this.executor = executor;
    }

    public void setAutoProxy(String autoProxyUrl) {
        ProxyConfig proxyConfig = new ProxyConfig();
        proxyConfig.setProxyAutoConfigUrl(autoProxyUrl);
        this.getWebClient().getOptions().setProxyConfig(proxyConfig);
    }

    public Capabilities getCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
        capabilities.setPlatform(Platform.getCurrent());
        capabilities.setJavascriptEnabled(this.isJavascriptEnabled());
        capabilities.setVersion(Version.getProductVersion());
        capabilities.setCapability("cssSelectorsEnabled", true);
        return capabilities;
    }

    public void get(String url) {
        URL fullUrl;
        try {
            fullUrl = UrlUtils.toUrlUnsafe((String)url);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        this.runAsync(() -> this.get(fullUrl));
    }

    protected void get(URL fullUrl) {
        this.alert.close();
        this.alert.setAutoAccept(false);
        try {
            BrowserVersion browser = this.getBrowserVersion();
            WebRequest request = new WebRequest(fullUrl, browser.getHtmlAcceptHeader(), browser.getAcceptEncodingHeader());
            request.setCharset(StandardCharsets.UTF_8);
            this.getWebClient().getPage(this.getCurrentWindow().getTopWindow(), request);
            this.currentWindow = this.getCurrentWindow().getTopWindow();
        }
        catch (UnknownHostException e) {
            this.getCurrentWindow().getTopWindow().setEnclosedPage((Page)new UnexpectedPage((WebResponse)new StringWebResponse("Unknown host", fullUrl), this.getCurrentWindow().getTopWindow()));
        }
        catch (ConnectException e) {
        }
        catch (SocketTimeoutException e) {
            throw new TimeoutException((Throwable)e);
        }
        catch (NoSuchSessionException e) {
            throw e;
        }
        catch (SSLHandshakeException e) {
            return;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        this.gotPage = true;
        this.pickWindow();
        this.resetKeyboardAndMouseState();
    }

    private void resetKeyboardAndMouseState() {
        this.keyboard = new HtmlUnitKeyboard(this);
        this.mouse = new HtmlUnitMouse(this, this.keyboard);
    }

    protected void pickWindow() {
        if (this.currentWindow == null) {
            this.currentWindow = this.getWebClient().getCurrentWindow();
        }
    }

    public String getCurrentUrl() {
        this.getWebClient();
        Page page = this.getCurrentWindow().getTopWindow().getEnclosedPage();
        if (page == null) {
            return null;
        }
        URL url = page.getUrl();
        if (url == null) {
            return null;
        }
        return url.toString();
    }

    public String getTitle() {
        this.ensureAlertUnlocked();
        Page page = this.lastPage();
        if (page == null || !(page instanceof HtmlPage)) {
            return null;
        }
        if (this.getCurrentWindow() instanceof FrameWindow) {
            page = this.getCurrentWindow().getTopWindow().getEnclosedPage();
        }
        return ((HtmlPage)page).getTitleText();
    }

    private void ensureAlertUnlocked() {
        if (this.alert.isLocked()) {
            String text = this.alert.getText();
            switch (this.unexpectedAlertBehaviour) {
                case ACCEPT: {
                    this.alert.accept();
                    return;
                }
                case ACCEPT_AND_NOTIFY: {
                    this.alert.accept();
                    break;
                }
                case DISMISS: {
                    this.alert.dismiss();
                    return;
                }
                case DISMISS_AND_NOTIFY: {
                    this.alert.dismiss();
                    break;
                }
            }
            throw new UnhandledAlertException("Alert found", text);
        }
    }

    public WebElement findElement(By by) {
        return this.findElement(by, (SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return this.findElements(by, (SearchContext)this);
    }

    public String getPageSource() {
        Page page = this.lastPage();
        if (page == null) {
            return null;
        }
        if (page instanceof SgmlPage) {
            return ((SgmlPage)page).asXml();
        }
        WebResponse response = page.getWebResponse();
        return response.getContentAsString();
    }

    public void close() {
        this.getWebClient();
        if (this.getWebClient().getWebWindows().size() == 1) {
            this.quit();
        } else {
            WebWindow thisWindow = this.getCurrentWindow();
            if (thisWindow != null) {
                this.alert.close();
                ((TopLevelWindow)thisWindow.getTopWindow()).close();
            }
            if (this.getWebClient().getWebWindows().size() == 0) {
                this.quit();
            }
        }
    }

    public void quit() {
        if (this.webClient != null) {
            this.alert.close();
            this.webClient.close();
            this.webClient = null;
        }
        this.defaultExecutor.shutdown();
        this.currentWindow = null;
    }

    public Set<String> getWindowHandles() {
        HashSet allHandles = Sets.newHashSet();
        for (WebWindow window : this.getWebClient().getTopLevelWindows()) {
            allHandles.add(String.valueOf(System.identityHashCode(window)));
        }
        return allHandles;
    }

    public String getWindowHandle() {
        WebWindow topWindow = this.getCurrentWindow().getTopWindow();
        if (topWindow.isClosed()) {
            throw new NoSuchWindowException("Window is closed");
        }
        return String.valueOf(System.identityHashCode(topWindow));
    }

    public Object executeScript(String script, Object ... args) {
        HtmlPage page = this.getPageToInjectScriptInto();
        script = "function() {" + script + "\n};";
        ScriptResult result = page.executeJavaScript(script);
        Object function = result.getJavaScriptResult();
        Object[] parameters = this.convertScriptArgs(page, args);
        try {
            result = page.executeJavaScriptFunction(function, this.getCurrentWindow().getScriptableObject(), parameters, (DomNode)page.getDocumentElement());
            return this.parseNativeJavascriptResult(result);
        }
        catch (Throwable ex) {
            throw new WebDriverException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeAsyncScript(String script, Object ... args) {
        HtmlPage page = this.getPageToInjectScriptInto();
        args = this.convertScriptArgs(page, args);
        this.asyncScriptExecutor = new AsyncScriptExecutor(page, this.scriptTimeout);
        try {
            Object result = this.asyncScriptExecutor.execute(script, args);
            this.ensureAlertUnlocked();
            Object object = this.parseNativeJavascriptResult(result);
            return object;
        }
        finally {
            this.asyncScriptExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] convertScriptArgs(HtmlPage page, Object[] args) {
        Object scope = page.getEnclosingWindow().getScriptableObject();
        if (!(scope instanceof Scriptable)) {
            return args;
        }
        Object[] parameters = new Object[args.length];
        Context.enter();
        try {
            for (int i = 0; i < args.length; ++i) {
                parameters[i] = this.parseArgumentIntoJavascriptParameter((Scriptable)scope, args[i]);
            }
        }
        finally {
            Context.exit();
        }
        return parameters;
    }

    private HtmlPage getPageToInjectScriptInto() {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("Javascript is not enabled for this HtmlUnitDriver instance");
        }
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            throw new UnsupportedOperationException("Cannot execute JS against a plain text page");
        }
        if (!this.gotPage) {
            throw new WebDriverException("Can't execute JavaScript before a page has been loaded!");
        }
        return (HtmlPage)lastPage;
    }

    private Object parseArgumentIntoJavascriptParameter(Scriptable scope, Object arg) {
        while (arg instanceof WrapsElement) {
            arg = ((WrapsElement)arg).getWrappedElement();
        }
        if (!(arg instanceof HtmlUnitWebElement || arg instanceof HtmlElement || arg instanceof Number || arg instanceof String || arg instanceof Boolean || arg.getClass().isArray() || arg instanceof Collection || arg instanceof Map)) {
            throw new IllegalArgumentException("Argument must be a string, number, boolean or WebElement: " + arg + " (" + arg.getClass() + ")");
        }
        if (arg instanceof HtmlUnitWebElement) {
            HtmlUnitWebElement webElement = (HtmlUnitWebElement)arg;
            this.assertElementNotStale(webElement.getElement());
            return webElement.getElement().getScriptableObject();
        }
        if (arg instanceof HtmlElement) {
            HtmlElement element = (HtmlElement)arg;
            this.assertElementNotStale((DomElement)element);
            return element.getScriptableObject();
        }
        if (arg instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Collection)arg) {
                list.add(this.parseArgumentIntoJavascriptParameter(scope, o));
            }
            return Context.getCurrentContext().newArray(scope, list.toArray());
        }
        if (arg.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Object[])arg) {
                list.add(this.parseArgumentIntoJavascriptParameter(scope, o));
            }
            return Context.getCurrentContext().newArray(scope, list.toArray());
        }
        if (arg instanceof Map) {
            Map argmap = (Map)arg;
            Scriptable map = Context.getCurrentContext().newObject(scope);
            for (Object key : argmap.keySet()) {
                map.put((String)key, map, this.parseArgumentIntoJavascriptParameter(scope, argmap.get(key)));
            }
            return map;
        }
        return arg;
    }

    protected void assertElementNotStale(DomElement element) {
        DomElement parentElement;
        SgmlPage elementPage = element.getPage();
        Page lastPage = this.lastPage();
        if (!lastPage.equals(elementPage)) {
            throw new StaleElementReferenceException("Element appears to be stale. Did you navigate away from the page that contained it?  And is the current window focussed the same as the one holding this element?");
        }
        for (parentElement = element; parentElement != null && !(parentElement instanceof SgmlPage); parentElement = parentElement.getParentNode()) {
        }
        if (parentElement == null) {
            throw new StaleElementReferenceException("The element seems to be disconnected from the DOM.  This means that a user cannot interact with it.");
        }
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    private Object parseNativeJavascriptResult(Object result) {
        Object value = result instanceof ScriptResult ? ((ScriptResult)result).getJavaScriptResult() : result;
        if (value instanceof HTMLElement) {
            return this.toWebElement((DomElement)((HTMLElement)value).getDomNodeOrDie());
        }
        if (value instanceof DocumentProxy) {
            Element element = ((DocumentProxy)value).getDelegee().getDocumentElement();
            if (element instanceof HTMLElement) {
                return this.toWebElement((DomElement)((HTMLElement)element).getDomNodeOrDie());
            }
            throw new WebDriverException("Do not know how to coerce to an HTMLElement: " + element);
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            String s = n.toString();
            if (!s.contains(".") || s.endsWith(".0")) {
                return n.longValue();
            }
            return n.doubleValue();
        }
        if (value instanceof NativeObject) {
            HashMap map = Maps.newHashMap((Map)((NativeObject)value));
            for (Map.Entry entry : map.entrySet()) {
                entry.setValue(this.parseNativeJavascriptResult(entry.getValue()));
            }
            return map;
        }
        if (value instanceof Location) {
            return HtmlUnitDriver.convertLocationToMap((Location)value);
        }
        if (value instanceof NativeArray) {
            final NativeArray array = (NativeArray)value;
            JavaScriptResultsCollection collection = new JavaScriptResultsCollection(){

                @Override
                public int getLength() {
                    return (int)array.getLength();
                }

                @Override
                public Object item(int index) {
                    return array.get(index);
                }
            };
            return this.parseJavascriptResultsList(collection);
        }
        if (value instanceof HTMLCollection) {
            final HTMLCollection array = (HTMLCollection)value;
            JavaScriptResultsCollection collection = new JavaScriptResultsCollection(){

                @Override
                public int getLength() {
                    return array.getLength();
                }

                @Override
                public Object item(int index) {
                    return array.get((Object)index);
                }
            };
            return this.parseJavascriptResultsList(collection);
        }
        if (value instanceof IdScriptableObject && value.getClass().getSimpleName().equals("NativeDate")) {
            long l = ((Number)HtmlUnitDriver.getPrivateField(value, "date")).longValue();
            return Instant.ofEpochMilli(l).toString();
        }
        if (value instanceof Undefined) {
            return null;
        }
        return value;
    }

    private static Object getPrivateField(Object o, String fieldName) {
        try {
            Field field = o.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> convertLocationToMap(Location location) {
        HashMap map = Maps.newHashMap();
        map.put("href", location.getHref());
        map.put("protocol", location.getProtocol());
        map.put("host", location.getHost());
        map.put("hostname", location.getHostname());
        map.put("port", location.getPort());
        map.put("pathname", location.getPathname());
        map.put("search", location.getSearch());
        map.put("hash", location.getHash());
        map.put("href", location.getHref());
        return map;
    }

    private List<Object> parseJavascriptResultsList(JavaScriptResultsCollection array) {
        ArrayList<Object> list = new ArrayList<Object>(array.getLength());
        for (int i = 0; i < array.getLength(); ++i) {
            list.add(this.parseNativeJavascriptResult(array.item(i)));
        }
        return list;
    }

    public WebDriver.TargetLocator switchTo() {
        return this.targetLocator;
    }

    private void switchToDefaultContentOfWindow(WebWindow window) {
        Page page = window.getEnclosedPage();
        if (page instanceof HtmlPage) {
            this.currentWindow = window;
        }
    }

    public WebDriver.Navigation navigate() {
        return new HtmlUnitNavigation();
    }

    protected Page lastPage() {
        this.getWebClient();
        return this.getCurrentWindow().getEnclosedPage();
    }

    public WebElement findElementByLinkText(String selector) {
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            throw new IllegalStateException("Cannot find links for " + lastPage);
        }
        String expectedText = selector.trim();
        List anchors = ((HtmlPage)lastPage).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!expectedText.equals(anchor.asNormalizedText().trim())) continue;
            return this.toWebElement((DomElement)anchor);
        }
        throw new NoSuchElementException("No link found with text: " + expectedText);
    }

    protected HtmlUnitWebElement toWebElement(DomElement element) {
        HtmlUnitWebElement e;
        Map<DomElement, HtmlUnitWebElement> pageMap = this.elementsMap.get(element.getPage());
        if (pageMap == null) {
            pageMap = new HashMap<DomElement, HtmlUnitWebElement>();
            this.elementsMap.put(element.getPage(), pageMap);
        }
        if ((e = pageMap.get(element)) == null) {
            e = new HtmlUnitWebElement(this, ++this.elementsCounter, element);
            pageMap.put(element, e);
        }
        return e;
    }

    public HtmlUnitWebElement getElementById(int id) {
        for (Map<DomElement, HtmlUnitWebElement> pageMap : this.elementsMap.values()) {
            for (HtmlUnitWebElement e : pageMap.values()) {
                if (e.id != id) continue;
                return e;
            }
        }
        return null;
    }

    public List<WebElement> findElementsByLinkText(String selector) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            return elements;
        }
        String expectedText = selector.trim();
        List anchors = ((HtmlPage)lastPage).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!expectedText.equals(anchor.asNormalizedText().trim())) continue;
            elements.add(this.toWebElement((DomElement)anchor));
        }
        return elements;
    }

    public WebElement findElementById(String id) {
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            throw new NoSuchElementException("Unable to locate element by id for " + lastPage);
        }
        DomElement element = ((HtmlPage)lastPage).getElementById(id);
        if (element == null) {
            throw new NoSuchElementException("Unable to locate element with ID: '" + id + "'");
        }
        return this.toWebElement(element);
    }

    public List<WebElement> findElementsById(String id) {
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        List allElements = ((HtmlPage)lastPage).getElementsById(id);
        return this.convertRawDomElementsToWebElements(allElements);
    }

    public WebElement findElementByClassName(String className) {
        if (className.indexOf(32) != -1) {
            throw new NoSuchElementException("Compound class names not permitted");
        }
        return this.findElementByCssSelector("." + className);
    }

    public List<WebElement> findElementsByClassName(String className) {
        if (className.indexOf(32) != -1) {
            throw new NoSuchElementException("Compound class names not permitted");
        }
        return this.findElementsByCssSelector("." + className);
    }

    public WebElement findElementByCssSelector(String using) {
        DomNode node;
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            throw new NoSuchElementException("Unable to locate element using css: " + lastPage);
        }
        try {
            node = ((HtmlPage)lastPage).querySelector(using);
        }
        catch (CSSException ex) {
            throw new NoSuchElementException("Unable to locate element using css", (Throwable)ex);
        }
        if (node instanceof DomElement) {
            return this.toWebElement((DomElement)node);
        }
        throw new NoSuchElementException("Returned node (" + node + ") was not a DOM element");
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        DomNodeList allNodes;
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            throw new NoSuchElementException("Unable to locate element using css: " + lastPage);
        }
        try {
            allNodes = ((HtmlPage)lastPage).querySelectorAll(using);
        }
        catch (CSSException ex) {
            throw new NoSuchElementException("Unable to locate element using css", (Throwable)ex);
        }
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
        for (DomNode node : allNodes) {
            if (node instanceof DomElement) {
                toReturn.add(this.toWebElement((DomElement)node));
                continue;
            }
            throw new NoSuchElementException("Returned node was not a DOM element");
        }
        return toReturn;
    }

    public WebElement findElementByName(String name) {
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            throw new IllegalStateException("Unable to locate element by name for " + lastPage);
        }
        List allElements = ((HtmlPage)lastPage).getElementsByName(name);
        if (!allElements.isEmpty()) {
            return this.toWebElement((DomElement)allElements.get(0));
        }
        throw new NoSuchElementException("Unable to locate element with name: " + name);
    }

    public List<WebElement> findElementsByName(String name) {
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        List allElements = ((HtmlPage)lastPage).getElementsByName(name);
        return this.convertRawDomElementsToWebElements(allElements);
    }

    public WebElement findElementByTagName(String name) {
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            throw new IllegalStateException("Unable to locate element by name for " + lastPage);
        }
        DomNodeList allElements = ((HtmlPage)lastPage).getElementsByTagName(name);
        if (allElements.getLength() > 0) {
            return this.toWebElement((DomElement)((HtmlElement)allElements.item(0)));
        }
        throw new NoSuchElementException("Unable to locate element with name: " + name);
    }

    public List<WebElement> findElementsByTagName(String name) {
        if ("".equals(name)) {
            throw new InvalidSelectorException("Unable to locate element by xpath for " + this.lastPage());
        }
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        DomNodeList allElements = ((HtmlPage)lastPage).getElementsByTagName(name);
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>(allElements.getLength());
        for (int i = 0; i < allElements.getLength(); ++i) {
            Node item = allElements.item(i);
            if (!(item instanceof DomElement)) continue;
            toReturn.add(this.toWebElement((DomElement)item));
        }
        return toReturn;
    }

    public WebElement findElementByXPath(String selector) {
        Object node;
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof SgmlPage)) {
            throw new IllegalStateException("Unable to locate element by xpath for " + lastPage);
        }
        try {
            node = ((SgmlPage)lastPage).getFirstByXPath(selector);
        }
        catch (Exception ex) {
            throw new InvalidSelectorException(String.format(INVALIDXPATHERROR, selector), (Throwable)ex);
        }
        if (node == null) {
            throw new NoSuchElementException("Unable to locate a node using " + selector);
        }
        if (node instanceof DomElement) {
            return this.toWebElement((DomElement)node);
        }
        throw new InvalidSelectorException(String.format(INVALIDSELECTIONERROR, selector, node.getClass()));
    }

    public List<WebElement> findElementsByXPath(String selector) {
        List nodes;
        Page lastPage = this.lastPage();
        if (!(lastPage instanceof SgmlPage)) {
            return new ArrayList<WebElement>();
        }
        try {
            nodes = ((SgmlPage)lastPage).getByXPath(selector);
        }
        catch (RuntimeException ex) {
            throw new InvalidSelectorException(String.format(INVALIDXPATHERROR, selector), (Throwable)ex);
        }
        ArrayList<WebElement> elements = new ArrayList<WebElement>(nodes.size());
        for (Object node : nodes) {
            if (!(node instanceof DomElement)) {
                throw new InvalidSelectorException(String.format(INVALIDSELECTIONERROR, selector, node.getClass()));
            }
            elements.add(this.toWebElement((DomElement)node));
        }
        return elements;
    }

    private List<WebElement> convertRawDomElementsToWebElements(List<DomElement> nodes) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>(nodes.size());
        for (DomElement node : nodes) {
            elements.add(this.toWebElement(node));
        }
        return elements;
    }

    public boolean isJavascriptEnabled() {
        return this.getWebClient().getOptions().isJavaScriptEnabled();
    }

    public void setJavascriptEnabled(boolean enableJavascript) {
        this.getWebClient().getOptions().setJavaScriptEnabled(enableJavascript);
    }

    public boolean isDownloadImages() {
        return this.getWebClient().getOptions().isDownloadImages();
    }

    public void setDownloadImages(boolean downloadImages) {
        this.getWebClient().getOptions().setDownloadImages(downloadImages);
    }

    public void setAcceptSslCertificates(boolean accept) {
        this.getWebClient().getOptions().setUseInsecureSSL(accept);
    }

    public boolean isAcceptSslCertificates() {
        return this.getWebClient().getOptions().isUseInsecureSSL();
    }

    private static boolean isChild(WebWindow parent, WebWindow potentialChild) {
        for (WebWindow child = potentialChild; child != null; child = child.getParentWindow()) {
            if (child == parent) {
                return true;
            }
            if (child == child.getTopWindow()) break;
        }
        return false;
    }

    protected <X> X implicitlyWaitFor(Callable<X> condition) {
        if (this.implicitWait < 200L) {
            try {
                return condition.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        long end = System.currentTimeMillis() + this.implicitWait;
        Exception lastException = null;
        do {
            X toReturn = null;
            try {
                toReturn = condition.call();
            }
            catch (Exception e) {
                lastException = e;
            }
            if (toReturn instanceof Boolean && !((Boolean)toReturn).booleanValue()) continue;
            if (toReturn != null) {
                return toReturn;
            }
            HtmlUnitDriver.sleepQuietly(200L);
        } while (System.currentTimeMillis() < end);
        if (lastException != null) {
            if (lastException instanceof RuntimeException) {
                throw (RuntimeException)lastException;
            }
            throw new WebDriverException((Throwable)lastException);
        }
        return null;
    }

    protected WebClient getWebClient() {
        if (this.webClient == null) {
            throw new NoSuchSessionException("Session is closed");
        }
        return this.webClient;
    }

    protected WebWindow getCurrentWindow() {
        if (this.currentWindow == null || this.currentWindow.isClosed()) {
            throw new NoSuchWindowException("Window is closed");
        }
        return this.currentWindow;
    }

    private URL getRawUrl() {
        Page page = this.lastPage();
        if (page == null) {
            return null;
        }
        return page.getUrl();
    }

    public WebDriver.Options manage() {
        return this.options;
    }

    public WebElement findElementByPartialLinkText(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Cannot find links for " + this.lastPage());
        }
        List anchors = ((HtmlPage)this.lastPage()).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!anchor.asNormalizedText().contains(using)) continue;
            return this.toWebElement((DomElement)anchor);
        }
        throw new NoSuchElementException("No link found with text: " + using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        List anchors = ((HtmlPage)this.lastPage()).getAnchors();
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (HtmlAnchor anchor : anchors) {
            if (!anchor.asNormalizedText().contains(using)) continue;
            elements.add(this.toWebElement((DomElement)anchor));
        }
        return elements;
    }

    WebElement findElement(final By locator, final SearchContext context) {
        this.ensureAlertUnlocked();
        return this.implicitlyWaitFor(new Callable<WebElement>(){

            @Override
            public WebElement call() throws Exception {
                return locator.findElement(context);
            }
        });
    }

    List<WebElement> findElements(By by, SearchContext context) {
        List found;
        if (this.implicitWait < 200L) {
            return by.findElements(context);
        }
        long end = System.currentTimeMillis() + this.implicitWait;
        do {
            if (!(found = by.findElements(context)).isEmpty()) {
                return found;
            }
            HtmlUnitDriver.sleepQuietly(200L);
        } while (System.currentTimeMillis() < end);
        return found;
    }

    private static void sleepQuietly(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static enum PageLoadStrategy {
        NORMAL,
        EAGER,
        NONE;

    }

    public class HtmlUnitWindow
    implements WebDriver.Window {
        private int SCROLLBAR_WIDTH = 8;
        private int HEADER_HEIGHT = 150;

        public void setSize(Dimension targetSize) {
            WebWindow topWindow = HtmlUnitDriver.this.getCurrentWindow().getTopWindow();
            int width = targetSize.getWidth();
            if (width < this.SCROLLBAR_WIDTH) {
                width = this.SCROLLBAR_WIDTH;
            }
            topWindow.setOuterWidth(width);
            topWindow.setInnerWidth(width - this.SCROLLBAR_WIDTH);
            int height = targetSize.getHeight();
            if (height < this.HEADER_HEIGHT) {
                height = this.HEADER_HEIGHT;
            }
            topWindow.setOuterHeight(height);
            topWindow.setInnerHeight(height - this.HEADER_HEIGHT);
        }

        public void setPosition(Point targetPosition) {
            HtmlUnitDriver.this.windowPosition = targetPosition;
        }

        public Dimension getSize() {
            WebWindow topWindow = HtmlUnitDriver.this.getCurrentWindow().getTopWindow();
            return new Dimension(topWindow.getOuterWidth(), topWindow.getOuterHeight());
        }

        public Point getPosition() {
            return HtmlUnitDriver.this.windowPosition;
        }

        public void maximize() {
            this.setSize(HtmlUnitDriver.this.initialWindowDimension);
            this.setPosition(new Point(0, 0));
        }

        public void fullscreen() {
            this.maximize();
        }
    }

    class HtmlUnitTimeouts
    implements WebDriver.Timeouts {
        HtmlUnitTimeouts() {
        }

        public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
            HtmlUnitDriver.this.implicitWait = TimeUnit.MILLISECONDS.convert(Math.max(0L, time), unit);
            return this;
        }

        public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
            HtmlUnitDriver.this.scriptTimeout = TimeUnit.MILLISECONDS.convert(time, unit);
            return this;
        }

        public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
            int timeout = (int)TimeUnit.MILLISECONDS.convert(time, unit);
            HtmlUnitDriver.this.getWebClient().getOptions().setTimeout(timeout > 0 ? timeout : 0);
            return this;
        }
    }

    private class HtmlUnitOptions
    implements WebDriver.Options {
        private final HtmlUnitLogs logs;
        private final Function<? super com.gargoylesoftware.htmlunit.util.Cookie, Cookie> htmlUnitCookieToSeleniumCookieTransformer = new Function<com.gargoylesoftware.htmlunit.util.Cookie, Cookie>(){

            public Cookie apply(com.gargoylesoftware.htmlunit.util.Cookie c) {
                return new Cookie.Builder(c.getName(), c.getValue()).domain(c.getDomain()).path(c.getPath()).expiresOn(c.getExpires()).isSecure(c.isSecure()).isHttpOnly(c.isHttpOnly()).build();
            }
        };

        public HtmlUnitOptions() {
            this.logs = new HtmlUnitLogs(HtmlUnitDriver.this.getWebClient());
        }

        public Logs logs() {
            return this.logs;
        }

        public void addCookie(Cookie cookie) {
            Page page = HtmlUnitDriver.this.lastPage();
            if (!(page instanceof HtmlPage)) {
                throw new UnableToSetCookieException("You may not set cookies on a page that is not HTML");
            }
            String domain = this.getDomainForCookie();
            this.verifyDomain(cookie, domain);
            HtmlUnitDriver.this.getWebClient().getCookieManager().addCookie(new com.gargoylesoftware.htmlunit.util.Cookie(domain, cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure()));
        }

        private void verifyDomain(Cookie cookie, String expectedDomain) {
            String domain = cookie.getDomain();
            if (domain == null) {
                return;
            }
            if ("".equals(domain)) {
                throw new InvalidCookieDomainException("Domain must not be an empty string. Consider using null instead");
            }
            if (domain.matches(".*[^:]:\\d+$")) {
                domain = domain.replaceFirst(":\\d+$", "");
            }
            expectedDomain = expectedDomain.startsWith(".") ? expectedDomain : "." + expectedDomain;
            String string = domain = domain.startsWith(".") ? domain : "." + domain;
            if (!expectedDomain.endsWith(domain)) {
                throw new InvalidCookieDomainException(String.format("You may only add cookies that would be visible to the current domain: %s => %s", domain, expectedDomain));
            }
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
            return null;
        }

        public void deleteCookieNamed(String name) {
            CookieManager cookieManager = HtmlUnitDriver.this.getWebClient().getCookieManager();
            URL url = HtmlUnitDriver.this.getRawUrl();
            Set rawCookies = HtmlUnitDriver.this.getWebClient().getCookies(url);
            for (com.gargoylesoftware.htmlunit.util.Cookie cookie : rawCookies) {
                if (!name.equals(cookie.getName())) continue;
                cookieManager.removeCookie(cookie);
            }
        }

        public void deleteCookie(Cookie cookie) {
            HtmlUnitDriver.this.getWebClient().getCookieManager().removeCookie(this.convertSeleniumCookieToHtmlUnit(cookie));
        }

        public void deleteAllCookies() {
            CookieManager cookieManager = HtmlUnitDriver.this.getWebClient().getCookieManager();
            URL url = HtmlUnitDriver.this.getRawUrl();
            Set rawCookies = HtmlUnitDriver.this.getWebClient().getCookies(url);
            for (com.gargoylesoftware.htmlunit.util.Cookie cookie : rawCookies) {
                cookieManager.removeCookie(cookie);
            }
        }

        public Set<Cookie> getCookies() {
            URL url = HtmlUnitDriver.this.getRawUrl();
            if (!url.toString().startsWith("http")) {
                return Sets.newHashSet();
            }
            return ImmutableSet.copyOf((Collection)Collections2.transform((Collection)HtmlUnitDriver.this.getWebClient().getCookies(url), this.htmlUnitCookieToSeleniumCookieTransformer));
        }

        private com.gargoylesoftware.htmlunit.util.Cookie convertSeleniumCookieToHtmlUnit(Cookie cookie) {
            return new com.gargoylesoftware.htmlunit.util.Cookie(cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure(), cookie.isHttpOnly());
        }

        private String getDomainForCookie() {
            URL current = HtmlUnitDriver.this.getRawUrl();
            return current.getHost();
        }

        public WebDriver.Timeouts timeouts() {
            return new HtmlUnitTimeouts();
        }

        public WebDriver.ImeHandler ime() {
            throw new UnsupportedOperationException("Cannot input IME using HtmlUnit.");
        }

        public WebDriver.Window window() {
            return new HtmlUnitWindow();
        }
    }

    private class HtmlUnitNavigation
    implements WebDriver.Navigation {
        private HtmlUnitNavigation() {
        }

        public void back() {
            HtmlUnitDriver.this.runAsync(() -> {
                try {
                    HtmlUnitDriver.this.getCurrentWindow().getHistory().back();
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            });
        }

        public void forward() {
            HtmlUnitDriver.this.runAsync(() -> {
                try {
                    HtmlUnitDriver.this.getCurrentWindow().getHistory().forward();
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            });
        }

        public void to(String url) {
            HtmlUnitDriver.this.get(url);
        }

        public void to(URL url) {
            HtmlUnitDriver.this.get(url);
        }

        public void refresh() {
            if (HtmlUnitDriver.this.lastPage() instanceof HtmlPage) {
                HtmlUnitDriver.this.runAsync(() -> {
                    try {
                        ((HtmlPage)HtmlUnitDriver.this.lastPage()).refresh();
                    }
                    catch (SocketTimeoutException e) {
                        throw new TimeoutException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new WebDriverException((Throwable)e);
                    }
                });
            }
        }
    }

    private class HtmlUnitTargetLocator
    implements WebDriver.TargetLocator {
        private HtmlUnitTargetLocator() {
        }

        public WebDriver frame(int index) {
            Page page = HtmlUnitDriver.this.lastPage();
            if (page instanceof HtmlPage) {
                try {
                    HtmlUnitDriver.this.currentWindow = (WebWindow)((HtmlPage)page).getFrames().get(index);
                }
                catch (IndexOutOfBoundsException ignored) {
                    throw new NoSuchFrameException("Cannot find frame: " + index);
                }
            }
            return HtmlUnitDriver.this;
        }

        public WebDriver frame(String nameOrId) {
            Page page = HtmlUnitDriver.this.lastPage();
            if (page instanceof HtmlPage) {
                for (FrameWindow frameWindow : ((HtmlPage)page).getFrames()) {
                    if (!frameWindow.getName().equals(nameOrId)) continue;
                    HtmlUnitDriver.this.currentWindow = (WebWindow)frameWindow;
                    return HtmlUnitDriver.this;
                }
            }
            try {
                HtmlUnitWebElement element = (HtmlUnitWebElement)HtmlUnitDriver.this.findElementById(nameOrId);
                DomElement domElement = element.getElement();
                if (domElement instanceof BaseFrameElement) {
                    HtmlUnitDriver.this.currentWindow = (WebWindow)((BaseFrameElement)domElement).getEnclosedWindow();
                    return HtmlUnitDriver.this;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            throw new NoSuchFrameException("Unable to locate frame with name or ID: " + nameOrId);
        }

        public WebDriver frame(WebElement frameElement) {
            while (frameElement instanceof WrapsElement) {
                frameElement = ((WrapsElement)frameElement).getWrappedElement();
            }
            HtmlUnitWebElement webElement = (HtmlUnitWebElement)frameElement;
            webElement.assertElementNotStale();
            DomElement domElement = webElement.getElement();
            if (!(domElement instanceof BaseFrameElement)) {
                throw new NoSuchFrameException(webElement.getTagName() + " is not a frame element.");
            }
            HtmlUnitDriver.this.currentWindow = (WebWindow)((BaseFrameElement)domElement).getEnclosedWindow();
            return HtmlUnitDriver.this;
        }

        public WebDriver parentFrame() {
            HtmlUnitDriver.this.currentWindow = HtmlUnitDriver.this.currentWindow.getParentWindow();
            return HtmlUnitDriver.this;
        }

        public WebDriver window(String windowId) {
            try {
                WebWindow window = HtmlUnitDriver.this.getWebClient().getWebWindowByName(windowId);
                return this.finishSelecting(window);
            }
            catch (WebWindowNotFoundException e) {
                List allWindows = HtmlUnitDriver.this.getWebClient().getWebWindows();
                for (WebWindow current : allWindows) {
                    WebWindow top = current.getTopWindow();
                    if (!String.valueOf(System.identityHashCode(top)).equals(windowId)) continue;
                    return this.finishSelecting(top);
                }
                throw new NoSuchWindowException("Cannot find window: " + windowId);
            }
        }

        private WebDriver finishSelecting(WebWindow window) {
            HtmlUnitDriver.this.getWebClient().setCurrentWindow(window);
            HtmlUnitDriver.this.currentWindow = window;
            HtmlUnitDriver.this.pickWindow();
            HtmlUnitDriver.this.alert.setAutoAccept(false);
            return HtmlUnitDriver.this;
        }

        public WebDriver defaultContent() {
            HtmlUnitDriver.this.switchToDefaultContentOfWindow(HtmlUnitDriver.this.getCurrentWindow().getTopWindow());
            return HtmlUnitDriver.this;
        }

        public WebElement activeElement() {
            Page page = HtmlUnitDriver.this.lastPage();
            if (page instanceof HtmlPage) {
                DomElement element = ((HtmlPage)page).getFocusedElement();
                if (element == null || element instanceof HtmlHtml) {
                    DomNodeList allBodies = ((HtmlPage)page).getDocumentElement().getElementsByTagName("body");
                    if (!allBodies.isEmpty()) {
                        return HtmlUnitDriver.this.toWebElement((DomElement)allBodies.get(0));
                    }
                } else {
                    return HtmlUnitDriver.this.toWebElement(element);
                }
            }
            throw new NoSuchElementException("Unable to locate element with focus or body tag");
        }

        public Alert alert() {
            WebWindow alertWindow;
            if (!HtmlUnitDriver.this.alert.isLocked()) {
                for (int i = 0; i < 5; ++i) {
                    if (HtmlUnitDriver.this.alert.isLocked()) continue;
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!HtmlUnitDriver.this.alert.isLocked()) {
                    HtmlUnitDriver.this.getCurrentWindow();
                    throw new NoAlertPresentException();
                }
            }
            if ((alertWindow = HtmlUnitDriver.this.alert.getWebWindow()) != HtmlUnitDriver.this.currentWindow && !HtmlUnitDriver.isChild(HtmlUnitDriver.this.currentWindow, alertWindow) && !HtmlUnitDriver.isChild(alertWindow, HtmlUnitDriver.this.currentWindow)) {
                throw new TimeoutException();
            }
            return HtmlUnitDriver.this.alert;
        }
    }

    protected static interface JavaScriptResultsCollection {
        public int getLength();

        public Object item(int var1);
    }
}

