/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.shared.yaml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.ZoneOffset;
import java.util.List;
import java.util.TimeZone;
import org.sdase.commons.shared.yaml.YamlLoadException;
import org.sdase.commons.shared.yaml.YamlWriteException;

public class YamlUtil {
    private static YAMLMapper mapper = YamlUtil.configuredMapper();
    private static YAMLFactory yamlFactory = new YAMLFactory();

    private YamlUtil() {
    }

    public static <T> T load(URL resource, Class<T> clazz) {
        try {
            return (T)mapper.readValue(resource, clazz);
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static <T> T load(URL resource, TypeReference<T> typeReference) {
        try {
            return (T)mapper.readValue(resource, typeReference);
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static <T> T load(InputStream resource, Class<T> clazz) {
        try {
            return (T)mapper.readValue(resource, clazz);
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static <T> T load(InputStream resource, TypeReference<T> typeReference) {
        try {
            return (T)mapper.readValue(resource, typeReference);
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static <T> T load(String content, Class<T> clazz) {
        try {
            return (T)mapper.readValue(content, clazz);
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static <T> T load(String content, TypeReference<T> typeReference) {
        try {
            return (T)mapper.readValue(content, typeReference);
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static <T> List<T> loadList(URL resource, Class<T> clazz) {
        try {
            YAMLParser parser = yamlFactory.createParser(resource);
            return mapper.readValues((JsonParser)parser, clazz).readAll();
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static <T> List<T> loadList(URL resource, TypeReference<T> typeReference) {
        try {
            YAMLParser parser = yamlFactory.createParser(resource);
            return mapper.readValues((JsonParser)parser, typeReference).readAll();
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static <T> List<T> loadList(InputStream resource, Class<T> clazz) {
        try {
            YAMLParser parser = yamlFactory.createParser(resource);
            return mapper.readValues((JsonParser)parser, clazz).readAll();
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static <T> List<T> loadList(InputStream resource, TypeReference<T> typeReference) {
        try {
            YAMLParser parser = yamlFactory.createParser(resource);
            return mapper.readValues((JsonParser)parser, typeReference).readAll();
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static <T> List<T> loadList(String content, Class<T> clazz) {
        try {
            YAMLParser parser = yamlFactory.createParser(content);
            return mapper.readValues((JsonParser)parser, clazz).readAll();
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static <T> List<T> loadList(String content, TypeReference<T> typeReference) {
        try {
            YAMLParser parser = yamlFactory.createParser(content);
            return mapper.readValues((JsonParser)parser, typeReference).readAll();
        }
        catch (IOException ioe) {
            throw new YamlLoadException(ioe);
        }
    }

    public static String writeValueAsString(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException jpe) {
            throw new YamlWriteException(jpe);
        }
    }

    private static YAMLMapper configuredMapper() {
        YAMLMapper mapper = new YAMLMapper();
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES).disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC)).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_YAML_COMMENTS}).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
        return mapper;
    }
}

