/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.topicana;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Deprecated
public class ComparisonResult {
    private final Set<String> missingTopics;
    private final Map<String, Comparison<Integer>> mismatchingReplicationFactor;
    private final Map<String, Comparison<Integer>> mismatchingPartitionCount;
    private final Map<String, Collection<Comparison<String>>> mismatchingConfiguration;

    ComparisonResult(Set<String> missingTopics, Map<String, Comparison<Integer>> mismatchingReplicationFactor, Map<String, Comparison<Integer>> mismatchingPartitionCount, Map<String, Collection<Comparison<String>>> mismatchingConfiguration) {
        this.missingTopics = missingTopics;
        this.mismatchingReplicationFactor = mismatchingReplicationFactor;
        this.mismatchingPartitionCount = mismatchingPartitionCount;
        this.mismatchingConfiguration = mismatchingConfiguration;
    }

    public boolean ok() {
        return this.missingTopics.isEmpty() && this.mismatchingReplicationFactor.isEmpty() && this.mismatchingPartitionCount.isEmpty() && this.mismatchingConfiguration.isEmpty();
    }

    public Set<String> getMissingTopics() {
        return this.missingTopics;
    }

    public Map<String, Comparison<Integer>> getMismatchingReplicationFactor() {
        return this.mismatchingReplicationFactor;
    }

    public Map<String, Comparison<Integer>> getMismatchingPartitionCount() {
        return this.mismatchingPartitionCount;
    }

    public Map<String, Collection<Comparison<String>>> getMismatchingConfiguration() {
        return this.mismatchingConfiguration;
    }

    public String toString() {
        return "ComparisonResult{missingTopics=" + this.missingTopics + ", mismatchingReplicationFactor=" + this.mismatchingReplicationFactor + ", mismatchingPartitionCount=" + this.mismatchingPartitionCount + ", mismatchingConfiguration=" + this.mismatchingConfiguration + '}';
    }

    public static class ComparisonResultBuilder {
        private final Set<String> missingTopics = new HashSet<String>();
        private final Map<String, Comparison<Integer>> mismatchingReplicationFactor = new HashMap<String, Comparison<Integer>>();
        private final Map<String, Comparison<Integer>> mismatchingPartitionCount = new HashMap<String, Comparison<Integer>>();
        private final Map<String, Collection<Comparison<String>>> mismatchingConfiguration = new HashMap<String, Collection<Comparison<String>>>();

        public ComparisonResultBuilder addMissingTopic(String missingTopic) {
            this.missingTopics.add(missingTopic);
            return this;
        }

        public ComparisonResultBuilder addMismatchingReplicationFactor(String topicName, int expected, int actual) {
            this.mismatchingReplicationFactor.put(topicName, new Comparison(topicName, "replication factor", actual, expected));
            return this;
        }

        public ComparisonResultBuilder addMismatchingPartitionCount(String topicName, int expected, int actual) {
            this.mismatchingPartitionCount.put(topicName, new Comparison(topicName, "partition count", actual, expected));
            return this;
        }

        public ComparisonResultBuilder addMismatchingConfiguration(String topicName, String property, String expected, String actual) {
            this.mismatchingConfiguration.putIfAbsent(topicName, new ArrayList());
            this.mismatchingConfiguration.get(topicName).add(new Comparison(topicName, property, actual, expected));
            return this;
        }

        public ComparisonResult build() {
            return new ComparisonResult(this.missingTopics, this.mismatchingReplicationFactor, this.mismatchingPartitionCount, this.mismatchingConfiguration);
        }
    }

    public static class Comparison<T> {
        private final String topicName;
        private final T actualValue;
        private final T expectedValue;
        private final String property;

        private Comparison(String topicName, String description, T actual, T expected) {
            this.topicName = topicName;
            this.actualValue = actual;
            this.expectedValue = expected;
            this.property = description;
        }

        private Comparison(String topicName, T actual, T expected) {
            this(topicName, null, actual, expected);
        }

        public String getTopicName() {
            return this.topicName;
        }

        public T getActualValue() {
            return this.actualValue;
        }

        public T getExpectedValue() {
            return this.expectedValue;
        }

        public String getProperty() {
            return this.property;
        }

        public String toString() {
            return "Comparison{topicName='" + this.topicName + '\'' + ", property='" + this.property + '\'' + ", actualValue=" + this.actualValue + ", expectedValue=" + this.expectedValue + '}';
        }
    }
}

