/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.serializers;

import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedNoSerializationErrorDeserializer<T>
implements Deserializer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WrappedNoSerializationErrorDeserializer.class);
    private Deserializer<T> wrappedDeserializer;

    public WrappedNoSerializationErrorDeserializer(Deserializer<T> deserializer) {
        this.wrappedDeserializer = deserializer;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.wrappedDeserializer.configure(configs, isKey);
    }

    public T deserialize(String topic, byte[] data) {
        try {
            return (T)this.wrappedDeserializer.deserialize(topic, data);
        }
        catch (SerializationException e) {
            LOGGER.error("Unable to deserialize record for topic {} due to exception", (Object)topic, (Object)e);
            return null;
        }
    }

    public void close() {
        this.wrappedDeserializer.close();
    }
}

