/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.serializers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaJsonSerializer<T>
implements Serializer<T> {
    private ObjectMapper objectMapper;

    public KafkaJsonSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, T data) {
        if (data == null) {
            return new byte[0];
        }
        try {
            return this.objectMapper.writeValueAsBytes(data);
        }
        catch (Exception e) {
            throw new SerializationException("Error serializing JSON message", (Throwable)e);
        }
    }

    public void close() {
    }
}

