/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;

public class ProducerTopicMessageCounter {
    private static final String METRIC_NAME = "kafka_producer_topic_message";
    private static final String HELP = "Amount of messages published by Kafka producers.";
    private static final String[] LABELS = new String[]{"producer_name", "topic_name"};
    private Counter topicMessagesCounter = this.createAndRegister();

    public void unregister() {
        CollectorRegistry.defaultRegistry.unregister((Collector)this.topicMessagesCounter);
    }

    public void increase(String producerName, String topicName) {
        String[] labelValues = this.createLabelValuesForCurrentRequest(producerName, topicName);
        ((Counter.Child)this.topicMessagesCounter.labels(labelValues)).inc();
    }

    private String[] createLabelValuesForCurrentRequest(String producerName, String topicName) {
        return new String[]{producerName, topicName};
    }

    private Counter createAndRegister() {
        Counter.Builder topicMessageCounterBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(METRIC_NAME)).labelNames(LABELS)).help(HELP);
        Counter counter = topicMessageCounterBuilder.create();
        CollectorRegistry.defaultRegistry.register((Collector)counter);
        return counter;
    }
}

