/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.sdase.commons.server.kafka.consumer.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerMetrics
extends Collector {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaConsumerMetrics.class);
    private static final String METRIC_NAME_PREFIX = "kafka_consumer_";
    private static final String[] KAFKA_METRICS = new String[]{"records-lag"};
    private static final String[] LABELS = new String[]{"consumer_name"};
    private static final String KAFKA_METRIC_TAG_CLIENT_ID = "client-id";
    private List<MessageListener<?, ?>> messageListeners;

    public KafkaConsumerMetrics(List<MessageListener<?, ?>> messageListeners) {
        this.messageListeners = messageListeners;
        this.register();
        LOGGER.debug("Registered Kafka Consumer Metrics Collector.");
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.messageListeners.forEach(listener -> mfs.addAll(this.collectGaugesPerListener(listener.getConsumer().metrics())));
        return mfs;
    }

    private List<GaugeMetricFamily> collectGaugesPerListener(Map<MetricName, ? extends Metric> metrics) {
        ArrayList<GaugeMetricFamily> list = new ArrayList<GaugeMetricFamily>();
        Arrays.stream(KAFKA_METRICS).forEach(metricName -> list.add(this.collectKafkaMetric(this.metricByNameOrNull(metrics, (String)metricName))));
        list.removeIf(Objects::isNull);
        return list;
    }

    private GaugeMetricFamily collectKafkaMetric(Map.Entry<MetricName, ? extends Metric> kafkaMetric) {
        if (kafkaMetric == null) {
            return null;
        }
        String normalizedMetricName = METRIC_NAME_PREFIX + kafkaMetric.getKey().name().replace('-', '_');
        GaugeMetricFamily labeledGauge = new GaugeMetricFamily(normalizedMetricName, kafkaMetric.getKey().description(), Arrays.asList(LABELS));
        String[] labelValues = this.createLabelValuesForCurrentMessage((String)kafkaMetric.getKey().tags().get(KAFKA_METRIC_TAG_CLIENT_ID));
        labeledGauge.addMetric(Arrays.asList(labelValues), ((Double)kafkaMetric.getValue().metricValue()).doubleValue());
        return labeledGauge;
    }

    private String[] createLabelValuesForCurrentMessage(String consumerName) {
        return new String[]{consumerName};
    }

    private Map.Entry<MetricName, ? extends Metric> metricByNameOrNull(Map<MetricName, ? extends Metric> metrics, String name) {
        return metrics.entrySet().stream().filter(mx -> ((MetricName)mx.getKey()).name().equals(name)).findFirst().orElse(null);
    }
}

