/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Histogram;

public class ConsumerTopicMessageHistogram {
    private static final String METRIC_NAME = "kafka_consumer_topic_message_duration";
    private static final String HELP = "Duration of Kafka Messages consumed in seconds.";
    private static final String[] LABELS = new String[]{"consumer_name", "topic_name"};
    private Histogram messageDurationHistogram = this.createAndRegister();

    public void unregister() {
        CollectorRegistry.defaultRegistry.unregister((Collector)this.messageDurationHistogram);
    }

    public void observe(double durationSeconds, String producerName, String topicName) {
        String[] labelValues = this.createLabelValuesForCurrentMessage(producerName, topicName);
        ((Histogram.Child)this.messageDurationHistogram.labels(labelValues)).observe(durationSeconds);
    }

    private String[] createLabelValuesForCurrentMessage(String producerName, String topicName) {
        return new String[]{producerName, topicName};
    }

    private Histogram createAndRegister() {
        Histogram.Builder histogramBuilder = (Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(METRIC_NAME)).labelNames(LABELS)).help(HELP);
        Histogram histogram = histogramBuilder.create();
        CollectorRegistry.defaultRegistry.register((Collector)histogram);
        return histogram;
    }
}

