/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.health;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.annotation.Async;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.AdminClient;
import org.sdase.commons.server.kafka.KafkaConfiguration;
import org.sdase.commons.server.kafka.KafkaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Async(period=30L, scheduleType=Async.ScheduleType.FIXED_DELAY)
public class KafkaHealthCheck
extends HealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaHealthCheck.class);
    private final KafkaConfiguration config;
    private final AdminClient adminClient;

    public KafkaHealthCheck(KafkaConfiguration config) {
        this.config = config;
        this.adminClient = AdminClient.create((Properties)KafkaProperties.forAdminClient(config));
    }

    protected HealthCheck.Result check() {
        try {
            this.adminClient.listTopics().names().get((long)this.config.getHealthCheck().getTimeoutInSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.warn("Kafka health check failed", (Throwable)e);
            return HealthCheck.Result.unhealthy((String)"Connection to broker failed within 2 seconds");
        }
        return HealthCheck.Result.healthy();
    }

    public void shutdown() {
        this.adminClient.close();
    }
}

