/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.consumer.strategies.synccommit;

import io.prometheus.client.SimpleTimer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.sdase.commons.server.kafka.consumer.ErrorHandler;
import org.sdase.commons.server.kafka.consumer.KafkaHelper;
import org.sdase.commons.server.kafka.consumer.MessageHandler;
import org.sdase.commons.server.kafka.consumer.StopListenerException;
import org.sdase.commons.server.kafka.consumer.strategies.MessageListenerStrategy;
import org.sdase.commons.server.kafka.exception.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncCommitMLS<K, V>
extends MessageListenerStrategy<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncCommitMLS.class);
    private final MessageHandler<K, V> handler;
    private final ErrorHandler<K, V> errorHandler;
    private String consumerName;

    public SyncCommitMLS(MessageHandler<K, V> handler, ErrorHandler<K, V> errorHandler) {
        this.handler = handler;
        this.errorHandler = errorHandler;
    }

    @Override
    public void processRecords(ConsumerRecords<K, V> records, KafkaConsumer<K, V> consumer) {
        if (this.consumerName == null) {
            this.consumerName = KafkaHelper.getClientId(consumer);
        }
        for (ConsumerRecord record : records) {
            LOGGER.debug("Handling message for {}", record.key());
            try {
                SimpleTimer timer = new SimpleTimer();
                this.handler.handle(record);
                this.addOffsetToCommitOnClose(record);
                double elapsedSeconds = timer.elapsedSeconds();
                this.consumerProcessedMsgHistogram.observe(elapsedSeconds, this.consumerName, record.topic());
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("calculated duration {} for message consumed by {} from {}", new Object[]{elapsedSeconds, this.consumerName, record.topic()});
            }
            catch (RuntimeException e) {
                LOGGER.error("Error while handling record {} in message handler {}", new Object[]{record.key(), this.handler.getClass(), e});
                boolean shouldContinue = this.errorHandler.handleError((ConsumerRecord<K, V>)record, e, (Consumer<K, V>)consumer);
                if (shouldContinue) continue;
                throw new StopListenerException(e);
            }
        }
        this.commitSync(consumer);
    }

    private void commitSync(KafkaConsumer<K, V> consumer) {
        try {
            consumer.commitSync();
        }
        catch (CommitFailedException e) {
            LOGGER.error("Commit failed", (Throwable)e);
        }
    }

    @Override
    public void verifyConsumerConfig(Map<String, String> config) {
        if (Boolean.valueOf(config.getOrDefault("enable.auto.commit", "true")).booleanValue()) {
            throw new ConfigurationException("The strategy should NOT use autocommit but property 'enable.auto.commit' in consumer config is set to 'true' (which is the default and must be disabled).");
        }
    }

    @Override
    public Map<String, String> forcedConfigToApply() {
        return Collections.singletonMap("enable.auto.commit", "false");
    }
}

