/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.consumer.strategies.retryprocessingerror;

import io.prometheus.client.SimpleTimer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.sdase.commons.server.kafka.consumer.ErrorHandler;
import org.sdase.commons.server.kafka.consumer.KafkaHelper;
import org.sdase.commons.server.kafka.consumer.MessageHandler;
import org.sdase.commons.server.kafka.consumer.StopListenerException;
import org.sdase.commons.server.kafka.consumer.strategies.MessageListenerStrategy;
import org.sdase.commons.server.kafka.exception.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryProcessingErrorMLS<K, V>
extends MessageListenerStrategy<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryProcessingErrorMLS.class);
    private final MessageHandler<K, V> handler;
    private final ErrorHandler<K, V> errorHandler;
    private String consumerName;

    public RetryProcessingErrorMLS(MessageHandler<K, V> handler, ErrorHandler<K, V> errorHandler) {
        this.handler = handler;
        this.errorHandler = errorHandler;
    }

    @Override
    public void processRecords(ConsumerRecords<K, V> records, KafkaConsumer<K, V> consumer) {
        if (this.consumerName == null) {
            this.consumerName = KafkaHelper.getClientId(consumer);
        }
        for (TopicPartition partition : records.partitions()) {
            this.processRecordsByPartition(records, consumer, partition);
        }
    }

    private void processRecordsByPartition(ConsumerRecords<K, V> records, KafkaConsumer<K, V> consumer, TopicPartition partition) {
        List partitionRecords = records.records(partition);
        OffsetAndMetadata lastCommitOffset = null;
        for (ConsumerRecord record : partitionRecords) {
            LOGGER.debug("Handling message for {}", record.key());
            try {
                SimpleTimer timer = new SimpleTimer();
                this.handler.handle(record);
                lastCommitOffset = new OffsetAndMetadata(record.offset() + 1L);
                this.addOffsetToCommitOnClose(record);
                double elapsedSeconds = timer.elapsedSeconds();
                this.consumerProcessedMsgHistogram.observe(elapsedSeconds, this.consumerName, record.topic());
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("calculated duration {} for message consumed by {} from {}", new Object[]{elapsedSeconds, this.consumerName, record.topic()});
            }
            catch (RuntimeException e) {
                LOGGER.error("Error while handling record {} in message handler {}", new Object[]{record.key(), this.handler.getClass(), e});
                boolean shouldContinue = this.errorHandler.handleError((ConsumerRecord<K, V>)record, e, (Consumer<K, V>)consumer);
                if (!shouldContinue) {
                    throw new StopListenerException(e);
                }
                LOGGER.warn("Error while handling record {} in message handler {}, will be retried", new Object[]{record.key(), this.handler.getClass(), e});
                consumer.seek(partition, record.offset());
                break;
            }
        }
        if (lastCommitOffset != null) {
            consumer.commitSync(Collections.singletonMap(partition, lastCommitOffset));
        }
    }

    @Override
    public void verifyConsumerConfig(Map<String, String> config) {
        if (Boolean.valueOf(config.getOrDefault("enable.auto.commit", "true")).booleanValue()) {
            throw new ConfigurationException("The strategy should commit explicitly by partition but property 'enable.auto.commit' in consumer config is set to 'true'");
        }
    }
}

