/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.consumer.strategies.autocommit;

import io.prometheus.client.SimpleTimer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.sdase.commons.server.kafka.consumer.ErrorHandler;
import org.sdase.commons.server.kafka.consumer.KafkaHelper;
import org.sdase.commons.server.kafka.consumer.MessageHandler;
import org.sdase.commons.server.kafka.consumer.StopListenerException;
import org.sdase.commons.server.kafka.consumer.strategies.MessageListenerStrategy;
import org.sdase.commons.server.kafka.exception.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutocommitMLS<K, V>
extends MessageListenerStrategy<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutocommitMLS.class);
    private final MessageHandler<K, V> handler;
    private final ErrorHandler<K, V> errorHandler;
    private String consumerName;

    public AutocommitMLS(MessageHandler<K, V> handler, ErrorHandler<K, V> errorHandler) {
        this.handler = handler;
        this.errorHandler = errorHandler;
    }

    @Override
    public void processRecords(ConsumerRecords<K, V> records, KafkaConsumer<K, V> consumer) {
        if (this.consumerName == null) {
            this.consumerName = KafkaHelper.getClientId(consumer);
        }
        for (ConsumerRecord record : records) {
            LOGGER.debug("Handling message for {}", record.key());
            try {
                SimpleTimer timer = new SimpleTimer();
                this.handler.handle(record);
                this.addOffsetToCommitOnClose(record);
                double elapsedSeconds = timer.elapsedSeconds();
                this.consumerProcessedMsgHistogram.observe(elapsedSeconds, this.consumerName, record.topic());
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("calculated duration {} for message consumed by {} from {}", new Object[]{elapsedSeconds, this.consumerName, record.topic()});
            }
            catch (RuntimeException e) {
                LOGGER.error("Error while handling record {} in message handler {}", new Object[]{record.key(), this.handler.getClass(), e});
                boolean shouldContinue = this.errorHandler.handleError((ConsumerRecord<K, V>)record, e, (Consumer<K, V>)consumer);
                if (shouldContinue) continue;
                throw new StopListenerException(e);
            }
        }
    }

    @Override
    public void verifyConsumerConfig(Map<String, String> config) {
        if (!Boolean.valueOf(config.getOrDefault("enable.auto.commit", "true")).booleanValue()) {
            throw new ConfigurationException("The strategy should use autocommit but property 'enable.auto.commit' in consumer config is set to 'false'");
        }
    }

    @Override
    public Map<String, String> forcedConfigToApply() {
        return Collections.singletonMap("enable.auto.commit", "true");
    }
}

