/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.consumer.strategies;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.sdase.commons.server.kafka.prometheus.ConsumerTopicMessageHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageListenerStrategy<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageListenerStrategy.class);
    protected ConsumerTopicMessageHistogram consumerProcessedMsgHistogram;
    private Map<TopicPartition, OffsetAndMetadata> offsetsToCommitOnClose = new HashMap<TopicPartition, OffsetAndMetadata>();

    public void init(ConsumerTopicMessageHistogram consumerTopicMessageHistogram) {
        this.consumerProcessedMsgHistogram = consumerTopicMessageHistogram;
    }

    public abstract void processRecords(ConsumerRecords<K, V> var1, KafkaConsumer<K, V> var2);

    public void resetOffsetsToCommitOnClose() {
        this.offsetsToCommitOnClose = new HashMap<TopicPartition, OffsetAndMetadata>();
    }

    protected void addOffsetToCommitOnClose(ConsumerRecord<K, V> consumerRecord) {
        this.offsetsToCommitOnClose.put(new TopicPartition(consumerRecord.topic(), consumerRecord.partition()), new OffsetAndMetadata(consumerRecord.offset() + 1L, null));
    }

    public void commitOnClose(KafkaConsumer<K, V> consumer) {
        try {
            if (!this.offsetsToCommitOnClose.isEmpty()) {
                LOGGER.info("Committing offsets on close: {}", this.offsetsToCommitOnClose);
                consumer.commitAsync(this.offsetsToCommitOnClose, null);
            } else {
                LOGGER.warn("Committing offsets of last poll on close");
                consumer.commitAsync();
            }
        }
        catch (CommitFailedException e) {
            LOGGER.error("Commit failed", (Throwable)e);
        }
    }

    public abstract void verifyConsumerConfig(Map<String, String> var1);

    public Map<String, String> forcedConfigToApply() {
        return Collections.emptyMap();
    }
}

