/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.config;

import java.util.HashMap;
import java.util.Map;

public class ProducerConfig {
    private String clientId;
    private Map<String, String> config = new HashMap<String, String>();

    public Map<String, String> getConfig() {
        if (this.clientId != null) {
            this.config.putIfAbsent("client.id", this.clientId);
        }
        return this.config;
    }

    public ProducerConfig setConfig(Map<String, String> config) {
        this.config = config;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public ProducerConfig setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements ProducerConfigBuilder {
        private String clientId;
        private Map<String, String> config = new HashMap<String, String>();

        @Override
        public ProducerConfigBuilder addConfig(String key, String value) {
            this.config.put(key, value);
            return this;
        }

        @Override
        public ProducerConfig build() {
            ProducerConfig producerConfig = new ProducerConfig();
            producerConfig.setConfig(this.config);
            producerConfig.setClientId(this.clientId);
            return producerConfig;
        }

        @Override
        public ProducerConfigBuilder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }
    }

    public static interface ProducerConfigBuilder {
        public ProducerConfigBuilder addConfig(String var1, String var2);

        public ProducerConfigBuilder withClientId(String var1);

        public ProducerConfig build();
    }
}

