/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.config;

import javax.validation.constraints.NotNull;

public class ListenerConfig {
    private int instances = 1;
    private long topicMissingRetryMs = 0L;
    private long pollInterval = 100L;
    private long pollIntervalFactorOnError = 4L;
    private long maxPollInterval = 25000L;

    private ListenerConfig() {
    }

    public static ListenerConfig getDefault() {
        return new ListenerConfig();
    }

    public static ListenerConfigBuilder builder() {
        return new ListenerConfigBuilder();
    }

    public int getInstances() {
        return this.instances;
    }

    public void setInstances(int instances) {
        this.instances = instances;
    }

    public long getTopicMissingRetryMs() {
        return this.topicMissingRetryMs;
    }

    public void setTopicMissingRetryMs(long topicMissingRetryMs) {
        this.topicMissingRetryMs = topicMissingRetryMs;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public long getPollIntervalFactorOnError() {
        return this.pollIntervalFactorOnError;
    }

    public void setPollIntervalFactorOnError(long pollIntervalFactorOnError) {
        this.pollIntervalFactorOnError = pollIntervalFactorOnError;
    }

    public long getMaxPollInterval() {
        return this.maxPollInterval;
    }

    public void setMaxPollInterval(long maxPollInterval) {
        this.maxPollInterval = maxPollInterval;
    }

    public static class ListenerConfigBuilder {
        private long topicMissingRetryMs = 0L;
        private long pollInterval = 100L;
        private long pollIntervalFactorOnError = 4L;
        private long maxPollInterval = 25000L;

        public ListenerConfigBuilder withTopicMissingRetryMs(@NotNull long ms) {
            this.topicMissingRetryMs = ms;
            return this;
        }

        public ListenerConfigBuilder withPollInterval(@NotNull long ms) {
            this.pollInterval = ms;
            return this;
        }

        public ListenerConfigBuilder withMaxPollInterval(@NotNull long ms) {
            this.maxPollInterval = ms;
            return this;
        }

        public ListenerConfigBuilder withPollIntervalFactorOnError(@NotNull long factor) {
            this.pollIntervalFactorOnError = factor;
            return this;
        }

        public ListenerConfig build(@NotNull int numberInstances) {
            ListenerConfig build = new ListenerConfig();
            build.setTopicMissingRetryMs(this.topicMissingRetryMs);
            build.setPollInterval(this.pollInterval);
            build.setMaxPollInterval(this.maxPollInterval);
            build.setPollIntervalFactorOnError(this.pollIntervalFactorOnError);
            build.setInstances(numberInstances);
            return build;
        }
    }
}

