/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.config;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class ConsumerConfig {
    @NotNull
    private String group = "default";
    private String clientId;
    private Map<String, String> config = new HashMap<String, String>();

    public Map<String, String> getConfig() {
        if (this.group != null) {
            this.config.putIfAbsent("group.id", this.group);
        }
        if (this.clientId != null) {
            this.config.putIfAbsent("client.id", this.clientId);
        }
        return this.config;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getClientId() {
        return this.clientId;
    }

    public ConsumerConfig setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public static GroupBuilder builder() {
        return new Builder();
    }

    public static class Builder
    implements ConsumerConfigBuilder,
    GroupBuilder {
        private String group = "default";
        private String clientId;
        private Map<String, String> config = new HashMap<String, String>();

        @Override
        public ConsumerConfigBuilder addConfig(String key, String value) {
            this.config.put(key, value);
            return this;
        }

        @Override
        public ConsumerConfig build() {
            ConsumerConfig consumerConfig = new ConsumerConfig();
            consumerConfig.setConfig(this.config);
            consumerConfig.setGroup(this.group);
            consumerConfig.setClientId(this.clientId);
            return consumerConfig;
        }

        @Override
        public ConsumerConfigBuilder withGroup(String group) {
            this.group = group;
            return this;
        }

        @Override
        public ConsumerConfigBuilder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }
    }

    public static interface ConsumerConfigBuilder {
        public ConsumerConfigBuilder addConfig(String var1, String var2);

        public ConsumerConfigBuilder withClientId(String var1);

        public ConsumerConfig build();
    }

    public static interface GroupBuilder
    extends ConsumerConfigBuilder {
        public ConsumerConfigBuilder withGroup(String var1);
    }
}

