/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.builder;

import javax.validation.constraints.NotNull;
import org.apache.kafka.common.serialization.Serializer;
import org.sdase.commons.server.kafka.config.ProducerConfig;
import org.sdase.commons.server.kafka.topicana.ExpectedTopicConfiguration;
import org.sdase.commons.server.kafka.topicana.TopicConfigurationBuilder;

public class ProducerRegistration<K, V> {
    private Serializer<K> keySerializer;
    private Serializer<V> valueSerializer;
    private ExpectedTopicConfiguration topic;
    private boolean checkTopicConfiguration;
    private ProducerConfig producerConfig;
    private String producerName;
    private boolean createTopicIfMissing;

    public String getProducerConfigName() {
        return this.producerName;
    }

    @Deprecated
    public ExpectedTopicConfiguration getTopic() {
        return this.topic;
    }

    public String getTopicName() {
        return this.topic.getTopicName();
    }

    @Deprecated
    public boolean isCheckTopicConfiguration() {
        return this.checkTopicConfiguration;
    }

    @Deprecated
    public boolean isCreateTopicIfMissing() {
        return this.createTopicIfMissing;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public ProducerConfig getProducerConfig() {
        return this.producerConfig;
    }

    public static <K, V> TopicBuilder<K, V> builder() {
        return new InitialBuilder();
    }

    private static <K, V> ProducerRegistration<K, V> build(InitialBuilder<K, V> initialBuilder, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        ProducerRegistration<K, V> build = new ProducerRegistration<K, V>();
        build.keySerializer = keySerializer;
        build.valueSerializer = valueSerializer;
        build.topic = ((InitialBuilder)initialBuilder).topic;
        build.checkTopicConfiguration = ((InitialBuilder)initialBuilder).checkTopicConfiguration;
        build.createTopicIfMissing = ((InitialBuilder)initialBuilder).createTopicIfMissing;
        build.producerConfig = ((InitialBuilder)initialBuilder).producerConfig;
        build.producerName = ((InitialBuilder)initialBuilder).producerName;
        return build;
    }

    private static class InitialBuilder<K, V>
    implements TopicBuilder<K, V>,
    ProducerBuilder<K, V>,
    KeySerializerBuilder<K, V> {
        private ExpectedTopicConfiguration topic;
        private boolean checkTopicConfiguration = false;
        private boolean createTopicIfMissing = false;
        private ProducerConfig producerConfig;
        private String producerName = null;

        private InitialBuilder() {
        }

        static <K, V, K2, V2> InitialBuilder<K2, V2> clone(InitialBuilder<K, V> source) {
            InitialBuilder<K, V> target = new InitialBuilder<K, V>();
            target.checkTopicConfiguration = source.checkTopicConfiguration;
            target.createTopicIfMissing = source.createTopicIfMissing;
            target.topic = source.topic;
            target.producerConfig = source.producerConfig;
            target.producerName = source.producerName;
            return target;
        }

        @Override
        @Deprecated
        public ProducerBuilder<K, V> forTopic(@NotNull ExpectedTopicConfiguration topic) {
            this.topic = topic;
            return this;
        }

        @Override
        public <K1> ValueSerializerBuilder<K1, V> withKeySerializer(Serializer<K1> keySerializer) {
            return new ValueSerializerBuilder(InitialBuilder.clone(this), keySerializer);
        }

        @Override
        public <V1> FinalBuilder<K, V1> withValueSerializer(Serializer<V1> valueSerializer) {
            return new FinalBuilder(InitialBuilder.clone(this), null, valueSerializer);
        }

        @Override
        @Deprecated
        public ProducerBuilder<K, V> checkTopicConfiguration() {
            this.checkTopicConfiguration = true;
            return this;
        }

        @Override
        @Deprecated
        public ProducerBuilder<K, V> createTopicIfMissing() {
            this.createTopicIfMissing = true;
            return this;
        }

        @Override
        public KeySerializerBuilder<K, V> withDefaultProducer() {
            this.producerConfig = null;
            this.producerName = null;
            return this;
        }

        @Override
        public KeySerializerBuilder<K, V> withProducerConfig(ProducerConfig config) {
            this.producerConfig = config;
            return this;
        }

        @Override
        public KeySerializerBuilder<K, V> withProducerConfig(String name) {
            this.producerName = name;
            return this;
        }

        @Override
        public ProducerRegistration<K, V> build() {
            return ProducerRegistration.build(this, null, null);
        }
    }

    public static class FinalBuilder<K, V> {
        private InitialBuilder<K, V> initialBuilder;
        private Serializer<K> keySerializer;
        private Serializer<V> valueSerializer;

        private FinalBuilder(InitialBuilder<K, V> initialBuilder, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            this.initialBuilder = initialBuilder;
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }

        public ProducerRegistration<K, V> build() {
            return ProducerRegistration.build(this.initialBuilder, this.keySerializer, this.valueSerializer);
        }
    }

    public static class ValueSerializerBuilder<K, V> {
        private InitialBuilder<K, V> initialBuilder;
        private Serializer<K> keySerializer;

        private ValueSerializerBuilder(InitialBuilder<K, V> initialBuilder, Serializer<K> keySerializer) {
            this.initialBuilder = initialBuilder;
            this.keySerializer = keySerializer;
        }

        public <V2> FinalBuilder<K, V2> withValueSerializer(Serializer<V2> valueSerializer) {
            return new FinalBuilder(InitialBuilder.clone(this.initialBuilder), this.keySerializer, valueSerializer);
        }

        public ProducerRegistration<K, V> build() {
            return ProducerRegistration.build(this.initialBuilder, this.keySerializer, null);
        }
    }

    public static interface KeySerializerBuilder<K, V> {
        public <K2> ValueSerializerBuilder<K2, V> withKeySerializer(Serializer<K2> var1);

        public <V2> FinalBuilder<K, V2> withValueSerializer(Serializer<V2> var1);

        public ProducerRegistration<K, V> build();
    }

    public static interface ProducerBuilder<K, V> {
        @Deprecated
        public ProducerBuilder<K, V> checkTopicConfiguration();

        @Deprecated
        public ProducerBuilder<K, V> createTopicIfMissing();

        public KeySerializerBuilder<K, V> withDefaultProducer();

        public KeySerializerBuilder<K, V> withProducerConfig(ProducerConfig var1);

        public KeySerializerBuilder<K, V> withProducerConfig(String var1);
    }

    public static interface TopicBuilder<K, V> {
        default public ProducerBuilder<K, V> forTopic(String topic) {
            return this.forTopic(TopicConfigurationBuilder.builder(topic).build());
        }

        @Deprecated
        public ProducerBuilder<K, V> forTopic(ExpectedTopicConfiguration var1);
    }
}

