/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Deserializer;
import org.sdase.commons.server.kafka.config.ConsumerConfig;
import org.sdase.commons.server.kafka.config.ListenerConfig;
import org.sdase.commons.server.kafka.consumer.strategies.MessageListenerStrategy;
import org.sdase.commons.server.kafka.topicana.ExpectedTopicConfiguration;
import org.sdase.commons.server.kafka.topicana.TopicConfigurationBuilder;

public class MessageListenerRegistration<K, V> {
    private Deserializer<K> keyDeserializer;
    private Deserializer<V> valueDeserializer;
    private Collection<ExpectedTopicConfiguration> topics;
    private boolean checkTopicConfiguration;
    private MessageListenerStrategy<K, V> strategy;
    private ConsumerConfig consumerConfig;
    private String consumerConfigName;
    private String listenerConfigName;
    private ListenerConfig listenerConfig;

    public Deserializer<K> getKeyDeserializer() {
        return this.keyDeserializer;
    }

    @Deprecated
    public boolean isCheckTopicConfiguration() {
        return this.checkTopicConfiguration;
    }

    public String getListenerConfigName() {
        return this.listenerConfigName;
    }

    public Deserializer<V> getValueDeserializer() {
        return this.valueDeserializer;
    }

    @Deprecated
    public Collection<ExpectedTopicConfiguration> getTopics() {
        return this.topics;
    }

    public Collection<String> getTopicsNames() {
        return this.topics.stream().map(ExpectedTopicConfiguration::getTopicName).collect(Collectors.toList());
    }

    public MessageListenerStrategy<K, V> getStrategy() {
        return this.strategy;
    }

    public ConsumerConfig getConsumerConfig() {
        return this.consumerConfig;
    }

    public String getConsumerConfigName() {
        return this.consumerConfigName;
    }

    public ListenerConfig getListenerConfig() {
        return this.listenerConfig;
    }

    public static ListenerBuilder builder() {
        return new InitialBuilder();
    }

    public static class FinalBuilder<K, V> {
        private InitialBuilder initialBuilder;
        private Deserializer<K> keyDeserializer;
        private Deserializer<V> valueDeserializer;
        private MessageListenerStrategy<K, V> messageListenerStrategy;

        private FinalBuilder(InitialBuilder initialBuilder, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, MessageListenerStrategy<K, V> messageListenerStrategy) {
            this.initialBuilder = initialBuilder;
            this.keyDeserializer = keyDeserializer;
            this.valueDeserializer = valueDeserializer;
            this.messageListenerStrategy = messageListenerStrategy;
        }

        public MessageListenerRegistration<K, V> build() {
            MessageListenerRegistration build = new MessageListenerRegistration();
            build.keyDeserializer = this.keyDeserializer;
            build.valueDeserializer = this.valueDeserializer;
            build.topics = this.initialBuilder.topics;
            build.checkTopicConfiguration = this.initialBuilder.topicExistCheck;
            build.consumerConfig = this.initialBuilder.consumerConfig;
            build.consumerConfigName = this.initialBuilder.consumerName;
            build.listenerConfig = this.initialBuilder.listenerConfig;
            build.listenerConfigName = this.initialBuilder.listenerName;
            build.strategy = this.messageListenerStrategy;
            return build;
        }
    }

    private static class PreselectedTypesListenerStrategyBuilder<K, V>
    implements ListenerStrategyBuilder<K, V> {
        private InitialBuilder initialBuilder;
        private Deserializer<K> keyDeserializer;
        private Deserializer<V> valueDeserializer;

        private PreselectedTypesListenerStrategyBuilder(InitialBuilder initialBuilder, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
            this.initialBuilder = initialBuilder;
            this.keyDeserializer = keyDeserializer;
            this.valueDeserializer = valueDeserializer;
        }

        @Override
        public FinalBuilder<K, V> withListenerStrategy(MessageListenerStrategy<K, V> strategy) {
            return new FinalBuilder(this.initialBuilder, this.keyDeserializer, this.valueDeserializer, strategy);
        }
    }

    private static class PreselectedValueTypeListenerStrategyBuilder<V>
    implements ListenerStrategyForDefinedValueTypeBuilder<V> {
        private InitialBuilder initialBuilder;
        private Deserializer<V> valueDeserializer;

        private PreselectedValueTypeListenerStrategyBuilder(InitialBuilder initialBuilder, Deserializer<V> valueDeserializer) {
            this.initialBuilder = initialBuilder;
            this.valueDeserializer = valueDeserializer;
        }

        @Override
        public <K2> FinalBuilder<K2, V> withListenerStrategy(MessageListenerStrategy<K2, V> strategy) {
            return new FinalBuilder(this.initialBuilder, null, this.valueDeserializer, strategy);
        }
    }

    private static class PreselectedKeyTypeValueDeserializerBuilder<K>
    implements ValueDeserializerForDefinedKeyTypeBuilder<K> {
        private InitialBuilder initialBuilder;
        private Deserializer<K> keyDeserializer;

        private PreselectedKeyTypeValueDeserializerBuilder(InitialBuilder initialBuilder, Deserializer<K> keyDeserializer) {
            this.initialBuilder = initialBuilder;
            this.keyDeserializer = keyDeserializer;
        }

        @Override
        public <V2> ListenerStrategyBuilder<K, V2> withValueDeserializer(Deserializer<V2> valueDeserializer) {
            return new PreselectedTypesListenerStrategyBuilder(this.initialBuilder, this.keyDeserializer, valueDeserializer);
        }

        @Override
        public <V2> FinalBuilder<K, V2> withListenerStrategy(MessageListenerStrategy<K, V2> strategy) {
            return new FinalBuilder(this.initialBuilder, this.keyDeserializer, null, strategy);
        }
    }

    private static class InitialBuilder
    implements ListenerBuilder,
    TopicBuilder,
    ConsumerBuilder,
    KeyDeserializerBuilder {
        private Collection<ExpectedTopicConfiguration> topics;
        private boolean topicExistCheck = false;
        private ConsumerConfig consumerConfig;
        private ListenerConfig listenerConfig;
        private String consumerName;
        private String listenerName;

        private InitialBuilder() {
        }

        @Override
        public TopicBuilder withListenerConfig(String name) {
            this.listenerName = name;
            return this;
        }

        @Override
        public TopicBuilder withListenerConfig(ListenerConfig config) {
            this.listenerConfig = config;
            return this;
        }

        @Override
        public TopicBuilder withDefaultListenerConfig() {
            this.listenerConfig = ListenerConfig.getDefault();
            return this;
        }

        @Override
        public ConsumerBuilder forTopic(String topic) {
            this.topics = Collections.singletonList(TopicConfigurationBuilder.builder(topic).build());
            return this;
        }

        @Override
        public ConsumerBuilder forTopics(Collection<String> topics) {
            this.topics = topics.stream().map(t -> TopicConfigurationBuilder.builder(t).build()).collect(Collectors.toList());
            return this;
        }

        @Override
        @Deprecated
        public ConsumerBuilder forTopicConfigs(Collection<ExpectedTopicConfiguration> topicConfiguration) {
            this.topics = topicConfiguration;
            return this;
        }

        @Override
        @Deprecated
        public ConsumerBuilder checkTopicConfiguration() {
            this.topicExistCheck = true;
            return this;
        }

        @Override
        public KeyDeserializerBuilder withConsumerConfig(String name) {
            this.consumerName = name;
            return this;
        }

        @Override
        public KeyDeserializerBuilder withConsumerConfig(ConsumerConfig consumerConfig) {
            this.consumerConfig = consumerConfig;
            return this;
        }

        @Override
        public KeyDeserializerBuilder withDefaultConsumer() {
            this.consumerConfig = null;
            return this;
        }

        @Override
        public <K2> ValueDeserializerForDefinedKeyTypeBuilder<K2> withKeyDeserializer(Deserializer<K2> keyDeserializer) {
            return new PreselectedKeyTypeValueDeserializerBuilder(this, keyDeserializer);
        }

        @Override
        public <V2> ListenerStrategyForDefinedValueTypeBuilder<V2> withValueDeserializer(Deserializer<V2> valueDeserializer) {
            return new PreselectedValueTypeListenerStrategyBuilder(this, valueDeserializer);
        }

        @Override
        public <K2, V2> FinalBuilder<K2, V2> withListenerStrategy(MessageListenerStrategy<K2, V2> strategy) {
            return new FinalBuilder(this, null, null, strategy);
        }
    }

    public static interface ListenerStrategyBuilder<K, V> {
        public FinalBuilder<K, V> withListenerStrategy(MessageListenerStrategy<K, V> var1);
    }

    public static interface ValueDeserializerForDefinedKeyTypeBuilder<K> {
        public <V2> ListenerStrategyBuilder<K, V2> withValueDeserializer(Deserializer<V2> var1);

        public <V2> FinalBuilder<K, V2> withListenerStrategy(MessageListenerStrategy<K, V2> var1);
    }

    public static interface ListenerStrategyForDefinedValueTypeBuilder<V> {
        public <K2> FinalBuilder<K2, V> withListenerStrategy(MessageListenerStrategy<K2, V> var1);
    }

    public static interface KeyDeserializerBuilder {
        public <K2> ValueDeserializerForDefinedKeyTypeBuilder<K2> withKeyDeserializer(Deserializer<K2> var1);

        public <V2> ListenerStrategyForDefinedValueTypeBuilder<V2> withValueDeserializer(Deserializer<V2> var1);

        public <K2, V2> FinalBuilder<K2, V2> withListenerStrategy(MessageListenerStrategy<K2, V2> var1);
    }

    public static interface ConsumerBuilder {
        @Deprecated
        public ConsumerBuilder checkTopicConfiguration();

        public KeyDeserializerBuilder withConsumerConfig(String var1);

        public KeyDeserializerBuilder withConsumerConfig(ConsumerConfig var1);

        public KeyDeserializerBuilder withDefaultConsumer();
    }

    public static interface TopicBuilder {
        public ConsumerBuilder forTopic(String var1);

        public ConsumerBuilder forTopics(Collection<String> var1);

        @Deprecated
        public ConsumerBuilder forTopicConfigs(Collection<ExpectedTopicConfiguration> var1);
    }

    public static interface ListenerBuilder {
        public TopicBuilder withListenerConfig(String var1);

        public TopicBuilder withListenerConfig(ListenerConfig var1);

        public TopicBuilder withDefaultListenerConfig();
    }
}

