/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka;

import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.ScramLoginModule;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.sdase.commons.server.kafka.KafkaConfiguration;
import org.sdase.commons.server.kafka.config.ProtocolType;
import org.sdase.commons.server.kafka.config.Security;

public class KafkaProperties
extends Properties {
    private static final long serialVersionUID = -4196815076149945888L;

    private KafkaProperties() {
    }

    private static Properties configureSecurity(Security security) {
        KafkaProperties props = new KafkaProperties();
        if (security == null) {
            return props;
        }
        if (security.getProtocol() != null) {
            props.put("security.protocol", security.getProtocol().name());
        }
        if (ProtocolType.isSasl(security.getProtocol()) && security.getPassword() != null && security.getUser() != null) {
            props.put("sasl.mechanism", security.getSaslMechanism());
            props.put("sasl.jaas.config", String.format("%s required username='%s' password='%s';", KafkaProperties.getLoginModule(security.getSaslMechanism()).getName(), security.getUser(), security.getPassword()));
        }
        return props;
    }

    private static KafkaProperties baseProperties(KafkaConfiguration configuration) {
        KafkaProperties props = new KafkaProperties();
        if (configuration.getBrokers() != null) {
            props.put("bootstrap.servers", String.join((CharSequence)",", configuration.getBrokers()));
        }
        props.putAll((Map<?, ?>)KafkaProperties.configureSecurity(configuration.getSecurity()));
        if (configuration.getConfig() != null) {
            props.putAll(KafkaProperties.noBlankValues(configuration.getConfig()));
        }
        return props;
    }

    private static KafkaProperties adminProperties(KafkaConfiguration configuration) {
        KafkaProperties props = new KafkaProperties();
        if (configuration.getAdminConfig() == null || configuration.getAdminConfig().getAdminEndpoint() == null || configuration.getAdminConfig().getAdminEndpoint().isEmpty() || StringUtils.isBlank((CharSequence)String.join((CharSequence)",", configuration.getAdminConfig().getAdminEndpoint()))) {
            props = KafkaProperties.baseProperties(configuration);
            return props;
        }
        props.put("bootstrap.servers", String.join((CharSequence)",", configuration.getAdminConfig().getAdminEndpoint()));
        props.putAll((Map<?, ?>)KafkaProperties.configureSecurity(configuration.getAdminConfig().getAdminSecurity()));
        return props;
    }

    public static KafkaProperties forAdminClient(KafkaConfiguration configuration) {
        KafkaProperties props = KafkaProperties.adminProperties(configuration);
        props.put("request.timeout.ms", (Object)configuration.getAdminConfig().getAdminClientRequestTimeoutMs());
        props.put("default.api.timeout.ms", (Object)configuration.getAdminConfig().getAdminClientRequestTimeoutMs());
        props.putAll(KafkaProperties.noBlankValues(configuration.getAdminConfig().getConfig()));
        return props;
    }

    public static KafkaProperties forConsumer(KafkaConfiguration configuration) {
        KafkaProperties props = KafkaProperties.baseProperties(configuration);
        props.put("group.id", "default");
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", String.valueOf(1000));
        props.put("auto.offset.reset", "earliest");
        props.put("key.deserializer", StringDeserializer.class.getName());
        props.put("value.deserializer", StringDeserializer.class.getName());
        return props;
    }

    public static KafkaProperties forProducer(KafkaConfiguration configuration) {
        KafkaProperties props = KafkaProperties.baseProperties(configuration);
        props.put("acks", "all");
        props.put("retries", "0");
        props.put("linger.ms", "0");
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", StringSerializer.class.getName());
        return props;
    }

    private static Class<?> getLoginModule(String saslMechanism) {
        switch (saslMechanism.toUpperCase()) {
            case "PLAIN": {
                return PlainLoginModule.class;
            }
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-512": {
                return ScramLoginModule.class;
            }
        }
        throw new IllegalArgumentException("Unsupported SASL mechanism " + saslMechanism);
    }

    private static Map<String, String> noBlankValues(Map<String, String> original) {
        return original.entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

