/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.jnr.posix;

import org.scijava.jython.shaded.jnr.posix.FileStat;
import org.scijava.jython.shaded.jnr.posix.JavaFileStat;
import org.scijava.jython.shaded.jnr.posix.POSIX;
import org.scijava.jython.shaded.jnr.posix.POSIXHandler;
import org.scijava.jython.shaded.jnr.posix.util.WindowsHelpers;
import org.scijava.jython.shaded.jnr.posix.windows.CommonFileInformation;

public class WindowsRawFileStat
extends JavaFileStat {
    private int st_atime;
    private int st_rdev;
    private int st_dev;
    private int st_nlink;
    private int st_mode;

    public WindowsRawFileStat(POSIX posix, POSIXHandler handler2) {
        super(posix, handler2);
    }

    public void setup(String path, CommonFileInformation fileInfo) {
        this.st_mode = fileInfo.getMode(path);
        this.setup(fileInfo);
        if (WindowsHelpers.isDriveLetterPath(path)) {
            int letterAsNumber;
            this.st_rdev = letterAsNumber = Character.toUpperCase(path.charAt(0)) - 65;
            this.st_dev = letterAsNumber;
        }
    }

    public void setup(CommonFileInformation fileInfo) {
        this.st_atime = (int)fileInfo.getLastAccessTimeMicroseconds();
        this.st_mtime = (int)fileInfo.getLastWriteTimeMicroseconds();
        this.st_ctime = (int)fileInfo.getCreationTimeMicroseconds();
        this.st_size = this.isDirectory() ? 0L : fileInfo.getFileSize();
        this.st_nlink = 1;
        this.st_mode &= 0xFFFFFFED;
    }

    @Override
    public int mode() {
        return this.st_mode;
    }

    @Override
    public int gid() {
        return 0;
    }

    @Override
    public int uid() {
        return 0;
    }

    @Override
    public long atime() {
        return this.st_atime;
    }

    @Override
    public long dev() {
        return this.st_dev;
    }

    @Override
    public int nlink() {
        return this.st_nlink;
    }

    @Override
    public long rdev() {
        return this.st_rdev;
    }

    @Override
    public long blocks() {
        return -1L;
    }

    @Override
    public long blockSize() {
        return -1L;
    }

    @Override
    public boolean isBlockDev() {
        return (this.mode() & 0xF000) == 24576;
    }

    @Override
    public boolean isCharDev() {
        return (this.mode() & 0xF000) == 8192;
    }

    @Override
    public boolean isDirectory() {
        return (this.mode() & 0xF000) == 16384;
    }

    @Override
    public boolean isEmpty() {
        return this.st_size() == 0L;
    }

    @Override
    public boolean isExecutable() {
        if (this.isOwned()) {
            return (this.mode() & 0x40) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 8) != 0;
        }
        return (this.mode() & 1) == 0;
    }

    @Override
    public boolean isExecutableReal() {
        if (this.isROwned()) {
            return (this.mode() & 0x40) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 8) != 0;
        }
        return (this.mode() & 1) == 0;
    }

    @Override
    public boolean isFile() {
        return (this.mode() & 0xF000) == 32768;
    }

    @Override
    public boolean isFifo() {
        return (this.mode() & 0xF000) == 4096;
    }

    @Override
    public boolean isGroupOwned() {
        return this.groupMember(this.gid());
    }

    @Override
    public boolean isIdentical(FileStat other) {
        return this.dev() == other.dev() && this.ino() == other.ino();
    }

    @Override
    public boolean isNamedPipe() {
        return (this.mode() & 0x1000) != 0;
    }

    @Override
    public boolean isOwned() {
        return true;
    }

    @Override
    public boolean isROwned() {
        return true;
    }

    @Override
    public boolean isReadable() {
        if (this.isOwned()) {
            return (this.mode() & 0x100) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 0x20) != 0;
        }
        return (this.mode() & 4) == 0;
    }

    @Override
    public boolean isReadableReal() {
        if (this.isROwned()) {
            return (this.mode() & 0x100) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 0x20) != 0;
        }
        return (this.mode() & 4) == 0;
    }

    @Override
    public boolean isSetgid() {
        return (this.mode() & 0x400) != 0;
    }

    @Override
    public boolean isSetuid() {
        return (this.mode() & 0x800) != 0;
    }

    @Override
    public boolean isSocket() {
        return (this.mode() & 0xF000) == 49152;
    }

    @Override
    public boolean isSticky() {
        return (this.mode() & 0x200) != 0;
    }

    @Override
    public boolean isSymlink() {
        return (this.mode() & 0xF000) == 40960;
    }

    @Override
    public boolean isWritable() {
        if (this.isOwned()) {
            return (this.mode() & 0x80) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 0x10) != 0;
        }
        return (this.mode() & 2) == 0;
    }

    @Override
    public boolean isWritableReal() {
        if (this.isROwned()) {
            return (this.mode() & 0x80) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 0x10) != 0;
        }
        return (this.mode() & 2) == 0;
    }
}

