/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.jnr.posix;

import org.scijava.jython.shaded.jnr.constants.Constant;
import org.scijava.jython.shaded.jnr.ffi.Platform;
import org.scijava.jython.shaded.jnr.ffi.mapper.FromNativeContext;
import org.scijava.jython.shaded.jnr.ffi.mapper.FromNativeConverter;
import org.scijava.jython.shaded.jnr.ffi.mapper.ToNativeContext;
import org.scijava.jython.shaded.jnr.ffi.mapper.ToNativeConverter;
import org.scijava.jython.shaded.jnr.ffi.mapper.TypeMapper;
import org.scijava.jython.shaded.jnr.posix.AixPOSIX;
import org.scijava.jython.shaded.jnr.posix.BaseNativePOSIX;
import org.scijava.jython.shaded.jnr.posix.FileStat;
import org.scijava.jython.shaded.jnr.posix.FreeBSDPOSIX;
import org.scijava.jython.shaded.jnr.posix.Group;
import org.scijava.jython.shaded.jnr.posix.HANDLE;
import org.scijava.jython.shaded.jnr.posix.LinuxPOSIX;
import org.scijava.jython.shaded.jnr.posix.MacOSPOSIX;
import org.scijava.jython.shaded.jnr.posix.MsgHdr;
import org.scijava.jython.shaded.jnr.posix.NativeTimes;
import org.scijava.jython.shaded.jnr.posix.OpenBSDPOSIX;
import org.scijava.jython.shaded.jnr.posix.Passwd;
import org.scijava.jython.shaded.jnr.posix.SolarisPOSIX;
import org.scijava.jython.shaded.jnr.posix.WString;
import org.scijava.jython.shaded.jnr.posix.WindowsPOSIX;
import org.scijava.jython.shaded.jnr.posix.util.Platform;

final class POSIXTypeMapper
implements TypeMapper {
    public static final TypeMapper INSTANCE = new POSIXTypeMapper();

    private POSIXTypeMapper() {
    }

    @Override
    public FromNativeConverter getFromNativeConverter(Class klazz) {
        if (Passwd.class.isAssignableFrom(klazz)) {
            if (Platform.IS_MAC) {
                return MacOSPOSIX.PASSWD;
            }
            if (Platform.IS_LINUX) {
                return LinuxPOSIX.PASSWD;
            }
            if (Platform.IS_SOLARIS) {
                return SolarisPOSIX.PASSWD;
            }
            if (Platform.IS_FREEBSD) {
                return FreeBSDPOSIX.PASSWD;
            }
            if (Platform.IS_OPENBSD) {
                return OpenBSDPOSIX.PASSWD;
            }
            if (Platform.IS_WINDOWS) {
                return WindowsPOSIX.PASSWD;
            }
            if (org.scijava.jython.shaded.jnr.ffi.Platform.getNativePlatform().getOS().equals((Object)Platform.OS.AIX)) {
                return AixPOSIX.PASSWD;
            }
            return null;
        }
        if (Group.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.GROUP;
        }
        if (HANDLE.class.isAssignableFrom(klazz)) {
            return HANDLE.Converter;
        }
        return null;
    }

    @Override
    public ToNativeConverter getToNativeConverter(Class klazz) {
        if (FileStat.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.FileStatConverter;
        }
        if (NativeTimes.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.TimesConverter;
        }
        if (Constant.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.ConstantConverter;
        }
        if (WString.class.isAssignableFrom(klazz)) {
            return WString.Converter;
        }
        if (HANDLE.class.isAssignableFrom(klazz)) {
            return HANDLE.Converter;
        }
        if (MsgHdr.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.MsgHdrConverter;
        }
        return null;
    }

    public final ToNativeConverter getToNativeConverter(Class klazz, ToNativeContext context) {
        return this.getToNativeConverter(klazz);
    }

    public final FromNativeConverter getFromNativeConverter(Class klazz, FromNativeContext context) {
        return this.getFromNativeConverter(klazz);
    }
}

