/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.jnr.netdb;

import java.util.Collection;
import java.util.Collections;
import org.scijava.jython.shaded.jnr.netdb.FileServicesDB;
import org.scijava.jython.shaded.jnr.netdb.IANAServicesDB;
import org.scijava.jython.shaded.jnr.netdb.NativeServicesDB;
import org.scijava.jython.shaded.jnr.netdb.ServicesDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Service {
    private final String serviceName;
    private final int port;
    final String proto;
    private final Collection<String> aliases;

    Service(String name, int port, String proto, Collection<String> aliases2) {
        this.serviceName = name;
        this.port = port;
        this.proto = proto;
        this.aliases = aliases2;
    }

    public static final Service getServiceByName(String name, String proto) {
        return Service.getServicesDB().getServiceByName(name, proto);
    }

    public static final Service getServiceByPort(int port, String proto) {
        return Service.getServicesDB().getServiceByPort(port, proto);
    }

    public static final Collection<Service> getAllServices() {
        return Collections.emptyList();
    }

    public final String getName() {
        return this.serviceName;
    }

    public final int getPort() {
        return this.port;
    }

    public final Collection<String> getAliases() {
        return this.aliases;
    }

    private static final ServicesDB getServicesDB() {
        return ServicesDBSingletonHolder.INSTANCE;
    }

    public String toString() {
        return String.format("<Service: Name: %s, Port: %d, Proto: %s, Aliases: %s>", this.serviceName, this.port, this.proto, this.aliases);
    }

    private static final class ServicesDBSingletonHolder {
        static final ServicesDB INSTANCE = ServicesDBSingletonHolder.load();

        private ServicesDBSingletonHolder() {
        }

        private static final ServicesDB load() {
            ServicesDB db = NativeServicesDB.load();
            if (db == null) {
                db = FileServicesDB.getInstance();
            }
            return db != null ? db : IANAServicesDB.getInstance();
        }
    }
}

