/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import org.python.apache.xerces.dom.AttrImpl;
import org.python.apache.xerces.dom.ChildNode;
import org.python.apache.xerces.dom.CoreDocumentImpl;
import org.python.apache.xerces.dom.DOMMessageFormatter;
import org.python.apache.xerces.dom.ElementImpl;
import org.python.apache.xerces.dom.NamedNodeMapImpl;
import org.scijava.jython.shaded.org.w3c.dom.DOMException;
import org.scijava.jython.shaded.org.w3c.dom.Document;
import org.scijava.jython.shaded.org.w3c.dom.DocumentType;
import org.scijava.jython.shaded.org.w3c.dom.NamedNodeMap;
import org.scijava.jython.shaded.org.w3c.dom.Node;
import org.scijava.jython.shaded.org.w3c.dom.NodeList;
import org.scijava.jython.shaded.org.w3c.dom.UserDataHandler;
import org.scijava.jython.shaded.org.w3c.dom.events.Event;
import org.scijava.jython.shaded.org.w3c.dom.events.EventListener;
import org.scijava.jython.shaded.org.w3c.dom.events.EventTarget;

public abstract class NodeImpl
implements Node,
NodeList,
EventTarget,
Cloneable,
Serializable {
    public static final short TREE_POSITION_PRECEDING = 1;
    public static final short TREE_POSITION_FOLLOWING = 2;
    public static final short TREE_POSITION_ANCESTOR = 4;
    public static final short TREE_POSITION_DESCENDANT = 8;
    public static final short TREE_POSITION_EQUIVALENT = 16;
    public static final short TREE_POSITION_SAME_NODE = 32;
    public static final short TREE_POSITION_DISCONNECTED = 0;
    public static final short DOCUMENT_POSITION_DISCONNECTED = 1;
    public static final short DOCUMENT_POSITION_PRECEDING = 2;
    public static final short DOCUMENT_POSITION_FOLLOWING = 4;
    public static final short DOCUMENT_POSITION_CONTAINS = 8;
    public static final short DOCUMENT_POSITION_IS_CONTAINED = 16;
    public static final short DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;
    static final long serialVersionUID = -6316591992167219696L;
    public static final short ELEMENT_DEFINITION_NODE = 21;
    protected NodeImpl ownerNode;
    protected short flags;
    protected static final short READONLY = 1;
    protected static final short SYNCDATA = 2;
    protected static final short SYNCCHILDREN = 4;
    protected static final short OWNED = 8;
    protected static final short FIRSTCHILD = 16;
    protected static final short SPECIFIED = 32;
    protected static final short IGNORABLEWS = 64;
    protected static final short HASSTRING = 128;
    protected static final short NORMALIZED = 256;
    protected static final short ID = 512;

    protected NodeImpl(CoreDocumentImpl coreDocumentImpl) {
        this.ownerNode = coreDocumentImpl;
    }

    public NodeImpl() {
    }

    public abstract short getNodeType();

    public abstract String getNodeName();

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String string2) throws DOMException {
    }

    public Node appendChild(Node node) throws DOMException {
        return this.insertBefore(node, null);
    }

    public Node cloneNode(boolean bl) {
        NodeImpl nodeImpl;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        try {
            nodeImpl = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("**Internal Error**" + cloneNotSupportedException);
        }
        nodeImpl.ownerNode = this.ownerDocument();
        nodeImpl.isOwned(false);
        nodeImpl.isReadOnly(false);
        this.ownerDocument().callUserDataHandlers(this, nodeImpl, (short)1);
        return nodeImpl;
    }

    public Document getOwnerDocument() {
        if (this.isOwned()) {
            return this.ownerNode.ownerDocument();
        }
        return (Document)this.ownerNode;
    }

    CoreDocumentImpl ownerDocument() {
        if (this.isOwned()) {
            return this.ownerNode.ownerDocument();
        }
        return (CoreDocumentImpl)this.ownerNode;
    }

    protected void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (!this.isOwned()) {
            this.ownerNode = coreDocumentImpl;
        }
    }

    protected int getNodeNumber() {
        CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)this.getOwnerDocument();
        int n = coreDocumentImpl.getNodeNumber(this);
        return n;
    }

    public Node getParentNode() {
        return null;
    }

    NodeImpl parentNode() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    ChildNode previousSibling() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public Node removeChild(Node node) throws DOMException {
        throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public int getLength() {
        return 0;
    }

    public Node item(int n) {
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String string2, String string3) {
        return this.ownerDocument().getImplementation().hasFeature(string2, string3);
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String string2) throws DOMException {
        throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
    }

    public String getLocalName() {
        return null;
    }

    public void addEventListener(String string2, EventListener eventListener, boolean bl) {
        this.ownerDocument().addEventListener(this, string2, eventListener, bl);
    }

    public void removeEventListener(String string2, EventListener eventListener, boolean bl) {
        this.ownerDocument().removeEventListener(this, string2, eventListener, bl);
    }

    public boolean dispatchEvent(Event event) {
        return this.ownerDocument().dispatchEvent(this, event);
    }

    public String getBaseURI() {
        return null;
    }

    public short compareTreePosition(Node node) {
        int n;
        if (this == node) {
            return 48;
        }
        short s = this.getNodeType();
        short s2 = node.getNodeType();
        if (s == 6 || s == 12 || s2 == 6 || s2 == 12) {
            return 0;
        }
        NodeImpl nodeImpl = this;
        Node node2 = node;
        int n2 = 0;
        int n3 = 0;
        NodeImpl nodeImpl2 = this;
        while (nodeImpl2 != null) {
            ++n2;
            if (nodeImpl2 == node) {
                return 5;
            }
            nodeImpl = nodeImpl2;
            nodeImpl2 = nodeImpl2.getParentNode();
        }
        nodeImpl2 = node;
        while (nodeImpl2 != null) {
            ++n3;
            if (nodeImpl2 == this) {
                return 10;
            }
            node2 = nodeImpl2;
            nodeImpl2 = nodeImpl2.getParentNode();
        }
        NodeImpl nodeImpl3 = this;
        Node node3 = node;
        short s3 = nodeImpl.getNodeType();
        short s4 = node2.getNodeType();
        if (s3 == 2) {
            nodeImpl3 = ((AttrImpl)nodeImpl).getOwnerElement();
        }
        if (s4 == 2) {
            node3 = ((AttrImpl)node2).getOwnerElement();
        }
        if (s3 == 2 && s4 == 2 && nodeImpl3 == node3) {
            return 16;
        }
        if (s3 == 2) {
            n2 = 0;
            nodeImpl2 = nodeImpl3;
            while (nodeImpl2 != null) {
                ++n2;
                if (nodeImpl2 == node3) {
                    return 1;
                }
                nodeImpl = nodeImpl2;
                nodeImpl2 = nodeImpl2.getParentNode();
            }
        }
        if (s4 == 2) {
            n3 = 0;
            nodeImpl2 = node3;
            while (nodeImpl2 != null) {
                ++n3;
                if (nodeImpl2 == nodeImpl3) {
                    return 2;
                }
                node2 = nodeImpl2;
                nodeImpl2 = nodeImpl2.getParentNode();
            }
        }
        if (nodeImpl != node2) {
            return 0;
        }
        if (n2 > n3) {
            n = 0;
            while (n < n2 - n3) {
                nodeImpl3 = nodeImpl3.getParentNode();
                ++n;
            }
            if (nodeImpl3 == node3) {
                return 1;
            }
        } else {
            n = 0;
            while (n < n3 - n2) {
                node3 = node3.getParentNode();
                ++n;
            }
            if (node3 == nodeImpl3) {
                return 2;
            }
        }
        Node node4 = nodeImpl3.getParentNode();
        Node node5 = node3.getParentNode();
        while (node4 != node5) {
            nodeImpl3 = node4;
            node3 = node5;
            node4 = node4.getParentNode();
            node5 = node5.getParentNode();
        }
        Node node6 = node4.getFirstChild();
        while (node6 != null) {
            if (node6 == node3) {
                return 1;
            }
            if (node6 == nodeImpl3) {
                return 2;
            }
            node6 = node6.getNextSibling();
        }
        return 0;
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        int n;
        DocumentType documentType;
        Document document;
        if (this == node) {
            return 0;
        }
        if (node != null && !(node instanceof NodeImpl)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, string2);
        }
        Document document2 = this.getNodeType() == 9 ? (Document)this : this.getOwnerDocument();
        if (document2 != (document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument()) && document2 != null && document != null) {
            int n2;
            int n3 = ((CoreDocumentImpl)document).getNodeNumber();
            if (n3 > (n2 = ((CoreDocumentImpl)document2).getNodeNumber())) {
                return 37;
            }
            return 35;
        }
        NodeImpl nodeImpl = this;
        Node node2 = node;
        int n4 = 0;
        int n5 = 0;
        NodeImpl nodeImpl2 = this;
        while (nodeImpl2 != null) {
            ++n4;
            if (nodeImpl2 == node) {
                return 10;
            }
            nodeImpl = nodeImpl2;
            nodeImpl2 = nodeImpl2.getParentNode();
        }
        nodeImpl2 = node;
        while (nodeImpl2 != null) {
            ++n5;
            if (nodeImpl2 == this) {
                return 20;
            }
            node2 = nodeImpl2;
            nodeImpl2 = nodeImpl2.getParentNode();
        }
        short s = nodeImpl.getNodeType();
        short s2 = node2.getNodeType();
        NodeImpl nodeImpl3 = this;
        Node node3 = node;
        switch (s) {
            case 6: 
            case 12: {
                documentType = document2.getDoctype();
                if (documentType == node2) {
                    return 10;
                }
                switch (s2) {
                    case 6: 
                    case 12: {
                        if (s != s2) {
                            return s > s2 ? (short)2 : 4;
                        }
                        if (s == 12) {
                            if (((NamedNodeMapImpl)documentType.getNotations()).precedes(node2, nodeImpl)) {
                                return 34;
                            }
                            return 36;
                        }
                        if (((NamedNodeMapImpl)documentType.getEntities()).precedes(node2, nodeImpl)) {
                            return 34;
                        }
                        return 36;
                    }
                }
                nodeImpl3 = nodeImpl = document2;
                break;
            }
            case 10: {
                if (node3 == document2) {
                    return 10;
                }
                if (document2 == null || document2 != document) break;
                return 4;
            }
            case 2: {
                nodeImpl3 = ((AttrImpl)nodeImpl).getOwnerElement();
                if (s2 == 2 && (node3 = ((AttrImpl)node2).getOwnerElement()) == nodeImpl3) {
                    if (((NamedNodeMapImpl)nodeImpl3.getAttributes()).precedes(node, this)) {
                        return 34;
                    }
                    return 36;
                }
                n4 = 0;
                nodeImpl2 = nodeImpl3;
                while (nodeImpl2 != null) {
                    ++n4;
                    if (nodeImpl2 == node3) {
                        return 10;
                    }
                    nodeImpl = nodeImpl2;
                    nodeImpl2 = nodeImpl2.getParentNode();
                }
                break;
            }
        }
        switch (s2) {
            case 6: 
            case 12: {
                documentType = document2.getDoctype();
                if (documentType == this) {
                    return 20;
                }
                node3 = node2 = document2;
                break;
            }
            case 10: {
                if (nodeImpl3 == document) {
                    return 20;
                }
                if (document == null || document2 != document) break;
                return 2;
            }
            case 2: {
                n5 = 0;
                node3 = ((AttrImpl)node2).getOwnerElement();
                nodeImpl2 = node3;
                while (nodeImpl2 != null) {
                    ++n5;
                    if (nodeImpl2 == nodeImpl3) {
                        return 20;
                    }
                    node2 = nodeImpl2;
                    nodeImpl2 = nodeImpl2.getParentNode();
                }
                break;
            }
        }
        if (nodeImpl != node2) {
            int n6;
            int n7 = nodeImpl.getNodeNumber();
            if (n7 > (n6 = ((NodeImpl)node2).getNodeNumber())) {
                return 37;
            }
            return 35;
        }
        if (n4 > n5) {
            n = 0;
            while (n < n4 - n5) {
                nodeImpl3 = nodeImpl3.getParentNode();
                ++n;
            }
            if (nodeImpl3 == node3) {
                return 2;
            }
        } else {
            n = 0;
            while (n < n5 - n4) {
                node3 = node3.getParentNode();
                ++n;
            }
            if (node3 == nodeImpl3) {
                return 4;
            }
        }
        Node node4 = nodeImpl3.getParentNode();
        Node node5 = node3.getParentNode();
        while (node4 != node5) {
            nodeImpl3 = node4;
            node3 = node5;
            node4 = node4.getParentNode();
            node5 = node5.getParentNode();
        }
        Node node6 = node4.getFirstChild();
        while (node6 != null) {
            if (node6 == node3) {
                return 2;
            }
            if (node6 == nodeImpl3) {
                return 4;
            }
            node6 = node6.getNextSibling();
        }
        return 0;
    }

    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    void getTextContent(StringBuffer stringBuffer) throws DOMException {
        String string2 = this.getNodeValue();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
    }

    public void setTextContent(String string2) throws DOMException {
        this.setNodeValue(string2);
    }

    public boolean isSameNode(Node node) {
        return this == node;
    }

    public boolean isDefaultNamespace(String string2) {
        short s = this.getNodeType();
        switch (s) {
            case 1: {
                NodeImpl nodeImpl;
                NodeImpl nodeImpl2;
                String string3 = this.getNamespaceURI();
                String string4 = this.getPrefix();
                if (string4 == null || string4.length() == 0) {
                    if (string2 == null) {
                        return string3 == string2;
                    }
                    return string2.equals(string3);
                }
                if (this.hasAttributes() && (nodeImpl2 = (NodeImpl)((ElementImpl)(nodeImpl = (ElementImpl)this)).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns")) != null) {
                    String string5 = nodeImpl2.getNodeValue();
                    if (string2 == null) {
                        return string3 == string5;
                    }
                    return string2.equals(string5);
                }
                nodeImpl = (NodeImpl)this.getElementAncestor(this);
                if (nodeImpl != null) {
                    return nodeImpl.isDefaultNamespace(string2);
                }
                return false;
            }
            case 9: {
                return ((NodeImpl)((Document)this).getDocumentElement()).isDefaultNamespace(string2);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
            case 2: {
                if (this.ownerNode.getNodeType() == 1) {
                    return this.ownerNode.isDefaultNamespace(string2);
                }
                return false;
            }
        }
        NodeImpl nodeImpl = (NodeImpl)this.getElementAncestor(this);
        if (nodeImpl != null) {
            return nodeImpl.isDefaultNamespace(string2);
        }
        return false;
    }

    public String lookupPrefix(String string2) {
        if (string2 == null) {
            return null;
        }
        short s = this.getNodeType();
        switch (s) {
            case 1: {
                this.getNamespaceURI();
                return this.lookupNamespacePrefix(string2, (ElementImpl)this);
            }
            case 9: {
                return ((NodeImpl)((Document)this).getDocumentElement()).lookupPrefix(string2);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.ownerNode.getNodeType() == 1) {
                    return this.ownerNode.lookupPrefix(string2);
                }
                return null;
            }
        }
        NodeImpl nodeImpl = (NodeImpl)this.getElementAncestor(this);
        if (nodeImpl != null) {
            return nodeImpl.lookupPrefix(string2);
        }
        return null;
    }

    public String lookupNamespaceURI(String string2) {
        short s = this.getNodeType();
        switch (s) {
            case 1: {
                Object object;
                String string3 = this.getNamespaceURI();
                String string4 = this.getPrefix();
                if (string3 != null) {
                    if (string2 == null && string4 == string2) {
                        return string3;
                    }
                    if (string4 != null && string4.equals(string2)) {
                        return string3;
                    }
                }
                if (this.hasAttributes()) {
                    object = this.getAttributes();
                    int n = object.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        Node node = object.item(n2);
                        String string5 = node.getPrefix();
                        String string6 = node.getNodeValue();
                        string3 = node.getNamespaceURI();
                        if (string3 != null && string3.equals("http://www.w3.org/2000/xmlns/")) {
                            if (string2 == null && node.getNodeName().equals("xmlns")) {
                                return string6.length() > 0 ? string6 : null;
                            }
                            if (string5 != null && string5.equals("xmlns") && node.getLocalName().equals(string2)) {
                                return string6.length() > 0 ? string6 : null;
                            }
                        }
                        ++n2;
                    }
                }
                if ((object = (NodeImpl)this.getElementAncestor(this)) != null) {
                    return ((NodeImpl)object).lookupNamespaceURI(string2);
                }
                return null;
            }
            case 9: {
                return ((NodeImpl)((Document)this).getDocumentElement()).lookupNamespaceURI(string2);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.ownerNode.getNodeType() == 1) {
                    return this.ownerNode.lookupNamespaceURI(string2);
                }
                return null;
            }
        }
        NodeImpl nodeImpl = (NodeImpl)this.getElementAncestor(this);
        if (nodeImpl != null) {
            return nodeImpl.lookupNamespaceURI(string2);
        }
        return null;
    }

    Node getElementAncestor(Node node) {
        Node node2 = node.getParentNode();
        while (node2 != null) {
            short s = node2.getNodeType();
            if (s == 1) {
                return node2;
            }
            node2 = node2.getParentNode();
        }
        return null;
    }

    String lookupNamespacePrefix(String string2, ElementImpl elementImpl) {
        Object object;
        String string3 = this.getNamespaceURI();
        String string4 = this.getPrefix();
        if (string3 != null && string3.equals(string2) && string4 != null && (object = elementImpl.lookupNamespaceURI(string4)) != null && ((String)object).equals(string2)) {
            return string4;
        }
        if (this.hasAttributes()) {
            object = this.getAttributes();
            int n = object.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string5;
                String string6;
                Node node = object.item(n2);
                String string7 = node.getPrefix();
                String string8 = node.getNodeValue();
                string3 = node.getNamespaceURI();
                if (string3 != null && string3.equals("http://www.w3.org/2000/xmlns/") && (node.getNodeName().equals("xmlns") || string7 != null && string7.equals("xmlns") && string8.equals(string2)) && (string6 = elementImpl.lookupNamespaceURI(string5 = node.getLocalName())) != null && string6.equals(string2)) {
                    return string5;
                }
                ++n2;
            }
        }
        if ((object = (NodeImpl)this.getElementAncestor(this)) != null) {
            return ((NodeImpl)object).lookupNamespacePrefix(string2, elementImpl);
        }
        return null;
    }

    public boolean isEqualNode(Node node) {
        if (node == this) {
            return true;
        }
        if (node.getNodeType() != this.getNodeType()) {
            return false;
        }
        if (this.getNodeName() == null ? node.getNodeName() != null : !this.getNodeName().equals(node.getNodeName())) {
            return false;
        }
        if (this.getLocalName() == null ? node.getLocalName() != null : !this.getLocalName().equals(node.getLocalName())) {
            return false;
        }
        if (this.getNamespaceURI() == null ? node.getNamespaceURI() != null : !this.getNamespaceURI().equals(node.getNamespaceURI())) {
            return false;
        }
        if (this.getPrefix() == null ? node.getPrefix() != null : !this.getPrefix().equals(node.getPrefix())) {
            return false;
        }
        return !(this.getNodeValue() == null ? node.getNodeValue() != null : !this.getNodeValue().equals(node.getNodeValue()));
    }

    public Object getFeature(String string2, String string3) {
        return this.isSupported(string2, string3) ? this : null;
    }

    public Object setUserData(String string2, Object object, UserDataHandler userDataHandler) {
        return this.ownerDocument().setUserData(this, string2, object, userDataHandler);
    }

    public Object getUserData(String string2) {
        return this.ownerDocument().getUserData(this, string2);
    }

    protected Hashtable getUserDataRecord() {
        return this.ownerDocument().getUserDataRecord(this);
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isReadOnly(bl);
    }

    public boolean getReadOnly() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.isReadOnly();
    }

    public void setUserData(Object object) {
        this.ownerDocument().setUserData(this, object);
    }

    public Object getUserData() {
        return this.ownerDocument().getUserData(this);
    }

    protected void changed() {
        this.ownerDocument().changed();
    }

    protected int changes() {
        return this.ownerDocument().changes();
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
    }

    protected Node getContainer() {
        return null;
    }

    final boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    final void isReadOnly(boolean bl) {
        this.flags = bl ? (short)(this.flags | 1) : (short)(this.flags & 0xFFFFFFFE);
    }

    final boolean needsSyncData() {
        return (this.flags & 2) != 0;
    }

    final void needsSyncData(boolean bl) {
        this.flags = bl ? (short)(this.flags | 2) : (short)(this.flags & 0xFFFFFFFD);
    }

    final boolean needsSyncChildren() {
        return (this.flags & 4) != 0;
    }

    public final void needsSyncChildren(boolean bl) {
        this.flags = bl ? (short)(this.flags | 4) : (short)(this.flags & 0xFFFFFFFB);
    }

    final boolean isOwned() {
        return (this.flags & 8) != 0;
    }

    final void isOwned(boolean bl) {
        this.flags = bl ? (short)(this.flags | 8) : (short)(this.flags & 0xFFFFFFF7);
    }

    final boolean isFirstChild() {
        return (this.flags & 0x10) != 0;
    }

    final void isFirstChild(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x10) : (short)(this.flags & 0xFFFFFFEF);
    }

    final boolean isSpecified() {
        return (this.flags & 0x20) != 0;
    }

    final void isSpecified(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x20) : (short)(this.flags & 0xFFFFFFDF);
    }

    final boolean internalIsIgnorableWhitespace() {
        return (this.flags & 0x40) != 0;
    }

    final void isIgnorableWhitespace(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x40) : (short)(this.flags & 0xFFFFFFBF);
    }

    final boolean hasStringValue() {
        return (this.flags & 0x80) != 0;
    }

    final void hasStringValue(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x80) : (short)(this.flags & 0xFFFFFF7F);
    }

    final boolean isNormalized() {
        return (this.flags & 0x100) != 0;
    }

    final void isNormalized(boolean bl) {
        if (!bl && this.isNormalized() && this.ownerNode != null) {
            this.ownerNode.isNormalized(false);
        }
        this.flags = bl ? (short)(this.flags | 0x100) : (short)(this.flags & 0xFFFFFEFF);
    }

    final boolean isIdAttribute() {
        return (this.flags & 0x200) != 0;
    }

    final void isIdAttribute(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x200) : (short)(this.flags & 0xFFFFFDFF);
    }

    public String toString() {
        return "[" + this.getNodeName() + ": " + this.getNodeValue() + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        objectOutputStream.defaultWriteObject();
    }
}

