/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.ivy.util.FileUtil;

public final class ChecksumHelper {
    private static Map algorithms = new HashMap<String, String>();
    private static final char[] CHARS;

    public static void check(File file, File object, String string) throws IOException {
        Object object2;
        int n;
        if (((String)(object = FileUtil.readEntirely(new BufferedReader(new FileReader((File)object))).trim().toLowerCase(Locale.US))).indexOf(32) >= 0 && (((String)object).startsWith("md") || ((String)object).startsWith("sha"))) {
            n = ((String)object).lastIndexOf(32);
            object2 = ((String)object).substring(n + 1);
        } else {
            n = ((String)object).indexOf(32);
            if (n != -1) {
                object2 = ((String)object).substring(0, n);
                if (((String)object2).endsWith(":")) {
                    object2 = new StringBuffer();
                    object = ((String)object).substring(n + 1).toCharArray();
                    for (n = 0; n < ((Object)object).length; ++n) {
                        if (Character.isWhitespace((char)object[n])) continue;
                        ((StringBuffer)object2).append((char)object[n]);
                    }
                    object2 = ((StringBuffer)object2).toString();
                }
            } else {
                object2 = object;
            }
        }
        String string2 = ChecksumHelper.computeAsString(file, string).trim().toLowerCase(Locale.US);
        if (!((String)object2).equals(string2)) {
            throw new IOException("invalid " + string + ": expected=" + (String)object2 + " computed=" + string2);
        }
    }

    public static String computeAsString(File file, String string) throws IOException {
        return ChecksumHelper.byteArrayToHexString(ChecksumHelper.compute(file, string));
    }

    private static byte[] compute(File object, String object2) throws IOException {
        object = new FileInputStream((File)object);
        try {
            int n;
            object2 = ChecksumHelper.getMessageDigest((String)object2);
            ((MessageDigest)object2).reset();
            byte[] byArray = new byte[2048];
            while ((n = ((InputStream)object).read(byArray)) != -1) {
                ((MessageDigest)object2).update(byArray, 0, n);
            }
            object2 = ((MessageDigest)object2).digest();
            return object2;
        }
        finally {
            ((InputStream)object).close();
        }
    }

    public static boolean isKnownAlgorithm(String string) {
        return algorithms.containsKey(string);
    }

    private static MessageDigest getMessageDigest(String string) {
        String string2 = (String)algorithms.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("unknown algorithm " + string);
        }
        try {
            return MessageDigest.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("unknown algorithm " + string);
        }
    }

    public static String byteArrayToHexString(byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length << 1);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = (byte)(byArray[i] & 0xF0);
            by = (byte)(by >>> 4);
            by = (byte)(by & 0xF);
            stringBuffer.append(CHARS[by]);
            by = (byte)(byArray[i] & 0xF);
            stringBuffer.append(CHARS[by]);
        }
        return stringBuffer.toString();
    }

    static {
        algorithms.put("md5", "MD5");
        algorithms.put("sha1", "SHA-1");
        CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

