/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes;

import java.io.IOException;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.HashMap;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Document;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.EntitiesData;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.CharacterReader;

public class Entities {
    private static final char[] codeDelims = new char[]{',', ';'};
    private static final HashMap<String, String> multipoints = new HashMap();
    private static final Document.OutputSettings DefaultOutput = new Document.OutputSettings();

    public static boolean isNamedEntity(String name) {
        String string;
        return EscapeMode.extended.codepointForName(string) != -1;
    }

    public static boolean isBaseNamedEntity(String name) {
        String string;
        return EscapeMode.base.codepointForName(string) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int codepointsForName(String name, int[] codepoints) {
        String val = multipoints.get(name);
        if (val != null) {
            void var2_3;
            codepoints[0] = val.codePointAt(0);
            codepoints[1] = var2_3.codePointAt(1);
            return 2;
        }
        int codepoint = EscapeMode.extended.codepointForName(name);
        if (codepoint != -1) {
            void var0_1;
            var1_2[0] = var0_1;
            return 1;
        }
        return 0;
    }

    static void escape(Appendable accum2, String string, Document.OutputSettings out, boolean inAttribute, boolean normaliseWhite, boolean stripLeadingWhite) throws IOException {
        int codePoint;
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        EscapeMode escapeMode = out.escapeMode();
        CharsetEncoder encoder = out.encoder();
        CoreCharset coreCharset = out.coreCharset;
        int length = string.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(offset);
            if (normaliseWhite) {
                if (StringUtil.isWhitespace(codePoint)) {
                    if (stripLeadingWhite && !reachedNonWhite || lastWasWhite) continue;
                    accum2.append(' ');
                    lastWasWhite = true;
                    continue;
                }
                lastWasWhite = false;
                reachedNonWhite = true;
            }
            if (codePoint < 65536) {
                char c = (char)codePoint;
                switch (c) {
                    case '&': {
                        accum2.append("&amp;");
                        break;
                    }
                    case '\u00a0': {
                        if (escapeMode != EscapeMode.xhtml) {
                            accum2.append("&nbsp;");
                            break;
                        }
                        accum2.append("&#xa0;");
                        break;
                    }
                    case '<': {
                        if (!inAttribute || escapeMode == EscapeMode.xhtml) {
                            accum2.append("&lt;");
                            break;
                        }
                        accum2.append(c);
                        break;
                    }
                    case '>': {
                        if (!inAttribute) {
                            accum2.append("&gt;");
                            break;
                        }
                        accum2.append(c);
                        break;
                    }
                    case '\"': {
                        if (inAttribute) {
                            accum2.append("&quot;");
                            break;
                        }
                        accum2.append(c);
                        break;
                    }
                    default: {
                        if (Entities.canEncode(coreCharset, c, encoder)) {
                            accum2.append(c);
                            break;
                        }
                        Entities.appendEncoded(accum2, escapeMode, codePoint);
                        break;
                    }
                }
                continue;
            }
            String c = new String(Character.toChars(codePoint));
            if (encoder.canEncode(c)) {
                accum2.append(c);
                continue;
            }
            Entities.appendEncoded(accum2, escapeMode, codePoint);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendEncoded(Appendable accum2, EscapeMode escapeMode, int codePoint) throws IOException {
        void var2_2;
        Appendable appendable;
        String name = escapeMode.nameForCodepoint(codePoint);
        if (!"".equals(name)) {
            void var1_1;
            accum2.append('&').append((CharSequence)var1_1).append(';');
            return;
        }
        appendable.append("&#x").append(Integer.toHexString((int)var2_2)).append(';');
    }

    /*
     * WARNING - void declaration
     */
    private static boolean canEncode(CoreCharset charset, char c, CharsetEncoder fallback) {
        void var1_1;
        void var2_2;
        CoreCharset coreCharset;
        switch (coreCharset) {
            case ascii: {
                return c < '\u0080';
            }
            case utf: {
                return true;
            }
        }
        return var2_2.canEncode((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void load(EscapeMode e, String pointsData, int size) {
        void var2_2;
        void var3_3;
        EscapeMode.access$102(e, new String[size]);
        EscapeMode.access$202(e, new int[size]);
        EscapeMode.access$302(e, new int[size]);
        EscapeMode.access$402(e, new String[size]);
        int i = 0;
        CharacterReader reader = new CharacterReader(pointsData);
        while (!reader.isEmpty()) {
            int cp2;
            String name = reader.consumeTo('=');
            reader.advance();
            int cp1 = Integer.parseInt(reader.consumeToAny(codeDelims), 36);
            char codeDelim = reader.current();
            reader.advance();
            if (codeDelim == ',') {
                cp2 = Integer.parseInt(reader.consumeTo(';'), 36);
                reader.advance();
            } else {
                cp2 = -1;
            }
            String string = reader.consumeTo('&');
            int index = Integer.parseInt(string, 36);
            reader.advance();
            ((EscapeMode)e).nameKeys[i] = name;
            ((EscapeMode)e).codeVals[i] = cp1;
            ((EscapeMode)e).codeKeys[index] = cp1;
            ((EscapeMode)e).nameVals[index] = name;
            if (cp2 != -1) {
                multipoints.put(name, new String(new int[]{cp1, cp2}, 0, 2));
            }
            ++i;
        }
        Validate.isTrue(var3_3 == var2_2, "Unexpected count of entities loaded");
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(EscapeMode x0, String x1, int x2) {
        void var2_2;
        void var1_1;
        Entities.load(x0, (String)var1_1, (int)var2_2);
    }

    public static final class EscapeMode
    extends Enum<EscapeMode> {
        public static final /* enum */ EscapeMode xhtml = new EscapeMode(EntitiesData.xmlPoints, 4);
        public static final /* enum */ EscapeMode base = new EscapeMode(EntitiesData.basePoints, 106);
        public static final /* enum */ EscapeMode extended = new EscapeMode(EntitiesData.fullPoints, 2125);
        private String[] nameKeys;
        private int[] codeVals;
        private int[] codeKeys;
        private String[] nameVals;
        private static final /* synthetic */ EscapeMode[] $VALUES;

        public static EscapeMode valueOf(String name) {
            String string;
            return Enum.valueOf(EscapeMode.class, string);
        }

        /*
         * WARNING - void declaration
         */
        private EscapeMode(String file, int size) {
            void var3_3;
            Entities.access$000(this, (String)var3_3, size);
        }

        /*
         * WARNING - void declaration
         */
        final int codepointForName(String name) {
            int index = Arrays.binarySearch(this.nameKeys, name);
            if (index >= 0) {
                void var1_2;
                return this.codeVals[var1_2];
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        final String nameForCodepoint(int codepoint) {
            int index = Arrays.binarySearch(this.codeKeys, codepoint);
            if (index >= 0) {
                void var2_2;
                void var1_1;
                if (index < this.nameVals.length - 1 && this.codeKeys[index + 1] == var1_1) {
                    return this.nameVals[index + 1];
                }
                return this.nameVals[var2_2];
            }
            return "";
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String[] access$102(EscapeMode x0, String[] x1) {
            void var1_1;
            x0.nameKeys = var1_1;
            return x0.nameKeys;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int[] access$202(EscapeMode x0, int[] x1) {
            void var1_1;
            x0.codeVals = var1_1;
            return x0.codeVals;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int[] access$302(EscapeMode x0, int[] x1) {
            void var1_1;
            x0.codeKeys = var1_1;
            return x0.codeKeys;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String[] access$402(EscapeMode x0, String[] x1) {
            void var1_1;
            x0.nameVals = var1_1;
            return x0.nameVals;
        }

        static {
            $VALUES = new EscapeMode[]{xhtml, base, extended};
        }
    }

    static final class CoreCharset
    extends Enum<CoreCharset> {
        public static final /* enum */ CoreCharset ascii = new CoreCharset();
        public static final /* enum */ CoreCharset utf = new CoreCharset();
        public static final /* enum */ CoreCharset fallback = new CoreCharset();
        private static final /* synthetic */ CoreCharset[] $VALUES;

        public static CoreCharset[] values() {
            return (CoreCharset[])$VALUES.clone();
        }

        static CoreCharset byName(String name) {
            String string;
            if (name.equals("US-ASCII")) {
                return ascii;
            }
            if (string.startsWith("UTF-")) {
                return utf;
            }
            return fallback;
        }

        static {
            $VALUES = new CoreCharset[]{ascii, utf, fallback};
        }
    }
}

