/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.BigVector;
import scala.collection.immutable.BitmapIndexedMapNode;
import scala.collection.immutable.MapNode;
import scala.collection.immutable.MapNode$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector0$;
import scala.collection.immutable.Vector1;
import scala.collection.immutable.VectorBuilder;
import scala.collection.immutable.VectorStatics$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class HashCollisionMapNode<K, V>
extends MapNode<K, V> {
    private final int originalHash;
    private final int hash;
    private Vector<Tuple2<K, V>> content;

    public final int originalHash() {
        return this.originalHash;
    }

    public final int hash() {
        return this.hash;
    }

    public final Vector<Tuple2<K, V>> content() {
        return this.content;
    }

    /*
     * WARNING - void declaration
     */
    public final void content_$eq(Vector<Tuple2<K, V>> x$1) {
        void var1_1;
        this.content = var1_1;
    }

    public final int indexOf(K key) {
        Iterator<Tuple2<K, V>> iter = this.content().iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (BoxesRunTime.equals(iter.next()._1(), key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public final int size() {
        return this.content().length();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V apply(K key, int originalHash, int hash, int shift) {
        void var1_1;
        void var3_3;
        void var2_2;
        Option<V> option = this.get(key, (int)var2_2, (int)var3_3, shift);
        if (option == null) {
            throw null;
        }
        Option<V> getOrElse_this = option;
        if (option.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (V)var1_1.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Option<V> get(K key, int originalHash, int hash, int shift) {
        void var3_4;
        if (this.hash() == var3_4) {
            int index = this.indexOf(key);
            if (index >= 0) {
                void var1_2;
                return new Some(((Tuple2)this.content().apply(var1_2))._2());
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V1> V1 getOrElse(K key, int originalHash, int hash, int shift, Function0<V1> f) {
        void var3_4;
        if (this.hash() == var3_4) {
            void var1_1;
            int n = this.indexOf(var1_1);
            switch (n) {
                case -1: {
                    return f.apply();
                }
            }
            return (V1)((Tuple2)this.content().apply(n))._2();
        }
        return f.apply();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsKey(K key, int originalHash, int hash, int shift) {
        void var1_1;
        void var3_3;
        return this.hash() == var3_3 && this.indexOf(var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V1> MapNode<K, V1> updated(K key, V1 value, int originalHash, int hash, int shift, boolean replaceValue) {
        void var2_2;
        void var1_1;
        void var3_3;
        int index = this.indexOf(key);
        if (index >= 0) {
            if (replaceValue) {
                if (((Tuple2)this.content().apply(index))._2() == value) {
                    return this;
                }
                return new HashCollisionMapNode<K, V>(originalHash, hash, this.content().updated(index, new Tuple2<K, V1>(key, value)));
            }
            return this;
        }
        return new HashCollisionMapNode<K, V>((int)var3_3, hash, this.content().appended(new Tuple2<void, void>(var1_1, var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V1> MapNode<K, V1> removed(K key, int originalHash, int hash, int shift) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.containsKey(key, originalHash, hash, shift)) {
            return this;
        }
        Serializable updatedContent = (Vector)this.content().filterNot((Function1<Tuple2, Object> & Serializable)keyValuePair -> {
            void var1_1;
            return BoxesRunTime.boxToBoolean(HashCollisionMapNode.$anonfun$removed$1(key, (Tuple2)var1_1));
        });
        if (updatedContent == null) {
            throw null;
        }
        switch (updatedContent.length()) {
            case 1: {
                void var4_5;
                updatedContent = (Tuple2)updatedContent.apply(false);
                if (updatedContent == null) {
                    throw new MatchError((Object)null);
                }
                Object k = ((Tuple2)updatedContent)._1();
                Object v = ((Tuple2)updatedContent)._2();
                int n = hash & 0x1F;
                return new BitmapIndexedMapNode(1 << n, 0, new Object[]{var4_5, var1_1}, new int[]{originalHash}, 1, hash);
            }
        }
        return new HashCollisionMapNode<K, V>((int)var2_2, (int)var3_3, var1_1);
    }

    @Override
    public final boolean hasNodes() {
        return false;
    }

    @Override
    public final int nodeArity() {
        return 0;
    }

    @Override
    public final MapNode<K, V> getNode(int index) {
        throw new IndexOutOfBoundsException("No sub-nodes present in hash-collision leaf node.");
    }

    @Override
    public final boolean hasPayload() {
        return true;
    }

    @Override
    public final int payloadArity() {
        return this.content().length();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final K getKey(int index) {
        void var1_1;
        return this.getPayload((int)var1_1)._1();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getValue(int index) {
        void var1_1;
        return this.getPayload((int)var1_1)._2();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Tuple2<K, V> getPayload(int index) {
        void var1_1;
        return (Tuple2)this.content().apply(var1_1);
    }

    @Override
    public final int getHash(int index) {
        return this.originalHash();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        Vector<Tuple2<K, V>> vector = this.content();
        if (vector == null) {
            throw null;
        }
        Vector<Tuple2<K, V>> foreach_this = vector;
        int foreach_c = vector.vectorSliceCount();
        for (int foreach_i = 0; foreach_i < foreach_c; ++foreach_i) {
            int foreach_foreachRec_i;
            void foreach_foreachRec_level;
            void foreach_foreachRec_a;
            int foreach_vectorSliceDim_c = foreach_c / 2;
            Object[] objectArray = foreach_this.vectorSlice(foreach_i);
            int n = foreach_vectorSliceDim_c + 1 - Math.abs(foreach_i - foreach_vectorSliceDim_c) - 1;
            VectorStatics$ foreach_foreachRec_this = VectorStatics$.MODULE$;
            int foreach_foreachRec_len = ((void)foreach_foreachRec_a).length;
            if (foreach_foreachRec_level == false) {
                for (foreach_foreachRec_i = 0; foreach_foreachRec_i < foreach_foreachRec_len; ++foreach_foreachRec_i) {
                    f.apply((Tuple2<K, V>)foreach_foreachRec_a[foreach_foreachRec_i]);
                }
                continue;
            }
            void foreach_foreachRec_l = foreach_foreachRec_level - true;
            while (foreach_foreachRec_i < foreach_foreachRec_len) {
                int foreachRec_i;
                Object[] foreachRec_a = (Object[])foreach_foreachRec_a[foreach_foreachRec_i];
                int foreachRec_len = foreachRec_a.length;
                if (foreach_foreachRec_l == false) {
                    for (foreachRec_i = 0; foreachRec_i < foreachRec_len; ++foreachRec_i) {
                        f.apply((Tuple2<K, V>)foreachRec_a[foreachRec_i]);
                    }
                } else {
                    void foreachRec_l = foreach_foreachRec_l - true;
                    while (foreachRec_i < foreachRec_len) {
                        foreach_foreachRec_this.foreachRec((int)foreachRec_l, (Object[])foreachRec_a[foreachRec_i], f);
                        ++foreachRec_i;
                    }
                }
                ++foreach_foreachRec_i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <U> void foreachEntry(Function2<K, V, U> f) {
        Vector<Tuple2<K, V>> vector = this.content();
        Function1<Tuple2, Object> & Serializable intersect = (Function1<Tuple2, Object> & Serializable)x0$1 -> {
            void var1_1;
            void var2_2;
            Function2 function2;
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            Object k = x0$1._1();
            Object v = x0$1._2();
            function2 = function2.apply(var2_2, var1_1);
            return function2;
        };
        if (vector == null) {
            throw null;
        }
        Vector<Tuple2<K, V>> foreach_this = vector;
        int foreach_c = vector.vectorSliceCount();
        for (int foreach_i = 0; foreach_i < foreach_c; ++foreach_i) {
            void $anonfun$foreachEntry$1_v2;
            int foreach_foreachRec_i;
            void foreach_foreachRec_level;
            void foreach_foreachRec_a;
            int foreach_vectorSliceDim_c = foreach_c / 2;
            Object[] objectArray = foreach_this.vectorSlice(foreach_i);
            int n = foreach_vectorSliceDim_c + 1 - Math.abs(foreach_i - foreach_vectorSliceDim_c) - 1;
            VectorStatics$ foreach_foreachRec_this = VectorStatics$.MODULE$;
            int foreach_foreachRec_len = ((void)foreach_foreachRec_a).length;
            if (foreach_foreachRec_level == false) {
                for (foreach_foreachRec_i = 0; foreach_foreachRec_i < foreach_foreachRec_len; ++foreach_foreachRec_i) {
                    Tuple2 tuple2 = (Tuple2)foreach_foreachRec_a[foreach_foreachRec_i];
                    if (tuple2 == null) {
                        throw new MatchError((Object)null);
                    }
                    Object $anonfun$foreachEntry$1_k = tuple2._1();
                    Object $anonfun$foreachEntry$1_v2 = tuple2._2();
                    f.apply($anonfun$foreachEntry$1_k, $anonfun$foreachEntry$1_v2);
                }
                continue;
            }
            void foreach_foreachRec_l = $anonfun$foreachEntry$1_v2 - true;
            while (foreach_foreachRec_i < foreach_foreachRec_len) {
                int foreachRec_i;
                Object[] foreachRec_a = (Object[])foreach_foreachRec_a[foreach_foreachRec_i];
                int foreachRec_len = foreachRec_a.length;
                if (foreach_foreachRec_l == false) {
                    for (foreachRec_i = 0; foreachRec_i < foreachRec_len; ++foreachRec_i) {
                        Tuple2 tuple2 = (Tuple2)foreachRec_a[foreachRec_i];
                        if (tuple2 == null) {
                            throw new MatchError((Object)null);
                        }
                        Object $anonfun$foreachEntry$1_k = tuple2._1();
                        Object $anonfun$foreachEntry$1_v3 = tuple2._2();
                        f.apply($anonfun$foreachEntry$1_k, $anonfun$foreachEntry$1_v3);
                    }
                } else {
                    void foreachRec_l = foreach_foreachRec_l - true;
                    while (foreachRec_i < foreachRec_len) {
                        void foreach_f;
                        void var6_6;
                        var6_6.foreachRec((int)foreachRec_l, (T[])((Object[])foreachRec_a[foreachRec_i]), foreach_f);
                        ++foreachRec_i;
                    }
                }
                ++foreach_foreachRec_i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void foreachWithHash(Function3<K, V, Object, BoxedUnit> f) {
        Iterator<Tuple2<K, V>> iter = this.content().iterator();
        while (iter.hasNext()) {
            void var3_3;
            Tuple2<K, V> next = iter.next();
            f.apply(next._1(), var3_3._2(), this.originalHash());
        }
    }

    public final boolean equals(Object that) {
        boolean bl;
        block7: {
            block3: {
                boolean bl2;
                block6: {
                    block5: {
                        block4: {
                            HashCollisionMapNode hashCollisionMapNode;
                            if (!(that instanceof HashCollisionMapNode)) break block3;
                            if (this == (hashCollisionMapNode = (HashCollisionMapNode)hashCollisionMapNode)) break block4;
                            if (this.hash() == hashCollisionMapNode.hash() && this.content().length() == hashCollisionMapNode.content().length()) {
                                Iterator<Tuple2<K, V>> iter = this.content().iterator();
                                while (iter.hasNext()) {
                                    Tuple2<K, V> tuple2 = iter.next();
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)null);
                                    }
                                    K key = tuple2._1();
                                    V value = tuple2._2();
                                    int index = hashCollisionMapNode.indexOf(key);
                                    if (index >= 0 && BoxesRunTime.equals(tuple2, ((Tuple2)hashCollisionMapNode.content().apply(index))._2())) continue;
                                    return false;
                                }
                            }
                            break block5;
                        }
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
                bl = bl2;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V1> HashCollisionMapNode<K, V1> concat(MapNode<K, V1> that, int shift) {
        void var1_1;
        HashCollisionMapNode<K, V> hashCollisionMapNode;
        if (that instanceof HashCollisionMapNode) {
            if ((that = (HashCollisionMapNode)that) == this) {
                hashCollisionMapNode = this;
            } else {
                void var2_3;
                VectorBuilder newContent = null;
                Iterator<Tuple2<K, V>> iter = this.content().iterator();
                while (iter.hasNext()) {
                    Tuple2<K, V> nextPayload = iter.next();
                    if (that.indexOf(nextPayload._1()) >= 0) continue;
                    if (newContent == null) {
                        newContent = new VectorBuilder();
                        newContent.addAll((IterableOnce)that.content());
                    }
                    newContent.addOne(nextPayload);
                }
                hashCollisionMapNode = newContent == null ? that : new HashCollisionMapNode<K, V>(this.originalHash(), this.hash(), var2_3.result());
            }
        } else {
            if (that instanceof BitmapIndexedMapNode) {
                throw new UnsupportedOperationException("Cannot concatenate a HashCollisionMapNode with a BitmapIndexedMapNode");
            }
            throw new MatchError(var1_1);
        }
        that = hashCollisionMapNode;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final MapNode<K, V> filterImpl(Function1<Tuple2<K, V>, Object> pred, boolean flipped) {
        void var2_2;
        void var1_1;
        Object[] filterImpl_newData;
        Object object;
        block34: {
            void filterImpl_k;
            BigVector filterImpl_foreachRest_this;
            Vector<Tuple2<K, V>> vector = this.content();
            if (vector == null) {
                throw null;
            }
            Vector<Tuple2<K, V>> filterImpl_this = vector;
            int filterImpl_i2 = 0;
            int filterImpl_len = filterImpl_this.prefix1().length;
            while (filterImpl_i2 != filterImpl_len) {
                void filterImpl_foreachRest_f2;
                if (BoxesRunTime.unboxToBoolean(pred.apply((Tuple2<K, V>)filterImpl_this.prefix1()[filterImpl_i2])) == flipped) {
                    int filterImpl_foreachRest_i;
                    int filterImpl_foreachRest_c;
                    int filterImpl_bitmap = 0;
                    for (int filterImpl_j = filterImpl_i2 + 1; filterImpl_j < filterImpl_len; ++filterImpl_j) {
                        if (BoxesRunTime.unboxToBoolean(pred.apply((Tuple2<K, V>)filterImpl_this.prefix1()[filterImpl_j])) == flipped) continue;
                        filterImpl_bitmap |= 1 << filterImpl_j;
                    }
                    int filterImpl_newLen = filterImpl_i2 + Integer.bitCount(filterImpl_bitmap);
                    if (filterImpl_this instanceof BigVector) {
                        int filterImpl_k2;
                        VectorBuilder filterImpl_b = new VectorBuilder();
                        for (filterImpl_k2 = 0; filterImpl_k2 < filterImpl_i2; ++filterImpl_k2) {
                            filterImpl_b.addOne(filterImpl_this.prefix1()[filterImpl_k2]);
                        }
                        filterImpl_k2 = filterImpl_i2 + 1;
                        while (filterImpl_i2 != filterImpl_newLen) {
                            if ((1 << filterImpl_k2 & filterImpl_bitmap) != 0) {
                                filterImpl_b.addOne(filterImpl_this.prefix1()[filterImpl_k2]);
                                ++filterImpl_i2;
                            }
                            ++filterImpl_k2;
                        }
                        Function1<Object, Object> & Serializable filterImpl_i2 = arg_0 -> Vector.$anonfun$filterImpl$1(pred, flipped, filterImpl_b, arg_0);
                        filterImpl_foreachRest_this = (BigVector)filterImpl_this;
                        filterImpl_foreachRest_c = filterImpl_foreachRest_this.vectorSliceCount();
                        for (filterImpl_foreachRest_i = 1; filterImpl_foreachRest_i < filterImpl_foreachRest_c; ++filterImpl_foreachRest_i) {
                            int filterImpl_foreachRest_foreachRec_i;
                            void filterImpl_foreachRest_foreachRec_level;
                            void filterImpl_foreachRest_foreachRec_a;
                            int filterImpl_foreachRest_vectorSliceDim_c = filterImpl_foreachRest_c / 2;
                            Object[] objectArray = filterImpl_foreachRest_this.vectorSlice(filterImpl_foreachRest_i);
                            int n = filterImpl_foreachRest_vectorSliceDim_c + 1 - Math.abs(filterImpl_foreachRest_i - filterImpl_foreachRest_vectorSliceDim_c) - 1;
                            VectorStatics$ filterImpl_foreachRest_foreachRec_this = VectorStatics$.MODULE$;
                            int filterImpl_foreachRest_foreachRec_len = ((void)filterImpl_foreachRest_foreachRec_a).length;
                            if (filterImpl_foreachRest_foreachRec_level == false) {
                                for (filterImpl_foreachRest_foreachRec_i = 0; filterImpl_foreachRest_foreachRec_i < filterImpl_foreachRest_foreachRec_len; ++filterImpl_foreachRest_foreachRec_i) {
                                    void var16_34 = filterImpl_foreachRest_foreachRec_a[filterImpl_foreachRest_foreachRec_i];
                                    if (BoxesRunTime.unboxToBoolean(pred.apply((Tuple2<K, V>)var16_34)) == flipped) continue;
                                    filterImpl_b.addOne((Object)var16_34);
                                }
                                continue;
                            }
                            void filterImpl_foreachRest_foreachRec_l = filterImpl_foreachRest_foreachRec_level - true;
                            while (filterImpl_foreachRest_foreachRec_i < filterImpl_foreachRest_foreachRec_len) {
                                int foreachRec_i;
                                Object[] foreachRec_a = (Object[])filterImpl_foreachRest_foreachRec_a[filterImpl_foreachRest_foreachRec_i];
                                int foreachRec_len = foreachRec_a.length;
                                if (filterImpl_foreachRest_foreachRec_l == false) {
                                    for (foreachRec_i = 0; foreachRec_i < foreachRec_len; ++foreachRec_i) {
                                        Object object2 = foreachRec_a[foreachRec_i];
                                        if (BoxesRunTime.unboxToBoolean(pred.apply((Tuple2<K, V>)object2)) == flipped) continue;
                                        filterImpl_b.addOne(object2);
                                    }
                                } else {
                                    void foreachRec_l = filterImpl_foreachRest_foreachRec_l - true;
                                    while (foreachRec_i < foreachRec_len) {
                                        void filterImpl_foreachRest_f2;
                                        filterImpl_foreachRest_foreachRec_this.foreachRec((int)foreachRec_l, (T[])((Object[])foreachRec_a[foreachRec_i]), filterImpl_foreachRest_f2);
                                        ++foreachRec_i;
                                    }
                                }
                                ++filterImpl_foreachRest_foreachRec_i;
                            }
                        }
                        object = filterImpl_b.result();
                        break block34;
                    }
                    if (filterImpl_foreachRest_c == 0) {
                        object = Vector0$.MODULE$;
                    } else {
                        filterImpl_newData = new Object[filterImpl_foreachRest_c];
                        System.arraycopy(filterImpl_foreachRest_this.prefix1(), 0, filterImpl_newData, 0, (int)filterImpl_foreachRest_f2);
                        filterImpl_k = filterImpl_foreachRest_f2 + true;
                        while (filterImpl_foreachRest_f2 != filterImpl_foreachRest_c) {
                            if ((1 << filterImpl_k & filterImpl_foreachRest_i) != 0) {
                                filterImpl_newData[filterImpl_foreachRest_f2] = filterImpl_foreachRest_this.prefix1()[filterImpl_k];
                                ++filterImpl_foreachRest_f2;
                            }
                            ++filterImpl_k;
                        }
                        object = new Vector1(filterImpl_newData);
                    }
                    break block34;
                }
                ++filterImpl_foreachRest_f2;
            }
            if (filterImpl_foreachRest_this instanceof BigVector) {
                VectorBuilder filterImpl_b = new VectorBuilder();
                filterImpl_b.initFrom(filterImpl_foreachRest_this.prefix1());
                Function1<Object, Object> & Serializable filterImpl_foreachRest_c = arg_0 -> Vector.$anonfun$filterImpl$2((Function1)filterImpl_newData, (boolean)filterImpl_k, filterImpl_b, arg_0);
                filterImpl_foreachRest_this = filterImpl_foreachRest_this;
                int filterImpl_foreachRest_c2 = filterImpl_foreachRest_this.vectorSliceCount();
                for (int filterImpl_foreachRest_i = 1; filterImpl_foreachRest_i < filterImpl_foreachRest_c2; ++filterImpl_foreachRest_i) {
                    int filterImpl_foreachRest_foreachRec_i;
                    void filterImpl_foreachRest_foreachRec_level;
                    int filterImpl_foreachRest_vectorSliceDim_c = filterImpl_foreachRest_c2 / 2;
                    Object[] filterImpl_foreachRest_foreachRec_a = filterImpl_foreachRest_this.vectorSlice(filterImpl_foreachRest_i);
                    int filterImpl_foreachRest_foreachRec_l = filterImpl_foreachRest_vectorSliceDim_c + 1 - Math.abs(filterImpl_foreachRest_i - filterImpl_foreachRest_vectorSliceDim_c) - 1;
                    VectorStatics$ filterImpl_foreachRest_foreachRec_this = VectorStatics$.MODULE$;
                    int filterImpl_foreachRest_foreachRec_len = filterImpl_foreachRest_foreachRec_a.length;
                    if (filterImpl_foreachRest_foreachRec_level == false) {
                        for (filterImpl_foreachRest_foreachRec_i = 0; filterImpl_foreachRest_foreachRec_i < filterImpl_foreachRest_foreachRec_len; ++filterImpl_foreachRest_foreachRec_i) {
                            Object foreachRec_l = filterImpl_foreachRest_foreachRec_a[filterImpl_foreachRest_foreachRec_i];
                            if (BoxesRunTime.unboxToBoolean(filterImpl_newData.apply(foreachRec_l)) == filterImpl_k) continue;
                            filterImpl_b.addOne(foreachRec_l);
                        }
                        continue;
                    }
                    filterImpl_foreachRest_foreachRec_l = filterImpl_foreachRest_foreachRec_level - true;
                    while (filterImpl_foreachRest_foreachRec_i < filterImpl_foreachRest_foreachRec_len) {
                        int foreachRec_i;
                        Object[] foreachRec_a = (Object[])filterImpl_foreachRest_foreachRec_a[filterImpl_foreachRest_foreachRec_i];
                        int foreachRec_len = foreachRec_a.length;
                        if (filterImpl_foreachRest_foreachRec_l == 0) {
                            for (foreachRec_i = 0; foreachRec_i < foreachRec_len; ++foreachRec_i) {
                                Object foreachRec_l = foreachRec_a[foreachRec_i];
                                if (BoxesRunTime.unboxToBoolean(filterImpl_newData.apply(foreachRec_l)) == filterImpl_k) continue;
                                filterImpl_b.addOne(foreachRec_l);
                            }
                        } else {
                            int foreachRec_l = filterImpl_foreachRest_foreachRec_l - 1;
                            while (foreachRec_i < foreachRec_len) {
                                void filterImpl_foreachRest_f;
                                filterImpl_foreachRest_foreachRec_this.foreachRec(foreachRec_l, (T[])((Object[])foreachRec_a[foreachRec_i]), filterImpl_foreachRest_f);
                                ++foreachRec_i;
                            }
                        }
                        ++filterImpl_foreachRest_foreachRec_i;
                    }
                }
                object = filterImpl_b.result();
            } else {
                void var3_4;
                object = var3_4;
            }
        }
        filterImpl_newData = object;
        Tuple2 newContent = object;
        int newContentLength = ((Vector)object).length();
        if (newContentLength == 0) {
            return MapNode$.MODULE$.empty();
        }
        if (newContentLength == 1) {
            void var2_3;
            if ((newContent = (Tuple2)((Vector)((Object)newContent)).head()) == null) {
                throw new MatchError((Object)null);
            }
            Object k = newContent._1();
            Object v = newContent._2();
            int n = this.hash() & 0x1F;
            return new BitmapIndexedMapNode(1 << n, 0, new Object[]{var2_3, var1_1}, new int[]{this.originalHash()}, 1, this.hash());
        }
        if (var2_2 == this.content().length()) {
            return this;
        }
        return new HashCollisionMapNode<K, V>(this.originalHash(), this.hash(), var1_1);
    }

    @Override
    public final HashCollisionMapNode<K, V> copy() {
        return new HashCollisionMapNode<K, V>(this.originalHash(), this.hash(), this.content());
    }

    public final int hashCode() {
        throw new UnsupportedOperationException("Trie nodes do not support hashing.");
    }

    @Override
    public final int cachedJavaKeySetHashCode() {
        return this.size() * this.hash();
    }

    public static final /* synthetic */ boolean $anonfun$removed$1(Object key$1, Tuple2 keyValuePair) {
        Object object;
        return BoxesRunTime.equals(keyValuePair._1(), object);
    }

    /*
     * WARNING - void declaration
     */
    public HashCollisionMapNode(int originalHash, int hash, Vector<Tuple2<K, V>> content) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.originalHash = var1_1;
        this.hash = var2_2;
        this.content = var3_3;
        Predef$.MODULE$.require(this.content().length() >= 2);
        Statics.releaseFence();
    }
}

