/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.resolver.RepositoryResolver;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Message;

public class FileSystemResolver
extends RepositoryResolver {
    private static final Pattern TRANSACTION_PATTERN = Pattern.compile("(.*[/\\\\]\\[revision\\])([/\\\\].+)");
    private String transactional = "auto";
    private Boolean supportTransaction;
    private String baseTransactionPattern;
    private Map fullTransactionPatterns = new HashMap();

    public FileSystemResolver() {
        this.setRepository(new FileRepository());
    }

    @Override
    public String getTypeName() {
        return "file";
    }

    @Override
    protected Collection filterNames(Collection collection) {
        if (this.supportTransaction()) {
            collection = super.filterNames(collection);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.endsWith(".part")) continue;
                iterator.remove();
            }
            return collection;
        }
        return super.filterNames(collection);
    }

    public boolean supportTransaction() {
        if ("false".equals(this.transactional)) {
            return false;
        }
        this.checkSupportTransaction();
        return this.supportTransaction;
    }

    private void checkSupportTransaction() {
        if (this.supportTransaction == null) {
            Matcher matcher;
            this.supportTransaction = Boolean.FALSE;
            Object object = this.getIvyPatterns();
            List list = this.getArtifactPatterns();
            if (object.size() > 0) {
                matcher = TRANSACTION_PATTERN.matcher((CharSequence)(object = (String)object.get(0)));
                if (!matcher.matches()) {
                    this.unsupportedTransaction("ivy pattern does not use revision as a directory");
                    return;
                }
                this.baseTransactionPattern = matcher.group(1);
                this.fullTransactionPatterns.put(object, matcher.group(1) + ".part" + matcher.group(2));
            }
            if (list.size() > 0) {
                object = (String)list.get(0);
                matcher = TRANSACTION_PATTERN.matcher((CharSequence)object);
                if (!matcher.matches()) {
                    this.unsupportedTransaction("artifact pattern does not use revision as a directory");
                    return;
                }
                if (this.baseTransactionPattern != null) {
                    if (!this.baseTransactionPattern.equals(matcher.group(1))) {
                        this.unsupportedTransaction("ivy pattern and artifact pattern do not use the same directory for revision");
                        return;
                    }
                    this.fullTransactionPatterns.put(object, matcher.group(1) + ".part" + matcher.group(2));
                } else {
                    this.baseTransactionPattern = matcher.group(1);
                    this.fullTransactionPatterns.put(object, matcher.group(1) + ".part" + matcher.group(2));
                }
            }
            this.supportTransaction = Boolean.TRUE;
        }
    }

    private void unsupportedTransaction(String string) {
        string = this.getName() + " do not support transaction. " + string;
        if ("true".equals(this.transactional)) {
            throw new IllegalStateException(string + ". Set transactional attribute to 'auto' or 'false' or fix the problem.");
        }
        Message.verbose(string);
        this.supportTransaction = Boolean.FALSE;
    }

    @Override
    public void addIvyPattern(String object) {
        object = Checks.checkAbsolute((String)object, "ivy pattern");
        super.addIvyPattern(((File)object).getAbsolutePath());
    }

    @Override
    public void addArtifactPattern(String object) {
        object = Checks.checkAbsolute((String)object, "artifact pattern");
        super.addArtifactPattern(((File)object).getAbsolutePath());
    }
}

