/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.io.Serializable;
import java.math.BigInteger;
import scala.math.BigDecimal;
import scala.math.BigInt$;
import scala.math.Ordered;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.math.ScalaNumericConversions;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class BigInt
extends ScalaNumber
implements Ordered<BigInt>,
ScalaNumericConversions {
    private final BigInteger bigInteger;

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean $less$eq(Object that) {
        void var1_1;
        return Ordered.$less$eq$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean $greater$eq(Object that) {
        void var1_1;
        return Ordered.$greater$eq$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Object that) {
        void var1_1;
        return Ordered.compareTo$(this, var1_1);
    }

    @Override
    public final byte toByte() {
        return ScalaNumericAnyConversions.toByte$(this);
    }

    @Override
    public final short toShort() {
        return ScalaNumericAnyConversions.toShort$(this);
    }

    @Override
    public final int toInt() {
        return ScalaNumericAnyConversions.toInt$(this);
    }

    @Override
    public final long toLong() {
        return ScalaNumericAnyConversions.toLong$(this);
    }

    @Override
    public final float toFloat() {
        return ScalaNumericAnyConversions.toFloat$(this);
    }

    @Override
    public final double toDouble() {
        return ScalaNumericAnyConversions.toDouble$(this);
    }

    @Override
    public final int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean unifiedPrimitiveEquals(Object x) {
        void var1_1;
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, var1_1);
    }

    public final BigInteger bigInteger() {
        return this.bigInteger;
    }

    public final int hashCode() {
        if (this.isValidLong()) {
            return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
        }
        return Statics.anyHash(this.bigInteger());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object that2222) {
        Object that2222;
        boolean bl;
        boolean that2222;
        boolean bl2;
        if (that2222 instanceof BigInt) {
            that2222 = (BigInt)that2222;
            bl2 = this.equals((BigInt)that2222);
            return bl2;
        }
        if (that2222 instanceof BigDecimal) {
            bl2 = ((BigDecimal)that2222).equals(this);
            return bl2;
        }
        if (that2222 instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(that2222);
            that2222 = this.isValidDouble() && this.doubleValue() == d;
            return bl;
        } else if (that2222 instanceof Float) {
            float that2222 = BoxesRunTime.unboxToFloat(that2222);
            that2222 = this.isValidFloat() && this.floatValue() == that2222;
            return bl;
        } else {
            void var1_1;
            if (!this.isValidLong()) return false;
            if (!ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, var1_1)) return false;
            return true;
        }
    }

    @Override
    public final boolean isValidByte() {
        BigInt$ bigInt$ = BigInt$.MODULE$;
        Serializable $greater$eq_that = bigInt$.apply(-128);
        if (Ordered.$greater$eq$(this, $greater$eq_that)) {
            $greater$eq_that = BigInt$.MODULE$;
            BigInt $less$eq_that = ((BigInt$)$greater$eq_that).apply(127);
            if (Ordered.$less$eq$(this, bigInt$)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isValidShort() {
        BigInt$ bigInt$ = BigInt$.MODULE$;
        Serializable $greater$eq_that = bigInt$.apply(Short.MIN_VALUE);
        if (Ordered.$greater$eq$(this, $greater$eq_that)) {
            $greater$eq_that = BigInt$.MODULE$;
            BigInt $less$eq_that = ((BigInt$)$greater$eq_that).apply(Short.MAX_VALUE);
            if (Ordered.$less$eq$(this, bigInt$)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isValidChar() {
        BigInt$ bigInt$ = BigInt$.MODULE$;
        Serializable $greater$eq_that = bigInt$.apply(0);
        if (Ordered.$greater$eq$(this, $greater$eq_that)) {
            $greater$eq_that = BigInt$.MODULE$;
            BigInt $less$eq_that = ((BigInt$)$greater$eq_that).apply(65535);
            if (Ordered.$less$eq$(this, bigInt$)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isValidInt() {
        BigInt$ bigInt$ = BigInt$.MODULE$;
        Serializable $greater$eq_that = bigInt$.apply(Integer.MIN_VALUE);
        if (Ordered.$greater$eq$(this, $greater$eq_that)) {
            $greater$eq_that = BigInt$.MODULE$;
            BigInt $less$eq_that = ((BigInt$)$greater$eq_that).apply(Integer.MAX_VALUE);
            if (Ordered.$less$eq$(this, bigInt$)) {
                return true;
            }
        }
        return false;
    }

    public final boolean isValidLong() {
        BigInt$ bigInt$ = BigInt$.MODULE$;
        Serializable $greater$eq_that = bigInt$.apply(Long.MIN_VALUE);
        if (Ordered.$greater$eq$(this, $greater$eq_that)) {
            $greater$eq_that = BigInt$.MODULE$;
            BigInt $less$eq_that = ((BigInt$)$greater$eq_that).apply(Long.MAX_VALUE);
            if (Ordered.$less$eq$(this, bigInt$)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidFloat() {
        block5: {
            block4: {
                void var2_2;
                void var1_1;
                int bitLen = this.bitLength();
                if (bitLen <= 24) break block4;
                int lowest = this.lowestSetBit();
                if (!(bitLen <= 128 && lowest >= var1_1 - 24 && var2_2 < 128)) break block5;
            }
            if (!this.bitLengthOverflow()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidDouble() {
        block5: {
            block4: {
                void var2_2;
                void var1_1;
                int bitLen = this.bitLength();
                if (bitLen <= 53) break block4;
                int lowest = this.lowestSetBit();
                if (!(bitLen <= 1024 && lowest >= var1_1 - 53 && var2_2 < 1024)) break block5;
            }
            if (!this.bitLengthOverflow()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean bitLengthOverflow() {
        void var1_1;
        BigInteger shifted = this.bigInteger().shiftRight(Integer.MAX_VALUE);
        return shifted.signum() != 0 && !var1_1.equals(BigInt$.MODULE$.scala$math$BigInt$$minusOne());
    }

    @Override
    public final boolean isWhole() {
        return true;
    }

    @Override
    public final BigInteger underlying() {
        return this.bigInteger();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(BigInt that) {
        void var1_1;
        return this.compare((BigInt)var1_1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compare(BigInt that) {
        void var1_1;
        return this.bigInteger().compareTo(var1_1.bigInteger());
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $plus(BigInt that) {
        void var1_1;
        return new BigInt(this.bigInteger().add(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $minus(BigInt that) {
        void var1_1;
        return new BigInt(this.bigInteger().subtract(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $times(BigInt that) {
        void var1_1;
        return new BigInt(this.bigInteger().multiply(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $div(BigInt that) {
        void var1_1;
        return new BigInt(this.bigInteger().divide(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $percent(BigInt that) {
        void var1_1;
        return new BigInt(this.bigInteger().remainder(var1_1.bigInteger()));
    }

    public final BigInt unary_$minus() {
        return new BigInt(this.bigInteger().negate());
    }

    public final int lowestSetBit() {
        return this.bigInteger().getLowestSetBit();
    }

    public final int bitLength() {
        return this.bigInteger().bitLength();
    }

    @Override
    public final byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public final short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public final int intValue() {
        return this.bigInteger().intValue();
    }

    @Override
    public final long longValue() {
        return this.bigInteger().longValue();
    }

    @Override
    public final float floatValue() {
        return this.bigInteger().floatValue();
    }

    @Override
    public final double doubleValue() {
        return this.bigInteger().doubleValue();
    }

    public final String toString() {
        return this.bigInteger().toString();
    }

    /*
     * WARNING - void declaration
     */
    public BigInt(BigInteger bigInteger) {
        void var1_1;
        this.bigInteger = var1_1;
    }
}

