/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.select;

import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.internal.Normalizer;
import coursier.util.shaded.org.jsoup.nodes.Comment;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.DocumentType;
import coursier.util.shaded.org.jsoup.nodes.Element;
import coursier.util.shaded.org.jsoup.nodes.Node;
import coursier.util.shaded.org.jsoup.nodes.PseudoTextElement;
import coursier.util.shaded.org.jsoup.nodes.TextNode;
import coursier.util.shaded.org.jsoup.nodes.XmlDeclaration;
import coursier.util.shaded.org.jsoup.select.Elements;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Evaluator {
    protected Evaluator() {
    }

    public abstract boolean matches(Element var1, Element var2);

    public static final class MatchText
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            if (element instanceof PseudoTextElement) {
                return true;
            }
            Object object = element.textNodes();
            object = object.iterator();
            while (object.hasNext()) {
                void var3_3;
                TextNode textNode = (TextNode)object.next();
                PseudoTextElement pel = new PseudoTextElement(coursier.util.shaded.org.jsoup.parser.Tag.valueOf(element.tagName()), element.baseUri(), element.attributes());
                textNode.replaceWith(pel);
                pel.appendChild((Node)var3_3);
            }
            return false;
        }

        public final String toString() {
            return ":matchText";
        }
    }

    public static final class MatchesOwn
    extends Evaluator {
        private Pattern pattern;

        /*
         * WARNING - void declaration
         */
        public MatchesOwn(Pattern pattern) {
            void var1_1;
            this.pattern = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            Matcher matcher = this.pattern.matcher(var2_2.ownText());
            return matcher.find();
        }

        public final String toString() {
            return String.format(":matchesOwn(%s)", this.pattern);
        }
    }

    public static final class Matches
    extends Evaluator {
        private Pattern pattern;

        /*
         * WARNING - void declaration
         */
        public Matches(Pattern pattern) {
            void var1_1;
            this.pattern = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            Matcher matcher = this.pattern.matcher(var2_2.text());
            return matcher.find();
        }

        public final String toString() {
            return String.format(":matches(%s)", this.pattern);
        }
    }

    public static final class ContainsOwnText
    extends Evaluator {
        private String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsOwnText(String searchText) {
            void var1_1;
            this.searchText = Normalizer.lowerCase((String)var1_1);
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return Normalizer.lowerCase(element.ownText()).contains(this.searchText);
        }

        public final String toString() {
            return String.format(":containsOwn(%s)", this.searchText);
        }
    }

    public static final class ContainsData
    extends Evaluator {
        private String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsData(String searchText) {
            void var1_1;
            this.searchText = Normalizer.lowerCase((String)var1_1);
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return Normalizer.lowerCase(element.data()).contains(this.searchText);
        }

        public final String toString() {
            return String.format(":containsData(%s)", this.searchText);
        }
    }

    public static final class ContainsText
    extends Evaluator {
        private String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsText(String searchText) {
            void var1_1;
            this.searchText = Normalizer.lowerCase((String)var1_1);
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return Normalizer.lowerCase(element.text()).contains(this.searchText);
        }

        public final String toString() {
            return String.format(":contains(%s)", this.searchText);
        }
    }

    public static abstract class IndexEvaluator
    extends Evaluator {
        int index;

        /*
         * WARNING - void declaration
         */
        public IndexEvaluator(int index) {
            void var1_1;
            this.index = var1_1;
        }
    }

    public static final class IsEmpty
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            Object object = element.childNodes();
            object = object.iterator();
            while (object.hasNext()) {
                void var2_2;
                Node n = (Node)object.next();
                if (n instanceof Comment || n instanceof XmlDeclaration || var2_2 instanceof DocumentType) continue;
                return false;
            }
            return true;
        }

        public final String toString() {
            return ":empty";
        }
    }

    public static final class IsOnlyOfType
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var3_3;
            Object object;
            Element p = element.parent();
            if (p == null || p instanceof Document) {
                return false;
            }
            int pos = 0;
            object = ((Element)object).children();
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                Element element2 = (Element)object.next();
                if (!element2.tag().equals(element.tag())) continue;
                ++pos;
            }
            return var3_3 == true;
        }

        public final String toString() {
            return ":only-of-type";
        }
    }

    public static final class IsOnlyChild
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            void var1_1;
            Element p = element.parent();
            return p != null && !(var1_1 instanceof Document) && var2_2.siblingElements().isEmpty();
        }

        public final String toString() {
            return ":only-child";
        }
    }

    public static final class IsRoot
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var1_1;
            void var2_2;
            void r;
            Object object = r = root instanceof Document ? root.child(0) : r;
            return var2_2 == var1_1;
        }

        public final String toString() {
            return ":root";
        }
    }

    public static final class IsFirstChild
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            void var1_1;
            Element p = element.parent();
            return p != null && !(var1_1 instanceof Document) && var2_2.elementSiblingIndex() == 0;
        }

        public final String toString() {
            return ":first-child";
        }
    }

    public static class IsNthLastOfType
    extends CssNthEvaluator {
        /*
         * WARNING - void declaration
         */
        public IsNthLastOfType(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected int calculatePosition(Element root, Element element) {
            void var1_2;
            int pos = 0;
            Elements family = element.parent().children();
            for (int i = element.elementSiblingIndex(); i < family.size(); ++i) {
                if (!((Element)family.get(i)).tag().equals(element.tag())) continue;
                ++pos;
            }
            return (int)var1_2;
        }

        @Override
        protected String getPseudoClass() {
            return "nth-last-of-type";
        }
    }

    public static class IsNthOfType
    extends CssNthEvaluator {
        /*
         * WARNING - void declaration
         */
        public IsNthOfType(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected int calculatePosition(Element root, Element element) {
            void var1_2;
            int pos = 0;
            Object object = element.parent().children();
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                Element el = (Element)object.next();
                if (el.tag().equals(element.tag())) {
                    ++pos;
                }
                if (el != element) continue;
            }
            return (int)var1_2;
        }

        @Override
        protected String getPseudoClass() {
            return "nth-of-type";
        }
    }

    public static final class IsNthLastChild
    extends CssNthEvaluator {
        /*
         * WARNING - void declaration
         */
        public IsNthLastChild(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int calculatePosition(Element root, Element element) {
            void var2_2;
            return element.parent().children().size() - var2_2.elementSiblingIndex();
        }

        @Override
        protected final String getPseudoClass() {
            return "nth-last-child";
        }
    }

    public static final class IsNthChild
    extends CssNthEvaluator {
        /*
         * WARNING - void declaration
         */
        public IsNthChild(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        protected final int calculatePosition(Element root, Element element) {
            return element.elementSiblingIndex() + 1;
        }

        @Override
        protected final String getPseudoClass() {
            return "nth-child";
        }
    }

    public static abstract class CssNthEvaluator
    extends Evaluator {
        protected final int a;
        protected final int b;

        /*
         * WARNING - void declaration
         */
        public CssNthEvaluator(int a, int b) {
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(Element root, Element element) {
            void var1_2;
            void var2_3;
            void var3_4;
            Element p = element.parent();
            if (p == null || var3_4 instanceof Document) {
                return false;
            }
            int pos = this.calculatePosition(root, (Element)var2_3);
            if (this.a == 0) {
                return pos == this.b;
            }
            return (pos - this.b) * this.a >= 0 && (var1_2 - this.b) % this.a == false;
        }

        public String toString() {
            if (this.a == 0) {
                return String.format(":%s(%d)", this.getPseudoClass(), this.b);
            }
            if (this.b == 0) {
                return String.format(":%s(%dn)", this.getPseudoClass(), this.a);
            }
            return String.format(":%s(%dn%+d)", this.getPseudoClass(), this.a, this.b);
        }

        protected abstract String getPseudoClass();

        protected abstract int calculatePosition(Element var1, Element var2);
    }

    public static final class IsLastOfType
    extends IsNthLastOfType {
        public IsLastOfType() {
            super(0, 1);
        }

        @Override
        public final String toString() {
            return ":last-of-type";
        }
    }

    public static final class IsFirstOfType
    extends IsNthOfType {
        public IsFirstOfType() {
            super(0, 1);
        }

        @Override
        public final String toString() {
            return ":first-of-type";
        }
    }

    public static final class IsLastChild
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var1_1;
            void var2_2;
            Element p = element.parent();
            return p != null && !(p instanceof Document) && var2_2.elementSiblingIndex() == var1_1.children().size() - 1;
        }

        public final String toString() {
            return ":last-child";
        }
    }

    public static final class IndexEquals
    extends IndexEvaluator {
        /*
         * WARNING - void declaration
         */
        public IndexEquals(int index) {
            super((int)var1_1);
            void var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.elementSiblingIndex() == this.index;
        }

        public final String toString() {
            return String.format(":eq(%d)", this.index);
        }
    }

    public static final class IndexGreaterThan
    extends IndexEvaluator {
        /*
         * WARNING - void declaration
         */
        public IndexGreaterThan(int index) {
            super((int)var1_1);
            void var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.elementSiblingIndex() > this.index;
        }

        public final String toString() {
            return String.format(":gt(%d)", this.index);
        }
    }

    public static final class IndexLessThan
    extends IndexEvaluator {
        /*
         * WARNING - void declaration
         */
        public IndexLessThan(int index) {
            super((int)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return root != element && var2_2.elementSiblingIndex() < this.index;
        }

        public final String toString() {
            return String.format(":lt(%d)", this.index);
        }
    }

    public static final class AllElements
    extends Evaluator {
        @Override
        public final boolean matches(Element root, Element element) {
            return true;
        }

        public final String toString() {
            return "*";
        }
    }

    public static abstract class AttributeKeyPair
    extends Evaluator {
        String key;
        String value;

        /*
         * WARNING - void declaration
         */
        public AttributeKeyPair(String key, String value) {
            this((String)var1_1, (String)var2_2, true);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public AttributeKeyPair(String key, String value, boolean trimValue) {
            void var1_2;
            void var2_3;
            void var3_4;
            Validate.notEmpty(key);
            Validate.notEmpty(value);
            this.key = Normalizer.normalize(key);
            boolean isStringLiteral = value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"");
            if (isStringLiteral) {
                value = value.substring(1, value.length() - 1);
            }
            this.value = var3_4 != false ? Normalizer.normalize(value) : Normalizer.normalize((String)var2_3, (boolean)var1_2);
        }
    }

    public static final class AttributeWithValueMatching
    extends Evaluator {
        String key;
        Pattern pattern;

        /*
         * WARNING - void declaration
         */
        public AttributeWithValueMatching(String key, Pattern pattern) {
            void var2_2;
            void var1_1;
            this.key = Normalizer.normalize((String)var1_1);
            this.pattern = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return element.hasAttr(this.key) && this.pattern.matcher(var2_2.attr(this.key)).find();
        }

        public final String toString() {
            return String.format("[%s~=%s]", this.key, this.pattern.toString());
        }
    }

    public static final class AttributeWithValueContaining
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueContaining(String key, String value) {
            super((String)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return element.hasAttr(this.key) && Normalizer.lowerCase(var2_2.attr(this.key)).contains(this.value);
        }

        public final String toString() {
            return String.format("[%s*=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueEnding
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueEnding(String key, String value) {
            super((String)var1_1, (String)var2_2, false);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return element.hasAttr(this.key) && Normalizer.lowerCase(var2_2.attr(this.key)).endsWith(this.value);
        }

        public final String toString() {
            return String.format("[%s$=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueStarting
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueStarting(String key, String value) {
            super((String)var1_1, (String)var2_2, false);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return element.hasAttr(this.key) && Normalizer.lowerCase(var2_2.attr(this.key)).startsWith(this.value);
        }

        public final String toString() {
            return String.format("[%s^=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueNot
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueNot(String key, String value) {
            super((String)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return !this.value.equalsIgnoreCase(var2_2.attr(this.key));
        }

        public final String toString() {
            return String.format("[%s!=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValue
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValue(String key, String value) {
            super((String)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return element.hasAttr(this.key) && this.value.equalsIgnoreCase(var2_2.attr(this.key).trim());
        }

        public final String toString() {
            return String.format("[%s=%s]", this.key, this.value);
        }
    }

    public static final class AttributeStarting
    extends Evaluator {
        private String keyPrefix;

        /*
         * WARNING - void declaration
         */
        public AttributeStarting(String keyPrefix) {
            void var1_1;
            Validate.notEmpty(keyPrefix);
            this.keyPrefix = Normalizer.lowerCase((String)var1_1);
        }

        @Override
        public final boolean matches(Element root, Element element) {
            Object object = element.attributes().asList();
            object = object.iterator();
            while (object.hasNext()) {
                coursier.util.shaded.org.jsoup.nodes.Attribute attribute = (coursier.util.shaded.org.jsoup.nodes.Attribute)object.next();
                if (!Normalizer.lowerCase(attribute.getKey()).startsWith(this.keyPrefix)) continue;
                return true;
            }
            return false;
        }

        public final String toString() {
            return String.format("[^%s]", this.keyPrefix);
        }
    }

    public static final class Attribute
    extends Evaluator {
        private String key;

        /*
         * WARNING - void declaration
         */
        public Attribute(String key) {
            void var1_1;
            this.key = var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.hasAttr(this.key);
        }

        public final String toString() {
            return String.format("[%s]", this.key);
        }
    }

    public static final class Class
    extends Evaluator {
        private String className;

        /*
         * WARNING - void declaration
         */
        public Class(String className) {
            void var1_1;
            this.className = var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.hasClass(this.className);
        }

        public final String toString() {
            return String.format(".%s", this.className);
        }
    }

    public static final class Id
    extends Evaluator {
        private String id;

        /*
         * WARNING - void declaration
         */
        public Id(String id) {
            void var1_1;
            this.id = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return this.id.equals(var2_2.id());
        }

        public final String toString() {
            return String.format("#%s", this.id);
        }
    }

    public static final class TagEndsWith
    extends Evaluator {
        private String tagName;

        /*
         * WARNING - void declaration
         */
        public TagEndsWith(String tagName) {
            void var1_1;
            this.tagName = var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.normalName().endsWith(this.tagName);
        }

        public final String toString() {
            return String.format("%s", this.tagName);
        }
    }

    public static final class Tag
    extends Evaluator {
        private String tagName;

        /*
         * WARNING - void declaration
         */
        public Tag(String tagName) {
            void var1_1;
            this.tagName = var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.normalName().equals(this.tagName);
        }

        public final String toString() {
            return String.format("%s", this.tagName);
        }
    }
}

