/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.parser;

import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.nodes.Attributes;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.Element;
import coursier.util.shaded.org.jsoup.parser.CharacterReader;
import coursier.util.shaded.org.jsoup.parser.ParseError;
import coursier.util.shaded.org.jsoup.parser.ParseErrorList;
import coursier.util.shaded.org.jsoup.parser.ParseSettings;
import coursier.util.shaded.org.jsoup.parser.Parser;
import coursier.util.shaded.org.jsoup.parser.Token;
import coursier.util.shaded.org.jsoup.parser.Tokeniser;
import java.io.Reader;
import java.util.ArrayList;

abstract class TreeBuilder {
    protected Parser parser;
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected ArrayList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseSettings settings;
    private Token.StartTag start = new Token.StartTag();
    private Token.EndTag end = new Token.EndTag();

    TreeBuilder() {
    }

    abstract ParseSettings defaultSettings();

    /*
     * WARNING - void declaration
     */
    protected void initialiseParse(Reader input, String baseUri, Parser parser) {
        void var2_2;
        void var3_3;
        void var1_1;
        Validate.notNull(input, "String input must not be null");
        Validate.notNull(baseUri, "BaseURI must not be null");
        this.doc = new Document(baseUri);
        this.doc.parser(parser);
        this.parser = parser;
        this.settings = parser.settings();
        this.reader = new CharacterReader((Reader)var1_1);
        this.currentToken = null;
        this.tokeniser = new Tokeniser(this.reader, var3_3.getErrors());
        this.stack = new ArrayList(32);
        this.baseUri = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    Document parse(Reader input, String baseUri, Parser parser) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.initialiseParse((Reader)var1_1, (String)var2_2, (Parser)var3_3);
        this.runParser();
        this.reader.close();
        this.reader = null;
        this.tokeniser = null;
        this.stack = null;
        return this.doc;
    }

    /*
     * WARNING - void declaration
     */
    protected void runParser() {
        void var3_3;
        Tokeniser tokeniser = this.tokeniser;
        Token.TokenType eof = Token.TokenType.EOF;
        do {
            Token token = tokeniser.read();
            this.process(token);
            token.reset();
        } while (var3_3.type != eof);
    }

    protected abstract boolean process(Token var1);

    /*
     * WARNING - void declaration
     */
    protected boolean processStartTag(String name) {
        void var1_1;
        void var2_2;
        Token.StartTag start = this.start;
        if (this.currentToken == start) {
            return this.process(new Token.StartTag().name(name));
        }
        return this.process(var2_2.reset().name((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public boolean processStartTag(String name, Attributes attrs) {
        void var3_3;
        void var2_2;
        void var1_1;
        Token.StartTag start = this.start;
        if (this.currentToken == start) {
            return this.process(new Token.StartTag().nameAttr(name, attrs));
        }
        start.reset();
        start.nameAttr((String)var1_1, (Attributes)var2_2);
        return this.process((Token)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean processEndTag(String name) {
        void var1_1;
        if (this.currentToken == this.end) {
            return this.process(new Token.EndTag().name(name));
        }
        TreeBuilder treeBuilder = this;
        return treeBuilder.process(treeBuilder.end.reset().name((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected Element currentElement() {
        int size = this.stack.size();
        if (size > 0) {
            void var1_1;
            return this.stack.get((int)(var1_1 - true));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void error(String msg) {
        ParseErrorList errors = this.parser.getErrors();
        if (errors.canAddError()) {
            void var1_1;
            void var2_2;
            var2_2.add(new ParseError(this.reader.pos(), (String)var1_1));
        }
    }
}

