/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.parser;

import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.nodes.Entities;
import coursier.util.shaded.org.jsoup.parser.CharacterReader;
import coursier.util.shaded.org.jsoup.parser.ParseError;
import coursier.util.shaded.org.jsoup.parser.ParseErrorList;
import coursier.util.shaded.org.jsoup.parser.Token;
import coursier.util.shaded.org.jsoup.parser.TokeniserState;
import java.util.Arrays;

final class Tokeniser {
    private static final char[] notCharRefCharsSorted = new char[]{'\t', '\n', '\r', '\f', ' ', '<', '&'};
    static final int[] win1252Extensions = new int[]{8364, 129, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 141, 381, 143, 144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 157, 382, 376};
    private final CharacterReader reader;
    private final ParseErrorList errors;
    private TokeniserState state = TokeniserState.Data;
    private Token emitPending;
    private boolean isEmitPending = false;
    private String charsString = null;
    private StringBuilder charsBuilder = new StringBuilder(1024);
    StringBuilder dataBuffer = new StringBuilder(1024);
    Token.Tag tagPending;
    Token.StartTag startPending = new Token.StartTag();
    Token.EndTag endPending = new Token.EndTag();
    Token.Character charPending = new Token.Character();
    Token.Doctype doctypePending = new Token.Doctype();
    Token.Comment commentPending = new Token.Comment();
    private String lastStartTag;
    private final int[] codepointHolder = new int[1];
    private final int[] multipointHolder = new int[2];

    /*
     * WARNING - void declaration
     */
    Tokeniser(CharacterReader reader, ParseErrorList errors) {
        void var2_2;
        void var1_1;
        this.reader = var1_1;
        this.errors = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    final Token read() {
        while (!this.isEmitPending) {
            Tokeniser tokeniser = this;
            this.state.read(tokeniser, tokeniser.reader);
        }
        StringBuilder cb = this.charsBuilder;
        if (cb.length() != 0) {
            void var1_1;
            String str = cb.toString();
            cb.delete(0, var1_1.length());
            this.charsString = null;
            return this.charPending.data(str);
        }
        if (this.charsString != null) {
            void var2_3;
            Token.Character token = this.charPending.data(this.charsString);
            this.charsString = null;
            return var2_3;
        }
        this.isEmitPending = false;
        return this.emitPending;
    }

    final void emit(Token token) {
        Token.EndTag endTag;
        Validate.isFalse(this.isEmitPending);
        this.emitPending = token;
        this.isEmitPending = true;
        if (token.type == Token.TokenType.StartTag) {
            Token.StartTag startTag = (Token.StartTag)token;
            this.lastStartTag = ((Token.StartTag)((Object)endTag)).tagName;
            return;
        }
        if (endTag.type == Token.TokenType.EndTag) {
            endTag = endTag;
            if (endTag.attributes != null) {
                this.error("Attributes incorrectly present on end tag");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    final void emit(String str) {
        void var1_1;
        if (this.charsString == null) {
            this.charsString = str;
            return;
        }
        if (this.charsBuilder.length() == 0) {
            this.charsBuilder.append(this.charsString);
        }
        this.charsBuilder.append((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void emit(int[] codepoints) {
        void var1_1;
        this.emit(new String(codepoints, 0, ((void)var1_1).length));
    }

    /*
     * WARNING - void declaration
     */
    final void emit(char c) {
        void var1_1;
        this.emit(String.valueOf((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    final void transition(TokeniserState state) {
        void var1_1;
        this.state = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void advanceTransition(TokeniserState state) {
        void var1_1;
        this.reader.advance();
        this.state = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final int[] consumeCharacterReference(Character additionalAllowedCharacter, boolean inAttribute) {
        void var3_4;
        void var2_2;
        int numChars;
        int base;
        if (this.reader.isEmpty()) {
            return null;
        }
        if (additionalAllowedCharacter != null && additionalAllowedCharacter.charValue() == this.reader.current()) {
            return null;
        }
        if (this.reader.matchesAnySorted(notCharRefCharsSorted)) {
            return null;
        }
        int[] codeRef = this.codepointHolder;
        this.reader.mark();
        if (this.reader.matchConsume("#")) {
            boolean isHexMode = this.reader.matchConsumeIgnoreCase("X");
            String numRef = isHexMode ? this.reader.consumeHexSequence() : this.reader.consumeDigitSequence();
            if (numRef.length() == 0) {
                this.characterReferenceError("numeric reference with no numerals");
                this.reader.rewindToMark();
                return null;
            }
            this.reader.unmark();
            if (!this.reader.matchConsume(";")) {
                this.characterReferenceError("missing semicolon");
            }
            int charval = -1;
            try {
                base = isHexMode ? 16 : 10;
                charval = Integer.valueOf(numRef, base);
            }
            catch (NumberFormatException numberFormatException) {}
            if (charval == -1 || charval >= 55296 && charval <= 57343 || charval > 0x10FFFF) {
                this.characterReferenceError("character outside of valid range");
                codeRef[0] = 65533;
                return codeRef;
            }
            if (charval >= 128 && charval < 128 + win1252Extensions.length) {
                this.characterReferenceError("character is not a valid unicode code point");
                charval = win1252Extensions[charval - 128];
            }
            codeRef[0] = charval;
            return codeRef;
        }
        String nameRef = this.reader.consumeLetterThenDigitSequence();
        boolean looksLegit = this.reader.matches(';');
        boolean bl = Entities.isBaseNamedEntity(nameRef) || Entities.isNamedEntity(nameRef) && looksLegit;
        if (!bl) {
            this.reader.rewindToMark();
            if (looksLegit) {
                this.characterReferenceError("invalid named reference");
            }
            return null;
        }
        if (base != 0 && (this.reader.matchesLetter() || this.reader.matchesDigit() || this.reader.matchesAny('=', '-', '_'))) {
            this.reader.rewindToMark();
            return null;
        }
        this.reader.unmark();
        if (!this.reader.matchConsume(";")) {
            this.characterReferenceError("missing semicolon");
        }
        if ((numChars = Entities.codepointsForName(nameRef, this.multipointHolder)) == 1) {
            void var1_1;
            codeRef[0] = this.multipointHolder[0];
            return var1_1;
        }
        if (var2_2 == 2) {
            return this.multipointHolder;
        }
        Validate.fail("Unexpected characters returned for " + (String)var3_4);
        return this.multipointHolder;
    }

    /*
     * WARNING - void declaration
     */
    final Token.Tag createTagPending(boolean start) {
        void var1_1;
        this.tagPending = var1_1 != false ? this.startPending.reset() : this.endPending.reset();
        return this.tagPending;
    }

    final void emitTagPending() {
        this.tagPending.finaliseTag();
        Tokeniser tokeniser = this;
        tokeniser.emit(tokeniser.tagPending);
    }

    final void createCommentPending() {
        this.commentPending.reset();
    }

    final void emitCommentPending() {
        Tokeniser tokeniser = this;
        tokeniser.emit(tokeniser.commentPending);
    }

    final void createBogusCommentPending() {
        this.commentPending.reset();
        this.commentPending.bogus = true;
    }

    final void createDoctypePending() {
        this.doctypePending.reset();
    }

    final void emitDoctypePending() {
        Tokeniser tokeniser = this;
        tokeniser.emit(tokeniser.doctypePending);
    }

    final void createTempBuffer() {
        Token.reset(this.dataBuffer);
    }

    final boolean isAppropriateEndTagToken() {
        return this.lastStartTag != null && this.tagPending.name().equalsIgnoreCase(this.lastStartTag);
    }

    final String appropriateEndTagName() {
        return this.lastStartTag;
    }

    /*
     * WARNING - void declaration
     */
    final void error(TokeniserState state) {
        if (this.errors.canAddError()) {
            void var1_1;
            this.errors.add(new ParseError(this.reader.pos(), "Unexpected character '%s' in input state [%s]", Character.valueOf(this.reader.current()), var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    final void eofError(TokeniserState state) {
        if (this.errors.canAddError()) {
            void var1_1;
            this.errors.add(new ParseError(this.reader.pos(), "Unexpectedly reached end of file (EOF) in input state [%s]", var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void characterReferenceError(String message) {
        if (this.errors.canAddError()) {
            void var1_1;
            this.errors.add(new ParseError(this.reader.pos(), "Invalid character reference: %s", var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    final void error(String errorMsg) {
        if (this.errors.canAddError()) {
            void var1_1;
            this.errors.add(new ParseError(this.reader.pos(), (String)var1_1));
        }
    }

    static {
        Arrays.sort(notCharRefCharsSorted);
    }
}

