/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.parser;

import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.internal.Normalizer;
import coursier.util.shaded.org.jsoup.parser.ParseSettings;
import java.util.HashMap;
import java.util.Map;

public class Tag
implements Cloneable {
    private static final Map<String, Tag> tags;
    private String tagName;
    private String normalName;
    private boolean isBlock = true;
    private boolean formatAsBlock = true;
    private boolean empty = false;
    private boolean selfClosing = false;
    private boolean preserveWhitespace = false;
    private boolean formList = false;
    private boolean formSubmit = false;
    private static final String[] blockTags;
    private static final String[] inlineTags;
    private static final String[] emptyTags;
    private static final String[] formatAsInlineTags;
    private static final String[] preserveWhitespaceTags;
    private static final String[] formListedTags;
    private static final String[] formSubmitTags;

    /*
     * WARNING - void declaration
     */
    private Tag(String tagName) {
        void var1_1;
        this.tagName = tagName;
        this.normalName = Normalizer.lowerCase((String)var1_1);
    }

    public String getName() {
        return this.tagName;
    }

    public String normalName() {
        return this.normalName;
    }

    /*
     * WARNING - void declaration
     */
    public static Tag valueOf(String tagName, ParseSettings settings) {
        void var2_2;
        Validate.notNull(tagName);
        Tag tag = tags.get(tagName);
        if (tag == null) {
            void var3_3;
            void var1_1;
            tagName = settings.normalizeTag(tagName);
            Validate.notEmpty(tagName);
            String normalName = Normalizer.lowerCase(tagName);
            tag = tags.get(normalName);
            if (tag == null) {
                tag = new Tag(tagName);
                new Tag(tagName).isBlock = false;
            } else if (var1_1.preserveTagCase() && !tagName.equals(var3_3)) {
                String string;
                tag = tag.clone();
                v0.tagName = string;
            }
        }
        return var2_2;
    }

    public static Tag valueOf(String tagName) {
        return Tag.valueOf(tagName, ParseSettings.preserveCase);
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public boolean formatAsBlock() {
        return this.formatAsBlock;
    }

    public boolean isInline() {
        return !this.isBlock;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isSelfClosing() {
        return this.empty || this.selfClosing;
    }

    public boolean isKnownTag() {
        return tags.containsKey(this.tagName);
    }

    public boolean preserveWhitespace() {
        return this.preserveWhitespace;
    }

    public boolean isFormListed() {
        return this.formList;
    }

    Tag setSelfClosing() {
        this.selfClosing = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)o;
        if (!this.tagName.equals(tag.tagName)) {
            return false;
        }
        if (this.empty != tag.empty) {
            return false;
        }
        if (this.formatAsBlock != tag.formatAsBlock) {
            return false;
        }
        if (this.isBlock != tag.isBlock) {
            return false;
        }
        if (this.preserveWhitespace != tag.preserveWhitespace) {
            return false;
        }
        if (this.selfClosing != tag.selfClosing) {
            return false;
        }
        if (this.formList != tag.formList) {
            return false;
        }
        return this.formSubmit == var1_1.formSubmit;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.tagName.hashCode();
        result = result * 31 + (this.isBlock ? 1 : 0);
        result = result * 31 + (this.formatAsBlock ? 1 : 0);
        result = result * 31 + (this.empty ? 1 : 0);
        result = result * 31 + (this.selfClosing ? 1 : 0);
        result = result * 31 + (this.preserveWhitespace ? 1 : 0);
        result = result * 31 + (this.formList ? 1 : 0);
        var1_1 = var1_1 * 31 + this.formSubmit;
        return (int)var1_1;
    }

    public String toString() {
        return this.tagName;
    }

    /*
     * WARNING - void declaration
     */
    protected Tag clone() {
        try {
            return (Tag)super.clone();
        }
        catch (CloneNotSupportedException e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    private static void register(Tag tag) {
        Tag tag2;
        tags.put(tag.tagName, tag2);
    }

    static {
        Tag tag;
        Object tagName;
        int n;
        tags = new HashMap<String, Tag>();
        blockTags = new String[]{"html", "head", "body", "frameset", "script", "noscript", "style", "meta", "link", "title", "frame", "noframes", "section", "nav", "aside", "hgroup", "header", "footer", "p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "pre", "div", "blockquote", "hr", "address", "figure", "figcaption", "form", "fieldset", "ins", "del", "dl", "dt", "dd", "li", "table", "caption", "thead", "tfoot", "tbody", "colgroup", "col", "tr", "th", "td", "video", "audio", "canvas", "details", "menu", "plaintext", "template", "article", "main", "svg", "math", "center"};
        inlineTags = new String[]{"object", "base", "font", "tt", "i", "b", "u", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "time", "acronym", "mark", "ruby", "rt", "rp", "a", "img", "br", "wbr", "map", "q", "sub", "sup", "bdo", "iframe", "embed", "span", "input", "select", "textarea", "label", "button", "optgroup", "option", "legend", "datalist", "keygen", "output", "progress", "meter", "area", "param", "source", "track", "summary", "command", "device", "area", "basefont", "bgsound", "menuitem", "param", "source", "track", "data", "bdi", "s"};
        emptyTags = new String[]{"meta", "link", "base", "frame", "img", "br", "wbr", "embed", "hr", "input", "keygen", "col", "command", "device", "area", "basefont", "bgsound", "menuitem", "param", "source", "track"};
        formatAsInlineTags = new String[]{"title", "a", "p", "h1", "h2", "h3", "h4", "h5", "h6", "pre", "address", "li", "th", "td", "script", "style", "ins", "del", "s"};
        preserveWhitespaceTags = new String[]{"pre", "plaintext", "title", "textarea"};
        formListedTags = new String[]{"button", "fieldset", "input", "keygen", "object", "output", "select", "textarea"};
        formSubmitTags = new String[]{"input", "keygen", "object", "select", "textarea"};
        String[] stringArray = blockTags;
        int n2 = blockTags.length;
        for (n = 0; n < n2; ++n) {
            tagName = stringArray[n];
            tagName = new Tag((String)tagName);
            Tag.register((Tag)tagName);
        }
        stringArray = inlineTags;
        n2 = inlineTags.length;
        for (n = 0; n < n2; ++n) {
            tagName = stringArray[n];
            tag = new Tag((String)tagName);
            new Tag((String)tagName).isBlock = false;
            tag.formatAsBlock = false;
            Tag.register(tag);
        }
        stringArray = emptyTags;
        n2 = emptyTags.length;
        for (n = 0; n < n2; ++n) {
            tagName = stringArray[n];
            tag = tags.get(tagName);
            Validate.notNull(tag);
            tag.empty = true;
        }
        stringArray = formatAsInlineTags;
        n2 = formatAsInlineTags.length;
        for (n = 0; n < n2; ++n) {
            tagName = stringArray[n];
            tag = tags.get(tagName);
            Validate.notNull(tag);
            tag.formatAsBlock = false;
        }
        stringArray = preserveWhitespaceTags;
        n2 = preserveWhitespaceTags.length;
        for (n = 0; n < n2; ++n) {
            tagName = stringArray[n];
            tag = tags.get(tagName);
            Validate.notNull(tag);
            tag.preserveWhitespace = true;
        }
        stringArray = formListedTags;
        n2 = formListedTags.length;
        for (n = 0; n < n2; ++n) {
            tagName = stringArray[n];
            tag = tags.get(tagName);
            Validate.notNull(tag);
            tag.formList = true;
        }
        stringArray = formSubmitTags;
        n2 = formSubmitTags.length;
        for (n = 0; n < n2; ++n) {
            tagName = stringArray[n];
            tag = tags.get(tagName);
            Validate.notNull(tag);
            var3_3.formSubmit = true;
        }
    }
}

