/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.parser;

import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.nodes.Attribute;
import coursier.util.shaded.org.jsoup.nodes.Attributes;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.DocumentType;
import coursier.util.shaded.org.jsoup.nodes.Element;
import coursier.util.shaded.org.jsoup.nodes.FormElement;
import coursier.util.shaded.org.jsoup.nodes.Node;
import coursier.util.shaded.org.jsoup.parser.HtmlTreeBuilder;
import coursier.util.shaded.org.jsoup.parser.ParseSettings;
import coursier.util.shaded.org.jsoup.parser.Tag;
import coursier.util.shaded.org.jsoup.parser.Token;
import coursier.util.shaded.org.jsoup.parser.TokeniserState;
import coursier.util.shaded.org.jsoup.parser.TreeBuilder;
import java.util.ArrayList;

abstract class HtmlTreeBuilderState
extends Enum<HtmlTreeBuilderState> {
    public static final /* enum */ HtmlTreeBuilderState Initial = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                return true;
            }
            if (t.isComment()) {
                tb.insert(t.asComment());
            } else if (t.isDoctype()) {
                void var3_3;
                Token.Doctype d = t.asDoctype();
                DocumentType doctype = new DocumentType(tb.settings.normalizeTag(d.getName()), d.getPublicIdentifier(), d.getSystemIdentifier());
                doctype.setPubSysKey(d.getPubSysKey());
                tb.getDocument().appendChild((Node)var3_3);
                if (var1_1.isForceQuirks()) {
                    tb.getDocument().quirksMode(Document.QuirksMode.quirks);
                }
                tb.transition(BeforeHtml);
            } else {
                void var2_2;
                tb.transition(BeforeHtml);
                return var2_2.process((Token)var1_1);
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState BeforeHtml = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isDoctype()) {
                tb.error(this);
                return false;
            }
            if (t.isComment()) {
                tb.insert(t.asComment());
            } else if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insert(t.asCharacter());
            } else if (t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                tb.insert(t.asStartTag());
                tb.transition(BeforeHead);
            } else {
                void var2_2;
                void var1_1;
                if (t.isEndTag() && StringUtil.inSorted(t.asEndTag().normalName(), Constants.BeforeHtmlToHead)) {
                    return this.anythingElse(t, tb);
                }
                if (t.isEndTag()) {
                    tb.error(this);
                    return false;
                }
                return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            void var2_2;
            tb.insertStartTag("html");
            tb.transition(BeforeHead);
            return var2_2.process((Token)var1_1);
        }
    };
    public static final /* enum */ HtmlTreeBuilderState BeforeHead = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insert(t.asCharacter());
            } else if (t.isComment()) {
                tb.insert(t.asComment());
            } else {
                void var1_1;
                if (t.isDoctype()) {
                    tb.error(this);
                    return false;
                }
                if (t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return InBody.process(t, tb);
                }
                if (t.isStartTag() && t.asStartTag().normalName().equals("head")) {
                    Element head = tb.insert(t.asStartTag());
                    tb.setHeadElement((Element)var1_1);
                    tb.transition(InHead);
                } else {
                    void var2_2;
                    if (var1_1.isEndTag() && StringUtil.inSorted(var1_1.asEndTag().normalName(), Constants.BeforeHtmlToHead)) {
                        tb.processStartTag("head");
                        return tb.process((Token)var1_1);
                    }
                    if (var1_1.isEndTag()) {
                        tb.error(this);
                        return false;
                    }
                    tb.processStartTag("head");
                    return var2_2.process((Token)var1_1);
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InHead = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insert(t.asCharacter());
                return true;
            }
            switch (t.type) {
                case Comment: {
                    tb.insert(t.asComment());
                    break;
                }
                case Doctype: {
                    tb.error(this);
                    return false;
                }
                case StartTag: {
                    void var3_3;
                    Token.StartTag start = t.asStartTag();
                    String name = start.normalName();
                    if (name.equals("html")) {
                        return InBody.process(t, tb);
                    }
                    if (StringUtil.inSorted(name, Constants.InHeadEmpty)) {
                        Element el = tb.insertEmpty(start);
                        if (!name.equals("base") || !el.hasAttr("href")) break;
                        tb.maybeSetBaseUri((Element)var3_3);
                        break;
                    }
                    if (name.equals("meta")) {
                        tb.insertEmpty((Token.StartTag)var3_3);
                        break;
                    }
                    if (name.equals("title")) {
                        HtmlTreeBuilderState.access$200((Token.StartTag)var3_3, tb);
                        break;
                    }
                    if (StringUtil.inSorted(name, Constants.InHeadRaw)) {
                        HtmlTreeBuilderState.access$300((Token.StartTag)var3_3, tb);
                        break;
                    }
                    if (name.equals("noscript")) {
                        tb.insert((Token.StartTag)var3_3);
                        tb.transition(InHeadNoscript);
                        break;
                    }
                    if (name.equals("script")) {
                        tb.tokeniser.transition(TokeniserState.ScriptData);
                        tb.markInsertionMode();
                        tb.transition(Text);
                        tb.insert((Token.StartTag)var3_3);
                        break;
                    }
                    if (name.equals("head")) {
                        tb.error(this);
                        return false;
                    }
                    return this.anythingElse(t, tb);
                }
                case EndTag: {
                    Token.EndTag endTag = t.asEndTag();
                    String name = endTag.normalName();
                    if (name.equals("head")) {
                        tb.pop();
                        tb.transition(AfterHead);
                        break;
                    }
                    if (StringUtil.inSorted(name, Constants.InHeadEnd)) {
                        return this.anythingElse(t, tb);
                    }
                    tb.error(this);
                    return false;
                }
                default: {
                    void var2_2;
                    void var1_1;
                    return this.anythingElse((Token)var1_1, (TreeBuilder)var2_2);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, TreeBuilder tb) {
            void var1_1;
            void var2_2;
            tb.processEndTag("head");
            return var2_2.process((Token)var1_1);
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InHeadNoscript = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isDoctype()) {
                tb.error(this);
            } else {
                if (t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return tb.process(t, InBody);
                }
                if (t.isEndTag() && t.asEndTag().normalName().equals("noscript")) {
                    tb.pop();
                    tb.transition(InHead);
                } else {
                    void var2_2;
                    void var1_1;
                    if (HtmlTreeBuilderState.isWhitespace(t) || t.isComment() || t.isStartTag() && StringUtil.inSorted(t.asStartTag().normalName(), Constants.InHeadNoScriptHead)) {
                        return tb.process(t, InHead);
                    }
                    if (t.isEndTag() && t.asEndTag().normalName().equals("br")) {
                        return this.anythingElse(t, tb);
                    }
                    if (t.isStartTag() && StringUtil.inSorted(t.asStartTag().normalName(), Constants.InHeadNoscriptIgnore) || t.isEndTag()) {
                        tb.error(this);
                        return false;
                    }
                    return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            void var2_2;
            tb.error(this);
            var2_2.insert(new Token.Character().data(var1_1.toString()));
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState AfterHead = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insert(t.asCharacter());
                return true;
            }
            if (t.isComment()) {
                tb.insert(t.asComment());
                return true;
            }
            if (t.isDoctype()) {
                tb.error(this);
                return true;
            }
            if (t.isStartTag()) {
                Token.StartTag startTag = t.asStartTag();
                String name = startTag.normalName();
                if (name.equals("html")) {
                    return tb.process(t, InBody);
                }
                if (name.equals("body")) {
                    tb.insert(startTag);
                    tb.framesetOk(false);
                    tb.transition(InBody);
                    return true;
                }
                if (name.equals("frameset")) {
                    tb.insert(startTag);
                    tb.transition(InFrameset);
                    return true;
                }
                if (StringUtil.inSorted(name, Constants.InBodyStartToHead)) {
                    void var3_3;
                    tb.error(this);
                    Element head = tb.getHeadElement();
                    tb.push(head);
                    tb.process(t, InHead);
                    tb.removeFromStack((Element)var3_3);
                    return true;
                }
                if (name.equals("head")) {
                    tb.error(this);
                    return false;
                }
                this.anythingElse(t, tb);
                return true;
            }
            if (!t.isEndTag()) {
                void var2_2;
                void var1_1;
                this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
                return true;
            }
            if (StringUtil.inSorted(t.asEndTag().normalName(), Constants.AfterHeadBody)) {
                this.anythingElse(t, tb);
                return true;
            }
            tb.error(this);
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            void var2_2;
            tb.processStartTag("body");
            tb.framesetOk(true);
            return var2_2.process((Token)var1_1);
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InBody = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            switch (t.type) {
                case Character: {
                    void var1_1;
                    Token.Character c = t.asCharacter();
                    if (c.getData().equals(nullString)) {
                        tb.error(this);
                        return false;
                    }
                    if (tb.framesetOk() && HtmlTreeBuilderState.isWhitespace(c)) {
                        tb.reconstructFormattingElements();
                        tb.insert(c);
                        break;
                    }
                    tb.reconstructFormattingElements();
                    tb.insert((Token.Character)var1_1);
                    tb.framesetOk(false);
                    break;
                }
                case Comment: {
                    void var1_1;
                    tb.insert(var1_1.asComment());
                    break;
                }
                case Doctype: {
                    tb.error(this);
                    return false;
                }
                case StartTag: {
                    void var1_1;
                    return this.inBodyStartTag((Token)var1_1, tb);
                }
                case EndTag: {
                    void var2_2;
                    void var1_1;
                    return this.inBodyEndTag((Token)var1_1, (HtmlTreeBuilder)var2_2);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean inBodyStartTag(Token t, HtmlTreeBuilder tb) {
            String name;
            Token.StartTag startTag = t.asStartTag();
            switch (name = startTag.normalName()) {
                case "a": {
                    if (tb.getActiveFormattingElement("a") != null) {
                        tb.error(this);
                        tb.processEndTag("a");
                        Element remainingA = tb.getFromStack("a");
                        if (remainingA != null) {
                            tb.removeFromActiveFormattingElements(remainingA);
                            tb.removeFromStack(remainingA);
                        }
                    }
                    tb.reconstructFormattingElements();
                    Object el = tb.insert(startTag);
                    tb.pushActiveFormattingElements((Element)el);
                    break;
                }
                case "span": {
                    tb.reconstructFormattingElements();
                    tb.insert(startTag);
                    break;
                }
                case "li": {
                    Object el;
                    tb.framesetOk(false);
                    Object stack = tb.getStack();
                    for (int i = ((ArrayList)stack).size() - 1; i > 0; --i) {
                        el = ((ArrayList)stack).get(i);
                        if (((Element)el).normalName().equals("li")) {
                            tb.processEndTag("li");
                            break;
                        }
                        if (tb.isSpecial((Element)el) && !StringUtil.inSorted(((Element)el).normalName(), Constants.InBodyStartLiBreakers)) break;
                    }
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insert(startTag);
                    break;
                }
                case "html": {
                    tb.error(this);
                    Element html = tb.getStack().get(0);
                    for (Attribute attribute : startTag.getAttributes()) {
                        if (html.hasAttr(attribute.getKey())) continue;
                        html.attributes().put(attribute);
                    }
                    break;
                }
                case "body": {
                    Object attribute2;
                    tb.error(this);
                    Object stack = tb.getStack();
                    if (((ArrayList)stack).size() == 1 || ((ArrayList)stack).size() > 2 && !((ArrayList)stack).get(1).normalName().equals("body")) {
                        return false;
                    }
                    tb.framesetOk(false);
                    Element body = ((ArrayList)stack).get(1);
                    for (Object attribute2 : startTag.getAttributes()) {
                        if (body.hasAttr(((Attribute)attribute2).getKey())) continue;
                        body.attributes().put((Attribute)attribute2);
                    }
                    break;
                }
                case "frameset": {
                    Object attribute2;
                    tb.error(this);
                    Object stack = tb.getStack();
                    if (((ArrayList)stack).size() == 1 || ((ArrayList)stack).size() > 2 && !((ArrayList)stack).get(1).normalName().equals("body")) {
                        return false;
                    }
                    if (!tb.framesetOk()) {
                        return false;
                    }
                    Element second = ((ArrayList)stack).get(1);
                    if (second.parent() != null) {
                        second.remove();
                    }
                    while (((ArrayList)stack).size() > 1) {
                        Object object = stack;
                        ((ArrayList)object).remove(((ArrayList)object).size() - 1);
                    }
                    tb.insert((Token.StartTag)attribute2);
                    tb.transition(InFrameset);
                    break;
                }
                case "form": {
                    Object attribute2;
                    if (tb.getFormElement() != null) {
                        tb.error(this);
                        return false;
                    }
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insertForm((Token.StartTag)attribute2, true);
                    break;
                }
                case "plaintext": {
                    Object attribute2;
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insert((Token.StartTag)attribute2);
                    tb.tokeniser.transition(TokeniserState.PLAINTEXT);
                    break;
                }
                case "button": {
                    Object attribute2;
                    if (tb.inButtonScope("button")) {
                        tb.error(this);
                        tb.processEndTag("button");
                        tb.process((Token)attribute2);
                        break;
                    }
                    tb.reconstructFormattingElements();
                    tb.insert((Token.StartTag)attribute2);
                    tb.framesetOk(false);
                    break;
                }
                case "nobr": {
                    Object attribute2;
                    tb.reconstructFormattingElements();
                    if (tb.inScope("nobr")) {
                        tb.error(this);
                        tb.processEndTag("nobr");
                        tb.reconstructFormattingElements();
                    }
                    Object el = tb.insert((Token.StartTag)attribute2);
                    tb.pushActiveFormattingElements((Element)el);
                    break;
                }
                case "table": {
                    Object attribute2;
                    if (tb.getDocument().quirksMode() != Document.QuirksMode.quirks && tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insert((Token.StartTag)attribute2);
                    tb.framesetOk(false);
                    tb.transition(InTable);
                    break;
                }
                case "input": {
                    Object attribute2;
                    tb.reconstructFormattingElements();
                    Object el = tb.insertEmpty((Token.StartTag)attribute2);
                    if (((Node)el).attr("type").equalsIgnoreCase("hidden")) break;
                    tb.framesetOk(false);
                    break;
                }
                case "hr": {
                    Object attribute2;
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insertEmpty((Token.StartTag)attribute2);
                    tb.framesetOk(false);
                    break;
                }
                case "image": {
                    Object attribute2;
                    if (tb.getFromStack("svg") == null) {
                        return tb.process(((Token.Tag)attribute2).name("img"));
                    }
                    tb.insert((Token.StartTag)attribute2);
                    break;
                }
                case "isindex": {
                    Object attribute2;
                    Object el;
                    tb.error(this);
                    if (tb.getFormElement() != null) {
                        return false;
                    }
                    tb.processStartTag("form");
                    if (((Token.StartTag)attribute2).attributes.hasKey("action")) {
                        el = tb.getFormElement();
                        ((Element)el).attr("action", ((Token.StartTag)attribute2).attributes.get("action"));
                    }
                    tb.processStartTag("hr");
                    tb.processStartTag("label");
                    String prompt = ((Token.StartTag)attribute2).attributes.hasKey("prompt") ? ((Token.StartTag)attribute2).attributes.get("prompt") : "This is a searchable index. Enter search keywords: ";
                    tb.process(new Token.Character().data(prompt));
                    Attributes inputAttribs = new Attributes();
                    for (Attribute attr : ((Token.StartTag)attribute2).attributes) {
                        if (StringUtil.inSorted(attr.getKey(), Constants.InBodyStartInputAttribs)) continue;
                        inputAttribs.put(attr);
                    }
                    inputAttribs.put("name", "isindex");
                    tb.processStartTag("input", inputAttribs);
                    tb.processEndTag("label");
                    tb.processStartTag("hr");
                    tb.processEndTag("form");
                    break;
                }
                case "textarea": {
                    Object attribute2;
                    tb.insert((Token.StartTag)attribute2);
                    if (((Token.Tag)attribute2).isSelfClosing()) break;
                    tb.tokeniser.transition(TokeniserState.Rcdata);
                    tb.markInsertionMode();
                    tb.framesetOk(false);
                    tb.transition(Text);
                    break;
                }
                case "xmp": {
                    Object attribute2;
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.reconstructFormattingElements();
                    tb.framesetOk(false);
                    HtmlTreeBuilderState.access$300((Token.StartTag)attribute2, tb);
                    break;
                }
                case "iframe": {
                    Object attribute2;
                    tb.framesetOk(false);
                    HtmlTreeBuilderState.access$300((Token.StartTag)attribute2, tb);
                    break;
                }
                case "noembed": {
                    Object attribute2;
                    HtmlTreeBuilderState.access$300((Token.StartTag)attribute2, tb);
                    break;
                }
                case "select": {
                    void var3_3;
                    Object attribute2;
                    tb.reconstructFormattingElements();
                    tb.insert((Token.StartTag)attribute2);
                    tb.framesetOk(false);
                    HtmlTreeBuilderState state = tb.state();
                    if (state.equals((Object)InTable) || state.equals((Object)InCaption) || state.equals((Object)InTableBody) || state.equals((Object)InRow) || var3_3.equals((Object)InCell)) {
                        tb.transition(InSelectInTable);
                        break;
                    }
                    tb.transition(InSelect);
                    break;
                }
                case "math": {
                    void var3_3;
                    tb.reconstructFormattingElements();
                    tb.insert((Token.StartTag)var3_3);
                    break;
                }
                case "svg": {
                    void var3_3;
                    tb.reconstructFormattingElements();
                    tb.insert((Token.StartTag)var3_3);
                    break;
                }
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "h6": {
                    void var3_3;
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    if (StringUtil.inSorted(tb.currentElement().normalName(), Constants.Headings)) {
                        tb.error(this);
                        tb.pop();
                    }
                    tb.insert((Token.StartTag)var3_3);
                    break;
                }
                case "pre": 
                case "listing": {
                    void var3_3;
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insert((Token.StartTag)var3_3);
                    tb.reader.matchConsume("\n");
                    tb.framesetOk(false);
                    break;
                }
                case "dd": 
                case "dt": {
                    void var3_3;
                    Object el;
                    tb.framesetOk(false);
                    Object stack = tb.getStack();
                    for (int i = ((ArrayList)stack).size() - 1; i > 0; --i) {
                        el = ((ArrayList)stack).get(i);
                        if (StringUtil.inSorted(((Element)el).normalName(), Constants.DdDt)) {
                            tb.processEndTag(((Element)el).normalName());
                            break;
                        }
                        if (tb.isSpecial((Element)el) && !StringUtil.inSorted(((Element)el).normalName(), Constants.InBodyStartLiBreakers)) break;
                    }
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insert((Token.StartTag)var3_3);
                    break;
                }
                case "optgroup": 
                case "option": {
                    void var3_3;
                    if (tb.currentElement().normalName().equals("option")) {
                        tb.processEndTag("option");
                    }
                    tb.reconstructFormattingElements();
                    tb.insert((Token.StartTag)var3_3);
                    break;
                }
                case "rp": 
                case "rt": {
                    void var3_3;
                    if (!tb.inScope("ruby")) break;
                    tb.generateImpliedEndTags();
                    if (!tb.currentElement().normalName().equals("ruby")) {
                        tb.error(this);
                        tb.popStackToBefore("ruby");
                    }
                    tb.insert((Token.StartTag)var3_3);
                    break;
                }
                default: {
                    void var2_2;
                    void var4_4;
                    void var3_3;
                    Object el;
                    if (StringUtil.inSorted((String)el, Constants.InBodyStartEmptyFormatters)) {
                        tb.reconstructFormattingElements();
                        tb.insertEmpty((Token.StartTag)var3_3);
                        tb.framesetOk(false);
                        break;
                    }
                    if (StringUtil.inSorted((String)el, Constants.InBodyStartPClosers)) {
                        if (tb.inButtonScope("p")) {
                            tb.processEndTag("p");
                        }
                        tb.insert((Token.StartTag)var3_3);
                        break;
                    }
                    if (StringUtil.inSorted((String)el, Constants.InBodyStartToHead)) {
                        void var1_1;
                        return tb.process((Token)var1_1, InHead);
                    }
                    if (StringUtil.inSorted((String)el, Constants.Formatters)) {
                        tb.reconstructFormattingElements();
                        el = tb.insert((Token.StartTag)var3_3);
                        tb.pushActiveFormattingElements((Element)el);
                        break;
                    }
                    if (StringUtil.inSorted((String)var4_4, Constants.InBodyStartApplets)) {
                        tb.reconstructFormattingElements();
                        tb.insert((Token.StartTag)var3_3);
                        tb.insertMarkerToFormattingElements();
                        tb.framesetOk(false);
                        break;
                    }
                    if (StringUtil.inSorted((String)var4_4, Constants.InBodyStartMedia)) {
                        tb.insertEmpty((Token.StartTag)var3_3);
                        break;
                    }
                    if (StringUtil.inSorted((String)var4_4, Constants.InBodyStartDrop)) {
                        tb.error(this);
                        return false;
                    }
                    tb.reconstructFormattingElements();
                    var2_2.insert((Token.StartTag)var3_3);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean inBodyEndTag(Token t2, HtmlTreeBuilder tb) {
            String name;
            Token.EndTag endTag = t2.asEndTag();
            switch (name = endTag.normalName()) {
                case "sarcasm": 
                case "span": {
                    return this.anyOtherEndTag(t2, tb);
                }
                case "li": {
                    if (!tb.inListItemScope(name)) {
                        tb.error(this);
                        return false;
                    }
                    tb.generateImpliedEndTags(name);
                    if (!tb.currentElement().normalName().equals(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(name);
                    break;
                }
                case "body": {
                    if (!tb.inScope("body")) {
                        tb.error(this);
                        return false;
                    }
                    tb.transition(AfterBody);
                    break;
                }
                case "html": {
                    boolean t2 = tb.processEndTag("body");
                    if (!t2) break;
                    return tb.process(endTag);
                }
                case "form": {
                    void var1_1;
                    FormElement currentForm = tb.getFormElement();
                    tb.setFormElement(null);
                    if (currentForm == null || !tb.inScope(name)) {
                        tb.error(this);
                        return false;
                    }
                    tb.generateImpliedEndTags();
                    if (!tb.currentElement().normalName().equals(name)) {
                        tb.error(this);
                    }
                    tb.removeFromStack((Element)var1_1);
                    break;
                }
                case "p": {
                    if (!tb.inButtonScope(name)) {
                        void var3_4;
                        tb.error(this);
                        tb.processStartTag(name);
                        return tb.process((Token)var3_4);
                    }
                    tb.generateImpliedEndTags(name);
                    if (!tb.currentElement().normalName().equals(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(name);
                    break;
                }
                case "dd": 
                case "dt": {
                    if (!tb.inScope(name)) {
                        tb.error(this);
                        return false;
                    }
                    tb.generateImpliedEndTags(name);
                    if (!tb.currentElement().normalName().equals(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(name);
                    break;
                }
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "h6": {
                    if (!tb.inScope(Constants.Headings)) {
                        tb.error(this);
                        return false;
                    }
                    tb.generateImpliedEndTags(name);
                    if (!tb.currentElement().normalName().equals(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(Constants.Headings);
                    break;
                }
                case "br": {
                    tb.error(this);
                    tb.processStartTag("br");
                    return false;
                }
                default: {
                    void var2_3;
                    void var1_1;
                    if (StringUtil.inSorted(name, Constants.InBodyEndAdoptionFormatters)) {
                        return this.inBodyEndTagAdoption((Token)var1_1, tb);
                    }
                    if (StringUtil.inSorted(name, Constants.InBodyEndClosers)) {
                        if (!tb.inScope(name)) {
                            tb.error(this);
                            return false;
                        }
                        tb.generateImpliedEndTags();
                        if (!tb.currentElement().normalName().equals(name)) {
                            tb.error(this);
                        }
                        tb.popStackToClose(name);
                        break;
                    }
                    if (StringUtil.inSorted(name, Constants.InBodyStartApplets)) {
                        if (tb.inScope("name")) break;
                        if (!tb.inScope(name)) {
                            tb.error(this);
                            return false;
                        }
                        tb.generateImpliedEndTags();
                        if (!tb.currentElement().normalName().equals(name)) {
                            tb.error(this);
                        }
                        tb.popStackToClose(name);
                        tb.clearFormattingElementsToLastMarker();
                        break;
                    }
                    return this.anyOtherEndTag((Token)var1_1, (HtmlTreeBuilder)var2_3);
                }
            }
            return true;
        }

        final boolean anyOtherEndTag(Token t, HtmlTreeBuilder tb) {
            String name = t.asEndTag().normalName;
            ArrayList<Element> stack = tb.getStack();
            for (int pos = stack.size() - 1; pos >= 0; --pos) {
                Element node = stack.get(pos);
                if (node.normalName().equals(name)) {
                    tb.generateImpliedEndTags(name);
                    if (!name.equals(tb.currentElement().normalName())) {
                        tb.error(this);
                    }
                    tb.popStackToClose(name);
                    break;
                }
                if (!tb.isSpecial(node)) continue;
                tb.error(this);
                return false;
            }
            return true;
        }

        private boolean inBodyEndTagAdoption(Token t, HtmlTreeBuilder tb) {
            Token.EndTag endTag = t.asEndTag();
            String name = endTag.normalName();
            ArrayList<Element> stack = tb.getStack();
            for (int i = 0; i < 8; ++i) {
                Node[] nodeArray;
                Element formatEl = tb.getActiveFormattingElement(name);
                if (formatEl == null) {
                    return this.anyOtherEndTag(t, tb);
                }
                if (!tb.onStack(formatEl)) {
                    tb.error(this);
                    tb.removeFromActiveFormattingElements(formatEl);
                    return true;
                }
                if (!tb.inScope(formatEl.normalName())) {
                    tb.error(this);
                    return false;
                }
                if (tb.currentElement() != formatEl) {
                    tb.error(this);
                }
                Element furthestBlock = null;
                Element commonAncestor = null;
                boolean seenFormattingElement = false;
                int stackSize = stack.size();
                for (int si = 0; si < stackSize && si < 64; ++si) {
                    Element el = stack.get(si);
                    if (el == formatEl) {
                        commonAncestor = stack.get(si - 1);
                        seenFormattingElement = true;
                        continue;
                    }
                    if (!seenFormattingElement || !tb.isSpecial(el)) continue;
                    furthestBlock = el;
                    break;
                }
                if (furthestBlock == null) {
                    tb.popStackToClose(formatEl.normalName());
                    tb.removeFromActiveFormattingElements(formatEl);
                    return true;
                }
                Element node = furthestBlock;
                Element lastNode = furthestBlock;
                for (int j = 0; j < 3; ++j) {
                    if (tb.onStack(node)) {
                        node = tb.aboveOnStack(node);
                    }
                    if (!tb.isInActiveFormattingElements(node)) {
                        tb.removeFromStack(node);
                        continue;
                    }
                    if (node == formatEl) break;
                    Element replacement = new Element(Tag.valueOf(node.nodeName(), ParseSettings.preserveCase), tb.getBaseUri());
                    tb.replaceActiveFormattingElement(node, replacement);
                    tb.replaceOnStack(node, replacement);
                    node = replacement;
                    if (lastNode.parent() != null) {
                        lastNode.remove();
                    }
                    node.appendChild(lastNode);
                    lastNode = node;
                }
                if (StringUtil.inSorted(commonAncestor.normalName(), Constants.InBodyEndTableFosters)) {
                    if (lastNode.parent() != null) {
                        lastNode.remove();
                    }
                    tb.insertInFosterParent(lastNode);
                } else {
                    if (lastNode.parent() != null) {
                        lastNode.remove();
                    }
                    commonAncestor.appendChild(lastNode);
                }
                Element adopter = new Element(formatEl.tag(), tb.getBaseUri());
                adopter.attributes().addAll(formatEl.attributes());
                Node[] nodeArray2 = nodeArray = furthestBlock.childNodes().toArray(new Node[0]);
                int n = nodeArray.length;
                for (int j = 0; j < n; ++j) {
                    Node childNode = nodeArray2[j];
                    adopter.appendChild(childNode);
                }
                furthestBlock.appendChild(adopter);
                tb.removeFromActiveFormattingElements(formatEl);
                tb.removeFromStack(formatEl);
                tb.insertOnStackAfter(furthestBlock, adopter);
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState Text = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isCharacter()) {
                tb.insert(t.asCharacter());
            } else {
                void var1_1;
                if (t.isEOF()) {
                    tb.error(this);
                    tb.pop();
                    HtmlTreeBuilder htmlTreeBuilder = tb;
                    htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                    return tb.process(t);
                }
                if (var1_1.isEndTag()) {
                    void var2_2;
                    tb.pop();
                    void v1 = var2_2;
                    v1.transition(v1.originalState());
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InTable = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            void var2_2;
            void var1_1;
            if (t.isCharacter()) {
                tb.newPendingTableCharacters();
                tb.markInsertionMode();
                tb.transition(InTableText);
                return tb.process(t);
            }
            if (t.isComment()) {
                tb.insert(t.asComment());
                return true;
            }
            if (t.isDoctype()) {
                tb.error(this);
                return false;
            }
            if (t.isStartTag()) {
                Token.StartTag startTag2 = t.asStartTag();
                String name = startTag2.normalName();
                if (name.equals("caption")) {
                    tb.clearStackToTableContext();
                    tb.insertMarkerToFormattingElements();
                    tb.insert(startTag2);
                    tb.transition(InCaption);
                } else if (name.equals("colgroup")) {
                    tb.clearStackToTableContext();
                    tb.insert(startTag2);
                    tb.transition(InColumnGroup);
                } else {
                    if (name.equals("col")) {
                        tb.processStartTag("colgroup");
                        return tb.process(t);
                    }
                    if (StringUtil.inSorted(name, Constants.InTableToBody)) {
                        tb.clearStackToTableContext();
                        tb.insert(startTag2);
                        tb.transition(InTableBody);
                    } else {
                        if (StringUtil.inSorted(name, Constants.InTableAddBody)) {
                            tb.processStartTag("tbody");
                            return tb.process(t);
                        }
                        if (name.equals("table")) {
                            tb.error(this);
                            boolean startTag2 = tb.processEndTag("table");
                            if (startTag2) {
                                return tb.process(t);
                            }
                        } else {
                            if (StringUtil.inSorted(name, Constants.InTableToHead)) {
                                return tb.process(t, InHead);
                            }
                            if (name.equals("input")) {
                                if (!startTag2.attributes.get("type").equalsIgnoreCase("hidden")) {
                                    return this.anythingElse(t, tb);
                                }
                                tb.insertEmpty(startTag2);
                            } else if (name.equals("form")) {
                                void var3_3;
                                tb.error(this);
                                if (tb.getFormElement() != null) {
                                    return false;
                                }
                                tb.insertForm((Token.StartTag)var3_3, false);
                            } else {
                                return this.anythingElse(t, tb);
                            }
                        }
                    }
                }
                return true;
            }
            if (t.isEndTag()) {
                Token.EndTag endTag = t.asEndTag();
                String name = endTag.normalName();
                if (name.equals("table")) {
                    if (!tb.inTableScope(name)) {
                        tb.error(this);
                        return false;
                    }
                } else {
                    if (StringUtil.inSorted(name, Constants.InTableEndErr)) {
                        tb.error(this);
                        return false;
                    }
                    return this.anythingElse(t, tb);
                }
                tb.popStackToClose("table");
                tb.resetInsertionMode();
                return true;
            }
            if (t.isEOF()) {
                if (tb.currentElement().normalName().equals("html")) {
                    tb.error(this);
                }
                return true;
            }
            return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        final boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_2;
            boolean processed2;
            tb.error(this);
            if (StringUtil.inSorted(tb.currentElement().normalName(), Constants.InTableFoster)) {
                tb.setFosterInserts(true);
                processed2 = tb.process(t, InBody);
                tb.setFosterInserts(false);
            } else {
                void processed;
                void var2_3;
                processed2 = var2_3.process((Token)processed, InBody);
            }
            return (boolean)var1_2;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InTableText = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            void var3_3;
            if (t.type == Token.TokenType.Character) {
                Token.Character c = t.asCharacter();
                if (c.getData().equals(nullString)) {
                    tb.error(this);
                    return false;
                }
            } else {
                void var1_1;
                void var2_2;
                if (tb.getPendingTableCharacters().size() > 0) {
                    for (String character : tb.getPendingTableCharacters()) {
                        if (!HtmlTreeBuilderState.isWhitespace(character)) {
                            tb.error(this);
                            if (StringUtil.inSorted(tb.currentElement().normalName(), Constants.InTableFoster)) {
                                tb.setFosterInserts(true);
                                tb.process(new Token.Character().data(character), InBody);
                                tb.setFosterInserts(false);
                                continue;
                            }
                            tb.process(new Token.Character().data(character), InBody);
                            continue;
                        }
                        tb.insert(new Token.Character().data(character));
                    }
                    tb.newPendingTableCharacters();
                }
                HtmlTreeBuilder htmlTreeBuilder = tb;
                htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                return var2_2.process((Token)var1_1);
            }
            tb.getPendingTableCharacters().add(var3_3.getData());
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InCaption = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            if (t.isEndTag() && t.asEndTag().normalName().equals("caption")) {
                Token.EndTag endTag = t.asEndTag();
                String name = endTag.normalName();
                if (!tb.inTableScope((String)var1_1)) {
                    tb.error(this);
                    return false;
                }
                tb.generateImpliedEndTags();
                if (!tb.currentElement().normalName().equals("caption")) {
                    tb.error(this);
                }
                tb.popStackToClose("caption");
                tb.clearFormattingElementsToLastMarker();
                tb.transition(InTable);
            } else if (var1_1.isStartTag() && StringUtil.inSorted(var1_1.asStartTag().normalName(), Constants.InCellCol) || var1_1.isEndTag() && var1_1.asEndTag().normalName().equals("table")) {
                tb.error(this);
                boolean bl = tb.processEndTag("caption");
                if (bl) {
                    return tb.process((Token)var1_1);
                }
            } else {
                void var2_2;
                if (var1_1.isEndTag() && StringUtil.inSorted(var1_1.asEndTag().normalName(), Constants.InCaptionIgnore)) {
                    tb.error(this);
                    return false;
                }
                return var2_2.process((Token)var1_1, InBody);
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InColumnGroup = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insert(t.asCharacter());
                return true;
            }
            block0 : switch (t.type) {
                case Comment: {
                    tb.insert(t.asComment());
                    break;
                }
                case Doctype: {
                    tb.error(this);
                    break;
                }
                case StartTag: {
                    Token.StartTag startTag = t.asStartTag();
                    switch (startTag.normalName()) {
                        case "html": {
                            return tb.process(t, InBody);
                        }
                        case "col": {
                            void var3_3;
                            tb.insertEmpty((Token.StartTag)var3_3);
                            break block0;
                        }
                    }
                    return this.anythingElse(t, tb);
                }
                case EndTag: {
                    Token.EndTag endTag = t.asEndTag();
                    if (endTag.normalName.equals("colgroup")) {
                        if (tb.currentElement().normalName().equals("html")) {
                            tb.error(this);
                            return false;
                        }
                        tb.pop();
                        tb.transition(InTable);
                        break;
                    }
                    return this.anythingElse(t, tb);
                }
                case EOF: {
                    if (tb.currentElement().normalName().equals("html")) {
                        return true;
                    }
                    return this.anythingElse(t, tb);
                }
                default: {
                    void var2_2;
                    void var1_1;
                    return this.anythingElse((Token)var1_1, (TreeBuilder)var2_2);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, TreeBuilder tb) {
            boolean bl = tb.processEndTag("colgroup");
            if (bl) {
                void var1_1;
                void var2_2;
                return var2_2.process((Token)var1_1);
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InTableBody = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            switch (t.type) {
                case StartTag: {
                    Token.StartTag startTag = t.asStartTag();
                    String name = startTag.normalName();
                    if (name.equals("template")) {
                        tb.insert(startTag);
                        break;
                    }
                    if (name.equals("tr")) {
                        tb.clearStackToTableBodyContext();
                        tb.insert(startTag);
                        tb.transition(InRow);
                        break;
                    }
                    if (StringUtil.inSorted(name, Constants.InCellNames)) {
                        void var3_3;
                        tb.error(this);
                        tb.processStartTag("tr");
                        return tb.process((Token)var3_3);
                    }
                    if (StringUtil.inSorted(name, Constants.InTableBodyExit)) {
                        return this.exitTableBody(t, tb);
                    }
                    return this.anythingElse(t, tb);
                }
                case EndTag: {
                    Token.EndTag endTag = t.asEndTag();
                    String name = endTag.normalName();
                    if (StringUtil.inSorted(name, Constants.InTableEndIgnore)) {
                        if (!tb.inTableScope(name)) {
                            tb.error(this);
                            return false;
                        }
                        tb.clearStackToTableBodyContext();
                        tb.pop();
                        tb.transition(InTable);
                        break;
                    }
                    if (name.equals("table")) {
                        return this.exitTableBody(t, tb);
                    }
                    if (StringUtil.inSorted(name, Constants.InTableBodyEndIgnore)) {
                        tb.error(this);
                        return false;
                    }
                    return this.anythingElse(t, tb);
                }
                default: {
                    void var2_2;
                    void var1_1;
                    return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean exitTableBody(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            void var2_2;
            if (!(tb.inTableScope("tbody") || tb.inTableScope("thead") || tb.inScope("tfoot"))) {
                tb.error(this);
                return false;
            }
            tb.clearStackToTableBodyContext();
            HtmlTreeBuilder htmlTreeBuilder = tb;
            htmlTreeBuilder.processEndTag(htmlTreeBuilder.currentElement().normalName());
            return var2_2.process((Token)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            return tb.process((Token)var1_1, InTable);
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InRow = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isStartTag()) {
                Token.StartTag startTag = t.asStartTag();
                String name = startTag.normalName();
                if (name.equals("template")) {
                    tb.insert(startTag);
                    return true;
                }
                if (StringUtil.inSorted(name, Constants.InCellNames)) {
                    void var3_3;
                    tb.clearStackToTableRowContext();
                    tb.insert((Token.StartTag)var3_3);
                    tb.transition(InCell);
                    tb.insertMarkerToFormattingElements();
                    return true;
                }
                if (!StringUtil.inSorted(name, Constants.InRowMissing)) return this.anythingElse(t, tb);
                return this.handleMissingTr(t, tb);
            }
            if (!t.isEndTag()) void var2_2;
            void var1_1;
            return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
            Token.EndTag endTag = t.asEndTag();
            String name = endTag.normalName();
            if (name.equals("tr")) {
                if (!tb.inTableScope(name)) {
                    tb.error(this);
                    return false;
                }
                tb.clearStackToTableRowContext();
                tb.pop();
                tb.transition(InTableBody);
                return true;
            }
            if (name.equals("table")) {
                return this.handleMissingTr(t, tb);
            }
            if (!StringUtil.inSorted(name, Constants.InTableToBody)) {
                if (!StringUtil.inSorted(name, Constants.InRowIgnore)) return this.anythingElse(t, tb);
                tb.error(this);
                return false;
            }
            if (!tb.inTableScope(name)) {
                tb.error(this);
                return false;
            }
            tb.processEndTag("tr");
            return tb.process(t);
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            return tb.process((Token)var1_1, InTable);
        }

        /*
         * WARNING - void declaration
         */
        private boolean handleMissingTr(Token t, TreeBuilder tb) {
            boolean bl = tb.processEndTag("tr");
            if (bl) {
                void var1_1;
                void var2_2;
                return var2_2.process((Token)var1_1);
            }
            return false;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InCell = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            void var2_2;
            void var1_1;
            if (t.isEndTag()) {
                Token.EndTag endTag = t.asEndTag();
                String name = endTag.normalName();
                if (StringUtil.inSorted(name, Constants.InCellNames)) {
                    if (!tb.inTableScope(name)) {
                        tb.error(this);
                        tb.transition(InRow);
                        return false;
                    }
                    tb.generateImpliedEndTags();
                    if (!tb.currentElement().normalName().equals(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(name);
                    tb.clearFormattingElementsToLastMarker();
                    tb.transition(InRow);
                    return true;
                }
                if (StringUtil.inSorted(name, Constants.InCellBody)) {
                    tb.error(this);
                    return false;
                }
                if (!StringUtil.inSorted(name, Constants.InCellTable)) return this.anythingElse(t, tb);
                if (!tb.inTableScope((String)((Object)endTag))) {
                    tb.error(this);
                    return false;
                }
                this.closeCell(tb);
                return tb.process(t);
            }
            if (!t.isStartTag()) return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
            if (!StringUtil.inSorted(t.asStartTag().normalName(), Constants.InCellCol)) return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
            if (!tb.inTableScope("td") && !tb.inTableScope("th")) {
                tb.error(this);
                return false;
            }
            this.closeCell(tb);
            return tb.process(t);
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            return tb.process((Token)var1_1, InBody);
        }

        /*
         * WARNING - void declaration
         */
        private void closeCell(HtmlTreeBuilder tb) {
            void var1_1;
            if (tb.inTableScope("td")) {
                tb.processEndTag("td");
                return;
            }
            var1_1.processEndTag("th");
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InSelect = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            block0 : switch (t.type) {
                case Character: {
                    void var1_1;
                    Token.Character c = t.asCharacter();
                    if (c.getData().equals(nullString)) {
                        tb.error(this);
                        return false;
                    }
                    tb.insert((Token.Character)var1_1);
                    break;
                }
                case Comment: {
                    void var1_1;
                    tb.insert(var1_1.asComment());
                    break;
                }
                case Doctype: {
                    tb.error(this);
                    return false;
                }
                case StartTag: {
                    void var1_1;
                    Token.StartTag start = var1_1.asStartTag();
                    String name = start.normalName();
                    if (name.equals("html")) {
                        return tb.process(start, InBody);
                    }
                    if (name.equals("option")) {
                        if (tb.currentElement().normalName().equals("option")) {
                            tb.processEndTag("option");
                        }
                        tb.insert(start);
                        break;
                    }
                    if (name.equals("optgroup")) {
                        if (tb.currentElement().normalName().equals("option")) {
                            tb.processEndTag("option");
                        }
                        if (tb.currentElement().normalName().equals("optgroup")) {
                            tb.processEndTag("optgroup");
                        }
                        tb.insert(start);
                        break;
                    }
                    if (name.equals("select")) {
                        tb.error(this);
                        return tb.processEndTag("select");
                    }
                    if (StringUtil.inSorted(name, Constants.InSelectEnd)) {
                        void var3_3;
                        tb.error(this);
                        if (!tb.inSelectScope("select")) {
                            return false;
                        }
                        tb.processEndTag("select");
                        return tb.process((Token)var3_3);
                    }
                    if (name.equals("script")) {
                        return tb.process((Token)var1_1, InHead);
                    }
                    return this.anythingElse((Token)var1_1, tb);
                }
                case EndTag: {
                    void var1_1;
                    Object object = var1_1.asEndTag();
                    String name = ((Token.Tag)object).normalName();
                    switch (name) {
                        case "optgroup": {
                            if (tb.currentElement().normalName().equals("option")) {
                                HtmlTreeBuilder htmlTreeBuilder = tb;
                                if (htmlTreeBuilder.aboveOnStack(htmlTreeBuilder.currentElement()) != null) {
                                    HtmlTreeBuilder htmlTreeBuilder2 = tb;
                                    if (htmlTreeBuilder2.aboveOnStack(htmlTreeBuilder2.currentElement()).normalName().equals("optgroup")) {
                                        tb.processEndTag("option");
                                    }
                                }
                            }
                            if (tb.currentElement().normalName().equals("optgroup")) {
                                tb.pop();
                                break block0;
                            }
                            tb.error(this);
                            break block0;
                        }
                        case "option": {
                            if (tb.currentElement().normalName().equals("option")) {
                                tb.pop();
                                break block0;
                            }
                            tb.error(this);
                            break block0;
                        }
                        case "select": {
                            if (!tb.inSelectScope(name)) {
                                tb.error(this);
                                return false;
                            }
                            tb.popStackToClose(name);
                            tb.resetInsertionMode();
                            break block0;
                        }
                    }
                    return this.anythingElse((Token)var1_1, tb);
                }
                case EOF: {
                    if (tb.currentElement().normalName().equals("html")) break;
                    tb.error(this);
                    break;
                }
                default: {
                    void var2_2;
                    void var1_1;
                    return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
                }
            }
            return true;
        }

        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            tb.error(this);
            return false;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InSelectInTable = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            void var2_2;
            if (t.isStartTag() && StringUtil.inSorted(t.asStartTag().normalName(), Constants.InSelecTableEnd)) {
                tb.error(this);
                tb.processEndTag("select");
                return tb.process(t);
            }
            if (t.isEndTag() && StringUtil.inSorted(t.asEndTag().normalName(), Constants.InSelecTableEnd)) {
                tb.error(this);
                if (tb.inTableScope(t.asEndTag().normalName())) {
                    tb.processEndTag("select");
                    return tb.process(t);
                }
                return false;
            }
            return var2_2.process((Token)var1_1, InSelect);
        }
    };
    public static final /* enum */ HtmlTreeBuilderState AfterBody = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insert(t.asCharacter());
            } else if (t.isComment()) {
                tb.insert(t.asComment());
            } else {
                if (t.isDoctype()) {
                    tb.error(this);
                    return false;
                }
                if (t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return tb.process(t, InBody);
                }
                if (t.isEndTag() && t.asEndTag().normalName().equals("html")) {
                    if (tb.isFragmentParsing()) {
                        tb.error(this);
                        return false;
                    }
                    tb.transition(AfterAfterBody);
                } else if (!t.isEOF()) {
                    void var1_1;
                    void var2_2;
                    tb.error(this);
                    tb.transition(InBody);
                    return var2_2.process((Token)var1_1);
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InFrameset = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            block21: {
                void var1_1;
                block23: {
                    block22: {
                        block20: {
                            if (!HtmlTreeBuilderState.isWhitespace(t)) break block20;
                            tb.insert(t.asCharacter());
                            break block21;
                        }
                        if (!t.isComment()) break block22;
                        tb.insert(t.asComment());
                        break block21;
                    }
                    if (t.isDoctype()) {
                        tb.error(this);
                        return false;
                    }
                    if (!t.isStartTag()) break block23;
                    Token.StartTag start = t.asStartTag();
                    switch (start.normalName()) {
                        case "html": {
                            return tb.process(start, InBody);
                        }
                        case "frameset": {
                            tb.insert(start);
                            break block21;
                        }
                        case "frame": {
                            tb.insertEmpty(start);
                            break block21;
                        }
                        case "noframes": {
                            return tb.process((Token)var1_1, InHead);
                        }
                        default: {
                            tb.error(this);
                            return false;
                        }
                    }
                }
                if (var1_1.isEndTag() && var1_1.asEndTag().normalName().equals("frameset")) {
                    if (tb.currentElement().normalName().equals("html")) {
                        tb.error(this);
                        return false;
                    }
                    tb.pop();
                    if (!tb.isFragmentParsing() && !tb.currentElement().normalName().equals("frameset")) {
                        tb.transition(AfterFrameset);
                    }
                } else if (var1_1.isEOF()) {
                    if (!tb.currentElement().normalName().equals("html")) {
                        tb.error(this);
                        return true;
                    }
                } else {
                    void var2_2;
                    var2_2.error(this);
                    return false;
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState AfterFrameset = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insert(t.asCharacter());
            } else if (t.isComment()) {
                tb.insert(t.asComment());
            } else {
                if (t.isDoctype()) {
                    tb.error(this);
                    return false;
                }
                if (t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return tb.process(t, InBody);
                }
                if (t.isEndTag() && t.asEndTag().normalName().equals("html")) {
                    tb.transition(AfterAfterFrameset);
                } else {
                    void var1_1;
                    if (t.isStartTag() && t.asStartTag().normalName().equals("noframes")) {
                        return tb.process(t, InHead);
                    }
                    if (!var1_1.isEOF()) {
                        void var2_2;
                        var2_2.error(this);
                        return false;
                    }
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState AfterAfterBody = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isComment()) {
                tb.insert(t.asComment());
            } else {
                if (t.isDoctype() || t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return tb.process(t, InBody);
                }
                if (HtmlTreeBuilderState.isWhitespace(t)) {
                    void var3_3;
                    Element html = tb.popStackToClose("html");
                    tb.insert(t.asCharacter());
                    tb.stack.add(html);
                    tb.stack.add(var3_3.selectFirst("body"));
                } else if (!t.isEOF()) {
                    void var1_1;
                    void var2_2;
                    tb.error(this);
                    tb.transition(InBody);
                    return var2_2.process((Token)var1_1);
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState AfterAfterFrameset = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isComment()) {
                tb.insert(t.asComment());
            } else {
                if (t.isDoctype() || HtmlTreeBuilderState.isWhitespace(t) || t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return tb.process(t, InBody);
                }
                if (!t.isEOF()) {
                    void var2_2;
                    if (t.isStartTag() && t.asStartTag().normalName().equals("noframes")) {
                        void var1_1;
                        return tb.process((Token)var1_1, InHead);
                    }
                    var2_2.error(this);
                    return false;
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState ForeignContent = new HtmlTreeBuilderState(){

        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            return true;
        }
    };
    private static final String nullString;
    private static final /* synthetic */ HtmlTreeBuilderState[] $VALUES;

    abstract boolean process(Token var1, HtmlTreeBuilder var2);

    private static boolean isWhitespace(Token t) {
        if (t.isCharacter()) {
            String string;
            string = ((Token)((Object)string)).asCharacter().getData();
            return StringUtil.isBlank(string);
        }
        return false;
    }

    private static boolean isWhitespace(String data) {
        return StringUtil.isBlank(data);
    }

    /*
     * WARNING - void declaration
     */
    private static void handleRcData(Token.StartTag startTag, HtmlTreeBuilder tb) {
        Token.StartTag startTag2;
        void var1_1;
        tb.tokeniser.transition(TokeniserState.Rcdata);
        tb.markInsertionMode();
        tb.transition(Text);
        var1_1.insert(startTag2);
    }

    /*
     * WARNING - void declaration
     */
    private static void handleRawtext(Token.StartTag startTag, HtmlTreeBuilder tb) {
        Token.StartTag startTag2;
        void var1_1;
        tb.tokeniser.transition(TokeniserState.Rawtext);
        tb.markInsertionMode();
        tb.transition(Text);
        var1_1.insert(startTag2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Token.StartTag x0, HtmlTreeBuilder x1) {
        void var1_1;
        HtmlTreeBuilderState.handleRcData(x0, (HtmlTreeBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(Token.StartTag x0, HtmlTreeBuilder x1) {
        void var1_1;
        HtmlTreeBuilderState.handleRawtext(x0, (HtmlTreeBuilder)var1_1);
    }

    static {
        $VALUES = new HtmlTreeBuilderState[]{Initial, BeforeHtml, BeforeHead, InHead, InHeadNoscript, AfterHead, InBody, Text, InTable, InTableText, InCaption, InColumnGroup, InTableBody, InRow, InCell, InSelect, InSelectInTable, AfterBody, InFrameset, AfterFrameset, AfterAfterBody, AfterAfterFrameset, ForeignContent};
        nullString = "\u0000";
    }

    static final class Constants {
        static final String[] InHeadEmpty = new String[]{"base", "basefont", "bgsound", "command", "link"};
        static final String[] InHeadRaw = new String[]{"noframes", "style"};
        static final String[] InHeadEnd = new String[]{"body", "br", "html"};
        static final String[] AfterHeadBody = new String[]{"body", "html"};
        static final String[] BeforeHtmlToHead = new String[]{"body", "br", "head", "html"};
        static final String[] InHeadNoScriptHead = new String[]{"basefont", "bgsound", "link", "meta", "noframes", "style"};
        static final String[] InBodyStartToHead = new String[]{"base", "basefont", "bgsound", "command", "link", "meta", "noframes", "script", "style", "title"};
        static final String[] InBodyStartPClosers = new String[]{"address", "article", "aside", "blockquote", "center", "details", "dir", "div", "dl", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "menu", "nav", "ol", "p", "section", "summary", "ul"};
        static final String[] Headings = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
        static final String[] InBodyStartLiBreakers = new String[]{"address", "div", "p"};
        static final String[] DdDt = new String[]{"dd", "dt"};
        static final String[] Formatters = new String[]{"b", "big", "code", "em", "font", "i", "s", "small", "strike", "strong", "tt", "u"};
        static final String[] InBodyStartApplets = new String[]{"applet", "marquee", "object"};
        static final String[] InBodyStartEmptyFormatters = new String[]{"area", "br", "embed", "img", "keygen", "wbr"};
        static final String[] InBodyStartMedia = new String[]{"param", "source", "track"};
        static final String[] InBodyStartInputAttribs = new String[]{"action", "name", "prompt"};
        static final String[] InBodyStartDrop = new String[]{"caption", "col", "colgroup", "frame", "head", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InBodyEndClosers = new String[]{"address", "article", "aside", "blockquote", "button", "center", "details", "dir", "div", "dl", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "listing", "menu", "nav", "ol", "pre", "section", "summary", "ul"};
        static final String[] InBodyEndAdoptionFormatters = new String[]{"a", "b", "big", "code", "em", "font", "i", "nobr", "s", "small", "strike", "strong", "tt", "u"};
        static final String[] InBodyEndTableFosters = new String[]{"table", "tbody", "tfoot", "thead", "tr"};
        static final String[] InTableToBody = new String[]{"tbody", "tfoot", "thead"};
        static final String[] InTableAddBody = new String[]{"td", "th", "tr"};
        static final String[] InTableToHead = new String[]{"script", "style"};
        static final String[] InCellNames = new String[]{"td", "th"};
        static final String[] InCellBody = new String[]{"body", "caption", "col", "colgroup", "html"};
        static final String[] InCellTable = new String[]{"table", "tbody", "tfoot", "thead", "tr"};
        static final String[] InCellCol = new String[]{"caption", "col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InTableEndErr = new String[]{"body", "caption", "col", "colgroup", "html", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InTableFoster = new String[]{"table", "tbody", "tfoot", "thead", "tr"};
        static final String[] InTableBodyExit = new String[]{"caption", "col", "colgroup", "tbody", "tfoot", "thead"};
        static final String[] InTableBodyEndIgnore = new String[]{"body", "caption", "col", "colgroup", "html", "td", "th", "tr"};
        static final String[] InRowMissing = new String[]{"caption", "col", "colgroup", "tbody", "tfoot", "thead", "tr"};
        static final String[] InRowIgnore = new String[]{"body", "caption", "col", "colgroup", "html", "td", "th"};
        static final String[] InSelectEnd = new String[]{"input", "keygen", "textarea"};
        static final String[] InSelecTableEnd = new String[]{"caption", "table", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InTableEndIgnore = new String[]{"tbody", "tfoot", "thead"};
        static final String[] InHeadNoscriptIgnore = new String[]{"head", "noscript"};
        static final String[] InCaptionIgnore = new String[]{"body", "col", "colgroup", "html", "tbody", "td", "tfoot", "th", "thead", "tr"};
    }
}

