/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.parser;

import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.nodes.CDataNode;
import coursier.util.shaded.org.jsoup.nodes.Comment;
import coursier.util.shaded.org.jsoup.nodes.DataNode;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.Element;
import coursier.util.shaded.org.jsoup.nodes.FormElement;
import coursier.util.shaded.org.jsoup.nodes.LeafNode;
import coursier.util.shaded.org.jsoup.nodes.Node;
import coursier.util.shaded.org.jsoup.nodes.TextNode;
import coursier.util.shaded.org.jsoup.parser.HtmlTreeBuilderState;
import coursier.util.shaded.org.jsoup.parser.ParseError;
import coursier.util.shaded.org.jsoup.parser.ParseSettings;
import coursier.util.shaded.org.jsoup.parser.Parser;
import coursier.util.shaded.org.jsoup.parser.Tag;
import coursier.util.shaded.org.jsoup.parser.Token;
import coursier.util.shaded.org.jsoup.parser.TokeniserState;
import coursier.util.shaded.org.jsoup.parser.TreeBuilder;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class HtmlTreeBuilder
extends TreeBuilder {
    static final String[] TagsSearchInScope = new String[]{"applet", "caption", "html", "marquee", "object", "table", "td", "th"};
    static final String[] TagSearchList = new String[]{"ol", "ul"};
    static final String[] TagSearchButton = new String[]{"button"};
    static final String[] TagSearchTableScope = new String[]{"html", "table"};
    static final String[] TagSearchSelectScope = new String[]{"optgroup", "option"};
    static final String[] TagSearchEndTags = new String[]{"dd", "dt", "li", "optgroup", "option", "p", "rp", "rt"};
    static final String[] TagSearchSpecial = new String[]{"address", "applet", "area", "article", "aside", "base", "basefont", "bgsound", "blockquote", "body", "br", "button", "caption", "center", "col", "colgroup", "command", "dd", "details", "dir", "div", "dl", "dt", "embed", "fieldset", "figcaption", "figure", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "iframe", "img", "input", "isindex", "li", "link", "listing", "marquee", "menu", "meta", "nav", "noembed", "noframes", "noscript", "object", "ol", "p", "param", "plaintext", "pre", "script", "section", "select", "style", "summary", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "ul", "wbr", "xmp"};
    private HtmlTreeBuilderState state;
    private HtmlTreeBuilderState originalState;
    private boolean baseUriSetFromDoc;
    private Element headElement;
    private FormElement formElement;
    private Element contextElement;
    private ArrayList<Element> formattingElements;
    private List<String> pendingTableCharacters;
    private Token.EndTag emptyEnd;
    private boolean framesetOk;
    private boolean fosterInserts;
    private boolean fragmentParsing;
    private String[] specificScopeTarget = new String[]{null};

    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.htmlDefault;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initialiseParse(Reader input, String baseUri, Parser parser) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.initialiseParse((Reader)var1_1, (String)var2_2, (Parser)var3_3);
        this.state = HtmlTreeBuilderState.Initial;
        this.originalState = null;
        this.baseUriSetFromDoc = false;
        this.headElement = null;
        this.formElement = null;
        this.contextElement = null;
        this.formattingElements = new ArrayList();
        this.pendingTableCharacters = new ArrayList<String>();
        this.emptyEnd = new Token.EndTag();
        this.framesetOk = true;
        this.fosterInserts = false;
        this.fragmentParsing = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean process(Token token) {
        void var1_1;
        this.currentToken = token;
        return this.state.process((Token)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    boolean process(Token token, HtmlTreeBuilderState state) {
        void var1_1;
        void var2_2;
        this.currentToken = token;
        return var2_2.process((Token)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    void transition(HtmlTreeBuilderState state) {
        void var1_1;
        this.state = var1_1;
    }

    HtmlTreeBuilderState state() {
        return this.state;
    }

    void markInsertionMode() {
        this.originalState = this.state;
    }

    HtmlTreeBuilderState originalState() {
        return this.originalState;
    }

    /*
     * WARNING - void declaration
     */
    void framesetOk(boolean framesetOk) {
        void var1_1;
        this.framesetOk = var1_1;
    }

    boolean framesetOk() {
        return this.framesetOk;
    }

    Document getDocument() {
        return this.doc;
    }

    String getBaseUri() {
        return this.baseUri;
    }

    /*
     * WARNING - void declaration
     */
    void maybeSetBaseUri(Element base) {
        if (this.baseUriSetFromDoc) {
            return;
        }
        String href = base.absUrl("href");
        if (href.length() != 0) {
            void var1_1;
            this.baseUri = href;
            this.baseUriSetFromDoc = true;
            this.doc.setBaseUri((String)var1_1);
        }
    }

    boolean isFragmentParsing() {
        return this.fragmentParsing;
    }

    /*
     * WARNING - void declaration
     */
    void error(HtmlTreeBuilderState state) {
        if (this.parser.getErrors().canAddError()) {
            void var1_1;
            this.parser.getErrors().add(new ParseError(this.reader.pos(), "Unexpected token [%s] when in state [%s]", this.currentToken.tokenType(), var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    Element insert(Token.StartTag startTag) {
        void var2_4;
        void var1_1;
        int n;
        if (startTag.attributes != null && !startTag.attributes.isEmpty() && (n = startTag.attributes.deduplicate(this.settings)) > 0) {
            this.error("Duplicate attribute");
        }
        if (startTag.isSelfClosing()) {
            Element el = this.insertEmpty(startTag);
            this.stack.add(el);
            this.tokeniser.transition(TokeniserState.Data);
            this.tokeniser.emit(this.emptyEnd.reset().name(el.tagName()));
            return el;
        }
        Element el = new Element(Tag.valueOf(startTag.name(), this.settings), null, this.settings.normalizeAttributes(var1_1.attributes));
        this.insert(el);
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    Element insertStartTag(String startTagName) {
        void var1_1;
        Element el = new Element(Tag.valueOf(startTagName, this.settings), null);
        this.insert(el);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void insert(Element el) {
        void var1_1;
        this.insertNode(el);
        this.stack.add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    Element insertEmpty(Token.StartTag startTag) {
        void var3_3;
        void var1_1;
        Tag tag = Tag.valueOf(startTag.name(), this.settings);
        Element el = new Element(tag, null, this.settings.normalizeAttributes(startTag.attributes));
        this.insertNode(el);
        if (var1_1.isSelfClosing()) {
            if (tag.isKnownTag()) {
                if (!tag.isEmpty()) {
                    this.tokeniser.error("Tag cannot be self closing; not a void tag");
                }
            } else {
                void var2_2;
                var2_2.setSelfClosing();
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    FormElement insertForm(Token.StartTag startTag, boolean onStack) {
        void var1_1;
        void var2_2;
        void var3_3;
        Tag tag = Tag.valueOf(startTag.name(), this.settings);
        FormElement el = new FormElement((Tag)var3_3, null, this.settings.normalizeAttributes(startTag.attributes));
        this.setFormElement(el);
        this.insertNode(el);
        if (var2_2 != false) {
            this.stack.add(el);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void insert(Token.Comment commentToken) {
        void var1_1;
        Comment comment = new Comment(commentToken.getData());
        this.insertNode((Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void insert(Token.Character characterToken) {
        void var1_1;
        void var2_2;
        void var3_3;
        Element el = this.currentElement();
        if (el == null) {
            el = this.doc;
        }
        String tagName = el.normalName();
        String data = characterToken.getData();
        LeafNode node = characterToken.isCData() ? new CDataNode(data) : (tagName.equals("script") || var3_3.equals("style") ? new DataNode(data) : new TextNode(data));
        var2_2.appendChild((Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void insertNode(Node node) {
        if (this.stack.isEmpty()) {
            this.doc.appendChild(node);
        } else if (this.isFosterInserts()) {
            this.insertInFosterParent(node);
        } else {
            this.currentElement().appendChild(node);
        }
        if (node instanceof Element && ((Element)node).tag().isFormListed() && this.formElement != null) {
            void var1_1;
            this.formElement.addElement((Element)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    Element pop() {
        void var1_1;
        int size = this.stack.size();
        return (Element)this.stack.remove((int)(var1_1 - true));
    }

    /*
     * WARNING - void declaration
     */
    void push(Element element) {
        void var1_1;
        this.stack.add(var1_1);
    }

    ArrayList<Element> getStack() {
        return this.stack;
    }

    /*
     * WARNING - void declaration
     */
    boolean onStack(Element el) {
        void var1_1;
        HtmlTreeBuilder htmlTreeBuilder = this;
        return htmlTreeBuilder.isElementInQueue(htmlTreeBuilder.stack, (Element)var1_1);
    }

    private boolean isElementInQueue(ArrayList<Element> queue, Element element) {
        for (int pos = queue.size() - 1; pos >= 0; --pos) {
            Element element2 = queue.get(pos);
            if (element2 != element) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    Element getFromStack(String elName) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            void var3_3;
            Element next = (Element)this.stack.get(pos);
            if (!next.normalName().equals(elName)) continue;
            return var3_3;
        }
        return null;
    }

    boolean removeFromStack(Element el) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            Element element = (Element)this.stack.get(pos);
            if (element != el) continue;
            this.stack.remove(pos);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    Element popStackToClose(String elName) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            void var3_3;
            Element el = (Element)this.stack.get(pos);
            this.stack.remove(pos);
            if (!el.normalName().equals(elName)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void popStackToClose(String ... elNames) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            void var3_3;
            Element next = (Element)this.stack.get(pos);
            this.stack.remove(pos);
            if (StringUtil.inSorted(var3_3.normalName(), elNames)) break;
        }
    }

    void popStackToBefore(String elName) {
        Element element;
        for (int pos = this.stack.size() - 1; pos >= 0 && !(element = (Element)this.stack.get(pos)).normalName().equals(elName); --pos) {
            this.stack.remove(pos);
        }
    }

    void clearStackToTableContext() {
        this.clearStackToContext("table");
    }

    void clearStackToTableBodyContext() {
        this.clearStackToContext("tbody", "tfoot", "thead", "template");
    }

    void clearStackToTableRowContext() {
        this.clearStackToContext("tr", "template");
    }

    /*
     * WARNING - void declaration
     */
    private void clearStackToContext(String ... nodeNames) {
        void var3_3;
        Element next;
        for (int pos = this.stack.size() - 1; pos >= 0 && !StringUtil.in((next = (Element)this.stack.get(pos)).normalName(), nodeNames) && !var3_3.normalName().equals("html"); --pos) {
            this.stack.remove(pos);
        }
    }

    Element aboveOnStack(Element el) {
        assert (this.onStack(el));
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            Element element = (Element)this.stack.get(pos);
            if (element != el) continue;
            return (Element)this.stack.get(pos - 1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void insertOnStackAfter(Element after, Element in) {
        void var2_3;
        void var1_2;
        int i = this.stack.lastIndexOf(after);
        Validate.isTrue(i != -1);
        this.stack.add((int)(var1_2 + true), var2_3);
    }

    /*
     * WARNING - void declaration
     */
    void replaceOnStack(Element out, Element in) {
        void var2_2;
        void var1_1;
        HtmlTreeBuilder htmlTreeBuilder = this;
        htmlTreeBuilder.replaceInQueue(htmlTreeBuilder.stack, (Element)var1_1, (Element)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void replaceInQueue(ArrayList<Element> queue, Element out, Element in) {
        void var3_4;
        void var2_3;
        void var1_1;
        int i = queue.lastIndexOf(out);
        Validate.isTrue(i != -1);
        var1_1.set((int)var2_3, var3_4);
    }

    /*
     * WARNING - void declaration
     */
    void resetInsertionMode() {
        boolean last = false;
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            void var3_3;
            String name;
            Element node = (Element)this.stack.get(pos);
            if (pos == 0) {
                last = true;
                node = this.contextElement;
            }
            if ("select".equals(name = node.normalName())) {
                this.transition(HtmlTreeBuilderState.InSelect);
                return;
            }
            if ("td".equals(name) || "th".equals(name) && !last) {
                this.transition(HtmlTreeBuilderState.InCell);
                return;
            }
            if ("tr".equals(name)) {
                this.transition(HtmlTreeBuilderState.InRow);
                return;
            }
            if ("tbody".equals(name) || "thead".equals(name) || "tfoot".equals(name)) {
                this.transition(HtmlTreeBuilderState.InTableBody);
                return;
            }
            if ("caption".equals(name)) {
                this.transition(HtmlTreeBuilderState.InCaption);
                return;
            }
            if ("colgroup".equals(name)) {
                this.transition(HtmlTreeBuilderState.InColumnGroup);
                return;
            }
            if ("table".equals(name)) {
                this.transition(HtmlTreeBuilderState.InTable);
                return;
            }
            if ("head".equals(name)) {
                this.transition(HtmlTreeBuilderState.InBody);
                return;
            }
            if ("body".equals(name)) {
                this.transition(HtmlTreeBuilderState.InBody);
                return;
            }
            if ("frameset".equals(name)) {
                this.transition(HtmlTreeBuilderState.InFrameset);
                return;
            }
            if ("html".equals(var3_3)) {
                this.transition(HtmlTreeBuilderState.BeforeHead);
                return;
            }
            if (!last) continue;
            this.transition(HtmlTreeBuilderState.InBody);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean inSpecificScope(String targetName, String[] baseTypes, String[] extraTypes) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.specificScopeTarget[0] = var1_1;
        HtmlTreeBuilder htmlTreeBuilder = this;
        return htmlTreeBuilder.inSpecificScope(htmlTreeBuilder.specificScopeTarget, (String[])var2_2, (String[])var3_3);
    }

    private boolean inSpecificScope(String[] targetNames, String[] baseTypes, String[] extraTypes) {
        int bottom = this.stack.size() - 1;
        int top = bottom > 100 ? bottom - 100 : 0;
        for (int pos = bottom; pos >= top; --pos) {
            String elName = ((Element)this.stack.get(pos)).normalName();
            if (StringUtil.inSorted(elName, targetNames)) {
                return true;
            }
            if (StringUtil.inSorted(elName, baseTypes)) {
                return false;
            }
            if (extraTypes == null || !StringUtil.inSorted(elName, extraTypes)) continue;
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    boolean inScope(String[] targetNames) {
        void var1_1;
        return this.inSpecificScope((String[])var1_1, TagsSearchInScope, null);
    }

    /*
     * WARNING - void declaration
     */
    boolean inScope(String targetName) {
        void var1_1;
        return this.inScope((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    boolean inScope(String targetName, String[] extras) {
        void var2_2;
        void var1_1;
        return this.inSpecificScope((String)var1_1, TagsSearchInScope, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    boolean inListItemScope(String targetName) {
        void var1_1;
        return this.inScope((String)var1_1, TagSearchList);
    }

    /*
     * WARNING - void declaration
     */
    boolean inButtonScope(String targetName) {
        void var1_1;
        return this.inScope((String)var1_1, TagSearchButton);
    }

    /*
     * WARNING - void declaration
     */
    boolean inTableScope(String targetName) {
        void var1_1;
        return this.inSpecificScope((String)var1_1, TagSearchTableScope, null);
    }

    boolean inSelectScope(String targetName) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            Element element = (Element)this.stack.get(pos);
            String elName = element.normalName();
            if (elName.equals(targetName)) {
                return true;
            }
            if (StringUtil.inSorted((String)((Object)element), TagSearchSelectScope)) continue;
            return false;
        }
        Validate.fail("Should not be reachable");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    void setHeadElement(Element headElement) {
        void var1_1;
        this.headElement = var1_1;
    }

    Element getHeadElement() {
        return this.headElement;
    }

    boolean isFosterInserts() {
        return this.fosterInserts;
    }

    /*
     * WARNING - void declaration
     */
    void setFosterInserts(boolean fosterInserts) {
        void var1_1;
        this.fosterInserts = var1_1;
    }

    FormElement getFormElement() {
        return this.formElement;
    }

    /*
     * WARNING - void declaration
     */
    void setFormElement(FormElement formElement) {
        void var1_1;
        this.formElement = var1_1;
    }

    void newPendingTableCharacters() {
        this.pendingTableCharacters = new ArrayList<String>();
    }

    List<String> getPendingTableCharacters() {
        return this.pendingTableCharacters;
    }

    void generateImpliedEndTags(String excludeTag) {
        while (excludeTag != null && !this.currentElement().normalName().equals(excludeTag) && StringUtil.inSorted(this.currentElement().normalName(), TagSearchEndTags)) {
            this.pop();
        }
    }

    void generateImpliedEndTags() {
        this.generateImpliedEndTags(null);
    }

    boolean isSpecial(Element el) {
        String string = el.normalName();
        return StringUtil.inSorted(string, TagSearchSpecial);
    }

    Element lastFormattingElement() {
        if (this.formattingElements.size() > 0) {
            return this.formattingElements.get(this.formattingElements.size() - 1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Element removeLastFormattingElement() {
        int size = this.formattingElements.size();
        if (size > 0) {
            void var1_1;
            return this.formattingElements.remove((int)(var1_1 - true));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void pushActiveFormattingElements(Element in) {
        void var1_1;
        Element el;
        int numSeen = 0;
        for (int pos = this.formattingElements.size() - 1; pos >= 0 && (el = this.formattingElements.get(pos)) != null; --pos) {
            if (this.isSameFormattingElement(in, el)) {
                ++numSeen;
            }
            if (numSeen != 3) continue;
            this.formattingElements.remove(pos);
            break;
        }
        this.formattingElements.add((Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSameFormattingElement(Element a, Element b) {
        void var2_2;
        void var1_1;
        return a.normalName().equals(b.normalName()) && var1_1.attributes().equals(var2_2.attributes());
    }

    void reconstructFormattingElements() {
        Element entry;
        Element last = this.lastFormattingElement();
        if (last == null || this.onStack(last)) {
            return;
        }
        int size = this.formattingElements.size();
        int pos = size - 1;
        boolean skip = false;
        do {
            if (pos != 0) continue;
            skip = true;
            break;
        } while ((entry = this.formattingElements.get(--pos)) != null && !this.onStack(entry));
        do {
            if (!skip) {
                entry = this.formattingElements.get(++pos);
            }
            Validate.notNull(entry);
            skip = false;
            Element newEl = this.insertStartTag(entry.normalName());
            newEl.attributes().addAll(entry.attributes());
            this.formattingElements.set(pos, newEl);
        } while (pos != size - 1);
    }

    void clearFormattingElementsToLastMarker() {
        Element element;
        while (!this.formattingElements.isEmpty() && (element = this.removeLastFormattingElement()) != null) {
        }
    }

    void removeFromActiveFormattingElements(Element el) {
        for (int pos = this.formattingElements.size() - 1; pos >= 0; --pos) {
            Element element = this.formattingElements.get(pos);
            if (element != el) continue;
            this.formattingElements.remove(pos);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isInActiveFormattingElements(Element el) {
        void var1_1;
        HtmlTreeBuilder htmlTreeBuilder = this;
        return htmlTreeBuilder.isElementInQueue(htmlTreeBuilder.formattingElements, (Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    Element getActiveFormattingElement(String nodeName) {
        Element next;
        for (int pos = this.formattingElements.size() - 1; pos >= 0 && (next = this.formattingElements.get(pos)) != null; --pos) {
            void var3_3;
            if (!next.normalName().equals(nodeName)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void replaceActiveFormattingElement(Element out, Element in) {
        void var2_2;
        void var1_1;
        HtmlTreeBuilder htmlTreeBuilder = this;
        htmlTreeBuilder.replaceInQueue(htmlTreeBuilder.formattingElements, (Element)var1_1, (Element)var2_2);
    }

    void insertMarkerToFormattingElements() {
        this.formattingElements.add(null);
    }

    /*
     * WARNING - void declaration
     */
    void insertInFosterParent(Node in) {
        void var1_1;
        void var2_4;
        Element fosterParent;
        Element lastTable = this.getFromStack("table");
        boolean isLastTableParent = false;
        if (lastTable != null) {
            if (lastTable.parent() != null) {
                lastTable.parent();
                fosterParent = null;
                isLastTableParent = true;
            } else {
                fosterParent = this.aboveOnStack(lastTable);
            }
        } else {
            fosterParent = (Element)this.stack.get(0);
        }
        if (isLastTableParent) {
            void var3_2;
            Validate.notNull(lastTable);
            var3_2.before(in);
            return;
        }
        var2_4.appendChild((Node)var1_1);
    }

    public String toString() {
        return "TreeBuilder{currentToken=" + this.currentToken + ", state=" + (Object)((Object)this.state) + ", currentElement=" + this.currentElement() + '}';
    }
}

