/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.nodes;

import coursier.util.shaded.org.jsoup.SerializationException;
import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.nodes.Attributes;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.NodeUtils;
import coursier.util.shaded.org.jsoup.select.NodeTraversor;
import coursier.util.shaded.org.jsoup.select.NodeVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Node
implements Cloneable {
    Node parentNode;
    int siblingIndex;

    protected Node() {
    }

    public abstract String nodeName();

    protected abstract boolean hasAttributes();

    public boolean hasParent() {
        return this.parentNode != null;
    }

    /*
     * WARNING - void declaration
     */
    public String attr(String attributeKey) {
        Validate.notNull(attributeKey);
        if (!this.hasAttributes()) {
            return "";
        }
        String val = this.attributes().getIgnoreCase(attributeKey);
        if (val.length() > 0) {
            void var2_2;
            return var2_2;
        }
        if (attributeKey.startsWith("abs:")) {
            void var1_1;
            return this.absUrl(var1_1.substring(4));
        }
        return "";
    }

    public abstract Attributes attributes();

    /*
     * WARNING - void declaration
     */
    public Node attr(String attributeKey, String attributeValue) {
        void var2_2;
        void var1_1;
        attributeKey = NodeUtils.parser(this).settings().normalizeAttribute(attributeKey);
        this.attributes().putIgnoreCase((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasAttr(String attributeKey) {
        void var1_1;
        Validate.notNull(attributeKey);
        if (attributeKey.startsWith("abs:")) {
            void var2_2;
            String key = attributeKey.substring(4);
            if (this.attributes().hasKeyIgnoreCase(key) && !this.absUrl((String)var2_2).equals("")) {
                return true;
            }
        }
        return this.attributes().hasKeyIgnoreCase((String)var1_1);
    }

    public abstract String baseUri();

    protected abstract void doSetBaseUri(String var1);

    /*
     * WARNING - void declaration
     */
    public void setBaseUri(String baseUri) {
        void var1_1;
        Validate.notNull(baseUri);
        this.doSetBaseUri((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String absUrl(String attributeKey) {
        void var1_1;
        Validate.notEmpty(attributeKey);
        if (!this.hasAttr(attributeKey)) {
            return "";
        }
        return StringUtil.resolve(this.baseUri(), this.attr((String)var1_1));
    }

    protected abstract List<Node> ensureChildNodes();

    /*
     * WARNING - void declaration
     */
    public Node childNode(int index) {
        void var1_1;
        return this.ensureChildNodes().get((int)var1_1);
    }

    public List<Node> childNodes() {
        return Collections.unmodifiableList(this.ensureChildNodes());
    }

    public abstract int childNodeSize();

    public abstract Node empty();

    public Node parent() {
        return this.parentNode;
    }

    public final Node parentNode() {
        return this.parentNode;
    }

    /*
     * WARNING - void declaration
     */
    public Node root() {
        void var1_1;
        Node node = this;
        while (node.parentNode != null) {
            node = node.parentNode;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Document ownerDocument() {
        Node root = this.root();
        if (root instanceof Document) {
            void var1_1;
            return (Document)var1_1;
        }
        return null;
    }

    public void remove() {
        Validate.notNull(this.parentNode);
        this.parentNode.removeChild(this);
    }

    /*
     * WARNING - void declaration
     */
    public Node before(Node node) {
        void var1_1;
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.addChildren(this.siblingIndex, new Node[]{var1_1});
        return this;
    }

    void nodelistChanged() {
    }

    /*
     * WARNING - void declaration
     */
    public void replaceWith(Node in) {
        void var1_1;
        Validate.notNull(in);
        Validate.notNull(this.parentNode);
        this.parentNode.replaceChild(this, (Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void setParentNode(Node parentNode) {
        void var1_1;
        Validate.notNull(parentNode);
        if (this.parentNode != null) {
            this.parentNode.removeChild(this);
        }
        this.parentNode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void replaceChild(Node out, Node in) {
        void var3_3;
        void var2_2;
        Validate.isTrue(out.parentNode == this);
        Validate.notNull(in);
        if (in.parentNode != null) {
            in.parentNode.removeChild(in);
        }
        int index = out.siblingIndex;
        this.ensureChildNodes().set(index, in);
        in.parentNode = this;
        var2_2.setSiblingIndex((int)var3_3);
        var1_1.parentNode = null;
    }

    /*
     * WARNING - void declaration
     */
    protected void removeChild(Node out) {
        void var2_2;
        Validate.isTrue(out.parentNode == this);
        int index = out.siblingIndex;
        this.ensureChildNodes().remove(index);
        this.reindexChildren((int)var2_2);
        var1_1.parentNode = null;
    }

    /*
     * WARNING - void declaration
     */
    protected void addChildren(int index, Node ... children) {
        void var1_1;
        void var2_2;
        void var3_3;
        Validate.notNull(children);
        if (children.length == 0) {
            return;
        }
        List<Node> nodes = this.ensureChildNodes();
        Node firstParent = children[0].parent();
        if (firstParent != null && firstParent.childNodeSize() == children.length) {
            List<Node> firstParentNodes = firstParent.childNodes();
            int i = children.length;
            while (i-- > 0 && children[i] == firstParentNodes.get(i)) {
            }
            firstParent.empty();
            nodes.addAll(index, Arrays.asList(children));
            i = children.length;
            while (i-- > 0) {
                children[i].parentNode = this;
            }
            this.reindexChildren(index);
            return;
        }
        Validate.noNullElements(children);
        Node[] nodeArray = children;
        int n = children.length;
        for (int i = 0; i < n; ++i) {
            Node child = nodeArray[i];
            this.reparentChild(child);
        }
        var3_3.addAll(index, Arrays.asList(var2_2));
        this.reindexChildren((int)var1_1);
    }

    protected void reparentChild(Node child) {
        child.setParentNode(this);
    }

    /*
     * WARNING - void declaration
     */
    private void reindexChildren(int start) {
        void i;
        List<Node> childNodes = this.ensureChildNodes();
        while (i < childNodes.size()) {
            childNodes.get((int)i).setSiblingIndex((int)i);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Node> siblingNodes() {
        void var2_2;
        Iterator iterator;
        if (this.parentNode == null) {
            return Collections.emptyList();
        }
        List<Node> nodes = this.parentNode.ensureChildNodes();
        ArrayList<void> siblings = new ArrayList<void>(nodes.size() - 1);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Node node = (Node)iterator.next();
            if (node == this) continue;
            siblings.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Node nextSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Node> siblings = this.parentNode.ensureChildNodes();
        int index = this.siblingIndex + 1;
        if (siblings.size() > index) {
            void var2_2;
            void var1_1;
            return (Node)var1_1.get((int)var2_2);
        }
        return null;
    }

    public Node previousSibling() {
        if (this.parentNode == null) {
            return null;
        }
        if (this.siblingIndex > 0) {
            return this.parentNode.ensureChildNodes().get(this.siblingIndex - 1);
        }
        return null;
    }

    public int siblingIndex() {
        return this.siblingIndex;
    }

    /*
     * WARNING - void declaration
     */
    protected void setSiblingIndex(int siblingIndex) {
        void var1_1;
        this.siblingIndex = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String outerHtml() {
        void var1_1;
        StringBuilder accum2 = StringUtil.borrowBuilder();
        this.outerHtml(accum2);
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void outerHtml(Appendable accum2) {
        void var1_1;
        NodeTraversor.traverse(new OuterHtmlVisitor((Appendable)var1_1, NodeUtils.outputSettings(this)), this);
    }

    abstract void outerHtmlHead(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    abstract void outerHtmlTail(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    /*
     * WARNING - void declaration
     */
    public <T extends Appendable> T html(T appendable) {
        void var1_1;
        this.outerHtml(appendable);
        return var1_1;
    }

    public String toString() {
        return this.outerHtml();
    }

    /*
     * WARNING - void declaration
     */
    protected void indent(Appendable accum2, int depth, Document.OutputSettings out) throws IOException {
        void var3_3;
        void var2_2;
        accum2.append('\n').append(StringUtil.padding((int)(var2_2 * var3_3.indentAmount())));
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        return this == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Node clone() {
        void var1_1;
        Node thisClone = this.doClone(null);
        LinkedList<Node> nodesToProcess = new LinkedList<Node>();
        nodesToProcess.add(thisClone);
        while (!nodesToProcess.isEmpty()) {
            Node currParent = (Node)nodesToProcess.remove();
            int size = currParent.childNodeSize();
            for (int i = 0; i < size; ++i) {
                List<Node> childNodes = currParent.ensureChildNodes();
                Node childClone = childNodes.get(i).doClone(currParent);
                childNodes.set(i, childClone);
                nodesToProcess.add(childClone);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Node doClone(Node parent) {
        void var2_3;
        void var1_1;
        try {
            Node clone = (Node)super.clone();
        }
        catch (CloneNotSupportedException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
        clone.parentNode = var1_1;
        clone.siblingIndex = var1_1 == null ? 0 : this.siblingIndex;
        return var2_3;
    }

    private static class OuterHtmlVisitor
    implements NodeVisitor {
        private Appendable accum;
        private Document.OutputSettings out;

        /*
         * WARNING - void declaration
         */
        OuterHtmlVisitor(Appendable accum2, Document.OutputSettings out) {
            void var2_2;
            void var1_1;
            this.accum = var1_1;
            this.out = out;
            var2_2.prepareEncoder();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void head(Node node, int depth) {
            try {
                void var2_3;
                node.outerHtmlHead(this.accum, (int)var2_3, this.out);
                return;
            }
            catch (IOException exception) {
                void var1_2;
                throw new SerializationException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void tail(Node node, int depth) {
            if (!node.nodeName().equals("#text")) {
                try {
                    void var2_3;
                    node.outerHtmlTail(this.accum, (int)var2_3, this.out);
                    return;
                }
                catch (IOException exception) {
                    void var1_2;
                    throw new SerializationException((Throwable)var1_2);
                }
            }
        }
    }
}

