/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.nodes;

import coursier.util.shaded.org.jsoup.helper.ChangeNotifyingArrayList;
import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.nodes.Attributes;
import coursier.util.shaded.org.jsoup.nodes.CDataNode;
import coursier.util.shaded.org.jsoup.nodes.Comment;
import coursier.util.shaded.org.jsoup.nodes.DataNode;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.Node;
import coursier.util.shaded.org.jsoup.nodes.NodeUtils;
import coursier.util.shaded.org.jsoup.nodes.TextNode;
import coursier.util.shaded.org.jsoup.parser.Tag;
import coursier.util.shaded.org.jsoup.select.Collector;
import coursier.util.shaded.org.jsoup.select.Elements;
import coursier.util.shaded.org.jsoup.select.Evaluator;
import coursier.util.shaded.org.jsoup.select.NodeTraversor;
import coursier.util.shaded.org.jsoup.select.NodeVisitor;
import coursier.util.shaded.org.jsoup.select.Selector;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class Element
extends Node {
    private static final List<Node> EMPTY_NODES = Collections.emptyList();
    private static final Pattern classSplit = Pattern.compile("\\s+");
    private static final String baseUriKey = Attributes.internalKey("baseUri");
    private Tag tag;
    private WeakReference<List<Element>> shadowChildrenRef;
    List<Node> childNodes;
    private Attributes attributes;

    /*
     * WARNING - void declaration
     */
    public Element(Tag tag, String baseUri, Attributes attributes) {
        void var1_1;
        void var3_3;
        Validate.notNull(tag);
        this.childNodes = EMPTY_NODES;
        this.attributes = var3_3;
        this.tag = var1_1;
        if (baseUri != null) {
            void var2_2;
            this.setBaseUri((String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Element(Tag tag, String baseUri) {
        this((Tag)var1_1, (String)var2_2, null);
        void var2_2;
        void var1_1;
    }

    @Override
    protected List<Node> ensureChildNodes() {
        if (this.childNodes == EMPTY_NODES) {
            this.childNodes = new NodeList(this, 4);
        }
        return this.childNodes;
    }

    @Override
    protected boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public Attributes attributes() {
        if (!this.hasAttributes()) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public String baseUri() {
        return Element.searchUpForAttribute(this, baseUriKey);
    }

    private static String searchUpForAttribute(Element start, String key) {
        for (Element el = start; el != null; el = el.parent()) {
            if (!el.hasAttributes() || !el.attributes.hasKey(key)) continue;
            return el.attributes.get(key);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doSetBaseUri(String baseUri) {
        void var1_1;
        this.attributes().put(baseUriKey, (String)var1_1);
    }

    @Override
    public int childNodeSize() {
        return this.childNodes.size();
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    public String normalName() {
        return this.tag.normalName();
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        if (this.hasAttributes()) {
            return this.attributes.getIgnoreCase("id");
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element attr(String attributeKey, String attributeValue) {
        void var2_2;
        void var1_1;
        super.attr((String)var1_1, (String)var2_2);
        return this;
    }

    @Override
    public final Element parent() {
        return (Element)this.parentNode;
    }

    /*
     * WARNING - void declaration
     */
    public Element child(int index) {
        void var1_1;
        return this.childElementsList().get((int)var1_1);
    }

    public Elements children() {
        return new Elements(this.childElementsList());
    }

    /*
     * WARNING - void declaration
     */
    private List<Element> childElementsList() {
        void var1_1;
        ArrayList<Element> children;
        if (this.shadowChildrenRef == null || (children = (ArrayList<Element>)this.shadowChildrenRef.get()) == null) {
            int size = this.childNodes.size();
            children = new ArrayList<Element>(size);
            for (int i = 0; i < size; ++i) {
                Node node = this.childNodes.get(i);
                if (!(node instanceof Element)) continue;
                children.add((Element)node);
            }
            this.shadowChildrenRef = new WeakReference(children);
        }
        return var1_1;
    }

    @Override
    void nodelistChanged() {
        super.nodelistChanged();
        this.shadowChildrenRef = null;
    }

    /*
     * WARNING - void declaration
     */
    public List<TextNode> textNodes() {
        void var1_1;
        ArrayList<TextNode> textNodes = new ArrayList<TextNode>();
        for (Node node : this.childNodes) {
            void var3_3;
            if (!(node instanceof TextNode)) continue;
            textNodes.add((TextNode)var3_3);
        }
        return Collections.unmodifiableList(var1_1);
    }

    public Elements select(String cssQuery) {
        return Selector.select(cssQuery, this);
    }

    public Element selectFirst(String cssQuery) {
        return Selector.selectFirst(cssQuery, this);
    }

    /*
     * WARNING - void declaration
     */
    public Element appendChild(Node child) {
        void var1_1;
        Validate.notNull(child);
        this.reparentChild(child);
        this.ensureChildNodes();
        this.childNodes.add(child);
        var1_1.setSiblingIndex(this.childNodes.size() - 1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element before(Node node) {
        void var1_1;
        return (Element)super.before((Node)var1_1);
    }

    @Override
    public Element empty() {
        this.childNodes.clear();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Elements siblingElements() {
        void var2_2;
        Iterator iterator;
        if (this.parentNode == null) {
            return new Elements(0);
        }
        List<Element> elements = this.parent().childElementsList();
        Elements siblings = new Elements(elements.size() - 1);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Element el = (Element)iterator.next();
            if (el == this) continue;
            siblings.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Element previousElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Element> siblings = this.parent().childElementsList();
        int index = Element.indexInList(this, siblings);
        if (index > 0) {
            void var2_2;
            void var1_1;
            return (Element)var1_1.get((int)(var2_2 - true));
        }
        return null;
    }

    public int elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        Element element = this;
        return Element.indexInList(element, element.parent().childElementsList());
    }

    private static <E extends Element> int indexInList(Element search, List<E> elements) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            if (elements.get(i) != search) continue;
            return i;
        }
        return 0;
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    /*
     * WARNING - void declaration
     */
    public String text() {
        void var1_1;
        StringBuilder accum2 = StringUtil.borrowBuilder();
        NodeTraversor.traverse(new NodeVisitor(this, accum2){
            final /* synthetic */ StringBuilder val$accum;
            final /* synthetic */ Element this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$accum = stringBuilder;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void head(Node node, int depth) {
                TextNode textNode;
                if (node instanceof TextNode) {
                    textNode = (TextNode)node;
                    Element.access$000(this.val$accum, textNode);
                    return;
                }
                if (textNode instanceof Element) {
                    void var1_1;
                    Element element = (Element)((Object)textNode);
                    if (this.val$accum.length() > 0 && (element.isBlock() || ((Element)var1_1).tag.getName().equals("br")) && !TextNode.lastCharIsWhitespace(this.val$accum)) {
                        this.val$accum.append(' ');
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void tail(Node node, int depth) {
                void var1_1;
                Element element;
                if (node instanceof Element && (element = (Element)node).isBlock() && var1_1.nextSibling() instanceof TextNode && !TextNode.lastCharIsWhitespace(this.val$accum)) {
                    this.val$accum.append(' ');
                }
            }
        }, this);
        return StringUtil.releaseBuilder((StringBuilder)var1_1).trim();
    }

    /*
     * WARNING - void declaration
     */
    public String ownText() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        this.ownText(sb);
        return StringUtil.releaseBuilder((StringBuilder)var1_1).trim();
    }

    /*
     * WARNING - void declaration
     */
    private void ownText(StringBuilder accum2) {
        for (Node child : this.childNodes) {
            void var3_3;
            if (child instanceof TextNode) {
                TextNode textNode = (TextNode)child;
                Element.appendNormalisedText(accum2, (TextNode)var3_3);
                continue;
            }
            if (!(var3_3 instanceof Element)) continue;
            Element.appendWhitespaceIfBr((Element)var3_3, accum2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendNormalisedText(StringBuilder accum2, TextNode textNode) {
        StringBuilder stringBuilder;
        void var2_2;
        void var1_1;
        String text2 = textNode.getWholeText();
        if (Element.preserveWhitespace(textNode.parentNode) || var1_1 instanceof CDataNode) {
            accum2.append(text2);
            return;
        }
        StringUtil.appendNormalisedWhitespace(accum2, (String)var2_2, TextNode.lastCharIsWhitespace(stringBuilder));
    }

    /*
     * WARNING - void declaration
     */
    private static void appendWhitespaceIfBr(Element element, StringBuilder accum2) {
        if (element.tag.getName().equals("br") && !TextNode.lastCharIsWhitespace(accum2)) {
            void var1_1;
            var1_1.append(" ");
        }
    }

    static boolean preserveWhitespace(Node node) {
        if (node instanceof Element) {
            Node el = (Element)node;
            int i = 0;
            do {
                if (((Element)el).tag.preserveWhitespace()) {
                    return true;
                }
                el = ((Element)el).parent();
            } while (++i < 6 && el != null);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String data() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        for (Node childNode : this.childNodes) {
            void var3_3;
            String elementData;
            Node comment;
            DataNode data;
            if (childNode instanceof DataNode) {
                data = (DataNode)childNode;
                sb.append(data.getWholeData());
                continue;
            }
            if (data instanceof Comment) {
                comment = (Comment)((Object)data);
                sb.append(comment.getData());
                continue;
            }
            if (comment instanceof Element) {
                comment = (Element)comment;
                elementData = ((Element)comment).data();
                sb.append(elementData);
                continue;
            }
            if (!(elementData instanceof CDataNode)) continue;
            CDataNode cDataNode = (CDataNode)((Object)elementData);
            sb.append(var3_3.getWholeText());
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasClass(String className) {
        void var3_3;
        if (!this.hasAttributes()) {
            return false;
        }
        String classAttr = this.attributes.getIgnoreCase("class");
        int len = classAttr.length();
        int wantLen = className.length();
        if (len == 0 || len < wantLen) {
            return false;
        }
        if (len == wantLen) {
            return className.equalsIgnoreCase(classAttr);
        }
        boolean inClass = false;
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(classAttr.charAt(i))) {
                if (!inClass) continue;
                if (i - start == wantLen && classAttr.regionMatches(true, start, className, 0, wantLen)) {
                    return true;
                }
                inClass = false;
                continue;
            }
            if (inClass) continue;
            inClass = true;
            start = i;
        }
        if (inClass && var3_3 - start == wantLen) {
            void var1_1;
            void var2_2;
            return var2_2.regionMatches(true, start, (String)var1_1, 0, wantLen);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void outerHtmlHead(Appendable accum2, int depth, Document.OutputSettings out) throws IOException {
        void var1_1;
        if (out.prettyPrint() && this.isFormatAsBlock(out) && !this.isInlineable(out) && (!(accum2 instanceof StringBuilder) || ((StringBuilder)accum2).length() > 0)) {
            void var2_2;
            this.indent(accum2, (int)var2_2, out);
        }
        accum2.append('<').append(this.tagName());
        if (this.attributes != null) {
            this.attributes.html(accum2, out);
        }
        if (this.childNodes.isEmpty() && this.tag.isSelfClosing()) {
            void var3_3;
            if (var3_3.syntax() == Document.OutputSettings.Syntax.html && this.tag.isEmpty()) {
                accum2.append('>');
                return;
            }
            accum2.append(" />");
            return;
        }
        var1_1.append('>');
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void outerHtmlTail(Appendable accum2, int depth, Document.OutputSettings out) throws IOException {
        if (!this.childNodes.isEmpty() || !this.tag.isSelfClosing()) {
            void var1_1;
            if (out.prettyPrint() && !this.childNodes.isEmpty() && (this.tag.formatAsBlock() || out.outline() && (this.childNodes.size() > 1 || this.childNodes.size() == 1 && !(this.childNodes.get(0) instanceof TextNode)))) {
                void var3_3;
                void var2_2;
                this.indent(accum2, (int)var2_2, (Document.OutputSettings)var3_3);
            }
            var1_1.append("</").append(this.tagName()).append('>');
        }
    }

    /*
     * WARNING - void declaration
     */
    public String html() {
        void var1_1;
        StringBuilder accum2 = StringUtil.borrowBuilder();
        this.html(accum2);
        String html = StringUtil.releaseBuilder(accum2);
        if (NodeUtils.outputSettings(this).prettyPrint()) {
            return html.trim();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Appendable> T html(T appendable) {
        void var1_1;
        int size = this.childNodes.size();
        for (int i = 0; i < size; ++i) {
            this.childNodes.get(i).outerHtml(appendable);
        }
        return var1_1;
    }

    @Override
    public Element clone() {
        return (Element)super.clone();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Element doClone(Node parent) {
        void var1_1;
        Element clone = (Element)super.doClone(parent);
        ((Element)super.doClone(parent)).attributes = this.attributes != null ? this.attributes.clone() : null;
        clone.childNodes = new NodeList(clone, this.childNodes.size());
        clone.childNodes.addAll(this.childNodes);
        clone.setBaseUri(this.baseUri());
        return var1_1;
    }

    @Override
    public Element root() {
        return (Element)super.root();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFormatAsBlock(Document.OutputSettings out) {
        void var1_1;
        return this.tag.formatAsBlock() || this.parent() != null && this.parent().tag().formatAsBlock() || var1_1.outline();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInlineable(Document.OutputSettings out) {
        void var1_1;
        return this.tag().isInline() && !this.tag().isEmpty() && this.parent().isBlock() && this.previousSibling() != null && !var1_1.outline();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(StringBuilder x0, TextNode x1) {
        void var1_1;
        Element.appendNormalisedText(x0, (TextNode)var1_1);
    }

    private static final class NodeList
    extends ChangeNotifyingArrayList<Node> {
        private final Element owner;

        /*
         * WARNING - void declaration
         */
        NodeList(Element owner, int initialCapacity) {
            super((int)var2_2);
            void var1_1;
            void var2_2;
            this.owner = var1_1;
        }

        @Override
        public final void onContentsChanged() {
            this.owner.nodelistChanged();
        }
    }
}

