/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.nodes;

import coursier.util.shaded.org.jsoup.SerializationException;
import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.internal.Normalizer;
import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.nodes.Attribute;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.Entities;
import coursier.util.shaded.org.jsoup.parser.ParseSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Attributes
implements Cloneable,
Iterable<Attribute> {
    private static final String[] Empty = new String[0];
    private int size = 0;
    String[] keys = Empty;
    String[] vals = Empty;

    /*
     * WARNING - void declaration
     */
    private void checkCapacity(int minNewSize) {
        void var2_2;
        int newSize;
        Validate.isTrue(minNewSize >= this.size);
        int curSize = this.keys.length;
        if (curSize >= minNewSize) {
            return;
        }
        int n = newSize = curSize >= 2 ? this.size << 1 : 2;
        if (minNewSize > newSize) {
            void var1_1;
            newSize = var1_1;
        }
        this.keys = Attributes.copyOf(this.keys, newSize);
        this.vals = Attributes.copyOf(this.vals, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] copyOf(String[] orig, int size) {
        void var2_2;
        void var1_1;
        String[] stringArray;
        String[] copy = new String[size];
        System.arraycopy(orig, 0, copy, 0, Math.min(stringArray.length, (int)var1_1));
        return var2_2;
    }

    int indexOfKey(String key) {
        Validate.notNull(key);
        for (int i = 0; i < this.size; ++i) {
            if (!key.equals(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    private int indexOfKeyIgnoreCase(String key) {
        Validate.notNull(key);
        for (int i = 0; i < this.size; ++i) {
            if (!key.equalsIgnoreCase(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    static String checkNotNull(String val) {
        String string;
        if (val == null) {
            return "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String get(String key) {
        void var1_2;
        int i = this.indexOfKey(key);
        if (i == -1) {
            return "";
        }
        return Attributes.checkNotNull(this.vals[var1_2]);
    }

    /*
     * WARNING - void declaration
     */
    public String getIgnoreCase(String key) {
        void var1_2;
        int i = this.indexOfKeyIgnoreCase(key);
        if (i == -1) {
            return "";
        }
        return Attributes.checkNotNull(this.vals[var1_2]);
    }

    /*
     * WARNING - void declaration
     */
    public Attributes add(String key, String value) {
        void var2_2;
        void var1_1;
        Attributes attributes = this;
        attributes.checkCapacity(attributes.size + 1);
        this.keys[this.size] = var1_1;
        this.vals[this.size] = var2_2;
        ++this.size;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Attributes put(String key, String value) {
        Validate.notNull(key);
        int i = this.indexOfKey(key);
        if (i != -1) {
            this.vals[var3_3] = value;
        } else {
            void var2_2;
            void var1_1;
            this.add((String)var1_1, (String)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    void putIgnoreCase(String key, String value) {
        int i = this.indexOfKeyIgnoreCase(key);
        if (i != -1) {
            this.vals[i] = value;
            if (!this.keys[i].equals(key)) {
                this.keys[var3_3] = key;
                return;
            }
        } else {
            void var2_2;
            void var1_1;
            this.add((String)var1_1, (String)var2_2);
        }
    }

    public Attributes put(Attribute attribute) {
        Validate.notNull(attribute);
        this.put(attribute.getKey(), attribute.getValue());
        var1_1.parent = this;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void remove(int index) {
        Validate.isFalse(index >= this.size);
        int shifted = this.size - index - 1;
        if (shifted > 0) {
            void var2_2;
            void var1_1;
            System.arraycopy(this.keys, index + 1, this.keys, index, shifted);
            System.arraycopy(this.vals, index + 1, this.vals, (int)var1_1, (int)var2_2);
        }
        --this.size;
        this.keys[this.size] = null;
        this.vals[this.size] = null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasKey(String key) {
        void var1_1;
        return this.indexOfKey((String)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasKeyIgnoreCase(String key) {
        void var1_1;
        return this.indexOfKeyIgnoreCase((String)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public int size() {
        void var1_1;
        int s = 0;
        for (int i = 0; i < this.size; ++i) {
            Attributes attributes = this;
            if (attributes.isInternalKey(attributes.keys[i])) continue;
            ++s;
        }
        return (int)var1_1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - void declaration
     */
    public void addAll(Attributes incoming) {
        Iterator<Attribute> iterator;
        if (incoming.size() == 0) {
            return;
        }
        Attributes attributes = this;
        attributes.checkCapacity(attributes.size + incoming.size);
        iterator = ((Attributes)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Attribute attr = iterator.next();
            this.put((Attribute)var2_2);
        }
    }

    @Override
    public Iterator<Attribute> iterator() {
        return new Iterator<Attribute>(this){
            int i = 0;
            final /* synthetic */ Attributes this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public boolean hasNext() {
                while (this.i < this.this$0.size && Attributes.access$100(this.this$0, this.this$0.keys[this.i])) {
                    ++this.i;
                }
                return this.i < this.this$0.size;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Attribute next() {
                void var1_1;
                Attribute attr = new Attribute(this.this$0.keys[this.i], this.this$0.vals[this.i], this.this$0);
                ++this.i;
                return var1_1;
            }

            @Override
            public void remove() {
                Attributes.access$200(this.this$0, --this.i);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public List<Attribute> asList() {
        void var1_1;
        ArrayList<void> list = new ArrayList<void>(this.size);
        for (int i = 0; i < this.size; ++i) {
            void var3_3;
            Attributes attributes = this;
            if (attributes.isInternalKey(attributes.keys[i])) continue;
            Attribute attr = new Attribute(this.keys[i], this.vals[i], this);
            list.add(var3_3);
        }
        return Collections.unmodifiableList(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String html() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        try {
            this.html(sb, new Document("").outputSettings());
        }
        catch (IOException e) {
            void var1_2;
            throw new SerializationException((Throwable)var1_2);
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    final void html(Appendable accum2, Document.OutputSettings out) throws IOException {
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            Attributes attributes = this;
            if (attributes.isInternalKey(attributes.keys[i])) continue;
            String key = this.keys[i];
            String val = this.vals[i];
            accum2.append(' ').append(key);
            if (Attribute.shouldCollapseAttribute(key, val, out)) continue;
            accum2.append("=\"");
            Entities.escape(accum2, val == null ? "" : val, out, true, false, false);
            accum2.append('\"');
        }
    }

    public String toString() {
        return this.html();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attributes that = (Attributes)o;
        if (this.size != that.size) {
            return false;
        }
        if (!Arrays.equals(this.keys, that.keys)) {
            return false;
        }
        return Arrays.equals(this.vals, var1_1.vals);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.size;
        result = result * 31 + Arrays.hashCode(this.keys);
        var1_1 = var1_1 * 31 + Arrays.hashCode(this.vals);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Attributes clone() {
        void var1_1;
        try {
            Attributes clone = (Attributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.size = this.size;
        this.keys = Attributes.copyOf(this.keys, this.size);
        this.vals = Attributes.copyOf(this.vals, this.size);
        return var1_1;
    }

    public void normalize() {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = Normalizer.lowerCase(this.keys[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public int deduplicate(ParseSettings settings) {
        void var2_3;
        if (this.isEmpty()) {
            return 0;
        }
        boolean preserve = settings.preserveAttributeCase();
        int dupes = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            for (int j = i + 1; j < this.keys.length && this.keys[j] != null; ++j) {
                if ((!preserve || !this.keys[i].equals(this.keys[j])) && (preserve || !this.keys[i].equalsIgnoreCase(this.keys[j]))) continue;
                ++dupes;
                this.remove(j);
                --j;
            }
        }
        return (int)var2_3;
    }

    static String internalKey(String key) {
        String string;
        return "/" + string;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInternalKey(String key) {
        void var1_1;
        return key != null && key.length() > 1 && var1_1.charAt(0) == '/';
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$100(Attributes x0, String x1) {
        void var1_1;
        return x0.isInternalKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Attributes x0, int x1) {
        void var1_1;
        x0.remove((int)var1_1);
    }
}

