/*
 * Decompiled with CFR 0.152.
 */
package coursier.paths;

import coursier.cache.shaded.dirs.dev.dirs.ProjectDirectories;
import coursier.paths.Util;
import java.io.File;
import java.io.IOException;

public final class CoursierPaths {
    private static final Object coursierDirectoriesLock = new Object();
    private static ProjectDirectories coursierDirectories0;
    private static final Object cacheDirectoryLock;
    private static volatile File cacheDirectory0;
    private static volatile File jvmCacheDirectory0;
    private static final Object configDirectoryLock;
    private static volatile File[] configDirectories0;
    private static final Object dataLocalDirectoryLock;
    private static volatile File dataLocalDirectory0;

    private static String computeCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_CACHE", "coursier.cache", "v1");
    }

    private static String computeCacheDirectory(String object, String string, String string2) throws IOException {
        if ((object = System.getenv((String)object)) == null) {
            object = System.getProperty(string);
        }
        if (object != null) {
            return object;
        }
        object = new File(CoursierPaths.coursierDirectories().cacheDir);
        object = new File((File)object, string2);
        Util.createDirectories(((File)object).toPath());
        return ((File)object).getAbsolutePath();
    }

    public static File cacheDirectory() throws IOException {
        if (cacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (cacheDirectory0 == null) {
                    cacheDirectory0 = new File(CoursierPaths.computeCacheDirectory()).getAbsoluteFile();
                }
            }
        }
        return cacheDirectory0;
    }

    private static ProjectDirectories coursierDirectories() throws IOException {
        if (coursierDirectories0 == null) {
            Object object = coursierDirectoriesLock;
            synchronized (object) {
                if (coursierDirectories0 == null) {
                    coursierDirectories0 = ProjectDirectories.from(null, null, "Coursier");
                }
            }
        }
        return coursierDirectories0;
    }

    private static File[] computeConfigDirectories() throws IOException {
        String string = System.getenv("COURSIER_CONFIG_DIR");
        if (string == null) {
            string = System.getProperty("coursier.config-dir");
        }
        if (string != null) {
            return new File[]{new File(string).getAbsoluteFile()};
        }
        string = CoursierPaths.coursierDirectories().configDir;
        String string2 = CoursierPaths.coursierDirectories().preferenceDir;
        if (string.equals(string2)) {
            return new File[]{new File(string).getAbsoluteFile()};
        }
        return new File[]{new File(string).getAbsoluteFile(), new File(string2).getAbsoluteFile()};
    }

    public static File[] configDirectories() throws IOException {
        if (configDirectories0 == null) {
            Object object = configDirectoryLock;
            synchronized (object) {
                if (configDirectories0 == null) {
                    configDirectories0 = CoursierPaths.computeConfigDirectories();
                }
            }
        }
        return (File[])configDirectories0.clone();
    }

    static {
        cacheDirectoryLock = new Object();
        cacheDirectory0 = null;
        jvmCacheDirectory0 = null;
        configDirectoryLock = new Object();
        configDirectories0 = null;
        dataLocalDirectoryLock = new Object();
        dataLocalDirectory0 = null;
    }
}

