/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache.internal;

import coursier.cache.ArtifactError;
import coursier.cache.ArtifactError$NotFound$;
import coursier.cache.CacheLocks$;
import coursier.cache.CacheLogger;
import coursier.cache.CachePolicy;
import coursier.cache.CacheUrl$;
import coursier.cache.ConnectionBuilder$;
import coursier.cache.internal.Downloader;
import coursier.core.Authentication;
import coursier.credentials.DirectCredentials;
import coursier.util.Artifact;
import coursier.util.Sync;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class Downloader$
implements Serializable {
    public static final Downloader$ MODULE$ = new Downloader$();
    private static final Seq<String> coursier$cache$internal$Downloader$$checksumHeader = new $colon$colon<Nothing$>((Nothing$)((Object)"MD5"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"SHA1"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"SHA256"), Nil$.MODULE$)));

    public final Seq<String> coursier$cache$internal$Downloader$$checksumHeader() {
        return coursier$cache$internal$Downloader$$checksumHeader;
    }

    /*
     * WARNING - void declaration
     */
    public final void coursier$cache$internal$Downloader$$readFullyTo(InputStream in, OutputStream out, CacheLogger logger, String url, long alreadyDownloaded, int bufferSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] b = (byte[])Array$.MODULE$.fill(bufferSize, () -> 0, ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, (InputStream)var1_1, b, (OutputStream)var2_2, (CacheLogger)var3_3, url);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> Either<ArtifactError, T> coursier$cache$internal$Downloader$$downloading(String url, File file, int sslRetry, Function0<Either<ArtifactError, T>> f) {
        void var1_1;
        void var3_3;
        return this.helper$2((int)var3_3, (String)var1_1, f);
    }

    /*
     * WARNING - void declaration
     */
    public final Either<ArtifactError, Option<Object>> coursier$cache$internal$Downloader$$contentLength(String url, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, CacheLogger logger, Option<Object> maxRedirectionsOpt) {
        Left<ArtifactError, Option<Object>> left;
        URLConnection conn = null;
        try {
            Left<ArtifactError, Option<Object>> left2;
            void var2_3;
            conn = ConnectionBuilder$.MODULE$.apply((String)url).withAuthentication((Option<Authentication>)authentication).withFollowHttpToHttpsRedirections(followHttpToHttpsRedirections).withFollowHttpsToHttpRedirections(followHttpsToHttpRedirections).withAutoCredentials(credentials).withSslSocketFactoryOpt(sslSocketFactoryOpt).withHostnameVerifierOpt(hostnameVerifierOpt).withMethod("HEAD").withMaxRedirectionsOpt(maxRedirectionsOpt).connection();
            authentication = conn;
            if (conn instanceof HttpURLConnection) {
                Right right;
                authentication = (HttpURLConnection)authentication;
                logger.gettingLength((String)url);
                boolean success = false;
                try {
                    Option<Object> len = new Some<Long>(BoxesRunTime.boxToLong(((URLConnection)authentication).getContentLengthLong())).filter(x$26 -> x$26 >= 0L);
                    success = true;
                    logger.gettingLengthResult((String)url, len);
                    right = package$.MODULE$.Right().apply(var2_3);
                }
                catch (Throwable throwable) {
                    void var3_5;
                    if (var3_5 == false) {
                        logger.gettingLengthResult((String)url, None$.MODULE$);
                    }
                    throw throwable;
                }
                url = right;
            } else {
                left2 = package$.MODULE$.Left().apply(new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(var2_3).append(" (").append((String)((Object)left2)).append(")").toString(), None$.MODULE$));
            }
            left = left2;
        }
        catch (Throwable throwable) {
            if (conn != null) {
                CacheUrl$.MODULE$.closeConn(conn);
            }
            throw throwable;
        }
        if (conn != null) {
            CacheUrl$.MODULE$.closeConn(conn);
        }
        return left;
    }

    /*
     * WARNING - void declaration
     */
    public final <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Sync<F> S) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new Downloader<F>((Artifact)var1_1, (CachePolicy)var2_2, (File)var3_3, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, S);
    }

    private final void helper$1(long count, InputStream in$1, byte[] b$1, OutputStream out$1, CacheLogger logger$2, String url$9) {
        int read;
        while ((read = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read);
            out$1.flush();
            logger$2.downloadProgress(url$9, count + (long)read);
            count += (long)read;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Either helper$2(int retry2, String url$10, Function0 f$1) {
        void var1_2;
        Some<Serializable> some;
        block8: {
            while (true) {
                Some<Throwable> some2;
                Serializable res;
                try {
                    some = CacheLocks$.MODULE$.withUrlLock(url$10, (Function0<Either> & Serializable)() -> {
                        try {
                            return (Either)f$1.apply();
                        }
                        catch (Throwable throwable) {
                            Left left = throwable;
                            Throwable throwable2 = throwable;
                            if (!(throwable instanceof FileNotFoundException) || (throwable2 = (FileNotFoundException)throwable2).getMessage() == null) {
                                throw left;
                            }
                            left = package$.MODULE$.Left().apply(new ArtifactError.NotFound(throwable2.getMessage(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
                            return left;
                        }
                    });
                    res = (Either)some.getOrElse((Function0<Left> & Serializable)() -> {
                        String string;
                        return package$.MODULE$.Left().apply(new ArtifactError.ConcurrentDownload(string));
                    });
                    some2 = new Some<Throwable>((Throwable)res);
                }
                catch (Throwable throwable) {
                    res = throwable;
                    Serializable serializable = throwable;
                    if (throwable instanceof SSLException && retry2 > 0) {
                        res = None$.MODULE$;
                    } else if (!((Option)(serializable = NonFatal$.MODULE$.unapply((Throwable)serializable))).isEmpty()) {
                        Throwable e = (Throwable)((Option)serializable).get();
                        ArtifactError.DownloadError ex = new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e).append(Option$.MODULE$.apply(e.getMessage()).fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)x$25 -> {
                            String string;
                            return new StringBuilder(3).append(" (").append(string).append(")").toString();
                        })).append(" while downloading ").append(url$10).toString(), new Some<Throwable>(e));
                        if (Boolean.getBoolean("coursier.cache.throw-exceptions")) {
                            throw ex;
                        }
                        some = new Some(package$.MODULE$.Left().apply(ex));
                    } else {
                        throw some;
                    }
                    some2 = some;
                }
                some = some2;
                some = some2;
                if (some2 instanceof Some) break block8;
                if (!None$.MODULE$.equals(some)) break;
                --retry2;
            }
            throw new MatchError(some);
        }
        Product retry2 = some;
        retry2 = (Either)((Object)retry2.value());
        return var1_2;
    }

    private Downloader$() {
    }
}

