/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.CacheChecksum$;
import coursier.cache.CacheLogger;
import coursier.cache.CachePolicy;
import coursier.cache.FileCache$;
import coursier.cache.internal.DownloadResult;
import coursier.cache.internal.Downloader$;
import coursier.core.Authentication;
import coursier.credentials.Credentials;
import coursier.credentials.DirectCredentials;
import coursier.util.Artifact;
import coursier.util.EitherT;
import coursier.util.Monad$ops$;
import coursier.util.Sync;
import coursier.util.WebPage$;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.duration.Duration;
import scala.math.Ordering$String$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class FileCache<F>
extends Cache<F>
implements Serializable,
Product {
    private Seq<DirectCredentials> allCredentials0;
    private ExecutionContextExecutorService ec;
    private final File location;
    private final Seq<CachePolicy> cachePolicies;
    private final Seq<Option<String>> checksums;
    private final Seq<Credentials> credentials;
    private final CacheLogger logger;
    private final ExecutorService pool;
    private final Option<Duration> ttl;
    private final boolean localArtifactsShouldBeCached;
    private final boolean followHttpToHttpsRedirections;
    private final boolean followHttpsToHttpRedirections;
    private final Option<Object> maxRedirections;
    private final int sslRetry;
    private final Option<SSLSocketFactory> sslSocketFactoryOpt;
    private final Option<HostnameVerifier> hostnameVerifierOpt;
    private final int retry;
    private final int bufferSize;
    private final Sync<F> sync;
    private final Seq<Option<String>> checksums0;
    private final Seq<String> actualChecksums;
    private volatile byte bitmap$0;

    @Override
    public final Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public final File location() {
        return this.location;
    }

    public final Seq<CachePolicy> cachePolicies() {
        return this.cachePolicies;
    }

    public final Seq<Option<String>> checksums() {
        return this.checksums;
    }

    public final Seq<Credentials> credentials() {
        return this.credentials;
    }

    public final CacheLogger logger() {
        return this.logger;
    }

    public final ExecutorService pool() {
        return this.pool;
    }

    public final Option<Duration> ttl() {
        return this.ttl;
    }

    public final boolean localArtifactsShouldBeCached() {
        return this.localArtifactsShouldBeCached;
    }

    public final boolean followHttpToHttpsRedirections() {
        return this.followHttpToHttpsRedirections;
    }

    public final boolean followHttpsToHttpRedirections() {
        return this.followHttpsToHttpRedirections;
    }

    public final Option<Object> maxRedirections() {
        return this.maxRedirections;
    }

    public final int sslRetry() {
        return this.sslRetry;
    }

    public final Option<SSLSocketFactory> sslSocketFactoryOpt() {
        return this.sslSocketFactoryOpt;
    }

    public final Option<HostnameVerifier> hostnameVerifierOpt() {
        return this.hostnameVerifierOpt;
    }

    public final int retry() {
        return this.retry;
    }

    public final int bufferSize() {
        return this.bufferSize;
    }

    public final Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private Seq<DirectCredentials> allCredentials0$lzycompute() {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.allCredentials0 = (Seq)this.credentials().flatMap((Function1<Credentials, Seq> & Serializable)x$1 -> x$1.get());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.allCredentials0;
    }

    private Seq<DirectCredentials> allCredentials0() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.allCredentials0$lzycompute();
        }
        return this.allCredentials0;
    }

    public final F allCredentials() {
        return this.S().delay((Function0<Seq> & Serializable)() -> this.allCredentials0());
    }

    public final FileCache<F> noCredentials() {
        return this.withCredentials(Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public final FileCache<F> addCredentials(Seq<Credentials> credentials) {
        void var1_1;
        FileCache fileCache = this;
        return fileCache.withCredentials((Seq)fileCache.credentials().$plus$plus(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final File localFile(String url, Option<String> user) {
        void var2_2;
        void var1_1;
        return FileCache$.MODULE$.localFile0((String)var1_1, this.location(), (Option<String>)var2_2, this.localArtifactsShouldBeCached());
    }

    public final Some<CacheLogger> loggerOpt() {
        return new Some<CacheLogger>(this.logger());
    }

    private Seq<Option<String>> checksums0() {
        return this.checksums0;
    }

    private Seq<String> actualChecksums() {
        return this.actualChecksums;
    }

    /*
     * WARNING - void declaration
     */
    private F download(Artifact artifact, CachePolicy cachePolicy) {
        void var2_2;
        void var1_1;
        return Downloader$.MODULE$.apply((Artifact)var1_1, (CachePolicy)var2_2, this.location(), this.actualChecksums(), this.allCredentials(), this.logger(), this.pool(), this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.bufferSize(), this.sync()).download();
    }

    /*
     * WARNING - void declaration
     */
    public final EitherT<F, ArtifactError, BoxedUnit> validateChecksum(Artifact artifact, String sumType) {
        void var3_3;
        void var2_2;
        void var1_1;
        File localFile0 = this.localFile(artifact.url(), artifact.authentication().map((Function1<Authentication, String> & Serializable)x$3 -> x$3.user()));
        Seq headerSumFile = new $colon$colon<Nothing$>((Nothing$)((Object)FileCache$.MODULE$.auxiliaryFile(localFile0, sumType)), Nil$.MODULE$);
        Option downloadedSumFile = artifact.checksumUrls().get(sumType).map((Function1<String, File> & Serializable)sumUrl -> {
            void var1_1;
            void var2_2;
            return this.localFile((String)var2_2, var1_1.authentication().map((Function1<Authentication, String> & Serializable)x$4 -> x$4.user()));
        });
        return new EitherT(this.S().schedule(this.pool(), () -> FileCache.$anonfun$validateChecksum$4(this, headerSumFile, (Option)var1_1, (String)var2_2, (File)var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    private EitherT<F, ArtifactError, File> filePerPolicy(Artifact artifact, CachePolicy policy, int retry) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object artifact0 = Monad$ops$.MODULE$.toAllMonadOps(this.allCredentials(), this.sync()).map((Function1<Seq, Artifact> & Serializable)allCredentials -> {
            Artifact artifact;
            if (artifact.authentication().isEmpty()) {
                void var1_1;
                Option authOpt = allCredentials.find((Function1<DirectCredentials, Object> & Serializable)x$6 -> {
                    void var1_1;
                    return BoxesRunTime.boxToBoolean(FileCache.$anonfun$filePerPolicy$2(artifact, (DirectCredentials)var1_1));
                }).map((Function1<DirectCredentials, Authentication> & Serializable)x$7 -> x$7.authentication());
                return artifact.withAuthentication((Option<Authentication>)var1_1);
            }
            return artifact;
        });
        return new EitherT(Monad$ops$.MODULE$.toAllMonadOps(var1_1, this.sync()).map((Function1<Artifact, Right> & Serializable)x$8 -> {
            Artifact artifact;
            return package$.MODULE$.Right().apply(artifact);
        })).flatMap(arg_0 -> FileCache.$anonfun$filePerPolicy$5(this, (CachePolicy)var2_2, (int)var3_3, arg_0), this.sync());
    }

    /*
     * WARNING - void declaration
     */
    private EitherT<F, ArtifactError, File> filePerPolicy0(Artifact artifact, CachePolicy policy, int retry) {
        void var2_2;
        void var3_3;
        void var1_1;
        return new EitherT(Monad$ops$.MODULE$.toAllMonadOps(this.download(artifact, policy), this.sync()).map((Function1<Seq, Either> & Serializable)results -> {
            Seq seq;
            void var2_2;
            void var1_1;
            void var3_3;
            Map resultsMap = ((IterableOnceOps)results.map((Function1<DownloadResult, Tuple2> & Serializable)x0$1 -> {
                Product product = x0$1;
                product = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(product.url()), product.errorOpt());
                return product;
            })).toMap($less$colon$less$.MODULE$.refl());
            Seq checksumResults = (Seq)this.checksums0().map(arg_0 -> FileCache.$anonfun$filePerPolicy0$3(artifact, (Map)var3_3, arg_0));
            Option<Option<String>> checksum = checksumResults.collectFirst(new Serializable(null){

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Option<Tuple3<String, String, Option<Option<ArtifactError>>>>, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                    void var1_1;
                    void var2_6;
                    Some some;
                    Tuple3 tuple3;
                    void var1_5;
                    Object object = x12;
                    if (None$.MODULE$.equals(object)) {
                        None$ x12 = None$.MODULE$;
                        return var1_5;
                    }
                    if (object instanceof Some && (tuple3 = (Tuple3)(some = (Some)object).value()) != null) {
                        Some some2;
                        Option option;
                        String c = (String)tuple3._1();
                        Option option2 = (Option)tuple3._3();
                        if (option2 instanceof Some && (option = (Option)(some2 = (Some)option2).value()).isEmpty()) {
                            Some<String> x12 = new Some<String>(c);
                            return var1_5;
                        }
                    }
                    R r = var2_6.apply(var1_1);
                    return var1_5;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Option<Tuple3<String, String, Option<Option<ArtifactError>>>> x1) {
                    Product product = x1;
                    if (None$.MODULE$.equals(product)) {
                        return true;
                    }
                    if (!(product instanceof Some)) return false;
                    if ((product = (Tuple3)((Some)product).value()) == null) return false;
                    if (!((product = (Option)((Tuple3)product)._3()) instanceof Some)) return false;
                    product = (Some)product;
                    if (!((Option)(product = (Option)((Some)product).value())).isEmpty()) return false;
                    return true;
                }
            });
            DownloadResult res = (DownloadResult)results.head();
            return res.errorOpt().toLeft(() -> {}).flatMap(arg_0 -> FileCache.$anonfun$filePerPolicy0$7((Option)var1_1, (DownloadResult)var2_2, seq, arg_0));
        })).flatMap((Function1<Tuple2, EitherT> & Serializable)x0$422 -> {
            FileCache fileCache;
            void var3_9;
            void var2_8;
            void var1_4;
            Product $this22;
            void var2_6;
            void var0_3;
            Option option;
            File f;
            void x0$422 = x0$422;
            if (x0$422 != null) {
                f = (File)x0$422._1();
                option = (Option)x0$422._2();
                if (None$.MODULE$.equals(option)) {
                    EitherT $this22 = new EitherT(super.S().point(package$.MODULE$.Right().apply(f)));
                    return var0_3;
                }
            }
            if (x0$422 == null) throw new MatchError(var2_6);
            f = (File)x0$422._1();
            option = (Option)x0$422._2();
            if (!(option instanceof Some)) throw new MatchError(var2_6);
            Some x0$422 = (Some)option;
            String c = (String)x0$422.value();
            EitherT eitherT = ((FileCache)this).validateChecksum((Artifact)var1_4, (String)var2_8).map(arg_0 -> FileCache.$anonfun$filePerPolicy0$9((File)var3_9, arg_0), fileCache.sync());
            return var0_3;
        }, this.sync()).leftFlatMap(arg_0 -> FileCache.$anonfun$filePerPolicy0$10(this, (Artifact)var1_1, (int)var3_3, (CachePolicy)var2_2, arg_0), this.sync());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EitherT<F, ArtifactError, File> file(Artifact artifact) {
        void var1_1;
        return this.file((Artifact)var1_1, this.retry());
    }

    /*
     * WARNING - void declaration
     */
    public final EitherT<F, ArtifactError, File> file(Artifact artifact, int retry) {
        void var2_2;
        void var1_1;
        return ((IterableOnceOps)((IterableOps)this.cachePolicies().tail()).map((Function1<CachePolicy, EitherT> & Serializable)x$14 -> {
            void var2_2;
            void var3_3;
            void var1_1;
            return this.filePerPolicy((Artifact)var1_1, (CachePolicy)var3_3, (int)var2_2);
        })).foldLeft(this.filePerPolicy((Artifact)var1_1, (CachePolicy)this.cachePolicies().head(), (int)var2_2), (Function2<EitherT, EitherT, EitherT> & Serializable)(x$15, x$16) -> {
            FileCache fileCache;
            void var2_2;
            return x$15.orElse(() -> FileCache.$anonfun$file$3((EitherT)var2_2), fileCache.sync());
        });
    }

    private int filePerPolicy$default$3() {
        return this.retry();
    }

    /*
     * WARNING - void declaration
     */
    private EitherT<F, String, String> fetchPerPolicy(Artifact artifact, CachePolicy policy) {
        void var3_6;
        void var1_4;
        void var2_5;
        artifact = ((Artifact)artifact).url().endsWith("/.links") ? new Tuple2<Artifact, Boolean>(((Artifact)artifact).withUrl(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(((Artifact)artifact).url()), ".links")), BoxesRunTime.boxToBoolean(true)) : new Tuple2<Artifact, Boolean>((Artifact)artifact, BoxesRunTime.boxToBoolean(false));
        Artifact artifact0 = (Artifact)((Tuple2)artifact)._1();
        boolean links22 = ((Tuple2)artifact)._2$mcZ$sp();
        Tuple2<Artifact, Boolean> tuple2 = new Tuple2<Artifact, Boolean>(artifact0, BoxesRunTime.boxToBoolean(links22));
        Tuple2<Artifact, Boolean> links22 = tuple2;
        links22 = tuple2;
        artifact0 = tuple2._1();
        boolean links = links22._2$mcZ$sp();
        return this.filePerPolicy(artifact0, (CachePolicy)var2_5, this.filePerPolicy$default$3()).leftMap((Function1<ArtifactError, String> & Serializable)x$18 -> x$18.describe(), this.sync()).flatMap(arg_0 -> FileCache.$anonfun$fetchPerPolicy$2(this, (boolean)var1_4, (Artifact)var3_6, arg_0), this.sync());
    }

    @Override
    public final Function1<Artifact, EitherT<F, String, String>> fetch() {
        return (Function1<Artifact, EitherT> & Serializable)a -> {
            void var1_1;
            FileCache fileCache;
            return ((IterableOnceOps)this.cachePolicies().tail()).foldLeft(this.fetchPerPolicy((Artifact)a, (CachePolicy)this.cachePolicies().head()), (arg_0, arg_1) -> FileCache.$anonfun$fetch$2(fileCache, (Artifact)var1_1, arg_0, arg_1));
        };
    }

    @Override
    public final Seq<Function1<Artifact, EitherT<F, String, String>>> fetchs() {
        return (Seq)this.cachePolicies().map((Function1<CachePolicy, Function1> & Serializable)p -> {
            void var1_1;
            return arg_0 -> FileCache.$anonfun$fetchs$2(this, (CachePolicy)var1_1, arg_0);
        });
    }

    private ExecutionContextExecutorService ec$lzycompute() {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.ec = ExecutionContext$.MODULE$.fromExecutorService(this.pool());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.ec;
    }

    @Override
    public final ExecutionContextExecutorService ec() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.ec$lzycompute();
        }
        return this.ec;
    }

    /*
     * WARNING - void declaration
     */
    public final FileCache<F> withCredentials(Seq<Credentials> credentials) {
        void var1_1;
        return new FileCache<F>(this.location(), this.cachePolicies(), this.checksums(), (Seq<Credentials>)var1_1, this.logger(), this.pool(), this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.retry(), this.bufferSize(), this.sync());
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder b = new StringBuilder("FileCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cachePolicies()));
        b.append(", ");
        b.append(String.valueOf(this.checksums()));
        b.append(", ");
        b.append(String.valueOf(this.credentials()));
        b.append(", ");
        b.append(String.valueOf(this.logger()));
        b.append(", ");
        b.append(String.valueOf(this.pool()));
        b.append(", ");
        b.append(String.valueOf(this.ttl()));
        b.append(", ");
        b.append(String.valueOf(this.localArtifactsShouldBeCached()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpToHttpsRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpsToHttpRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.maxRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.sslRetry()));
        b.append(", ");
        b.append(String.valueOf(this.sslSocketFactoryOpt()));
        b.append(", ");
        b.append(String.valueOf(this.hostnameVerifierOpt()));
        b.append(", ");
        b.append(String.valueOf(this.retry()));
        b.append(", ");
        b.append(String.valueOf(this.bufferSize()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean canEqual(Object obj) {
        void var1_1;
        return obj != null && var1_1 instanceof FileCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        Sync<F> sync;
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        FileCache other = (FileCache)obj;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Seq<CachePolicy> seq = this.cachePolicies();
        Seq<CachePolicy> seq2 = other.cachePolicies();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Option<String>> seq3 = this.checksums();
        Seq<Option<String>> seq4 = other.checksums();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        Seq<Credentials> seq5 = this.credentials();
        Seq<Credentials> seq6 = other.credentials();
        if (seq5 == null) {
            if (seq6 != null) {
                return false;
            }
        } else if (!seq5.equals(seq6)) return false;
        CacheLogger cacheLogger = this.logger();
        CacheLogger cacheLogger2 = other.logger();
        if (cacheLogger == null) {
            if (cacheLogger2 != null) {
                return false;
            }
        } else if (!cacheLogger.equals(cacheLogger2)) return false;
        ExecutorService executorService = this.pool();
        ExecutorService executorService2 = other.pool();
        if (executorService == null) {
            if (executorService2 != null) {
                return false;
            }
        } else if (!executorService.equals(executorService2)) return false;
        Option<Duration> option = this.ttl();
        Option<Duration> option2 = other.ttl();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.localArtifactsShouldBeCached() != other.localArtifactsShouldBeCached()) return false;
        if (this.followHttpToHttpsRedirections() != other.followHttpToHttpsRedirections()) return false;
        if (this.followHttpsToHttpRedirections() != other.followHttpsToHttpRedirections()) return false;
        Option<Object> option3 = this.maxRedirections();
        Option<Object> option4 = other.maxRedirections();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.sslRetry() != other.sslRetry()) return false;
        Option<SSLSocketFactory> option5 = this.sslSocketFactoryOpt();
        Option<SSLSocketFactory> option6 = other.sslSocketFactoryOpt();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<HostnameVerifier> option7 = this.hostnameVerifierOpt();
        Option<HostnameVerifier> option8 = other.hostnameVerifierOpt();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        if (this.retry() != other.retry()) return false;
        if (this.bufferSize() != other.bufferSize()) return false;
        Sync<F> sync2 = this.sync();
        sync = ((FileCache)((Object)sync)).sync();
        if (sync2 == null) {
            if (sync == null) return true;
            return false;
        } else {
            if (!sync2.equals(sync)) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int code = 17 + Statics.anyHash("FileCache");
        code = code * 37 + Statics.anyHash(this.location());
        code = code * 37 + Statics.anyHash(this.cachePolicies());
        code = code * 37 + Statics.anyHash(this.checksums());
        code = code * 37 + Statics.anyHash(this.credentials());
        code = code * 37 + Statics.anyHash(this.logger());
        code = code * 37 + Statics.anyHash(this.pool());
        code = code * 37 + Statics.anyHash(this.ttl());
        code = code * 37 + (this.localArtifactsShouldBeCached() ? 1231 : 1237);
        code = code * 37 + (this.followHttpToHttpsRedirections() ? 1231 : 1237);
        code = code * 37 + (this.followHttpsToHttpRedirections() ? 1231 : 1237);
        code = code * 37 + Statics.anyHash(this.maxRedirections());
        code = code * 37 + this.sslRetry();
        code = code * 37 + Statics.anyHash(this.sslSocketFactoryOpt());
        code = code * 37 + Statics.anyHash(this.hostnameVerifierOpt());
        code = code * 37 + this.retry();
        code = code * 37 + this.bufferSize();
        code = code * 37 + Statics.anyHash(this.sync());
        return (int)(var1_1 * 37);
    }

    @Override
    public final String productPrefix() {
        return "FileCache";
    }

    @Override
    public final int productArity() {
        return 17;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object productElement(int n) {
        void var1_1;
        switch (n) {
            case 0: {
                return this.location();
            }
            case 1: {
                return this.cachePolicies();
            }
            case 2: {
                return this.checksums();
            }
            case 3: {
                return this.credentials();
            }
            case 4: {
                return this.logger();
            }
            case 5: {
                return this.pool();
            }
            case 6: {
                return this.ttl();
            }
            case 7: {
                return BoxesRunTime.boxToBoolean(this.localArtifactsShouldBeCached());
            }
            case 8: {
                return BoxesRunTime.boxToBoolean(this.followHttpToHttpsRedirections());
            }
            case 9: {
                return BoxesRunTime.boxToBoolean(this.followHttpsToHttpRedirections());
            }
            case 10: {
                return this.maxRedirections();
            }
            case 11: {
                return BoxesRunTime.boxToInteger(this.sslRetry());
            }
            case 12: {
                return this.sslSocketFactoryOpt();
            }
            case 13: {
                return this.hostnameVerifierOpt();
            }
            case 14: {
                return BoxesRunTime.boxToInteger(this.retry());
            }
            case 15: {
                return BoxesRunTime.boxToInteger(this.bufferSize());
            }
            case 16: {
                return this.sync();
            }
        }
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)var1_1)).toString());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Either $anonfun$validateChecksum$4(FileCache $this, Seq headerSumFile$122, Option downloadedSumFile$1, String sumType$1, File localFile0$1) {
        Option headerSumFile$122 = ((IterableOnceOps)headerSumFile$122.$plus$plus(Option$.MODULE$.option2Iterable(downloadedSumFile$1).toSeq())).find((Function1<File, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.exists()));
        if (headerSumFile$122 instanceof Some) {
            Serializable serializable;
            Some headerSumFile$122 = (Some)headerSumFile$122;
            File sumFile = (File)headerSumFile$122.value();
            downloadedSumFile$1 = CacheChecksum$.MODULE$.parseRawChecksum(Files.readAllBytes(sumFile.toPath()));
            if (!None$.MODULE$.equals(downloadedSumFile$1)) {
                void var1_4;
                Serializable calculatedSum;
                void var2_5;
                if (!(downloadedSumFile$1 instanceof Some)) throw new MatchError(var2_5);
                BigInteger sum = (BigInteger)(downloadedSumFile$1 = (Some)downloadedSumFile$1).value();
                return BoxesRunTime.equalsNumNum(sum, (Number)(calculatedSum = FileCache$.MODULE$.coursier$cache$FileCache$$persistedDigest(((FileCache)$this).location(), (String)sumType$1, (File)localFile0$1))) ? package$.MODULE$.Right().apply(BoxedUnit.UNIT) : package$.MODULE$.Left().apply(new ArtifactError.WrongChecksum((String)sumType$1, ((BigInteger)serializable).toString(16), var2_5.toString(16), localFile0$1.getPath(), var1_4.getPath()));
            }
            $this = package$.MODULE$.Left().apply(new ArtifactError.ChecksumFormatError((String)sumType$1, sumFile.getPath()));
            return serializable;
        } else {
            void var3_6;
            void var1_2;
            if (!None$.MODULE$.equals(var1_2)) throw new MatchError(var1_2);
            return package$.MODULE$.Left().apply(new ArtifactError.ChecksumNotFound((String)var3_6, localFile0$1.getPath()));
        }
    }

    public static final /* synthetic */ boolean $anonfun$filePerPolicy$2(Artifact artifact$2, DirectCredentials x$6) {
        Artifact artifact;
        return x$6.autoMatches(artifact.url(), None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$filePerPolicy$5(FileCache $this, CachePolicy policy$1, int retry$1, Artifact a) {
        void var2_2;
        void var1_1;
        void var3_3;
        return $this.filePerPolicy0((Artifact)var3_3, (CachePolicy)var1_1, (int)var2_2);
    }

    public static final /* synthetic */ boolean $anonfun$filePerPolicy0$5(char x$9) {
        return x$9 != '-';
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ String $anonfun$filePerPolicy0$4(Artifact artifact$3, String c$1) {
        void var1_1;
        Artifact artifact;
        return new StringBuilder(1).append(artifact.url()).append(".").append(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(var1_1.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(FileCache.$anonfun$filePerPolicy0$5(BoxesRunTime.unboxToChar(x$9))))).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$filePerPolicy0$3(Artifact artifact$3, Map resultsMap$1, Option x0$2) {
        Some some;
        void var2_2;
        if (None$.MODULE$.equals(x0$2)) {
            artifact$3 = None$.MODULE$;
        } else if (x0$2 instanceof Some) {
            void var1_1;
            x0$2 = (Some)x0$2;
            String c = (String)((Some)x0$2).value();
            Some url = (String)((Artifact)artifact$3).checksumUrls().getOrElse(c, () -> FileCache.$anonfun$filePerPolicy0$4((Artifact)artifact$3, c));
            some = new Some(new Tuple3(var2_2, url, var1_1.get(some)));
        } else {
            throw new MatchError(var2_2);
        }
        return some;
    }

    private static final Seq checksumErrors$1(Seq checksumResults$1) {
        return (Seq)checksumResults$1.collect(new Serializable(null){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Option<Tuple3<String, String, Option<Option<ArtifactError>>>>, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                void var1_1;
                void var2_8;
                Tuple3 tuple3;
                void var1_7;
                boolean bl;
                boolean bl2 = false;
                Some some = null;
                Object object = x12;
                if (object instanceof Some) {
                    bl = true;
                    some = (Some)object;
                    Tuple3 tuple32 = (Tuple3)some.value();
                    if (tuple32 != null) {
                        String c = (String)tuple32._1();
                        String url = (String)tuple32._2();
                        Option option = (Option)tuple32._3();
                        if (None$.MODULE$.equals(option)) {
                            Tuple2<String, String> x12 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c), new StringBuilder(15).append(url).append(" not downloaded").toString());
                            return var1_7;
                        }
                    }
                }
                if (bl && (tuple3 = (Tuple3)some.value()) != null) {
                    Some some2;
                    Option option;
                    String c = (String)tuple3._1();
                    Option option2 = (Option)tuple3._3();
                    if (option2 instanceof Some && (option = (Option)(some2 = (Some)option2).value()) instanceof Some) {
                        void var1_4;
                        Some x12 = (Some)option;
                        ArtifactError e = (ArtifactError)x12.value();
                        Tuple2<String, String> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c), var1_4.describe());
                        return var1_7;
                    }
                }
                R r = var2_8.apply(var1_1);
                return var1_7;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Option<Tuple3<String, String, Option<Option<ArtifactError>>>> x1) {
                Some some;
                Option option;
                Option option2;
                Tuple3 tuple3;
                void var1_14;
                void var1_1;
                boolean bl = false;
                Some some2 = null;
                void var1_2 = var1_1;
                if (var1_2 instanceof Some) {
                    Option option3;
                    bl = true;
                    some2 = (Some)var1_2;
                    Tuple3 tuple32 = (Tuple3)some2.value();
                    if (tuple32 != null && None$.MODULE$.equals(option3 = (Option)tuple32._3())) {
                        return (boolean)var1_14;
                    }
                }
                if (bl && (tuple3 = (Tuple3)some2.value()) != null && (option2 = (Option)tuple3._3()) instanceof Some && (option = (Option)(some = (Some)option2).value()) instanceof Some) {
                    return (boolean)var1_14;
                }
                boolean bl2 = false;
                return (boolean)var1_14;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Either $anonfun$filePerPolicy0$7(Option checksum$1, DownloadResult res$1, Seq checksumResults$1, BoxedUnit x$10) {
        Product product;
        if (None$.MODULE$.equals(checksum$1)) {
            void var2_2;
            checksum$1 = package$.MODULE$.Left().apply(new ArtifactError.ChecksumErrors(FileCache.checksumErrors$1((Seq)var2_2)));
        } else if (checksum$1 instanceof Some) {
            void var1_1;
            checksum$1 = (Some)checksum$1;
            Product c = (Option)((Some)checksum$1).value();
            product = package$.MODULE$.Right().apply(new Tuple2<File, Option>(var1_1.file(), (Option)product));
        } else {
            throw new MatchError(product);
        }
        return product;
    }

    public static final /* synthetic */ File $anonfun$filePerPolicy0$9(File f$1, BoxedUnit x$11) {
        return f$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Right $anonfun$filePerPolicy0$12(FileCache $this, boolean foundBadFileInCache$1, File badFile$1, File badChecksumFile$1, Artifact artifact$3, ArtifactError.WrongChecksum x2$1) {
        FileCache fileCache;
        void var2_2;
        void var3_3;
        void var1_1;
        Predef$.MODULE$.assert((boolean)var1_1);
        badFile$1.delete();
        var3_3.delete();
        FileCache$.MODULE$.clearAuxiliaryFiles((File)var2_2);
        fileCache.logger().removedCorruptFile(artifact$3.url(), new Some<String>(x2$1.describe()));
        return package$.MODULE$.Right().apply(BoxedUnit.UNIT);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$filePerPolicy0$13(FileCache $this, Artifact artifact$3, CachePolicy policy$2, int retry$2, BoxedUnit x$13) {
        void var3_3;
        void var2_2;
        void var1_1;
        return $this.filePerPolicy0((Artifact)var1_1, (CachePolicy)var2_2, (int)(var3_3 - true));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$filePerPolicy0$10(FileCache $this, Artifact artifact$3, int retry$2, CachePolicy policy$2, ArtifactError x0$4) {
        Product product;
        ArtifactError artifactError = x0$4;
        if (artifactError instanceof ArtifactError.WrongChecksum) {
            void var2_2;
            void var3_3;
            void var1_1;
            artifactError = (ArtifactError.WrongChecksum)artifactError;
            File badFile = ((FileCache)$this).localFile(artifact$3.url(), artifact$3.authentication().map((Function1<Authentication, String> & Serializable)x$12 -> x$12.user()));
            File badChecksumFile = new File(((ArtifactError.WrongChecksum)artifactError).sumFile());
            String location0 = new StringBuilder(1).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(((FileCache)$this).location().getCanonicalPath()), "/")).append("/").toString();
            boolean foundBadFileInCache = badFile.getCanonicalPath().startsWith(location0) && badChecksumFile.getCanonicalPath().startsWith(location0);
            $this = retry$2 <= 0 || !foundBadFileInCache ? new EitherT(((FileCache)$this).S().point(package$.MODULE$.Left().apply(artifactError))) : new EitherT(((FileCache)$this).S().schedule(((FileCache)$this).pool(), () -> FileCache.$anonfun$filePerPolicy0$12((FileCache)$this, true, badFile, badChecksumFile, artifact$3, (ArtifactError.WrongChecksum)artifactError))).flatMap(arg_0 -> FileCache.$anonfun$filePerPolicy0$13((FileCache)$this, (Artifact)var1_1, (CachePolicy)var3_3, (int)var2_2, arg_0), ((FileCache)$this).sync());
        } else {
            product = new EitherT(product.S().point(package$.MODULE$.Left().apply(artifactError)));
        }
        return product;
    }

    public static final /* synthetic */ EitherT $anonfun$file$3(EitherT x$16$1) {
        return x$16$1;
    }

    private static final Left notFound$1(File f) {
        File file;
        return package$.MODULE$.Left().apply(new StringBuilder(10).append(file.getCanonicalPath()).append(" not found").toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final Either read$1(File f, boolean links$1, Artifact artifact0$1) {
        Serializable serializable;
        try {
            String string;
            if (links$1) {
                File linkFile = FileCache$.MODULE$.auxiliaryFile(f, "links");
                String string2 = f.getName();
                String string3 = ".directory";
                string = string2 != null && string2.equals(string3) && linkFile.isFile() ? new String(Files.readAllBytes(linkFile.toPath()), StandardCharsets.UTF_8) : WebPage$.MODULE$.listElements(((Artifact)serializable).url(), new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8)).mkString("\n");
            } else {
                string = new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8);
            }
            String content = string;
            return package$.MODULE$.Right().apply(content);
        }
        catch (Throwable throwable) {
            Serializable serializable2;
            void var1_3;
            Throwable content = throwable;
            serializable = throwable;
            serializable = NonFatal$.MODULE$.unapply((Throwable)serializable);
            if (((Option)serializable).isEmpty()) {
                throw var1_3;
            }
            Throwable e = (Throwable)((Option)serializable).get();
            serializable2 = package$.MODULE$.Left().apply(new StringBuilder(24).append("Could not read (file:").append(serializable2.getCanonicalPath()).append("): ").append(var1_3.getMessage()).toString());
            return serializable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$fetchPerPolicy$2(FileCache $this, boolean links$1, Artifact artifact0$1, File f) {
        void var1_3;
        FileCache fileCache;
        Either either;
        if (f.exists()) {
            void content2;
            if (f.isDirectory()) {
                if (artifact0$1.url().startsWith("file:")) {
                    String string;
                    if (links$1) {
                        string = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(f.listFiles()), (Function1<File, String> & Serializable)c -> {
                            void var1_1;
                            File file;
                            String name = c.getName();
                            if (file.isDirectory()) {
                                return new StringBuilder(1).append(name).append("/").toString();
                            }
                            return var1_1;
                        }, ClassTag$.MODULE$.apply(String.class))), Ordering$String$.MODULE$)).mkString("\n");
                    } else {
                        String elements = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(f.listFiles()), (Function1<File, String> & Serializable)c -> {
                            void var1_1;
                            File file;
                            String name = c.getName();
                            if (file.isDirectory()) {
                                return new StringBuilder(1).append(name).append("/").toString();
                            }
                            return var1_1;
                        }, ClassTag$.MODULE$.apply(String.class))), Ordering$String$.MODULE$)), (Function1<String, String> & Serializable)name0 -> {
                            String string;
                            return new StringBuilder(24).append("<li><a href=\"").append((String)name0).append("\">").append(string).append("</a></li>").toString();
                        }, ClassTag$.MODULE$.apply(String.class))).mkString();
                        string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(249).append("<!DOCTYPE html>\n                   |<html>\n                   |<head></head>\n                   |<body>\n                   |<ul>\n                   |").append(elements).append("\n                   |</ul>\n                   |</body>\n                   |</html>\n                 ").toString()));
                    }
                    String content2 = string;
                    either = package$.MODULE$.Right().apply(content2);
                } else {
                    File f0 = new File(f, ".directory");
                    either = f0.exists() ? (f0.isDirectory() ? package$.MODULE$.Left().apply(new StringBuilder(22).append("Woops: ").append(f.getCanonicalPath()).append(" is a directory").toString()) : FileCache.read$1(f0, (boolean)content2, artifact0$1)) : FileCache.notFound$1(f0);
                }
            } else {
                void var2_4;
                either = FileCache.read$1(f, (boolean)content2, (Artifact)var2_4);
            }
        } else {
            void var3_5;
            either = FileCache.notFound$1((File)var3_5);
        }
        Left res = either;
        return new EitherT(fileCache.S().point(var1_3));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$fetch$3(FileCache $this, Artifact a$1, CachePolicy x$20$1) {
        void var2_2;
        void var1_1;
        return $this.fetchPerPolicy((Artifact)var1_1, (CachePolicy)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$fetch$2(FileCache $this, Artifact a$1, EitherT x$19, CachePolicy x$20) {
        FileCache fileCache;
        void var3_3;
        void var1_1;
        return x$19.orElse(() -> FileCache.$anonfun$fetch$3($this, (Artifact)var1_1, (CachePolicy)var3_3), fileCache.sync());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$fetchs$2(FileCache $this, CachePolicy p$1, Artifact a) {
        void var1_1;
        void var2_2;
        return $this.fetchPerPolicy((Artifact)var2_2, (CachePolicy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public FileCache(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Sync<F> sync) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.location = var1_1;
        this.cachePolicies = var2_2;
        this.checksums = checksums;
        this.credentials = credentials;
        this.logger = logger;
        this.pool = pool;
        this.ttl = ttl;
        this.localArtifactsShouldBeCached = localArtifactsShouldBeCached;
        this.followHttpToHttpsRedirections = followHttpToHttpsRedirections;
        this.followHttpsToHttpRedirections = followHttpsToHttpRedirections;
        this.maxRedirections = maxRedirections;
        this.sslRetry = sslRetry;
        this.sslSocketFactoryOpt = sslSocketFactoryOpt;
        this.hostnameVerifierOpt = hostnameVerifierOpt;
        this.retry = retry;
        this.bufferSize = bufferSize;
        this.sync = sync;
        Product.$init$(this);
        this.checksums0 = checksums.isEmpty() ? (Seq)new $colon$colon<Nothing$>((Nothing$)((Object)None$.MODULE$), Nil$.MODULE$) : var3_3;
        this.actualChecksums = (Seq)((SeqOps)this.checksums0().flatMap((Function1<Option, Seq> & Serializable)x$2 -> {
            Option option;
            return Option$.MODULE$.option2Iterable(option).toSeq();
        })).distinct();
    }
}

