/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.CacheDefaults$;
import coursier.cache.CacheLogger$;
import coursier.cache.FileCache;
import coursier.cache.internal.FileUtil;
import coursier.cache.internal.FileUtil$;
import coursier.paths.CachePath;
import coursier.util.Sync;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.Locale;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

public final class FileCache$
implements Serializable {
    public static final FileCache$ MODULE$ = new FileCache$();

    /*
     * WARNING - void declaration
     */
    public final File localFile0(String url, File cache, Option<String> user, boolean localArtifactsShouldBeCached) {
        void var3_3;
        void var2_2;
        return CachePath.localFile(url, (File)var2_2, (String)var3_3.orNull($less$colon$less$.MODULE$.refl()), localArtifactsShouldBeCached);
    }

    /*
     * WARNING - void declaration
     */
    private String auxiliaryFilePrefix(File file) {
        void var1_1;
        return new StringBuilder(3).append(".").append(var1_1.getName()).append("__").toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearAuxiliaryFiles(File file) {
        void var2_2;
        void var1_1;
        String prefix = this.auxiliaryFilePrefix(file);
        FilenameFilter filter = new FilenameFilter(prefix){
            private final String prefix$1;

            public final boolean accept(File dir, String name) {
                return name.startsWith(this.prefix$1);
            }
            {
                void var1_1;
                this.prefix$1 = var1_1;
            }
        };
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(var1_1.getParentFile().listFiles((FilenameFilter)var2_2)), (Function1<File, Object> & Serializable)f -> BoxesRunTime.boxToBoolean(f.delete()));
    }

    /*
     * WARNING - void declaration
     */
    public final File auxiliaryFile(File file, String key) {
        void var2_2;
        void var1_1;
        String key0 = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(key.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$21 -> BoxesRunTime.boxToBoolean(FileCache$.$anonfun$auxiliaryFile$1(BoxesRunTime.unboxToChar(x$21))));
        return new File(file.getParentFile(), new StringBuilder(0).append(this.auxiliaryFilePrefix((File)var1_1)).append((String)var2_2).toString());
    }

    /*
     * WARNING - void declaration
     */
    public final <F> FileCache<F> apply(Sync<F> S) {
        void var1_1;
        return this.apply(CacheDefaults$.MODULE$.location(), (Sync<F>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final BigInteger coursier$cache$FileCache$$persistedDigest(File location, String sumType, File localFile) {
        void var1_3;
        byte[] byArray;
        String location12 = new StringBuilder(1).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(location.getCanonicalPath()), "/")).append("/").toString();
        boolean location12 = localFile.getCanonicalPath().startsWith(location12);
        if (!location12) {
            byArray = this.computeDigest(sumType, localFile);
        } else {
            File cacheFile = this.auxiliaryFile(localFile, new StringBuilder(9).append(sumType).append(".computed").toString());
            Path cacheFilePath = cacheFile.toPath();
            try {
                byArray = Files.readAllBytes(cacheFilePath);
            }
            catch (NoSuchFileException noSuchFileException) {
                void var2_4;
                void var3_6;
                byte[] bytes = this.computeDigest(sumType, (File)var3_6);
                Path tmpFile = File.createTempFile(cacheFile.getName(), ".tmp", cacheFile.getParentFile()).toPath();
                try {
                    Files.write(tmpFile, bytes, new OpenOption[0]);
                    try {
                        Files.move(tmpFile, cacheFilePath, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    }
                }
                finally {
                    Files.deleteIfExists(tmpFile);
                }
                byArray = var2_4;
            }
        }
        byte[] digested = byArray;
        return new BigInteger(1, (byte[])var1_3);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] computeDigest(String sumType, File localFile) {
        void var1_1;
        void var3_4;
        MessageDigest md22 = MessageDigest.getInstance(sumType);
        FileInputStream is = null;
        try {
            void var2_3;
            is = new FileInputStream((File)var2_3);
            FileUtil$.MODULE$.withContent(is, new FileUtil.UpdateDigest(md22), FileUtil$.MODULE$.withContent$default$3());
        }
        catch (Throwable md22) {
            is.close();
            throw md22;
        }
        var3_4.close();
        return var1_1.digest();
    }

    /*
     * WARNING - void declaration
     */
    public final <F> FileCache<F> apply(File location, Sync<F> sync) {
        void var2_2;
        void var1_1;
        None$ none$ = None$.MODULE$;
        return new FileCache((File)var1_1, CacheDefaults$.MODULE$.cachePolicies(), CacheDefaults$.MODULE$.checksums(), CacheDefaults$.MODULE$.credentials(), CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, true, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.sslRetryCount(), none$, none$, CacheDefaults$.MODULE$.defaultRetryCount(), CacheDefaults$.MODULE$.bufferSize(), var2_2);
    }

    public final <F> Sync<Task> apply$default$1() {
        return Task$.MODULE$.sync();
    }

    public static final /* synthetic */ boolean $anonfun$auxiliaryFile$1(char x$21) {
        return x$21 != '-';
    }

    private FileCache$() {
    }
}

