/*
 * Decompiled with CFR 0.152.
 */
package concurrentrefhashmap;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentReferenceHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    static final ReferenceType DEFAULT_KEY_TYPE = ReferenceType.WEAK;
    static final ReferenceType DEFAULT_VALUE_TYPE = ReferenceType.STRONG;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    boolean identityComparisons;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;

    private static int hash(int n) {
        int n2 = n;
        n = n2 + (n2 << 15 ^ 0xFFFFCD7D);
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    final Segment<K, V> segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    private int hashOf(Object object) {
        return ConcurrentReferenceHashMap.hash(this.identityComparisons ? System.identityHashCode(object) : object.hashCode());
    }

    public ConcurrentReferenceHashMap(int n, float f, int n2, ReferenceType referenceType, ReferenceType referenceType2, EnumSet<Option> enumSet) {
        int n3;
        if (!(f > 0.0f) || n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 > 65536) {
            n2 = 65536;
        }
        int n4 = 0;
        for (n3 = 1; n3 < n2; n3 <<= 1) {
            ++n4;
        }
        this.segmentShift = 32 - n4;
        this.segmentMask = n3 - 1;
        this.segments = Segment.newArray(n3);
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if ((n2 = n / n3) * n3 < n) {
            ++n2;
        }
        for (n = 1; n < n2; n <<= 1) {
        }
        this.identityComparisons = enumSet != null && enumSet.contains((Object)Option.IDENTITY_COMPARISONS);
        for (n2 = 0; n2 < this.segments.length; ++n2) {
            this.segments[n2] = new Segment(n, f, referenceType, referenceType2, this.identityComparisons);
        }
    }

    public ConcurrentReferenceHashMap(int n, float f, int n2) {
        this(n, f, n2, DEFAULT_KEY_TYPE, DEFAULT_VALUE_TYPE, null);
    }

    public ConcurrentReferenceHashMap(int n, ReferenceType referenceType, ReferenceType referenceType2) {
        this(n, 0.75f, 16, referenceType, referenceType2, null);
    }

    public ConcurrentReferenceHashMap() {
        this(16, 0.75f, 16);
    }

    @Override
    public boolean isEmpty() {
        int n;
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[this.segments.length];
        int n2 = 0;
        for (n = 0; n < segmentArray.length; ++n) {
            if (segmentArray[n].count != 0) {
                return false;
            }
            nArray[n] = segmentArray[n].modCount;
            n2 += nArray[n];
        }
        if (n2 != 0) {
            for (n = 0; n < segmentArray.length; ++n) {
                if (segmentArray[n].count == 0 && nArray[n] == segmentArray[n].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        int n;
        Segment<K, V>[] segmentArray = this.segments;
        long l = 0L;
        long l2 = 0L;
        int[] nArray = new int[segmentArray.length];
        for (n = 0; n < 2; ++n) {
            int n2;
            l2 = 0L;
            l = 0L;
            int n3 = 0;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                l += (long)segmentArray[n2].count;
                nArray[n2] = segmentArray[n2].modCount;
                n3 += nArray[n2];
            }
            if (n3 != 0) {
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    l2 += (long)segmentArray[n2].count;
                    if (nArray[n2] == segmentArray[n2].modCount) continue;
                    l2 = -1L;
                    break;
                }
            }
            if (l2 == l) break;
        }
        if (l2 != l) {
            l = 0L;
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].lock();
            }
            for (n = 0; n < segmentArray.length; ++n) {
                l += (long)segmentArray[n].count;
            }
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].unlock();
            }
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hashOf(object);
        return this.segmentFor(n).get(object, n);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        int n = this.hashOf(object);
        return this.segmentFor(n).containsKey(object, n);
    }

    @Override
    public boolean containsValue(Object object) {
        int n;
        boolean bl;
        if (object == null) {
            return false;
        }
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[this.segments.length];
        for (bl = false; bl < 2 != 0; bl += 1) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                int cfr_ignored_0 = segmentArray[n2].count;
                nArray[n2] = segmentArray[n2].modCount;
                n3 += nArray[n2];
                if (!segmentArray[n2].containsValue(object)) continue;
                return true;
            }
            n2 = 1;
            if (n3 != 0) {
                for (n3 = 0; n3 < segmentArray.length; ++n3) {
                    int cfr_ignored_1 = segmentArray[n3].count;
                    if (nArray[n3] == segmentArray[n3].modCount) continue;
                    n2 = 0;
                    break;
                }
            }
            if (n2 == 0) continue;
            return false;
        }
        for (bl = false; bl < segmentArray.length; bl += 1) {
            segmentArray[bl].lock();
        }
        bl = false;
        try {
            for (n = 0; n < segmentArray.length; ++n) {
                if (!segmentArray[n].containsValue(object)) continue;
                bl = true;
                break;
            }
        }
        finally {
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].unlock();
            }
        }
        return bl;
    }

    @Override
    public V put(K k, V v) {
        if (k == null || v == null) {
            return null;
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).put(k, n, v, false);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (k == null || v == null) {
            return null;
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).put(k, n, v, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> object) {
        for (Map.Entry entry : object.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hashOf(object);
        return this.segmentFor(n).remove(object, n, null, false);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        int n = this.hashOf(object);
        return this.segmentFor(n).remove(object, n, object2, false) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        if (k == null || v == null || v2 == null) {
            throw new NullPointerException();
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).replace(k, n, v, v2);
    }

    @Override
    public V replace(K k, V v) {
        if (k == null || v == null) {
            return null;
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).replace(k, n, v);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    @Override
    public Set<K> keySet() {
        Set<K> set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        Collection<V> collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values();
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Object v = ConcurrentReferenceHashMap.this.get((object = (Map.Entry)object).getKey());
            return v != null && v.equals(object.getValue());
        }

        @Override
        public final boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            object = (Map.Entry)object;
            return ConcurrentReferenceHashMap.this.remove(object.getKey(), object.getValue());
        }

        @Override
        public final int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public final boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public final void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public final int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public final boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public final boolean contains(Object object) {
            return ConcurrentReferenceHashMap.this.containsValue(object);
        }

        @Override
        public final void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public final int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public final boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public final boolean contains(Object object) {
            return ConcurrentReferenceHashMap.this.containsKey(object);
        }

        @Override
        public final boolean remove(Object object) {
            return ConcurrentReferenceHashMap.this.remove(object) != null;
        }

        @Override
        public final void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public final Map.Entry<K, V> next() {
            HashEntry hashEntry = super.nextEntry();
            return new WriteThroughEntry(hashEntry.key(), hashEntry.value());
        }
    }

    final class WriteThroughEntry
    extends SimpleEntry<K, V> {
        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public final V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            Object v2 = super.setValue(v);
            ConcurrentReferenceHashMap.this.put(this.getKey(), v);
            return v2;
        }
    }

    static class SimpleEntry<K, V>
    implements Serializable,
    Map.Entry<K, V> {
        private final K key;
        private V value;

        public SimpleEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            return SimpleEntry.eq(this.key, (object = (Map.Entry)object).getKey()) && SimpleEntry.eq(this.value, object.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            return object.equals(object2);
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Enumeration<V>,
    Iterator<V> {
        ValueIterator() {
        }

        @Override
        public final V next() {
            return super.nextEntry().value();
        }

        @Override
        public final V nextElement() {
            return super.nextEntry().value();
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Enumeration<K>,
    Iterator<K> {
        KeyIterator() {
        }

        @Override
        public final K next() {
            return super.nextEntry().key();
        }

        @Override
        public final K nextElement() {
            return super.nextEntry().key();
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;
        K currentKey;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentReferenceHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment segment = ConcurrentReferenceHashMap.this.segments[this.nextSegmentIndex--];
                if (segment.count == 0) continue;
                this.currentTable = segment.table;
                for (int i = this.currentTable.length - 1; i >= 0; --i) {
                    this.nextEntry = this.currentTable[i];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = i - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            while (this.nextEntry != null) {
                if (this.nextEntry.key() != null) {
                    return true;
                }
                this.advance();
            }
            return false;
        }

        HashEntry<K, V> nextEntry() {
            do {
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextEntry;
                this.currentKey = this.lastReturned.key();
                this.advance();
            } while (this.currentKey == null);
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentReferenceHashMap.this.remove(this.currentKey);
            this.lastReturned = null;
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry<K, V>[] table;
        final float loadFactor;
        volatile transient ReferenceQueue<Object> refQueue;
        final ReferenceType keyType;
        final ReferenceType valueType;
        final boolean identityComparisons;

        Segment(int n, float f, ReferenceType referenceType, ReferenceType referenceType2, boolean bl) {
            this.loadFactor = f;
            this.keyType = referenceType;
            this.valueType = referenceType2;
            this.identityComparisons = bl;
            this.setTable(HashEntry.newArray(n));
        }

        static final <K, V> Segment<K, V>[] newArray(int n) {
            return new Segment[n];
        }

        private boolean keyEq(Object object, Object object2) {
            if (this.identityComparisons) {
                return object == object2;
            }
            return object.equals(object2);
        }

        final void setTable(HashEntry<K, V>[] hashEntryArray) {
            this.threshold = (int)((float)hashEntryArray.length * this.loadFactor);
            this.table = hashEntryArray;
            this.refQueue = new ReferenceQueue();
        }

        final HashEntry<K, V> getFirst(int n) {
            HashEntry<K, V>[] hashEntryArray = this.table;
            return this.table[n & hashEntryArray.length - 1];
        }

        final HashEntry<K, V> newHashEntry(K k, int n, HashEntry<K, V> hashEntry, V v) {
            return new HashEntry<K, V>(k, n, hashEntry, v, this.keyType, this.valueType, this.refQueue);
        }

        final V readValueUnderLock(HashEntry<K, V> hashEntry) {
            this.lock();
            try {
                this.removeStale();
                hashEntry = hashEntry.value();
                return (V)hashEntry;
            }
            finally {
                this.unlock();
            }
        }

        final V get(Object object, int n) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && this.keyEq(object, hashEntry.key())) {
                        object = hashEntry.valueRef;
                        if (object != null) {
                            return hashEntry.dereferenceValue(object);
                        }
                        return this.readValueUnderLock(hashEntry);
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return null;
        }

        final boolean containsKey(Object object, int n) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && this.keyEq(object, hashEntry.key())) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return false;
        }

        final boolean containsValue(Object object) {
            if (this.count != 0) {
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n = this.table.length;
                for (int i = 0; i < n; ++i) {
                    HashEntry<K, V> hashEntry = hashEntryArray[i];
                    while (hashEntry != null) {
                        Object object2 = hashEntry.valueRef;
                        object2 = object2 == null ? this.readValueUnderLock(hashEntry) : hashEntry.dereferenceValue(object2);
                        if (object.equals(object2)) {
                            return true;
                        }
                        hashEntry = hashEntry.next;
                    }
                }
            }
            return false;
        }

        final boolean replace(K k, int n, V v, V v2) {
            this.lock();
            try {
                this.removeStale();
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (!(hashEntry == null || hashEntry.hash == n && this.keyEq(k, hashEntry.key()))) {
                    hashEntry = hashEntry.next;
                }
                boolean bl = false;
                if (hashEntry != null && v.equals(hashEntry.value())) {
                    bl = true;
                    hashEntry.setValue(v2, this.valueType, this.refQueue);
                }
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        final V replace(K object, int n, V v) {
            this.lock();
            try {
                this.removeStale();
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (!(hashEntry == null || hashEntry.hash == n && this.keyEq(object, hashEntry.key()))) {
                    hashEntry = hashEntry.next;
                }
                object = null;
                if (hashEntry != null) {
                    object = hashEntry.value();
                    hashEntry.setValue(v, this.valueType, this.refQueue);
                }
                return (V)object;
            }
            finally {
                this.unlock();
            }
        }

        final V put(K k, int n, V v, boolean bl) {
            this.lock();
            try {
                Object var10_12;
                HashEntry<K, V> hashEntry;
                int n2;
                this.removeStale();
                int n3 = this.count;
                int n4 = n3;
                ++n4;
                if (n3 > this.threshold && (n2 = this.rehash()) > 0) {
                    this.count = (n4 -= n2) - 1;
                }
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n5 = n & hashEntryArray.length - 1;
                HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n5];
                while (!(hashEntry2 == null || hashEntry2.hash == n && this.keyEq(k, hashEntry2.key()))) {
                    hashEntry2 = hashEntry2.next;
                }
                if (hashEntry2 != null) {
                    var10_12 = hashEntry2.value();
                    if (!bl) {
                        hashEntry2.setValue(v, this.valueType, this.refQueue);
                    }
                } else {
                    var10_12 = null;
                    ++this.modCount;
                    hashEntryArray[n5] = this.newHashEntry(k, n, hashEntry, v);
                    this.count = n4;
                }
                k = var10_12;
                return (V)k;
            }
            finally {
                this.unlock();
            }
        }

        final int rehash() {
            HashEntry<K, V>[] hashEntryArray = this.table;
            int n = this.table.length;
            if (n >= 0x40000000) {
                return 0;
            }
            HashEntry<K, V>[] hashEntryArray2 = HashEntry.newArray(n << 1);
            this.threshold = (int)((float)hashEntryArray2.length * this.loadFactor);
            int n2 = hashEntryArray2.length - 1;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                HashEntry<K, V> hashEntry = hashEntryArray[i];
                if (hashEntry == null) continue;
                HashEntry hashEntry2 = hashEntry.next;
                int n4 = hashEntry.hash & n2;
                if (hashEntry2 == null) {
                    hashEntryArray2[n4] = hashEntry;
                    continue;
                }
                HashEntry<K, V> hashEntry3 = hashEntry;
                while (hashEntry2 != null) {
                    int n5 = hashEntry2.hash & n2;
                    if (n5 != n4) {
                        n4 = n5;
                        hashEntry3 = hashEntry2;
                    }
                    hashEntry2 = hashEntry2.next;
                }
                hashEntryArray2[n4] = hashEntry3;
                hashEntry2 = hashEntry;
                while (hashEntry2 != hashEntry3) {
                    Object k = hashEntry2.key();
                    if (k == null) {
                        ++n3;
                    } else {
                        int n6 = hashEntry2.hash & n2;
                        HashEntry hashEntry4 = hashEntryArray2[n6];
                        hashEntryArray2[n6] = this.newHashEntry(k, hashEntry2.hash, hashEntry4, hashEntry2.value());
                    }
                    hashEntry2 = hashEntry2.next;
                }
            }
            this.table = hashEntryArray2;
            return n3;
        }

        final V remove(Object object, int n, Object hashEntry, boolean bl) {
            this.lock();
            try {
                HashEntry<K, V> hashEntry2;
                if (!bl) {
                    this.removeStale();
                }
                int n2 = this.count - 1;
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n3 = n & hashEntryArray.length - 1;
                HashEntry<K, V> hashEntry3 = hashEntry2 = hashEntryArray[n3];
                while (hashEntry3 != null && object != hashEntry3.keyRef && (bl || n != hashEntry3.hash || !this.keyEq(object, hashEntry3.key()))) {
                    hashEntry3 = hashEntry3.next;
                }
                object = null;
                if (hashEntry3 != null) {
                    Object object2 = hashEntry3.value();
                    if (hashEntry == null || hashEntry.equals(object2)) {
                        object = object2;
                        ++this.modCount;
                        object2 = hashEntry3.next;
                        hashEntry = hashEntry2;
                        while (hashEntry != hashEntry3) {
                            K k = hashEntry.key();
                            if (k == null) {
                                --n2;
                            } else {
                                object2 = this.newHashEntry(k, hashEntry.hash, (HashEntry<K, V>)object2, hashEntry.value());
                            }
                            hashEntry = hashEntry.next;
                        }
                        hashEntryArray[n3] = object2;
                        this.count = n2;
                    }
                }
                Object object3 = object;
                return (V)object3;
            }
            finally {
                this.unlock();
            }
        }

        final void removeStale() {
            KeyReference keyReference;
            while ((keyReference = (KeyReference)((Object)this.refQueue.poll())) != null) {
                this.remove(keyReference.keyRef(), keyReference.keyHash(), null, true);
            }
        }

        final void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<K, V>[] hashEntryArray = this.table;
                    for (int i = 0; i < hashEntryArray.length; ++i) {
                        hashEntryArray[i] = null;
                    }
                    ++this.modCount;
                    this.refQueue = new ReferenceQueue();
                    this.count = 0;
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    static final class HashEntry<K, V> {
        final Object keyRef;
        final int hash;
        volatile Object valueRef;
        final HashEntry<K, V> next;

        HashEntry(K k, int n, HashEntry<K, V> hashEntry, V v, ReferenceType referenceType, ReferenceType referenceType2, ReferenceQueue<Object> referenceQueue) {
            this.hash = n;
            this.next = hashEntry;
            this.keyRef = this.newKeyReference(k, referenceType, referenceQueue);
            this.valueRef = this.newValueReference(v, referenceType2, referenceQueue);
        }

        final Object newKeyReference(K k, ReferenceType referenceType, ReferenceQueue<Object> referenceQueue) {
            if (referenceType == ReferenceType.WEAK) {
                return new WeakKeyReference<K>(k, this.hash, referenceQueue);
            }
            if (referenceType == ReferenceType.SOFT) {
                return new SoftKeyReference<K>(k, this.hash, referenceQueue);
            }
            return k;
        }

        final Object newValueReference(V v, ReferenceType referenceType, ReferenceQueue<Object> referenceQueue) {
            if (referenceType == ReferenceType.WEAK) {
                return new WeakValueReference<V>(v, this.keyRef, this.hash, referenceQueue);
            }
            if (referenceType == ReferenceType.SOFT) {
                return new SoftValueReference<V>(v, this.keyRef, this.hash, referenceQueue);
            }
            return v;
        }

        final K key() {
            if (this.keyRef instanceof KeyReference) {
                return (K)((Reference)this.keyRef).get();
            }
            return (K)this.keyRef;
        }

        final V value() {
            HashEntry hashEntry = this;
            return hashEntry.dereferenceValue(hashEntry.valueRef);
        }

        final V dereferenceValue(Object object) {
            if (object instanceof KeyReference) {
                return (V)((Reference)object).get();
            }
            return (V)object;
        }

        final void setValue(V v, ReferenceType referenceType, ReferenceQueue<Object> referenceQueue) {
            this.valueRef = this.newValueReference(v, referenceType, referenceQueue);
        }

        static final <K, V> HashEntry<K, V>[] newArray(int n) {
            return new HashEntry[n];
        }
    }

    static final class SoftValueReference<V>
    extends SoftReference<V>
    implements KeyReference {
        final Object keyRef;
        final int hash;

        SoftValueReference(V v, Object object, int n, ReferenceQueue<Object> referenceQueue) {
            super(v, referenceQueue);
            this.keyRef = object;
            this.hash = n;
        }

        @Override
        public final int keyHash() {
            return this.hash;
        }

        @Override
        public final Object keyRef() {
            return this.keyRef;
        }
    }

    static final class WeakValueReference<V>
    extends WeakReference<V>
    implements KeyReference {
        final Object keyRef;
        final int hash;

        WeakValueReference(V v, Object object, int n, ReferenceQueue<Object> referenceQueue) {
            super(v, referenceQueue);
            this.keyRef = object;
            this.hash = n;
        }

        @Override
        public final int keyHash() {
            return this.hash;
        }

        @Override
        public final Object keyRef() {
            return this.keyRef;
        }
    }

    static final class SoftKeyReference<K>
    extends SoftReference<K>
    implements KeyReference {
        final int hash;

        SoftKeyReference(K k, int n, ReferenceQueue<Object> referenceQueue) {
            super(k, referenceQueue);
            this.hash = n;
        }

        @Override
        public final int keyHash() {
            return this.hash;
        }

        @Override
        public final Object keyRef() {
            return this;
        }
    }

    static final class WeakKeyReference<K>
    extends WeakReference<K>
    implements KeyReference {
        final int hash;

        WeakKeyReference(K k, int n, ReferenceQueue<Object> referenceQueue) {
            super(k, referenceQueue);
            this.hash = n;
        }

        @Override
        public final int keyHash() {
            return this.hash;
        }

        @Override
        public final Object keyRef() {
            return this;
        }
    }

    static interface KeyReference {
        public int keyHash();

        public Object keyRef();
    }

    public static final class Option
    extends Enum<Option> {
        public static final /* enum */ Option IDENTITY_COMPARISONS = new Option();
        private static final /* synthetic */ Option[] $VALUES;

        static {
            $VALUES = new Option[]{IDENTITY_COMPARISONS};
        }
    }

    public static final class ReferenceType
    extends Enum<ReferenceType> {
        public static final /* enum */ ReferenceType STRONG = new ReferenceType();
        public static final /* enum */ ReferenceType WEAK = new ReferenceType();
        public static final /* enum */ ReferenceType SOFT = new ReferenceType();
        private static final /* synthetic */ ReferenceType[] $VALUES;

        static {
            $VALUES = new ReferenceType[]{STRONG, WEAK, SOFT};
        }
    }
}

