/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.resolve.VisitData;
import org.apache.ivy.core.resolve.VisitNode;
import org.apache.ivy.util.Message;

public final class ResolveData {
    private ResolveEngine engine;
    private Map visitData;
    private ConfigurationResolveReport report;
    private ResolveOptions options;
    private VisitNode currentVisitNode = null;
    private ResolvedModuleRevision currentResolvedModuleRevision;

    public ResolveData(ResolveData resolveData, boolean bl) {
        this(resolveData.engine, new ResolveOptions(resolveData.options).setValidate(bl), resolveData.report, resolveData.visitData);
        Object object = resolveData.currentVisitNode;
        this.currentVisitNode = object;
        object = resolveData.currentResolvedModuleRevision;
        this.currentResolvedModuleRevision = object;
    }

    public ResolveData(ResolveEngine resolveEngine, ResolveOptions resolveOptions) {
        this(resolveEngine, resolveOptions, null, new LinkedHashMap());
    }

    private ResolveData(ResolveEngine resolveEngine, ResolveOptions resolveOptions, ConfigurationResolveReport configurationResolveReport, Map map2) {
        this.engine = resolveEngine;
        this.report = configurationResolveReport;
        this.visitData = map2;
        this.options = resolveOptions;
    }

    public final ConfigurationResolveReport getReport() {
        return this.report;
    }

    public final IvyNode getNode(ModuleRevisionId moduleRevisionId) {
        VisitData visitData = this.getVisitData(moduleRevisionId);
        if (visitData == null) {
            return null;
        }
        return visitData.getNode();
    }

    public final Collection getNodes() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (VisitData visitData : this.visitData.values()) {
            arrayList.add(visitData.getNode());
        }
        return arrayList;
    }

    public final Collection getNodeIds() {
        return this.visitData.keySet();
    }

    public final VisitData getVisitData(ModuleRevisionId moduleRevisionId) {
        VisitData visitData = (VisitData)this.visitData.get(moduleRevisionId);
        if (visitData == null) {
            for (Map.Entry entry : this.visitData.entrySet()) {
                boolean bl;
                block6: {
                    int n;
                    ModuleRevisionId moduleRevisionId2 = (ModuleRevisionId)entry.getKey();
                    Map map2 = moduleRevisionId2.getAttributes();
                    Map map3 = moduleRevisionId.getAttributes();
                    int n2 = map3.size();
                    if (n2 == (n = map2.size())) {
                        bl = map3.equals(map2);
                    } else {
                        Map map4 = n2 < n ? map3 : map2;
                        Map map5 = n2 < n ? map2 : map3;
                        for (Map.Entry entry2 : map4.entrySet()) {
                            Object v;
                            Object v2;
                            if (!map5.containsKey(entry2.getKey())) {
                                bl = false;
                                break block6;
                            }
                            Object v3 = map4.get(entry2.getKey());
                            Object v4 = v3;
                            if (v4 == (v2 = (v = map5.get(entry2.getKey()))) ? true : (v4 == null ? v2 == null : (v2 == null ? v4 == null : v4.equals(v2)))) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                visitData = (VisitData)entry.getValue();
                break;
            }
        }
        return visitData;
    }

    public final VisitNode getCurrentVisitNode() {
        return this.currentVisitNode;
    }

    final void setCurrentVisitNode(VisitNode visitNode) {
        this.currentVisitNode = visitNode;
    }

    public final void register(VisitNode visitNode) {
        this.register(visitNode.getId(), visitNode);
    }

    public final void register(ModuleRevisionId moduleRevisionId, VisitNode visitNode) {
        VisitData visitData = this.getVisitData(moduleRevisionId);
        if (visitData == null) {
            visitData = new VisitData(visitNode.getNode());
            visitData.addVisitNode(visitNode);
            this.visitData.put(moduleRevisionId, visitData);
            return;
        }
        visitData.setNode(visitNode.getNode());
        visitData.addVisitNode(visitNode);
    }

    final void replaceNode(ModuleRevisionId moduleRevisionId, IvyNode ivyNode, String string) {
        VisitData visitData = this.getVisitData(moduleRevisionId);
        if (visitData == null) {
            throw new IllegalArgumentException("impossible to replace node for id " + moduleRevisionId + ". No registered node found.");
        }
        VisitData visitData2 = this.getVisitData(ivyNode.getId());
        if (visitData2 == null) {
            throw new IllegalArgumentException("impossible to replace node with " + ivyNode + ". No registered node found for " + ivyNode.getId() + ".");
        }
        this.visitData.put(moduleRevisionId, visitData2);
        List list = visitData.getVisitNodes(string);
        String string2 = string;
        visitData2.getVisitNodes(string2).addAll(list);
        this.report.updateDependency(moduleRevisionId, ivyNode);
    }

    public final void setReport(ConfigurationResolveReport configurationResolveReport) {
        this.report = configurationResolveReport;
    }

    public final Date getDate() {
        return this.options.getDate();
    }

    public final boolean isValidate() {
        return this.options.isValidate();
    }

    public final boolean isTransitive() {
        return this.options.isTransitive();
    }

    public final ResolveOptions getOptions() {
        return this.options;
    }

    public final ResolveEngineSettings getSettings() {
        return this.engine.getSettings();
    }

    public final EventManager getEventManager() {
        return this.engine.getEventManager();
    }

    final void blacklist(IvyNode ivyNode) {
        Iterator iterator2 = this.visitData.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            if (((VisitData)entry.getValue()).getNode() != ivyNode || ivyNode.getResolvedId().equals(entry.getKey())) continue;
            iterator2.remove();
        }
    }

    public final boolean isBlacklisted(String string, ModuleRevisionId moduleRevisionId) {
        IvyNode ivyNode = this.getNode(moduleRevisionId);
        return ivyNode != null && ivyNode.isBlacklisted(string);
    }

    public final DependencyDescriptor mediate(DependencyDescriptor dependencyDescriptor) {
        DependencyDescriptor dependencyDescriptor2 = dependencyDescriptor;
        dependencyDescriptor = this.engine.mediate(dependencyDescriptor, this.options);
        VisitNode visitNode = this.currentVisitNode;
        if (visitNode != null) {
            ArrayList arrayList = new ArrayList(visitNode.getPath());
            arrayList.remove(arrayList.size() - 1);
            Collections.reverse(arrayList);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                ModuleDescriptor moduleDescriptor = ((VisitNode)iterator2.next()).getDescriptor();
                if (moduleDescriptor == null) continue;
                dependencyDescriptor = moduleDescriptor.mediate(dependencyDescriptor);
            }
        }
        if (dependencyDescriptor2 != dependencyDescriptor) {
            Message.verbose("dependency descriptor has been mediated: " + dependencyDescriptor2 + " => " + dependencyDescriptor);
        }
        return dependencyDescriptor;
    }

    public final void setCurrentResolvedModuleRevision(ResolvedModuleRevision resolvedModuleRevision) {
        this.currentResolvedModuleRevision = resolvedModuleRevision;
    }

    public final ResolvedModuleRevision getCurrentResolvedModuleRevision() {
        return this.currentResolvedModuleRevision;
    }
}

