/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSeq;
import scala.collection.GenTraversable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import xsbt.boot.BootException;
import xsbt.boot.Pre$$anonfun$assert$1;
import xsbt.boot.Pre$$anonfun$const$1;
import xsbt.boot.Pre$$anonfun$delete$1;
import xsbt.boot.Pre$$anonfun$getJars$1;
import xsbt.boot.Pre$$anonfun$getMissing$1;
import xsbt.boot.Pre$$anonfun$readProperties$1;
import xsbt.boot.Pre$$anonfun$toURLs$1;
import xsbt.boot.Pre$$anonfun$writeProperties$1;
import xsbt.boot.Using$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Pre$ {
    public static final Pre$ MODULE$;
    private final boolean isWindows;
    private final boolean isCygwin;

    static {
        new Pre$();
    }

    public static Option readLine(String string) {
        Console console = System.console();
        if (console == null) {
            return None$.MODULE$;
        }
        return Option$.apply(console.readLine(string, new Object[0]));
    }

    public static String trimLeading(String string) {
        int n;
        String string2 = string;
        for (n = 0; n < string2.length() && Character.isWhitespace(string2.charAt(n)); ++n) {
        }
        return string.substring(n);
    }

    public static boolean isEmpty(String string) {
        return string.length() == 0;
    }

    public static boolean isNonEmpty(String string) {
        return string.length() > 0;
    }

    public static void assert(boolean bl, Function0 function0) {
        if (bl) {
            return;
        }
        throw new AssertionError(function0.apply());
    }

    public static void assert(boolean bl) {
        Pre$.assert(bl, new Pre$$anonfun$assert$1());
    }

    public static void require(boolean bl, Function0 function0) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException((String)function0.apply());
    }

    public static Nothing$ error(String string) {
        throw new BootException(Pre$.prefixError(string));
    }

    public static Nothing$ declined(String string) {
        throw new BootException(string);
    }

    public static String prefixError(String string) {
        return new StringBuilder().append((Object)"error during sbt launcher: ").append((Object)string).toString();
    }

    public static boolean toBoolean(String string) {
        return Boolean.parseBoolean(string);
    }

    public static Object toArray(List list, ClassTag classTag) {
        Object object;
        Object object2 = object = classTag.newArray(list.length());
        List list2 = list;
        int n = 0;
        while (true) {
            if (n >= ScalaRunTime$.array_length(object2)) break;
            ScalaRunTime$.array_update(object2, n, list2.head());
            list2 = (List)list2.tail();
            ++n;
        }
        return object;
    }

    public static File[] concat(File[] fileArray, File[] fileArray2) {
        File[] fileArray3 = new File[fileArray.length + fileArray2.length];
        System.arraycopy(fileArray, 0, fileArray3, 0, fileArray.length);
        System.arraycopy(fileArray2, 0, fileArray3, fileArray.length, fileArray2.length);
        return fileArray3;
    }

    public final File[] array$7b437989(GenSeq genSeq) {
        return (File[])Pre$.toArray(genSeq.toList(), ClassManifestFactory$.classType(File.class));
    }

    public static Object orElse(Option option, Object object) {
        if (option.isDefined()) {
            return option.get();
        }
        return object;
    }

    public static File[] wrapNull(File[] fileArray) {
        if (fileArray == null) {
            return new File[0];
        }
        return fileArray;
    }

    public static Function1 const(Object object) {
        return new Pre$$anonfun$const$1(object);
    }

    public static Option strictOr(Option option, Option option2) {
        Option option3 = option;
        None$ none$ = None$.MODULE$;
        Option option4 = option3;
        Option option5 = !(none$ != null ? !none$.equals(option4) : option4 != null) ? option2 : option;
        return option5;
    }

    public final Object getOrError(Option option, String string) {
        Option option2 = option;
        None$ none$ = None$.MODULE$;
        Option option3 = option2;
        if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
            throw Pre$.error(string);
        }
        if (option2 instanceof Some) {
            return ((Some)option2).x();
        }
        throw new MatchError(option2);
    }

    public static Object orNull(Option option) {
        Option option2;
        block4: {
            Object object;
            block3: {
                block2: {
                    option2 = option;
                    None$ none$ = None$.MODULE$;
                    Option option3 = option2;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block2;
                    object = null;
                    break block3;
                }
                if (!(option2 instanceof Some)) break block4;
                object = ((Some)option2).x();
            }
            return object;
        }
        throw new MatchError(option2);
    }

    public final File[] getJars(List list) {
        return (File[])Pre$.toArray((List)list.flatMap(new Pre$$anonfun$getJars$1(), List$.MODULE$.canBuildFrom()), ClassManifestFactory$.classType(File.class));
    }

    public static GenTraversable getMissing$d83f809$4442e4c1(ClassLoader classLoader, GenTraversable genTraversable) {
        return (GenTraversable)genTraversable.toList().filter(new Pre$$anonfun$getMissing$1(classLoader));
    }

    public static URL[] toURLs(File[] fileArray) {
        return (URL[])Predef$.refArrayOps(fileArray).map(new Pre$$anonfun$toURLs$1(), Array$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)));
    }

    public static File toFile(URL uRL) {
        try {
            return new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(uRL.getPath());
        }
    }

    public static void delete(File file2) {
        File[] fileArray;
        if (file2.isDirectory() && (fileArray = file2.listFiles()) != null) {
            Predef$.refArrayOps(fileArray).foreach(new Pre$$anonfun$delete$1());
        }
        if (file2.exists()) {
            file2.delete();
        }
    }

    public final boolean isWindows() {
        return this.isWindows;
    }

    public final boolean isCygwin() {
        return this.isCygwin;
    }

    public static String substituteTilde(String string) {
        return string.replaceFirst("^~(/|\\\\|$)", new StringBuilder().append((Object)System.getProperty("user.home")).append((Object)"$1").toString());
    }

    public static Properties readProperties(File file2) {
        Properties properties;
        block0: {
            properties = new Properties();
            if (!file2.exists()) break block0;
            Using$.apply(new FileInputStream(file2), new Pre$$anonfun$readProperties$1(properties));
        }
        return properties;
    }

    public static void writeProperties(Properties properties, File file2, String string) {
        file2.getParentFile().mkdirs();
        Using$.apply(new FileOutputStream(file2), new Pre$$anonfun$writeProperties$1(properties, string));
    }

    public static void setSystemProperties(Properties properties) {
        for (String string : properties.stringPropertyNames()) {
            System.setProperty(string, properties.getProperty(string));
        }
    }

    public static boolean xsbt$boot$Pre$$classMissing$1(String string, ClassLoader classLoader) {
        try {
            Class.forName(string, false, classLoader);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    private Pre$() {
        MODULE$ = this;
        this.isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        this.isCygwin = this.isWindows && Boolean.getBoolean("sbt.cygwin");
    }
}

